/* =============================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found in the
 *  license agreement under which this software has been supplied.
 *  ============================================================================
 */

/** ============================================================================
 *  @file  cslr_aif.h
 *
 *  @path  $(CSLPATH)\inc
 *
 *  @desc  This file contains the Register Descriptions for AIF
 *  ===========================================================================
 */

#ifndef _CSLR_AIF_H_
#define _CSLR_AIF_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for LCFG 
\**************************************************************************/
typedef struct  {
    volatile Uint32 LINK_CFG;
    volatile Uint8 RSVD0[2044];
} CSL_AifLcfgRegs;

/**************************************************************************\
* Register Overlay Structure for RM_LINK 
\**************************************************************************/
typedef struct  {
    volatile Uint32 RM_LINK_CFG;
    volatile Uint32 RM_LINK_PI_OFFSET_CFG;
    volatile Uint32 RM_LINK_LOS_THOLD_CFG;
    volatile Uint8 RSVD0[116];
    volatile Uint32 RM_LINK_STSA;
    volatile Uint32 RM_LINK_STSB;
    volatile Uint32 RM_LINK_STSC;
    volatile Uint32 RM_LINK_STSD;
    volatile Uint8 RSVD1[1904];
} CSL_AifRm_linkRegs;

/**************************************************************************\
* Register Overlay Structure for TM_LINK 
\**************************************************************************/
typedef struct  {
    volatile Uint32 TM_LINK_CFGA;
    volatile Uint32 TM_LINK_CFGB;
    volatile Uint32 TM_LINK_CFGC;
    volatile Uint8 RSVD0[116];
    volatile Uint32 TM_LINK_STS;
    volatile Uint8 RSVD1[1916];
} CSL_AifTm_linkRegs;

/**************************************************************************\
* Register Overlay Structure for AG_LINK 
\**************************************************************************/
typedef struct  {
    volatile Uint32 AG_LINK_CFG;
    volatile Uint32 AG_LINK_STS;
    volatile Uint32 AG_LINK_HDR_ERR_STSA;
    volatile Uint32 AG_LINK_HDR_ERR_STSB;
    volatile Uint32 AG_LINK_HDR_ERR_STSC;
    volatile Uint32 AG_LINK_HDR_ERR_STSD;
    volatile Uint8 RSVD0[2024];
} CSL_AifAg_linkRegs;

/**************************************************************************\
* Register Overlay Structure for CI_LINK 
\**************************************************************************/
typedef struct  {
    volatile Uint32 CI_LINK_CFG;
    volatile Uint8 RSVD0[2044];
} CSL_AifCi_linkRegs;

/**************************************************************************\
* Register Overlay Structure for CO_LINK 
\**************************************************************************/
typedef struct  {
    volatile Uint32 CO_LINK_CFG;
    volatile Uint8 RSVD0[2044];
} CSL_AifCo_linkRegs;

/**************************************************************************\
* Register Overlay Structure for DB_OUT_HEAD_STS 
\**************************************************************************/
typedef struct  {
    volatile Uint32 DB_OUT_PKTSW_HEAD_STS;
} CSL_AifDb_out_head_stsRegs;

/**************************************************************************\
* Register Overlay Structure for DB_OUT_TAIL_STS 
\**************************************************************************/
typedef struct  {
    volatile Uint32 DB_OUT_PKTSW_TAIL_STS;
} CSL_AifDb_out_tail_stsRegs;

/**************************************************************************\
* Register Overlay Structure for PD84LUT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 PD_LINK_84CNT_LUT0_CFG;
    volatile Uint32 PD_LINK_84CNT_LUT1_CFG;
    volatile Uint32 PD_LINK_84CNT_LUT2_CFG;
    volatile Uint32 PD_LINK_CPRI_SI_LUT0_CFG;
    volatile Uint32 PD_LINK_CPRI_SI_LUT1_CFG;
    volatile Uint32 PD_LINK_CPRI_FORMAT_LUT_CFG;
    volatile Uint8 RSVD0[2024];
} CSL_AifPd84lutRegs;

/**************************************************************************\
* Register Overlay Structure for PDADRLUT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 PD_ADR_LUT;
} CSL_AifPdadrlutRegs;

/**************************************************************************\
* Register Overlay Structure for PE_LINK_CFG 
\**************************************************************************/
typedef struct  {
    volatile Uint32 PE_LINK_84_EN_LUT0_CFG;
    volatile Uint32 PE_LINK_84_EN_LUT1_CFG;
    volatile Uint32 PE_LINK_84_EN_LUT2_CFG;
    volatile Uint32 PE_TERM_CNT01_CFG;
    volatile Uint32 PE_TERM_CNT23_CFG;
    volatile Uint8 RSVD0[492];
    volatile Uint32 PE_LINK_84CNT_LUT[84];
    volatile Uint8 RSVD1[176];
    volatile Uint32 PE_LINK_ID_LUT0[21];
    volatile Uint8 RSVD2[172];
    volatile Uint32 PE_LINK_ID_LUT1[21];
    volatile Uint8 RSVD3[684];
} CSL_AifPe_link_cfgRegs;

/**************************************************************************\
* Register Overlay Structure for INTSRC 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EE_LINK_IRS_A;
    volatile Uint32 EE_LINK_IRS_B;
    volatile Uint32 EE_EV0_LINK_IMS_A;
    volatile Uint32 EE_EV0_LINK_IMS_B;
    volatile Uint32 EE_EV1_LINK_IMS_A;
    volatile Uint32 EE_EV1_LINK_IMS_B;
    volatile Uint32 EE_EV0_LINK_MSK_SET_A;
    volatile Uint32 EE_EV0_LINK_MSK_SET_B;
    volatile Uint32 EE_EV1_LINK_MSK_SET_A;
    volatile Uint32 EE_EV1_LINK_MSK_SET_B;
    volatile Uint32 EE_EV0_LINK_MSK_CLR_A;
    volatile Uint32 EE_EV0_LINK_MSK_CLR_B;
    volatile Uint32 EE_EV1_LINK_MSK_CLR_A;
    volatile Uint32 EE_EV1_LINK_MSK_CLR_B;
    volatile Uint8 RSVD0[1992];
} CSL_AifIntsrcRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 AIF_PD;
    volatile Uint32 AIF_GLOBAL_CFG;
    volatile Uint32 AIF_EMU_CNTL;
    volatile Uint8 RSVD0[16372];
    CSL_AifLcfgRegs LCFG[6];
    volatile Uint32 AIF_SERDES0_PLL_CFG;
    volatile Uint32 AIF_SERDES1_PLL_CFG;
    volatile Uint32 AIF_SERDES0_TST_CFG;
    volatile Uint32 AIF_SERDES1_TST_CFG;
    volatile Uint8 RSVD1[112];
    volatile Uint32 SERDES_STS;
    volatile Uint8 RSVD2[3964];
    CSL_AifRm_linkRegs RM_LINK[6];
    volatile Uint32 RM_SYNC_CNT_CFG;
    volatile Uint32 RM_UNSYNC_CNT_CFG;
    volatile Uint8 RSVD3[4088];
    CSL_AifTm_linkRegs TM_LINK[6];
    volatile Uint8 RSVD4[16384];
    volatile Uint32 CD_OUT_MUX_SEL_CFG;
    volatile Uint32 CD_CB_SRC_SEL_CFG;
    volatile Uint32 CD_CB_OFFSET_CFG;
    volatile Uint32 CD_CB_VALID_WIND_CFG;
    volatile Uint32 CD_DC_SRC_SEL_CFG;
    volatile Uint32 CD_DC_DST_SEL_CFG;
    volatile Uint8 RSVD5[104];
    volatile Uint32 CD_STS;
    volatile Uint8 RSVD6[3964];
    CSL_AifAg_linkRegs AG_LINK[6];
    volatile Uint8 RSVD7[4096];
    CSL_AifCi_linkRegs CI_LINK[6];
    volatile Uint8 RSVD8[4096];
    CSL_AifCo_linkRegs CO_LINK[6];
    volatile Uint8 RSVD9[16388];
    volatile Uint32 DB_GENERIC_CFG;
    volatile Uint32 DB_DMA_QUE_CLR_CFG;
    volatile Uint32 DB_DMA_CNT_CLR_CFG;
    volatile Uint32 DB_OUT_PKTSW_EN_CFG;
    volatile Uint32 DB_OUT_PKTSW_FLUSH_CFG;
    volatile Uint32 DB_IN_FIFO_EVNT_CFG;
    volatile Uint32 DB_IN_FIFO_SIZE_CFG;
    volatile Uint32 DB_FORCE_SYSEVENT_CFG;
    volatile Uint32 DB_OUTB_TRK_AUTOSYNC_CFG;
    volatile Uint32 DB_INB_TRK_AUTOSYNC_CFG;
    volatile Uint8 RSVD10[20];
    volatile Uint32 DB_IN_DMA_CNT0_STS;
    volatile Uint32 DB_IN_DMA_CNT1_STS;
    volatile Uint32 DB_IN_DMA_CNT2_STS;
    volatile Uint32 DB_OUT_DMA_CNT0_STS;
    volatile Uint32 DB_OUT_DMA_CNT1_STS;
    volatile Uint32 DB_OUT_DMA_CNT2_STS;
    volatile Uint32 DB_IN_DMA_DEPTH_STS;
    volatile Uint32 DB_OUT_DMA_DEPTH_STS;
    volatile Uint32 DB_OUT_PKTSW_STS;
    volatile Uint32 DB_OUT_PKTSW_DEPTH_STS;
    volatile Uint32 DB_OUT_PKTSW_NE_STS;
    volatile Uint8 RSVD11[20];
    CSL_AifDb_out_head_stsRegs DB_OUT_HEAD_STS[15];
    volatile Uint8 RSVD12[4];
    CSL_AifDb_out_tail_stsRegs DB_OUT_TAIL_STS[15];
    volatile Uint8 RSVD13[3844];
    CSL_AifPd84lutRegs PD84LUT[6];
    volatile Uint32 PD_0_CFG;
    volatile Uint32 PD_1_CFG;
    volatile Uint32 PD_ADR_MUX_SEL_CFG;		
    volatile Uint32 PD_TYPE_CIR_LUT_CFG;
    volatile Uint32 PD_TYPE_PKT_LUT_CFG;
    volatile Uint32 PD_TYPE_ERR_LUT_CFG;
    volatile Uint8 RSVD14[2024];
    CSL_AifPdadrlutRegs PDADRLUT[512];
    CSL_AifPe_link_cfgRegs PE_LINK_CFG[6];
    volatile Uint32 PE_CFG;
    volatile Uint8 RSVD15[20476];
    CSL_AifIntsrcRegs INTSRC[6];
    volatile Uint32 EE_CFG;
    volatile Uint32 EE_LINK_SEL_EV2A;
    volatile Uint32 EE_LINK_SEL_EV2B;
    volatile Uint32 EE_LINK_SEL_EV3A;
    volatile Uint32 EE_LINK_SEL_EV3B;
    volatile Uint32 EE_INT_END;
    volatile Uint8 RSVD16[104];
    volatile Uint32 EE_AI_RUN;
    volatile Uint8 RSVD17[124];
    volatile Uint32 EE_COMMON_IRS;
    volatile Uint32 EE_COMMON_IMS_EV0;
    volatile Uint32 EE_COMMON_IMS_EV1;
    volatile Uint32 EE_EV2_LINK_IMS_A;
    volatile Uint32 EE_EV2_LINK_IMS_B;
    volatile Uint32 EE_COMMON_IMS_EV2;
    volatile Uint32 EE_EV3_LINK_IMS_A;
    volatile Uint32 EE_EV3_LINK_IMS_B;
    volatile Uint32 EE_COMMON_IMS_EV3;
    volatile Uint32 EE_COMMON_MSK_SET_EV0;
    volatile Uint32 EE_COMMON_MSK_SET_EV1;
    volatile Uint32 EE_EV2_LINK_MSK_SET_A;
    volatile Uint32 EE_EV2_LINK_MSK_SET_B;
    volatile Uint32 EE_COMMON_MSK_SET_EV2;
    volatile Uint32 EE_EV3_LINK_MSK_SET_A;
    volatile Uint32 EE_EV3_LINK_MSK_SET_B;
    volatile Uint32 EE_COMMON_MSK_SET_EV3;
    volatile Uint32 EE_COMMON_MSK_CLR_EV0;
    volatile Uint32 EE_COMMON_MSK_CLR_EV1;
    volatile Uint32 EE_EV2_LINK_MSK_CLR_A;
    volatile Uint32 EE_EV2_LINK_MSK_CLR_B;
    volatile Uint32 EE_COMMON_MSK_CLR_EV2;
    volatile Uint32 EE_EV3_LINK_MSK_CLR_A;
    volatile Uint32 EE_EV3_LINK_MSK_CLR_B;
    volatile Uint32 EE_COMMON_MSK_CLR_EV3;
    volatile Uint8 RSVD18[156];
    volatile Uint32 EE_INT_VECT_EV0;
    volatile Uint32 EE_INT_VECT_EV1;
    volatile Uint32 EE_INT_VECT_EV2;
    volatile Uint32 EE_INT_VECT_EV3;
    volatile Uint8 RSVD19[36336];
    volatile Uint32 VD_RD_BUSERR;
    volatile Uint32 VD_WR_BUSERR;
} CSL_AifRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* AIF_PD */

#define CSL_AIF_AIF_PD_SCHEME_MASK       (0xC0000000u)
#define CSL_AIF_AIF_PD_SCHEME_SHIFT      (0x0000001Eu)
#define CSL_AIF_AIF_PD_SCHEME_RESETVAL   (0x00000001u)

#define CSL_AIF_AIF_PD_FUNCTION_MASK     (0x0FFF0000u)
#define CSL_AIF_AIF_PD_FUNCTION_SHIFT    (0x00000010u)
#define CSL_AIF_AIF_PD_FUNCTION_RESETVAL (0x00000800u)

#define CSL_AIF_AIF_PD_RTL_MASK          (0x0000F800u)
#define CSL_AIF_AIF_PD_RTL_SHIFT         (0x0000000Bu)
#define CSL_AIF_AIF_PD_RTL_RESETVAL      (0x00000001u)

#define CSL_AIF_AIF_PD_MAJOR_MASK        (0x00000700u)
#define CSL_AIF_AIF_PD_MAJOR_SHIFT       (0x00000008u)
#define CSL_AIF_AIF_PD_MAJOR_RESETVAL    (0x00000001u)

#define CSL_AIF_AIF_PD_CUSTOM_MASK       (0x000000C0u)
#define CSL_AIF_AIF_PD_CUSTOM_SHIFT      (0x00000006u)
#define CSL_AIF_AIF_PD_CUSTOM_RESETVAL   (0x00000001u)

#define CSL_AIF_AIF_PD_MINOR_MASK        (0x0000003Fu)
#define CSL_AIF_AIF_PD_MINOR_SHIFT       (0x00000000u)
#define CSL_AIF_AIF_PD_MINOR_RESETVAL    (0x00000001u)

#define CSL_AIF_AIF_PD_RESETVAL          (0x48000941u)

/* AIF_GLOBAL_CFG */

#define CSL_AIF_AIF_GLOBAL_CFG_RM_RAW_DATA_SEL_MASK (0x00000070u)
#define CSL_AIF_AIF_GLOBAL_CFG_RM_RAW_DATA_SEL_SHIFT (0x00000004u)
#define CSL_AIF_AIF_GLOBAL_CFG_RM_RAW_DATA_SEL_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_GLOBAL_CFG_OP_MODE_MASK (0x00000001u)
#define CSL_AIF_AIF_GLOBAL_CFG_OP_MODE_SHIFT (0x00000000u)
#define CSL_AIF_AIF_GLOBAL_CFG_OP_MODE_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_GLOBAL_CFG_RESETVAL  (0x00000000u)

/* AIF_EMU_CNTL */

#define CSL_AIF_AIF_EMU_CNTL_RT_SEL_MASK (0x00000004u)
#define CSL_AIF_AIF_EMU_CNTL_RT_SEL_SHIFT (0x00000002u)
#define CSL_AIF_AIF_EMU_CNTL_RT_SEL_RESETVAL (0x00000000u)

/*----RT_SEL Tokens----*/
#define CSL_AIF_AIF_EMU_CNTL_RT_SEL_EMUSUSP (0x00000000u)
#define CSL_AIF_AIF_EMU_CNTL_RT_SEL_EMUSUSP_RT (0x00000001u)

#define CSL_AIF_AIF_EMU_CNTL_FREERUN_MASK (0x00000001u)
#define CSL_AIF_AIF_EMU_CNTL_FREERUN_SHIFT (0x00000000u)
#define CSL_AIF_AIF_EMU_CNTL_FREERUN_RESETVAL (0x00000000u)

/*----FREERUN Tokens----*/
#define CSL_AIF_AIF_EMU_CNTL_FREERUN_HALT (0x00000000u)
#define CSL_AIF_AIF_EMU_CNTL_FREERUN_FREE (0x00000001u)

#define CSL_AIF_AIF_EMU_CNTL_RESETVAL    (0x00000000u)

/* AIF_SERDES0_PLL_CFG */

#define CSL_AIF_AIF_SERDES0_PLL_CFG_LOOP_BW_MASK (0x00000300u)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_LOOP_BW_SHIFT (0x00000008u)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_LOOP_BW_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_PLL_CFG_MPY_FACTOR_MASK (0x0000001Eu)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_MPY_FACTOR_SHIFT (0x00000001u)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_MPY_FACTOR_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_PLL_CFG_PLL_EN_MASK (0x00000001u)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_PLL_EN_SHIFT (0x00000000u)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_PLL_EN_RESETVAL (0x00000000u)

/*----PLL_EN Tokens----*/
#define CSL_AIF_AIF_SERDES0_PLL_CFG_PLL_EN_DISABLED (0x00000000u)
#define CSL_AIF_AIF_SERDES0_PLL_CFG_PLL_EN_ENABLED (0x00000001u)

#define CSL_AIF_AIF_SERDES0_PLL_CFG_RESETVAL (0x00000000u)

/* AIF_SERDES1_PLL_CFG */

#define CSL_AIF_AIF_SERDES1_PLL_CFG_LOOP_BW_MASK (0x00000300u)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_LOOP_BW_SHIFT (0x00000008u)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_LOOP_BW_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_PLL_CFG_MPY_FACTOR_MASK (0x0000001Eu)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_MPY_FACTOR_SHIFT (0x00000001u)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_MPY_FACTOR_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_PLL_CFG_PLL_EN_MASK (0x00000001u)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_PLL_EN_SHIFT (0x00000000u)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_PLL_EN_RESETVAL (0x00000000u)

/*----PLL_EN Tokens----*/
#define CSL_AIF_AIF_SERDES1_PLL_CFG_PLL_EN_DISABLED (0x00000000u)
#define CSL_AIF_AIF_SERDES1_PLL_CFG_PLL_EN_ENABLED (0x00000001u)

#define CSL_AIF_AIF_SERDES1_PLL_CFG_RESETVAL (0x00000000u)

/* AIF_SERDES0_TST_CFG */

#define CSL_AIF_AIF_SERDES0_TST_CFG_INVPATT_MASK (0x00004000u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_INVPATT_SHIFT (0x0000000Eu)
#define CSL_AIF_AIF_SERDES0_TST_CFG_INVPATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_RATE_MASK (0x00003000u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_RATE_SHIFT (0x0000000Cu)
#define CSL_AIF_AIF_SERDES0_TST_CFG_RATE_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_LOOPBACK_MASK (0x000000C0u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_LOOPBACK_SHIFT (0x00000006u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_LOOPBACK_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_CLK_BYP_MASK (0x00000030u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_CLK_BYP_SHIFT (0x00000004u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_CLK_BYP_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_EN_RX_PATT_MASK (0x00000008u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_EN_RX_PATT_SHIFT (0x00000003u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_EN_RX_PATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_EX_TX_PATT_MASK (0x00000004u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_EX_TX_PATT_SHIFT (0x00000002u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_EX_TX_PATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_TEST_PATT_MASK (0x00000003u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_TEST_PATT_SHIFT (0x00000000u)
#define CSL_AIF_AIF_SERDES0_TST_CFG_TEST_PATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES0_TST_CFG_RESETVAL (0x00000000u)

/* AIF_SERDES1_TST_CFG */

#define CSL_AIF_AIF_SERDES1_TST_CFG_INVPATT_MASK (0x00004000u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_INVPATT_SHIFT (0x0000000Eu)
#define CSL_AIF_AIF_SERDES1_TST_CFG_INVPATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_RATE_MASK (0x00003000u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_RATE_SHIFT (0x0000000Cu)
#define CSL_AIF_AIF_SERDES1_TST_CFG_RATE_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_LOOPBACK_MASK (0x000000C0u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_LOOPBACK_SHIFT (0x00000006u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_LOOPBACK_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_CLK_BYP_MASK (0x00000030u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_CLK_BYP_SHIFT (0x00000004u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_CLK_BYP_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_EN_RX_PATT_MASK (0x00000008u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_EN_RX_PATT_SHIFT (0x00000003u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_EN_RX_PATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_EX_TX_PATT_MASK (0x00000004u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_EX_TX_PATT_SHIFT (0x00000002u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_EX_TX_PATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_TEST_PATT_MASK (0x00000003u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_TEST_PATT_SHIFT (0x00000000u)
#define CSL_AIF_AIF_SERDES1_TST_CFG_TEST_PATT_RESETVAL (0x00000000u)

#define CSL_AIF_AIF_SERDES1_TST_CFG_RESETVAL (0x00000000u)

/* SERDES_STS */

#define CSL_AIF_SERDES_STS_PLL1_LOCKED_MASK (0x00000080u)
#define CSL_AIF_SERDES_STS_PLL1_LOCKED_SHIFT (0x00000007u)
#define CSL_AIF_SERDES_STS_PLL1_LOCKED_RESETVAL (0x00000000u)

#define CSL_AIF_SERDES_STS_PLL0_LOCKED_MASK (0x00000040u)
#define CSL_AIF_SERDES_STS_PLL0_LOCKED_SHIFT (0x00000006u)
#define CSL_AIF_SERDES_STS_PLL0_LOCKED_RESETVAL (0x00000000u)

#define CSL_AIF_SERDES_STS_SD_RX_LOS_DET_MASK (0x0000003Fu)
#define CSL_AIF_SERDES_STS_SD_RX_LOS_DET_SHIFT (0x00000000u)
#define CSL_AIF_SERDES_STS_SD_RX_LOS_DET_RESETVAL (0x00000000u)

#define CSL_AIF_SERDES_STS_RESETVAL      (0x00000000u)

/* LINK_CFG */

#define CSL_AIF_LINK_CFG_SD_TX_TEST_EN_MASK (0x20000000u)
#define CSL_AIF_LINK_CFG_SD_TX_TEST_EN_SHIFT (0x0000001Du)
#define CSL_AIF_LINK_CFG_SD_TX_TEST_EN_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_RX_TEXT_EN_MASK (0x10000000u)
#define CSL_AIF_LINK_CFG_SD_RX_TEXT_EN_SHIFT (0x0000001Cu)
#define CSL_AIF_LINK_CFG_SD_RX_TEXT_EN_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_TX_DE_MASK   (0x07800000u)
#define CSL_AIF_LINK_CFG_SD_TX_DE_SHIFT  (0x00000017u)
#define CSL_AIF_LINK_CFG_SD_TX_DE_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_TX_SWING_MASK (0x00700000u)
#define CSL_AIF_LINK_CFG_SD_TX_SWING_SHIFT (0x00000014u)
#define CSL_AIF_LINK_CFG_SD_TX_SWING_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_TX_INV_TX_PAIR_MASK (0x00080000u)
#define CSL_AIF_LINK_CFG_SD_TX_INV_TX_PAIR_SHIFT (0x00000013u)
#define CSL_AIF_LINK_CFG_SD_TX_INV_TX_PAIR_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_TX_CM_MASK   (0x00040000u)
#define CSL_AIF_LINK_CFG_SD_TX_CM_SHIFT  (0x00000012u)
#define CSL_AIF_LINK_CFG_SD_TX_CM_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_RX_EQ_MASK   (0x0003C000u)
#define CSL_AIF_LINK_CFG_SD_RX_EQ_SHIFT  (0x0000000Eu)
#define CSL_AIF_LINK_CFG_SD_RX_EQ_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_RX_CDR_MASK  (0x00003800u)
#define CSL_AIF_LINK_CFG_SD_RX_CDR_SHIFT (0x0000000Bu)
#define CSL_AIF_LINK_CFG_SD_RX_CDR_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_RX_TERM_MASK (0x00000700u)
#define CSL_AIF_LINK_CFG_SD_RX_TERM_SHIFT (0x00000008u)
#define CSL_AIF_LINK_CFG_SD_RX_TERM_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_RX_INV_RX_PAIR_MASK (0x00000040u)
#define CSL_AIF_LINK_CFG_SD_RX_INV_RX_PAIR_SHIFT (0x00000006u)
#define CSL_AIF_LINK_CFG_SD_RX_INV_RX_PAIR_RESETVAL (0x00000000u)

#define CSL_AIF_LINK_CFG_SD_RX_LOS_EN_MASK (0x00000020u)
#define CSL_AIF_LINK_CFG_SD_RX_LOS_EN_SHIFT (0x00000005u)
#define CSL_AIF_LINK_CFG_SD_RX_LOS_EN_RESETVAL (0x00000000u)

/*----SD_RX_LOS_EN Tokens----*/
#define CSL_AIF_LINK_CFG_SD_RX_LOS_EN_DISABLED (0x00000000u)
#define CSL_AIF_LINK_CFG_SD_RX_LOS_EN_ENABLED (0x00000001u)

#define CSL_AIF_LINK_CFG_SD_RX_ALIGN_EN_MASK (0x00000010u)
#define CSL_AIF_LINK_CFG_SD_RX_ALIGN_EN_SHIFT (0x00000004u)
#define CSL_AIF_LINK_CFG_SD_RX_ALIGN_EN_RESETVAL (0x00000000u)

/*----SD_RX_ALIGN_EN Tokens----*/
#define CSL_AIF_LINK_CFG_SD_RX_ALIGN_EN_DISABLED (0x00000000u)
#define CSL_AIF_LINK_CFG_SD_RX_ALIGN_EN_ENABLED (0x00000001u)

#define CSL_AIF_LINK_CFG_LINK_RATE_MASK  (0x0000000Cu)
#define CSL_AIF_LINK_CFG_LINK_RATE_SHIFT (0x00000002u)
#define CSL_AIF_LINK_CFG_LINK_RATE_RESETVAL (0x00000000u)

/*----LINK_RATE Tokens----*/
#define CSL_AIF_LINK_CFG_LINK_RATE_4X    (0x00000000u)
#define CSL_AIF_LINK_CFG_LINK_RATE_2X    (0x00000001u)
#define CSL_AIF_LINK_CFG_LINK_RATE_1X    (0x00000002u)

#define CSL_AIF_LINK_CFG_TX_LINK_EN_MASK (0x00000002u)
#define CSL_AIF_LINK_CFG_TX_LINK_EN_SHIFT (0x00000001u)
#define CSL_AIF_LINK_CFG_TX_LINK_EN_RESETVAL (0x00000000u)

/*----TX_LINK_EN Tokens----*/
#define CSL_AIF_LINK_CFG_TX_LINK_EN_DISABLED (0x00000000u)
#define CSL_AIF_LINK_CFG_TX_LINK_EN_ENABLED (0x00000001u)

#define CSL_AIF_LINK_CFG_RX_LINK_EN_MASK (0x00000001u)
#define CSL_AIF_LINK_CFG_RX_LINK_EN_SHIFT (0x00000000u)
#define CSL_AIF_LINK_CFG_RX_LINK_EN_RESETVAL (0x00000000u)

/*----RX_LINK_EN Tokens----*/
#define CSL_AIF_LINK_CFG_RX_LINK_EN_DISABLED (0x00000000u)
#define CSL_AIF_LINK_CFG_RX_LINK_EN_ENABLED (0x00000001u)

#define CSL_AIF_LINK_CFG_RESETVAL        (0x00000000u)

/* RM_LINK_CFG */

#define CSL_AIF_RM_LINK_CFG_RM_RCVD_MSTR_FRAME_WIND_MASK (0x0FFF0000u)
#define CSL_AIF_RM_LINK_CFG_RM_RCVD_MSTR_FRAME_WIND_SHIFT (0x00000010u)
#define CSL_AIF_RM_LINK_CFG_RM_RCVD_MSTR_FRAME_WIND_RESETVAL (0x00000000u)

/*----RM_RCVD_MSTR_FRAME_WIND Tokens----*/
#define CSL_AIF_RM_LINK_CFG_RM_RCVD_MSTR_FRAME_WIND_DISABLE (0x00000000u)

#define CSL_AIF_RM_LINK_CFG_RM_VALID_MSTR_FRAME_WIND_MASK (0x0000FF00u)
#define CSL_AIF_RM_LINK_CFG_RM_VALID_MSTR_FRAME_WIND_SHIFT (0x00000008u)
#define CSL_AIF_RM_LINK_CFG_RM_VALID_MSTR_FRAME_WIND_RESETVAL (0x00000000u)

/*----RM_VALID_MSTR_FRAME_WIND Tokens----*/
#define CSL_AIF_RM_LINK_CFG_RM_VALID_MSTR_FRAME_WIND_DISABLE (0x00000000u)

#define CSL_AIF_RM_LINK_CFG_RM_EXTRA_K28P7_ERR_SUPPRESS_MASK (0x00000020u)
#define CSL_AIF_RM_LINK_CFG_RM_EXTRA_K28P7_ERR_SUPPRESS_SHIFT (0x00000005u)
#define CSL_AIF_RM_LINK_CFG_RM_EXTRA_K28P7_ERR_SUPPRESS_RESETVAL (0x00000000u)

/*----RM_EXTRA_K28P7_ERR_SUPPRESS Tokens----*/
#define CSL_AIF_RM_LINK_CFG_RM_EXTRA_K28P7_ERR_SUPPRESS_ALLOW (0x00000000u)
#define CSL_AIF_RM_LINK_CFG_RM_EXTRA_K28P7_ERR_SUPPRESS_SUPPRESS (0x00000001u)

#define CSL_AIF_RM_LINK_CFG_RM_ERROR_SUPPRESS_MASK (0x00000010u)
#define CSL_AIF_RM_LINK_CFG_RM_ERROR_SUPPRESS_SHIFT (0x00000004u)
#define CSL_AIF_RM_LINK_CFG_RM_ERROR_SUPPRESS_RESETVAL (0x00000000u)

/*----RM_ERROR_SUPPRESS Tokens----*/
#define CSL_AIF_RM_LINK_CFG_RM_ERROR_SUPPRESS_ALLOW (0x00000000u)
#define CSL_AIF_RM_LINK_CFG_RM_ERROR_SUPPRESS_SUPPRESS (0x00000001u)

#define CSL_AIF_RM_LINK_CFG_RM_FORCE_RX_STATE_MASK (0x0000000Eu)
#define CSL_AIF_RM_LINK_CFG_RM_FORCE_RX_STATE_SHIFT (0x00000001u)
#define CSL_AIF_RM_LINK_CFG_RM_FORCE_RX_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_CFG_RM_RECEIVER_EN_MASK (0x00000001u)
#define CSL_AIF_RM_LINK_CFG_RM_RECEIVER_EN_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_CFG_RM_RECEIVER_EN_RESETVAL (0x00000000u)

/*----RM_RECEIVER_EN Tokens----*/
#define CSL_AIF_RM_LINK_CFG_RM_RECEIVER_EN_DISABLED (0x00000000u)
#define CSL_AIF_RM_LINK_CFG_RM_RECEIVER_EN_ENABLED (0x00000001u)

#define CSL_AIF_RM_LINK_CFG_RESETVAL     (0x00000000u)

/* RM_LINK_PI_OFFSET_CFG */

#define CSL_AIF_RM_LINK_PI_OFFSET_CFG_RM_PI_OFFSET_MASK (0x000FFFFFu)
#define CSL_AIF_RM_LINK_PI_OFFSET_CFG_RM_PI_OFFSET_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_PI_OFFSET_CFG_RM_PI_OFFSET_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_PI_OFFSET_CFG_RESETVAL (0x00000000u)

/* RM_LINK_LOS_THOLD_CFG */

#define CSL_AIF_RM_LINK_LOS_THOLD_CFG_RM_LOS_DET_THOLD_MASK (0x000FFFFFu)
#define CSL_AIF_RM_LINK_LOS_THOLD_CFG_RM_LOS_DET_THOLD_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_LOS_THOLD_CFG_RM_LOS_DET_THOLD_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_LOS_THOLD_CFG_RESETVAL (0x00000000u)

/* RM_LINK_STSA */

#define CSL_AIF_RM_LINK_STSA_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MASK (0x00000400u)
#define CSL_AIF_RM_LINK_STSA_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_SHIFT (0x0000000Au)
#define CSL_AIF_RM_LINK_STSA_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSA_RM_LOS_DET_MASK (0x00000200u)
#define CSL_AIF_RM_LINK_STSA_RM_LOS_DET_SHIFT (0x00000009u)
#define CSL_AIF_RM_LINK_STSA_RM_LOS_DET_RESETVAL (0x00000000u)

/*----RM_LOS_DET Tokens----*/
#define CSL_AIF_RM_LINK_STSA_RM_LOS_DET_NOT_DETECTED (0x00000000u)
#define CSL_AIF_RM_LINK_STSA_RM_LOS_DET_DETECTED (0x00000001u)

#define CSL_AIF_RM_LINK_STSA_RM_LOSS_OF_SIGNAL_MASK (0x00000100u)
#define CSL_AIF_RM_LINK_STSA_RM_LOSS_OF_SIGNAL_SHIFT (0x00000008u)
#define CSL_AIF_RM_LINK_STSA_RM_LOSS_OF_SIGNAL_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSA_RM_SYNC_STATUS_MASK (0x0000000Fu)
#define CSL_AIF_RM_LINK_STSA_RM_SYNC_STATUS_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_STSA_RM_SYNC_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSA_RESETVAL    (0x00000000u)

/* RM_LINK_STSB */

#define CSL_AIF_RM_LINK_STSB_RM_RCVD_MSTR_FRAME_OFFSET_MASK (0xFFF00000u)
#define CSL_AIF_RM_LINK_STSB_RM_RCVD_MSTR_FRAME_OFFSET_SHIFT (0x00000014u)
#define CSL_AIF_RM_LINK_STSB_RM_RCVD_MSTR_FRAME_OFFSET_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSB_RM_NUM_LOS_MASK (0x000FFFFFu)
#define CSL_AIF_RM_LINK_STSB_RM_NUM_LOS_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_STSB_RM_NUM_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSB_RESETVAL    (0x00000000u)

/* RM_LINK_STSC */

#define CSL_AIF_RM_LINK_STSC_RM_LOF_STATE_MASK (0x02000000u)
#define CSL_AIF_RM_LINK_STSC_RM_LOF_STATE_SHIFT (0x00000019u)
#define CSL_AIF_RM_LINK_STSC_RM_LOF_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSC_RM_HFSYNC_STATE_MASK (0x01000000u)
#define CSL_AIF_RM_LINK_STSC_RM_HFSYNC_STATE_SHIFT (0x00000018u)
#define CSL_AIF_RM_LINK_STSC_RM_HFSYNC_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSC_RM_BFN_HIGH_MASK (0x00FF0000u)
#define CSL_AIF_RM_LINK_STSC_RM_BFN_HIGH_SHIFT (0x00000010u)
#define CSL_AIF_RM_LINK_STSC_RM_BFN_HIGH_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSC_RM_BFN_LOW_MASK (0x0000FF00u)
#define CSL_AIF_RM_LINK_STSC_RM_BFN_LOW_SHIFT (0x00000008u)
#define CSL_AIF_RM_LINK_STSC_RM_BFN_LOW_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSC_RM_HFN_MASK (0x000000FFu)
#define CSL_AIF_RM_LINK_STSC_RM_HFN_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_STSC_RM_HFN_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSC_RESETVAL    (0x00000000u)

/* RM_LINK_STSD */

#define CSL_AIF_RM_LINK_STSD_RM_PNTR_P_MASK (0xFF000000u)
#define CSL_AIF_RM_LINK_STSD_RM_PNTR_P_SHIFT (0x00000018u)
#define CSL_AIF_RM_LINK_STSD_RM_PNTR_P_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_RCVD_LOF_MASK (0x00100000u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_LOF_SHIFT (0x00000014u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_RCVD_LOS_MASK (0x00080000u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_LOS_SHIFT (0x00000013u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_RCVD_SDI_MASK (0x00040000u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_SDI_SHIFT (0x00000012u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_RCVD_RAI_MASK (0x00020000u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_RAI_SHIFT (0x00000011u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_RCVD_RST_MASK (0x00010000u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_RST_SHIFT (0x00000010u)
#define CSL_AIF_RM_LINK_STSD_RM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_START_UP_MASK (0x0000FF00u)
#define CSL_AIF_RM_LINK_STSD_RM_START_UP_SHIFT (0x00000008u)
#define CSL_AIF_RM_LINK_STSD_RM_START_UP_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RM_VERSION_MASK (0x000000FFu)
#define CSL_AIF_RM_LINK_STSD_RM_VERSION_SHIFT (0x00000000u)
#define CSL_AIF_RM_LINK_STSD_RM_VERSION_RESETVAL (0x00000000u)

#define CSL_AIF_RM_LINK_STSD_RESETVAL    (0x00000000u)

/* RM_SYNC_CNT_CFG */

#define CSL_AIF_RM_SYNC_CNT_CFG_RM_FRAME_SYNC_T_MASK (0xFFFF0000u)
#define CSL_AIF_RM_SYNC_CNT_CFG_RM_FRAME_SYNC_T_SHIFT (0x00000010u)
#define CSL_AIF_RM_SYNC_CNT_CFG_RM_FRAME_SYNC_T_RESETVAL (0x00000000u)

#define CSL_AIF_RM_SYNC_CNT_CFG_RM_SYNC_T_MASK (0x0000FFFFu)
#define CSL_AIF_RM_SYNC_CNT_CFG_RM_SYNC_T_SHIFT (0x00000000u)
#define CSL_AIF_RM_SYNC_CNT_CFG_RM_SYNC_T_RESETVAL (0x00000000u)

#define CSL_AIF_RM_SYNC_CNT_CFG_RESETVAL (0x00000000u)

/* RM_UNSYNC_CNT_CFG */

#define CSL_AIF_RM_UNSYNC_CNT_CFG_RM_FRAME_UNSYNC_T_MASK (0xFFFF0000u)
#define CSL_AIF_RM_UNSYNC_CNT_CFG_RM_FRAME_UNSYNC_T_SHIFT (0x00000010u)
#define CSL_AIF_RM_UNSYNC_CNT_CFG_RM_FRAME_UNSYNC_T_RESETVAL (0x00000000u)

#define CSL_AIF_RM_UNSYNC_CNT_CFG_RM_UNSYNC_T_MASK (0x0000FFFFu)
#define CSL_AIF_RM_UNSYNC_CNT_CFG_RM_UNSYNC_T_SHIFT (0x00000000u)
#define CSL_AIF_RM_UNSYNC_CNT_CFG_RM_UNSYNC_T_RESETVAL (0x00000000u)

#define CSL_AIF_RM_UNSYNC_CNT_CFG_RESETVAL (0x00000000u)

/* TM_LINK_CFGA */

#define CSL_AIF_TM_LINK_CFGA_TM_DELTA_OFFSET_MASK (0xFFFF0000u)
#define CSL_AIF_TM_LINK_CFGA_TM_DELTA_OFFSET_SHIFT (0x00000010u)
#define CSL_AIF_TM_LINK_CFGA_TM_DELTA_OFFSET_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGA_TM_FIFO_FULL_THOLD_MASK (0x00001F00u)
#define CSL_AIF_TM_LINK_CFGA_TM_FIFO_FULL_THOLD_SHIFT (0x00000008u)
#define CSL_AIF_TM_LINK_CFGA_TM_FIFO_FULL_THOLD_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGA_TM_LOS_EN_MASK (0x00000020u)
#define CSL_AIF_TM_LINK_CFGA_TM_LOS_EN_SHIFT (0x00000005u)
#define CSL_AIF_TM_LINK_CFGA_TM_LOS_EN_RESETVAL (0x00000000u)

/*----TM_LOS_EN Tokens----*/
#define CSL_AIF_TM_LINK_CFGA_TM_LOS_EN_DISABLED (0x00000000u)
#define CSL_AIF_TM_LINK_CFGA_TM_LOS_EN_ENABLED (0x00000001u)

#define CSL_AIF_TM_LINK_CFGA_TM_FRAME_XMIT_EN_MASK (0x00000010u)
#define CSL_AIF_TM_LINK_CFGA_TM_FRAME_XMIT_EN_SHIFT (0x00000004u)
#define CSL_AIF_TM_LINK_CFGA_TM_FRAME_XMIT_EN_RESETVAL (0x00000000u)

/*----TM_FRAME_XMIT_EN Tokens----*/
#define CSL_AIF_TM_LINK_CFGA_TM_FRAME_XMIT_EN_DISABLED (0x00000000u)
#define CSL_AIF_TM_LINK_CFGA_TM_FRAME_XMIT_EN_ENABLED (0x00000001u)

#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_MASK (0x0000000Eu)
#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_SHIFT (0x00000001u)
#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_RESETVAL (0x00000000u)

/*----TM_FORCE_TX_STATE Tokens----*/
#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_NOT_ACTIVE0 (0x00000000u)
#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_FORCE_ST0 (0x00000004u)
#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_FORCE_ST1 (0x00000005u)
#define CSL_AIF_TM_LINK_CFGA_TM_FORCE_TX_STATE_FORCE_ST2 (0x00000006u)

#define CSL_AIF_TM_LINK_CFGA_TM_TRANSMITTER_EN_MASK (0x00000001u)
#define CSL_AIF_TM_LINK_CFGA_TM_TRANSMITTER_EN_SHIFT (0x00000000u)
#define CSL_AIF_TM_LINK_CFGA_TM_TRANSMITTER_EN_RESETVAL (0x00000000u)

/*----TM_TRANSMITTER_EN Tokens----*/
#define CSL_AIF_TM_LINK_CFGA_TM_TRANSMITTER_EN_DISABLED (0x00000000u)
#define CSL_AIF_TM_LINK_CFGA_TM_TRANSMITTER_EN_ENABLED (0x00000001u)

#define CSL_AIF_TM_LINK_CFGA_RESETVAL    (0x00000000u)

/* TM_LINK_CFGB */

#define CSL_AIF_TM_LINK_CFGB_TM_PNTR_P_MASK (0xFF000000u)
#define CSL_AIF_TM_LINK_CFGB_TM_PNTR_P_SHIFT (0x00000018u)
#define CSL_AIF_TM_LINK_CFGB_TM_PNTR_P_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_START_UP_MASK (0x00FF0000u)
#define CSL_AIF_TM_LINK_CFGB_TM_START_UP_SHIFT (0x00000010u)
#define CSL_AIF_TM_LINK_CFGB_TM_START_UP_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_VERSION_MASK (0x0000FF00u)
#define CSL_AIF_TM_LINK_CFGB_TM_VERSION_SHIFT (0x00000008u)
#define CSL_AIF_TM_LINK_CFGB_TM_VERSION_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_LOF_MASK (0x00000010u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_LOF_SHIFT (0x00000004u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_LOS_MASK (0x00000008u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_LOS_SHIFT (0x00000003u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_SDI_MASK (0x00000004u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_SDI_SHIFT (0x00000002u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_RAI_MASK (0x00000002u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_RAI_SHIFT (0x00000001u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_RST_MASK (0x00000001u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_RST_SHIFT (0x00000000u)
#define CSL_AIF_TM_LINK_CFGB_TM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGB_RESETVAL    (0x00000000u)

/* TM_LINK_CFGC */

#define CSL_AIF_TM_LINK_CFGC_TM_BFN_HIGH_MASK (0x0000FF00u)
#define CSL_AIF_TM_LINK_CFGC_TM_BFN_HIGH_SHIFT (0x00000008u)
#define CSL_AIF_TM_LINK_CFGC_TM_BFN_HIGH_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGC_TM_BFN_LOW_MASK (0x000000FFu)
#define CSL_AIF_TM_LINK_CFGC_TM_BFN_LOW_SHIFT (0x00000000u)
#define CSL_AIF_TM_LINK_CFGC_TM_BFN_LOW_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_CFGC_RESETVAL    (0x00000000u)

/* TM_LINK_STS */

#define CSL_AIF_TM_LINK_STS_TM_FIFO_UNF_MASK (0x00000800u)
#define CSL_AIF_TM_LINK_STS_TM_FIFO_UNF_SHIFT (0x0000000Bu)
#define CSL_AIF_TM_LINK_STS_TM_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_STS_TM_FIFO_OVF_MASK (0x00000400u)
#define CSL_AIF_TM_LINK_STS_TM_FIFO_OVF_SHIFT (0x0000000Au)
#define CSL_AIF_TM_LINK_STS_TM_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_STS_TM_DATA_NOT_ALIGNED_MASK (0x00000200u)
#define CSL_AIF_TM_LINK_STS_TM_DATA_NOT_ALIGNED_SHIFT (0x00000009u)
#define CSL_AIF_TM_LINK_STS_TM_DATA_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_STS_TM_FRAME_NOT_ALIGNED_MASK (0x00000100u)
#define CSL_AIF_TM_LINK_STS_TM_FRAME_NOT_ALIGNED_SHIFT (0x00000008u)
#define CSL_AIF_TM_LINK_STS_TM_FRAME_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_STS_TM_SYNC_STATUS_MASK (0x00000007u)
#define CSL_AIF_TM_LINK_STS_TM_SYNC_STATUS_SHIFT (0x00000000u)
#define CSL_AIF_TM_LINK_STS_TM_SYNC_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_TM_LINK_STS_RESETVAL     (0x00000000u)

/* CD_OUT_MUX_SEL_CFG */

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC1_EN_MASK (0x08000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC1_EN_SHIFT (0x0000001Bu)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC1_EN_RESETVAL (0x00000000u)

/*----DC1_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC1_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC1_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC0_EN_MASK (0x04000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC0_EN_SHIFT (0x0000001Au)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC0_EN_RESETVAL (0x00000000u)

/*----DC0_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC0_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_DC0_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB1_EN_MASK (0x02000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB1_EN_SHIFT (0x00000019u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB1_EN_RESETVAL (0x00000000u)

/*----CB1_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB1_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB1_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB0_EN_MASK (0x01000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB0_EN_SHIFT (0x00000018u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB0_EN_RESETVAL (0x00000000u)

/*----CB0_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB0_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CB0_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT5_EN_MASK (0x00800000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT5_EN_SHIFT (0x00000017u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT5_EN_RESETVAL (0x00000000u)

/*----CD_OUT5_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT5_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT5_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_MASK (0x00700000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_SHIFT (0x00000014u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_RESETVAL (0x00000000u)

/*----CD_OUT_MUX5_SRC_SEL Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_LINK_5 (0x00000005u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_CB_0 (0x00000006u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX5_SRC_SEL_CB_1 (0x00000007u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT4_EN_MASK (0x00080000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT4_EN_SHIFT (0x00000013u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT4_EN_RESETVAL (0x00000000u)

/*----CD_OUT4_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT4_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT4_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_MASK (0x00070000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_SHIFT (0x00000010u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_RESETVAL (0x00000000u)

/*----CD_OUT_MUX4_SRC_SEL Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_LINK_5 (0x00000005u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_CB_0 (0x00000006u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX4_SRC_SEL_CB_1 (0x00000007u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT3_EN_MASK (0x00008000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT3_EN_SHIFT (0x0000000Fu)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT3_EN_RESETVAL (0x00000000u)

/*----CD_OUT3_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT3_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT3_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_MASK (0x00007000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_SHIFT (0x0000000Cu)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_RESETVAL (0x00000000u)

/*----CD_OUT_MUX3_SRC_SEL Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_LINK_5 (0x00000005u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_CB_0 (0x00000006u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX3_SRC_SEL_CB_1 (0x00000007u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT2_EN_MASK (0x00000800u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT2_EN_SHIFT (0x0000000Bu)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT2_EN_RESETVAL (0x00000000u)

/*----CD_OUT2_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT2_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT2_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_MASK (0x00000700u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_SHIFT (0x00000008u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_RESETVAL (0x00000000u)

/*----CD_OUT_MUX2_SRC_SEL Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_LINK_5 (0x00000005u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_CB_0 (0x00000006u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX2_SRC_SEL_CB_1 (0x00000007u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT1_EN_MASK (0x00000080u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT1_EN_SHIFT (0x00000007u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT1_EN_RESETVAL (0x00000000u)

/*----CD_OUT1_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT1_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT1_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_MASK (0x00000070u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_SHIFT (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_RESETVAL (0x00000000u)

/*----CD_OUT_MUX1_SRC_SEL Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_LINK_5 (0x00000005u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_CB_0 (0x00000006u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX1_SRC_SEL_CB_1 (0x00000007u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT0_EN_MASK (0x00000008u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT0_EN_SHIFT (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT0_EN_RESETVAL (0x00000000u)

/*----CD_OUT0_EN Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT0_EN_DISABLE (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT0_EN_ENABLE (0x00000001u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_MASK (0x00000007u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_SHIFT (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_RESETVAL (0x00000000u)

/*----CD_OUT_MUX0_SRC_SEL Tokens----*/
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_LINK_5 (0x00000005u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_CB_0 (0x00000006u)
#define CSL_AIF_CD_OUT_MUX_SEL_CFG_CD_OUT_MUX0_SRC_SEL_CB_1 (0x00000007u)

#define CSL_AIF_CD_OUT_MUX_SEL_CFG_RESETVAL (0x00000000u)

/* CD_CB_SRC_SEL_CFG */

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_MASK (0x70000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_SHIFT (0x0000001Cu)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_RESETVAL (0x00000000u)

/*----CB1_SRC_D_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_D_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_MASK (0x07000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_SHIFT (0x00000018u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_RESETVAL (0x00000000u)

/*----CB1_SRC_C_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_C_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_MASK (0x00700000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_SHIFT (0x00000014u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_RESETVAL (0x00000000u)

/*----CB1_SRC_B_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_B_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_MASK (0x00070000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_SHIFT (0x00000010u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_RESETVAL (0x00000000u)

/*----CB1_SRC_A_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB1_SRC_A_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_MASK (0x00007000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_SHIFT (0x0000000Cu)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_RESETVAL (0x00000000u)

/*----CB0_SRC_D_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_D_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_MASK (0x00000700u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_SHIFT (0x00000008u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_RESETVAL (0x00000000u)

/*----CB0_SRC_C_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_C_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_MASK (0x00000070u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_SHIFT (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_RESETVAL (0x00000000u)

/*----CB0_SRC_B_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_B_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_MASK (0x00000007u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_SHIFT (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_RESETVAL (0x00000000u)

/*----CB0_SRC_A_SEL Tokens----*/
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_CB_SRC_SEL_CFG_CB0_SRC_A_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_CB_SRC_SEL_CFG_RESETVAL (0x00000000u)

/* CD_CB_OFFSET_CFG */

#define CSL_AIF_CD_CB_OFFSET_CFG_CB1_FS_OFFSET_MASK (0xFFFF0000u)
#define CSL_AIF_CD_CB_OFFSET_CFG_CB1_FS_OFFSET_SHIFT (0x00000010u)
#define CSL_AIF_CD_CB_OFFSET_CFG_CB1_FS_OFFSET_RESETVAL (0x00000000u)

#define CSL_AIF_CD_CB_OFFSET_CFG_CB0_FS_OFFSET_MASK (0x0000FFFFu)
#define CSL_AIF_CD_CB_OFFSET_CFG_CB0_FS_OFFSET_SHIFT (0x00000000u)
#define CSL_AIF_CD_CB_OFFSET_CFG_CB0_FS_OFFSET_RESETVAL (0x00000000u)

#define CSL_AIF_CD_CB_OFFSET_CFG_RESETVAL (0x00000000u)

/* CD_CB_VALID_WIND_CFG */

#define CSL_AIF_CD_CB_VALID_WIND_CFG_CB1_VALID_DATA_WIND_MASK (0x00001F00u)
#define CSL_AIF_CD_CB_VALID_WIND_CFG_CB1_VALID_DATA_WIND_SHIFT (0x00000008u)
#define CSL_AIF_CD_CB_VALID_WIND_CFG_CB1_VALID_DATA_WIND_RESETVAL (0x00000000u)

#define CSL_AIF_CD_CB_VALID_WIND_CFG_CB0_VALID_DATA_WIND_MASK (0x0000001Fu)
#define CSL_AIF_CD_CB_VALID_WIND_CFG_CB0_VALID_DATA_WIND_SHIFT (0x00000000u)
#define CSL_AIF_CD_CB_VALID_WIND_CFG_CB0_VALID_DATA_WIND_RESETVAL (0x00000000u)

#define CSL_AIF_CD_CB_VALID_WIND_CFG_RESETVAL (0x00000000u)

/* CD_DC_SRC_SEL_CFG */

#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_MASK (0x00000070u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_SHIFT (0x00000004u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_RESETVAL (0x00000000u)

/*----DC1_SRC_SEL Tokens----*/
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC1_SRC_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_MASK (0x00000007u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_SHIFT (0x00000000u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_RESETVAL (0x00000000u)

/*----DC0_SRC_SEL Tokens----*/
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_SRC_SEL_CFG_DC0_SRC_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_SRC_SEL_CFG_RESETVAL (0x00000000u)

/* CD_DC_DST_SEL_CFG */

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_MASK (0x70000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_SHIFT (0x0000001Cu)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_RESETVAL (0x00000000u)

/*----DC1_DEST_D_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_D_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_MASK (0x07000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_SHIFT (0x00000018u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_RESETVAL (0x00000000u)

/*----DC1_DEST_C_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_C_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_MASK (0x00700000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_SHIFT (0x00000014u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_RESETVAL (0x00000000u)

/*----DC1_DEST_B_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_B_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_MASK (0x00070000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_SHIFT (0x00000010u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_RESETVAL (0x00000000u)

/*----DC1_DEST_A_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC1_DEST_A_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_MASK (0x00007000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_SHIFT (0x0000000Cu)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_RESETVAL (0x00000000u)

/*----DC0_DEST_D_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_D_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_MASK (0x00000700u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_SHIFT (0x00000008u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_RESETVAL (0x00000000u)

/*----DC0_DEST_C_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_C_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_MASK (0x00000070u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_SHIFT (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_RESETVAL (0x00000000u)

/*----DC0_DEST_B_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_B_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_MASK (0x00000007u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_SHIFT (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_RESETVAL (0x00000000u)

/*----DC0_DEST_A_SEL Tokens----*/
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_LINK_0 (0x00000000u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_LINK_1 (0x00000001u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_LINK_2 (0x00000002u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_LINK_3 (0x00000003u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_LINK_4 (0x00000004u)
#define CSL_AIF_CD_DC_DST_SEL_CFG_DC0_DEST_A_SEL_LINK_5 (0x00000005u)

#define CSL_AIF_CD_DC_DST_SEL_CFG_RESETVAL (0x00000000u)

/* CD_STS */

#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK5_MASK (0x00200000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK5_SHIFT (0x00000015u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK5_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK4_MASK (0x00100000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK4_SHIFT (0x00000014u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK3_MASK (0x00080000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK3_SHIFT (0x00000013u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK2_MASK (0x00040000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK2_SHIFT (0x00000012u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK1_MASK (0x00020000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK1_SHIFT (0x00000011u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK0_MASK (0x00010000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK0_SHIFT (0x00000010u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_OVF_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK5_MASK (0x00002000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK5_SHIFT (0x0000000Du)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK5_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK4_MASK (0x00001000u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK4_SHIFT (0x0000000Cu)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK3_MASK (0x00000800u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK3_SHIFT (0x0000000Bu)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK2_MASK (0x00000400u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK2_SHIFT (0x0000000Au)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK1_MASK (0x00000200u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK1_SHIFT (0x00000009u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK0_MASK (0x00000100u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK0_SHIFT (0x00000008u)
#define CSL_AIF_CD_STS_CD_OUT_FIFO_UNF_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_CB_ALIGN_ERR_MASK (0x00000003u)
#define CSL_AIF_CD_STS_CB_ALIGN_ERR_SHIFT (0x00000000u)
#define CSL_AIF_CD_STS_CB_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_CD_STS_RESETVAL          (0x00000000u)

/* AG_LINK_CFG */

#define CSL_AIF_AG_LINK_CFG_AG_HDR_ERR_SEL_MASK (0x00000008u)
#define CSL_AIF_AG_LINK_CFG_AG_HDR_ERR_SEL_SHIFT (0x00000003u)
#define CSL_AIF_AG_LINK_CFG_AG_HDR_ERR_SEL_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_CFG_AG_ERR_EN_MASK (0x00000004u)
#define CSL_AIF_AG_LINK_CFG_AG_ERR_EN_SHIFT (0x00000002u)
#define CSL_AIF_AG_LINK_CFG_AG_ERR_EN_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_CFG_AG_MODE_MASK (0x00000003u)
#define CSL_AIF_AG_LINK_CFG_AG_MODE_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_CFG_AG_MODE_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_CFG_RESETVAL     (0x00000000u)

/* AG_LINK_STS */

#define CSL_AIF_AG_LINK_STS_AG_AXC_SUM_OVF_MASK (0x0000FFFFu)
#define CSL_AIF_AG_LINK_STS_AG_AXC_SUM_OVF_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_STS_AG_AXC_SUM_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_STS_RESETVAL     (0x00000000u)

/* AG_LINK_HDR_ERR_STSA */

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR20_MASK (0x00100000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR20_SHIFT (0x00000014u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR20_RESETVAL (0x00000000u)

/*----HDR_ERR20 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR20_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR20_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR_MASK (0x001FFFFFu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR19_MASK (0x00080000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR19_SHIFT (0x00000013u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR19_RESETVAL (0x00000000u)

/*----HDR_ERR19 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR19_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR19_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR18_MASK (0x00040000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR18_SHIFT (0x00000012u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR18_RESETVAL (0x00000000u)

/*----HDR_ERR18 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR18_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR18_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR17_MASK (0x00020000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR17_SHIFT (0x00000011u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR17_RESETVAL (0x00000000u)

/*----HDR_ERR17 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR17_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR17_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR16_MASK (0x00010000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR16_SHIFT (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR16_RESETVAL (0x00000000u)

/*----HDR_ERR16 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR16_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR16_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR15_MASK (0x00008000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR15_SHIFT (0x0000000Fu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR15_RESETVAL (0x00000000u)

/*----HDR_ERR15 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR15_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR15_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR14_MASK (0x00004000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR14_SHIFT (0x0000000Eu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR14_RESETVAL (0x00000000u)

/*----HDR_ERR14 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR14_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR14_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR13_MASK (0x00002000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR13_SHIFT (0x0000000Du)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR13_RESETVAL (0x00000000u)

/*----HDR_ERR13 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR13_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR13_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR12_MASK (0x00001000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR12_SHIFT (0x0000000Cu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR12_RESETVAL (0x00000000u)

/*----HDR_ERR12 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR12_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR12_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR11_MASK (0x00000800u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR11_SHIFT (0x0000000Bu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR11_RESETVAL (0x00000000u)

/*----HDR_ERR11 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR11_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR11_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR10_MASK (0x00000400u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR10_SHIFT (0x0000000Au)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR10_RESETVAL (0x00000000u)

/*----HDR_ERR10 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR10_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR10_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR9_MASK (0x00000200u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR9_SHIFT (0x00000009u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR9_RESETVAL (0x00000000u)

/*----HDR_ERR9 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR9_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR9_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR8_MASK (0x00000100u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR8_SHIFT (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR8_RESETVAL (0x00000000u)

/*----HDR_ERR8 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR8_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR8_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR7_MASK (0x00000080u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR7_SHIFT (0x00000007u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR7_RESETVAL (0x00000000u)

/*----HDR_ERR7 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR7_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR7_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR6_MASK (0x00000040u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR6_SHIFT (0x00000006u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR6_RESETVAL (0x00000000u)

/*----HDR_ERR6 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR6_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR6_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR5_MASK (0x00000020u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR5_SHIFT (0x00000005u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR5_RESETVAL (0x00000000u)

/*----HDR_ERR5 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR5_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR5_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR4_MASK (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR4_SHIFT (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR4_RESETVAL (0x00000000u)

/*----HDR_ERR4 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR4_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR4_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR3_MASK (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR3_SHIFT (0x00000003u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR3_RESETVAL (0x00000000u)

/*----HDR_ERR3 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR3_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR3_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR2_MASK (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR2_SHIFT (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR2_RESETVAL (0x00000000u)

/*----HDR_ERR2 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR2_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR2_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR1_MASK (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR1_SHIFT (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR1_RESETVAL (0x00000000u)

/*----HDR_ERR1 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR1_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR1_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR0_MASK (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR0_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR0_RESETVAL (0x00000000u)

/*----HDR_ERR0 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR0_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSA_HDR_ERR0_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSA_RESETVAL (0x00000000u)

/* AG_LINK_HDR_ERR_STSB */

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR41_MASK (0x00100000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR41_SHIFT (0x00000014u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR41_RESETVAL (0x00000000u)

/*----HDR_ERR41 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR41_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR41_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR_MASK (0x001FFFFFu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR40_MASK (0x00080000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR40_SHIFT (0x00000013u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR40_RESETVAL (0x00000000u)

/*----HDR_ERR40 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR40_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR40_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR39_MASK (0x00040000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR39_SHIFT (0x00000012u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR39_RESETVAL (0x00000000u)

/*----HDR_ERR39 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR39_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR39_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR38_MASK (0x00020000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR38_SHIFT (0x00000011u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR38_RESETVAL (0x00000000u)

/*----HDR_ERR38 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR38_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR38_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR37_MASK (0x00010000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR37_SHIFT (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR37_RESETVAL (0x00000000u)

/*----HDR_ERR37 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR37_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR37_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR36_MASK (0x00008000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR36_SHIFT (0x0000000Fu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR36_RESETVAL (0x00000000u)

/*----HDR_ERR36 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR36_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR36_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR35_MASK (0x00004000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR35_SHIFT (0x0000000Eu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR35_RESETVAL (0x00000000u)

/*----HDR_ERR35 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR35_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR35_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR34_MASK (0x00002000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR34_SHIFT (0x0000000Du)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR34_RESETVAL (0x00000000u)

/*----HDR_ERR34 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR34_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR34_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR33_MASK (0x00001000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR33_SHIFT (0x0000000Cu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR33_RESETVAL (0x00000000u)

/*----HDR_ERR33 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR33_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR33_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR32_MASK (0x00000800u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR32_SHIFT (0x0000000Bu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR32_RESETVAL (0x00000000u)

/*----HDR_ERR32 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR32_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR32_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR31_MASK (0x00000400u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR31_SHIFT (0x0000000Au)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR31_RESETVAL (0x00000000u)

/*----HDR_ERR31 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR31_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR31_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR30_MASK (0x00000200u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR30_SHIFT (0x00000009u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR30_RESETVAL (0x00000000u)

/*----HDR_ERR30 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR30_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR30_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR29_MASK (0x00000100u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR29_SHIFT (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR29_RESETVAL (0x00000000u)

/*----HDR_ERR29 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR29_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR29_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR28_MASK (0x00000080u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR28_SHIFT (0x00000007u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR28_RESETVAL (0x00000000u)

/*----HDR_ERR28 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR28_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR28_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR27_MASK (0x00000040u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR27_SHIFT (0x00000006u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR27_RESETVAL (0x00000000u)

/*----HDR_ERR27 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR27_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR27_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR26_MASK (0x00000020u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR26_SHIFT (0x00000005u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR26_RESETVAL (0x00000000u)

/*----HDR_ERR26 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR26_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR26_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR25_MASK (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR25_SHIFT (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR25_RESETVAL (0x00000000u)

/*----HDR_ERR25 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR25_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR25_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR24_MASK (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR24_SHIFT (0x00000003u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR24_RESETVAL (0x00000000u)

/*----HDR_ERR24 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR24_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR24_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR23_MASK (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR23_SHIFT (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR23_RESETVAL (0x00000000u)

/*----HDR_ERR23 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR23_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR23_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR22_MASK (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR22_SHIFT (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR22_RESETVAL (0x00000000u)

/*----HDR_ERR22 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR22_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR22_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR21_MASK (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR21_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR21_RESETVAL (0x00000000u)

/*----HDR_ERR21 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR21_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSB_HDR_ERR21_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSB_RESETVAL (0x00000000u)

/* AG_LINK_HDR_ERR_STSC */

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR62_MASK (0x00100000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR62_SHIFT (0x00000014u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR62_RESETVAL (0x00000000u)

/*----HDR_ERR62 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR62_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR62_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR_MASK (0x001FFFFFu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR61_MASK (0x00080000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR61_SHIFT (0x00000013u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR61_RESETVAL (0x00000000u)

/*----HDR_ERR61 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR61_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR61_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR60_MASK (0x00040000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR60_SHIFT (0x00000012u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR60_RESETVAL (0x00000000u)

/*----HDR_ERR60 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR60_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR60_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR59_MASK (0x00020000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR59_SHIFT (0x00000011u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR59_RESETVAL (0x00000000u)

/*----HDR_ERR59 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR59_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR59_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR58_MASK (0x00010000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR58_SHIFT (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR58_RESETVAL (0x00000000u)

/*----HDR_ERR58 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR58_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR58_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR57_MASK (0x00008000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR57_SHIFT (0x0000000Fu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR57_RESETVAL (0x00000000u)

/*----HDR_ERR57 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR57_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR57_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR56_MASK (0x00004000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR56_SHIFT (0x0000000Eu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR56_RESETVAL (0x00000000u)

/*----HDR_ERR56 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR56_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR56_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR55_MASK (0x00002000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR55_SHIFT (0x0000000Du)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR55_RESETVAL (0x00000000u)

/*----HDR_ERR55 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR55_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR55_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR54_MASK (0x00001000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR54_SHIFT (0x0000000Cu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR54_RESETVAL (0x00000000u)

/*----HDR_ERR54 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR54_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR54_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR53_MASK (0x00000800u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR53_SHIFT (0x0000000Bu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR53_RESETVAL (0x00000000u)

/*----HDR_ERR53 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR53_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR53_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR52_MASK (0x00000400u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR52_SHIFT (0x0000000Au)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR52_RESETVAL (0x00000000u)

/*----HDR_ERR52 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR52_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR52_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR51_MASK (0x00000200u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR51_SHIFT (0x00000009u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR51_RESETVAL (0x00000000u)

/*----HDR_ERR51 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR51_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR51_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR50_MASK (0x00000100u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR50_SHIFT (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR50_RESETVAL (0x00000000u)

/*----HDR_ERR50 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR50_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR50_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR49_MASK (0x00000080u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR49_SHIFT (0x00000007u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR49_RESETVAL (0x00000000u)

/*----HDR_ERR49 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR49_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR49_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR48_MASK (0x00000040u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR48_SHIFT (0x00000006u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR48_RESETVAL (0x00000000u)

/*----HDR_ERR48 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR48_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR48_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR47_MASK (0x00000020u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR47_SHIFT (0x00000005u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR47_RESETVAL (0x00000000u)

/*----HDR_ERR47 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR47_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR47_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR46_MASK (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR46_SHIFT (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR46_RESETVAL (0x00000000u)

/*----HDR_ERR46 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR46_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR46_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR45_MASK (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR45_SHIFT (0x00000003u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR45_RESETVAL (0x00000000u)

/*----HDR_ERR45 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR45_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR45_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR44_MASK (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR44_SHIFT (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR44_RESETVAL (0x00000000u)

/*----HDR_ERR44 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR44_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR44_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR43_MASK (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR43_SHIFT (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR43_RESETVAL (0x00000000u)

/*----HDR_ERR43 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR43_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR43_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR42_MASK (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR42_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR42_RESETVAL (0x00000000u)

/*----HDR_ERR42 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR42_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSC_HDR_ERR42_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSC_RESETVAL (0x00000000u)

/* AG_LINK_HDR_ERR_STSD */

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR83_MASK (0x00100000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR83_SHIFT (0x00000014u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR83_RESETVAL (0x00000000u)

/*----HDR_ERR83 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR83_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR83_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR_MASK (0x001FFFFFu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR82_MASK (0x00080000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR82_SHIFT (0x00000013u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR82_RESETVAL (0x00000000u)

/*----HDR_ERR82 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR82_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR82_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR81_MASK (0x00040000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR81_SHIFT (0x00000012u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR81_RESETVAL (0x00000000u)

/*----HDR_ERR81 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR81_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR81_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR80_MASK (0x00020000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR80_SHIFT (0x00000011u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR80_RESETVAL (0x00000000u)

/*----HDR_ERR80 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR80_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR80_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR79_MASK (0x00010000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR79_SHIFT (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR79_RESETVAL (0x00000000u)

/*----HDR_ERR79 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR79_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR79_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR78_MASK (0x00008000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR78_SHIFT (0x0000000Fu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR78_RESETVAL (0x00000000u)

/*----HDR_ERR78 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR78_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR78_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR77_MASK (0x00004000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR77_SHIFT (0x0000000Eu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR77_RESETVAL (0x00000000u)

/*----HDR_ERR77 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR77_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR77_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR76_MASK (0x00002000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR76_SHIFT (0x0000000Du)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR76_RESETVAL (0x00000000u)

/*----HDR_ERR76 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR76_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR76_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR75_MASK (0x00001000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR75_SHIFT (0x0000000Cu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR75_RESETVAL (0x00000000u)

/*----HDR_ERR75 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR75_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR75_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR74_MASK (0x00000800u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR74_SHIFT (0x0000000Bu)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR74_RESETVAL (0x00000000u)

/*----HDR_ERR74 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR74_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR74_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR73_MASK (0x00000400u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR73_SHIFT (0x0000000Au)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR73_RESETVAL (0x00000000u)

/*----HDR_ERR73 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR73_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR73_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR72_MASK (0x00000200u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR72_SHIFT (0x00000009u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR72_RESETVAL (0x00000000u)

/*----HDR_ERR72 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR72_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR72_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR71_MASK (0x00000100u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR71_SHIFT (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR71_RESETVAL (0x00000000u)

/*----HDR_ERR71 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR71_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR71_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR70_MASK (0x00000080u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR70_SHIFT (0x00000007u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR70_RESETVAL (0x00000000u)

/*----HDR_ERR70 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR70_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR70_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR69_MASK (0x00000040u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR69_SHIFT (0x00000006u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR69_RESETVAL (0x00000000u)

/*----HDR_ERR69 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR69_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR69_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR68_MASK (0x00000020u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR68_SHIFT (0x00000005u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR68_RESETVAL (0x00000000u)

/*----HDR_ERR68 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR68_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR68_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR67_MASK (0x00000010u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR67_SHIFT (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR67_RESETVAL (0x00000000u)

/*----HDR_ERR67 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR67_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR67_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR66_MASK (0x00000008u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR66_SHIFT (0x00000003u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR66_RESETVAL (0x00000000u)

/*----HDR_ERR66 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR66_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR66_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR65_MASK (0x00000004u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR65_SHIFT (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR65_RESETVAL (0x00000000u)

/*----HDR_ERR65 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR65_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR65_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR64_MASK (0x00000002u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR64_SHIFT (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR64_RESETVAL (0x00000000u)

/*----HDR_ERR64 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR64_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR64_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR63_MASK (0x00000001u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR63_SHIFT (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR63_RESETVAL (0x00000000u)

/*----HDR_ERR63 Tokens----*/
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR63_NO_ERR (0x00000000u)
#define CSL_AIF_AG_LINK_HDR_ERR_STSD_HDR_ERR63_ERR (0x00000001u)

#define CSL_AIF_AG_LINK_HDR_ERR_STSD_RESETVAL (0x00000000u)

/* CI_LINK_CFG */

#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_MASK (0x00000003u)
#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_SHIFT (0x00000000u)
#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_RESETVAL (0x00000000u)

/*----CI_DATA_FMT Tokens----*/
#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_UL_PIC_7BIT (0x00000000u)
#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_UL_PIC_8BIT (0x00000001u)
#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_DL_GEN_15BIT (0x00000002u)
#define CSL_AIF_CI_LINK_CFG_CI_DATA_FMT_DL_GEN_16BIT (0x00000003u)

#define CSL_AIF_CI_LINK_CFG_RESETVAL     (0x00000000u)

/* CO_LINK_CFG */

#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_MASK (0x00000003u)
#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_SHIFT (0x00000000u)
#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_RESETVAL (0x00000000u)

/*----CO_DATA_FMT Tokens----*/
#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_UL_PIC_7BIT (0x00000000u)
#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_UL_PIC_8BIT (0x00000001u)
#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_DL_GEN_15BIT (0x00000002u)
#define CSL_AIF_CO_LINK_CFG_CO_DATA_FMT_DL_GEN_16BIT (0x00000003u)

#define CSL_AIF_CO_LINK_CFG_RESETVAL     (0x00000000u)

/* DB_GENERIC_CFG */

#define CSL_AIF_DB_GENERIC_CFG_CAPTURE_EN_MASK (0x00004000u)
#define CSL_AIF_DB_GENERIC_CFG_CAPTURE_EN_SHIFT (0x0000000Eu)
#define CSL_AIF_DB_GENERIC_CFG_CAPTURE_EN_RESETVAL (0x00000000u)

#define CSL_AIF_DB_GENERIC_CFG_MEM_LEAK_FLUSH_MASK (0x00000001u)
#define CSL_AIF_DB_GENERIC_CFG_MEM_LEAK_FLUSH_SHIFT (0x00000000u)
#define CSL_AIF_DB_GENERIC_CFG_MEM_LEAK_FLUSH_RESETVAL (0x00000000u)

#define CSL_AIF_DB_GENERIC_CFG_RESETVAL  (0x00000000u)

/* DB_DMA_QUE_CLR_CFG */

#define CSL_AIF_DB_DMA_QUE_CLR_CFG_OUT_DMA_VBUS_QUE_CLR_MASK (0x00003F00u)
#define CSL_AIF_DB_DMA_QUE_CLR_CFG_OUT_DMA_VBUS_QUE_CLR_SHIFT (0x00000008u)
#define CSL_AIF_DB_DMA_QUE_CLR_CFG_OUT_DMA_VBUS_QUE_CLR_RESETVAL (0x00000000u)

#define CSL_AIF_DB_DMA_QUE_CLR_CFG_IN_DMA_VBUS_QUE_CLR_MASK (0x0000003Fu)
#define CSL_AIF_DB_DMA_QUE_CLR_CFG_IN_DMA_VBUS_QUE_CLR_SHIFT (0x00000000u)
#define CSL_AIF_DB_DMA_QUE_CLR_CFG_IN_DMA_VBUS_QUE_CLR_RESETVAL (0x00000000u)

#define CSL_AIF_DB_DMA_QUE_CLR_CFG_RESETVAL (0x00000000u)

/* DB_DMA_CNT_CLR_CFG */

#define CSL_AIF_DB_DMA_CNT_CLR_CFG_OUT_DMA_COUNT_CLR_MASK (0x00003F00u)
#define CSL_AIF_DB_DMA_CNT_CLR_CFG_OUT_DMA_COUNT_CLR_SHIFT (0x00000008u)
#define CSL_AIF_DB_DMA_CNT_CLR_CFG_OUT_DMA_COUNT_CLR_RESETVAL (0x00000000u)

#define CSL_AIF_DB_DMA_CNT_CLR_CFG_IN_DMA_COUNT_CLR_MASK (0x0000003Fu)
#define CSL_AIF_DB_DMA_CNT_CLR_CFG_IN_DMA_COUNT_CLR_SHIFT (0x00000000u)
#define CSL_AIF_DB_DMA_CNT_CLR_CFG_IN_DMA_COUNT_CLR_RESETVAL (0x00000000u)

#define CSL_AIF_DB_DMA_CNT_CLR_CFG_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_EN_CFG */

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK5_MASK (0x3E000000u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK5_SHIFT (0x00000019u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK5_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK4_MASK (0x01F00000u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK4_SHIFT (0x00000014u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK3_MASK (0x000F8000u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK3_SHIFT (0x0000000Fu)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK2_MASK (0x00007C00u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK2_SHIFT (0x0000000Au)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK1_MASK (0x000003E0u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK1_SHIFT (0x00000005u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK0_MASK (0x0000001Fu)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_PKTSW_FIFO_EN_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_EN_CFG_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_FLUSH_CFG */

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK5_MASK (0x3E000000u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK5_SHIFT (0x00000019u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK5_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK4_MASK (0x01F00000u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK4_SHIFT (0x00000014u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK3_MASK (0x000F8000u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK3_SHIFT (0x0000000Fu)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK2_MASK (0x00007C00u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK2_SHIFT (0x0000000Au)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK1_MASK (0x000003E0u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK1_SHIFT (0x00000005u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK0_MASK (0x0000001Fu)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_PKTSW_FIFO_FLUSH_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_FLUSH_CFG_RESETVAL (0x00000000u)

/* DB_IN_FIFO_EVNT_CFG */

#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_MASK (0x00000700u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_SHIFT (0x00000008u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_RESETVAL (0x00000000u)

/*----PKTSW_FIFO2_EVNT_DEPTH Tokens----*/
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_DEPTH_01 (0x00000000u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_DEPTH_02 (0x00000001u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_DEPTH_04 (0x00000002u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_DEPTH_08 (0x00000003u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_DEPTH_16 (0x00000004u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO2_EVNT_DEPTH_DEPTH_32 (0x00000005u)

#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_RESERVED_MASK (0x00000080u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_RESERVED_SHIFT (0x00000007u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_RESERVED_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_MASK (0x00000070u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_SHIFT (0x00000004u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_RESETVAL (0x00000000u)

/*----PKTSW_FIFO1_EVNT_DEPTH Tokens----*/
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_DEPTH_01 (0x00000000u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_DEPTH_02 (0x00000001u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_DEPTH_04 (0x00000002u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_DEPTH_08 (0x00000003u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_DEPTH_16 (0x00000004u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO1_EVNT_DEPTH_DEPTH_32 (0x00000005u)

#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_MASK (0x00000007u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_SHIFT (0x00000000u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_RESETVAL (0x00000000u)

/*----PKTSW_FIFO0_EVNT_DEPTH Tokens----*/
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_DEPTH_01 (0x00000000u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_DEPTH_02 (0x00000001u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_DEPTH_04 (0x00000002u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_DEPTH_08 (0x00000003u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_DEPTH_16 (0x00000004u)
#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_PKTSW_FIFO0_EVNT_DEPTH_DEPTH_32 (0x00000005u)

#define CSL_AIF_DB_IN_FIFO_EVNT_CFG_RESETVAL (0x00000000u)

/* DB_IN_FIFO_SIZE_CFG */

#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO3_START_MASK (0x001F0000u)
#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO3_START_SHIFT (0x00000010u)
#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO3_START_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO2_START_MASK (0x00001F00u)
#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO2_START_SHIFT (0x00000008u)
#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO2_START_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO1_START_MASK (0x0000001Fu)
#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO1_START_SHIFT (0x00000000u)
#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_PKTSW_FIFO1_START_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_FIFO_SIZE_CFG_RESETVAL (0x00000000u)

/* DB_IN_DMA_CNT0_STS */

#define CSL_AIF_DB_IN_DMA_CNT0_STS_IN_DMA_COUNT_LINK1_MASK (0xFFFF0000u)
#define CSL_AIF_DB_IN_DMA_CNT0_STS_IN_DMA_COUNT_LINK1_SHIFT (0x00000010u)
#define CSL_AIF_DB_IN_DMA_CNT0_STS_IN_DMA_COUNT_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_CNT0_STS_IN_DMA_COUNT_LINK0_MASK (0x0000FFFFu)
#define CSL_AIF_DB_IN_DMA_CNT0_STS_IN_DMA_COUNT_LINK0_SHIFT (0x00000000u)
#define CSL_AIF_DB_IN_DMA_CNT0_STS_IN_DMA_COUNT_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_CNT0_STS_RESETVAL (0x00000000u)

/* DB_IN_DMA_CNT1_STS */

#define CSL_AIF_DB_IN_DMA_CNT1_STS_IN_DMA_COUNT_LINK3_MASK (0xFFFF0000u)
#define CSL_AIF_DB_IN_DMA_CNT1_STS_IN_DMA_COUNT_LINK3_SHIFT (0x00000010u)
#define CSL_AIF_DB_IN_DMA_CNT1_STS_IN_DMA_COUNT_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_CNT1_STS_IN_DMA_COUNT_LINK2_MASK (0x0000FFFFu)
#define CSL_AIF_DB_IN_DMA_CNT1_STS_IN_DMA_COUNT_LINK2_SHIFT (0x00000000u)
#define CSL_AIF_DB_IN_DMA_CNT1_STS_IN_DMA_COUNT_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_CNT1_STS_RESETVAL (0x00000000u)

/* DB_IN_DMA_CNT2_STS */

#define CSL_AIF_DB_IN_DMA_CNT2_STS_IN_DMA_COUNT_LINK5_MASK (0xFFFF0000u)
#define CSL_AIF_DB_IN_DMA_CNT2_STS_IN_DMA_COUNT_LINK5_SHIFT (0x00000010u)
#define CSL_AIF_DB_IN_DMA_CNT2_STS_IN_DMA_COUNT_LINK5_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_CNT2_STS_IN_DMA_COUNT_LINK4_MASK (0x0000FFFFu)
#define CSL_AIF_DB_IN_DMA_CNT2_STS_IN_DMA_COUNT_LINK4_SHIFT (0x00000000u)
#define CSL_AIF_DB_IN_DMA_CNT2_STS_IN_DMA_COUNT_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_CNT2_STS_RESETVAL (0x00000000u)

/* DB_OUT_DMA_CNT0_STS */

#define CSL_AIF_DB_OUT_DMA_CNT0_STS_OUT_DMA_COUNT_LOUTK1_MASK (0xFFFF0000u)
#define CSL_AIF_DB_OUT_DMA_CNT0_STS_OUT_DMA_COUNT_LOUTK1_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_DMA_CNT0_STS_OUT_DMA_COUNT_LOUTK1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_CNT0_STS_OUT_DMA_COUNT_LOUTK0_MASK (0x0000FFFFu)
#define CSL_AIF_DB_OUT_DMA_CNT0_STS_OUT_DMA_COUNT_LOUTK0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_DMA_CNT0_STS_OUT_DMA_COUNT_LOUTK0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_CNT0_STS_RESETVAL (0x00000000u)

/* DB_OUT_DMA_CNT1_STS */

#define CSL_AIF_DB_OUT_DMA_CNT1_STS_OUT_DMA_COUNT_LOUTK3_MASK (0xFFFF0000u)
#define CSL_AIF_DB_OUT_DMA_CNT1_STS_OUT_DMA_COUNT_LOUTK3_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_DMA_CNT1_STS_OUT_DMA_COUNT_LOUTK3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_CNT1_STS_OUT_DMA_COUNT_LOUTK2_MASK (0x0000FFFFu)
#define CSL_AIF_DB_OUT_DMA_CNT1_STS_OUT_DMA_COUNT_LOUTK2_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_DMA_CNT1_STS_OUT_DMA_COUNT_LOUTK2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_CNT1_STS_RESETVAL (0x00000000u)

/* DB_OUT_DMA_CNT2_STS */

#define CSL_AIF_DB_OUT_DMA_CNT2_STS_OUT_DMA_COUNT_LOUTK5_MASK (0xFFFF0000u)
#define CSL_AIF_DB_OUT_DMA_CNT2_STS_OUT_DMA_COUNT_LOUTK5_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_DMA_CNT2_STS_OUT_DMA_COUNT_LOUTK5_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_CNT2_STS_OUT_DMA_COUNT_LOUTK4_MASK (0x0000FFFFu)
#define CSL_AIF_DB_OUT_DMA_CNT2_STS_OUT_DMA_COUNT_LOUTK4_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_DMA_CNT2_STS_OUT_DMA_COUNT_LOUTK4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_CNT2_STS_RESETVAL (0x00000000u)

/* DB_IN_DMA_DEPTH_STS */

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH5_MASK (0x00F00000u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH5_SHIFT (0x00000014u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH5_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH4_MASK (0x000F0000u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH4_SHIFT (0x00000010u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH3_MASK (0x0000F000u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH3_SHIFT (0x0000000Cu)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH2_MASK (0x00000F00u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH2_SHIFT (0x00000008u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH1_MASK (0x000000F0u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH1_SHIFT (0x00000004u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH0_MASK (0x0000000Fu)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH0_SHIFT (0x00000000u)
#define CSL_AIF_DB_IN_DMA_DEPTH_STS_IN_DMA_DEPTH0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_IN_DMA_DEPTH_STS_RESETVAL (0x00000000u)

/* DB_OUT_DMA_DEPTH_STS */

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH5_MASK (0x00F00000u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH5_SHIFT (0x00000014u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH5_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH4_MASK (0x000F0000u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH4_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH3_MASK (0x0000F000u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH3_SHIFT (0x0000000Cu)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH2_MASK (0x00000F00u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH2_SHIFT (0x00000008u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH1_MASK (0x000000F0u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH1_SHIFT (0x00000004u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH0_MASK (0x0000000Fu)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_OUT_DMA_DEPTH0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_DMA_DEPTH_STS_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_STS */

#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_RD_INDEX_MASK (0xF8000000u)
#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_RD_INDEX_SHIFT (0x0000001Bu)
#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_RD_INDEX_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_RD_PTR_MASK (0x01FF0000u)
#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_RD_PTR_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_RD_PTR_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_WR_PTR_MASK (0x000001FFu)
#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_WR_PTR_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_STS_PKTSW_FIFO_WR_PTR_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_STS_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_DEPTH_STS */

#define CSL_AIF_DB_OUT_PKTSW_DEPTH_STS_PKT_SW_FIFO_DEPTH_MASK (0x000001FFu)
#define CSL_AIF_DB_OUT_PKTSW_DEPTH_STS_PKT_SW_FIFO_DEPTH_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_DEPTH_STS_PKT_SW_FIFO_DEPTH_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_DEPTH_STS_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_NE_STS */

#define CSL_AIF_DB_OUT_PKTSW_NE_STS_PKT_SW_FIFO_NE_MASK (0x3FFFFFFFu)
#define CSL_AIF_DB_OUT_PKTSW_NE_STS_PKT_SW_FIFO_NE_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_NE_STS_PKT_SW_FIFO_NE_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_NE_STS_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_HEAD_STS */

#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_FIFO_HEAD_PTR1_MASK (0x01FF0000u)
#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_FIFO_HEAD_PTR1_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_FIFO_HEAD_PTR1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_FIFO_HEAD_PTR0_MASK (0x000001FFu)
#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_FIFO_HEAD_PTR0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_FIFO_HEAD_PTR0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_HEAD_STS_RESETVAL (0x00000000u)

/* DB_OUT_PKTSW_TAIL_STS */

#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_FIFO_TAIL_PTR1_MASK (0x01FF0000u)
#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_FIFO_TAIL_PTR1_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_FIFO_TAIL_PTR1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_FIFO_TAIL_PTR0_MASK (0x000001FFu)
#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_FIFO_TAIL_PTR0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_FIFO_TAIL_PTR0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUT_PKTSW_TAIL_STS_RESETVAL (0x00000000u)

/* PD_LINK_84CNT_LUT0_CFG */

#define CSL_AIF_PD_LINK_84CNT_LUT0_CFG_TIME_STAMP_INCR_NXT_LUT0_MASK (0xFFFFFFFFu)
#define CSL_AIF_PD_LINK_84CNT_LUT0_CFG_TIME_STAMP_INCR_NXT_LUT0_SHIFT (0x00000000u)
#define CSL_AIF_PD_LINK_84CNT_LUT0_CFG_TIME_STAMP_INCR_NXT_LUT0_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_84CNT_LUT0_CFG_RESETVAL (0x00000000u)

/* PD_LINK_84CNT_LUT1_CFG */

#define CSL_AIF_PD_LINK_84CNT_LUT1_CFG_TIME_STAMP_INCR_NXT_LUT1_MASK (0xFFFFFFFFu)
#define CSL_AIF_PD_LINK_84CNT_LUT1_CFG_TIME_STAMP_INCR_NXT_LUT1_SHIFT (0x00000000u)
#define CSL_AIF_PD_LINK_84CNT_LUT1_CFG_TIME_STAMP_INCR_NXT_LUT1_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_84CNT_LUT1_CFG_RESETVAL (0x00000000u)

/* PD_LINK_84CNT_LUT2_CFG */

#define CSL_AIF_PD_LINK_84CNT_LUT2_CFG_TIME_STAMP_INCR_NXT_LUT2_MASK (0xFFFFFFFFu)
#define CSL_AIF_PD_LINK_84CNT_LUT2_CFG_TIME_STAMP_INCR_NXT_LUT2_SHIFT (0x00000000u)
#define CSL_AIF_PD_LINK_84CNT_LUT2_CFG_TIME_STAMP_INCR_NXT_LUT2_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_84CNT_LUT2_CFG_RESETVAL (0x00000000u)

/* PD_LINK_CPRI_SI_LUT0_CFG */

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_7_LUT_MASK (0xF0000000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_7_LUT_SHIFT (0x0000001Cu)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_7_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_6_LUT_MASK (0x0F000000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_6_LUT_SHIFT (0x00000018u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_6_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_5_LUT_MASK (0x00F00000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_5_LUT_SHIFT (0x00000014u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_5_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_4_LUT_MASK (0x000F0000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_4_LUT_SHIFT (0x00000010u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_4_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_3_LUT_MASK (0x0000F000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_3_LUT_SHIFT (0x0000000Cu)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_3_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_2_LUT_MASK (0x00000F00u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_2_LUT_SHIFT (0x00000008u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_2_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_1_LUT_MASK (0x000000F0u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_1_LUT_SHIFT (0x00000004u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_1_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_0_LUT_MASK (0x0000000Fu)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_0_LUT_SHIFT (0x00000000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_CPRI_SI_AXC_0_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT0_CFG_RESETVAL (0x00000000u)

/* PD_LINK_CPRI_SI_LUT1_CFG */

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_F_LUT_MASK (0xF0000000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_F_LUT_SHIFT (0x0000001Cu)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_F_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_E_LUT_MASK (0x0F000000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_E_LUT_SHIFT (0x00000018u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_E_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_D_LUT_MASK (0x00F00000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_D_LUT_SHIFT (0x00000014u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_D_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_C_LUT_MASK (0x000F0000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_C_LUT_SHIFT (0x00000010u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_C_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_B_LUT_MASK (0x0000F000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_B_LUT_SHIFT (0x0000000Cu)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_B_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_A_LUT_MASK (0x00000F00u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_A_LUT_SHIFT (0x00000008u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_A_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_9_LUT_MASK (0x000000F0u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_9_LUT_SHIFT (0x00000004u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_9_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_8_LUT_MASK (0x0000000Fu)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_8_LUT_SHIFT (0x00000000u)
#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_CPRI_SI_AXC_8_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_SI_LUT1_CFG_RESETVAL (0x00000000u)

/* PD_LINK_CPRI_FORMAT_LUT_CFG */

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_F_MASK (0xC0000000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_F_SHIFT (0x0000001Eu)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_F_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_E_MASK (0x30000000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_E_SHIFT (0x0000001Cu)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_E_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_D_MASK (0x0C000000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_D_SHIFT (0x0000001Au)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_D_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_C_MASK (0x03000000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_C_SHIFT (0x00000018u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_C_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_B_MASK (0x00C00000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_B_SHIFT (0x00000016u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_B_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_A_MASK (0x00300000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_A_SHIFT (0x00000014u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_A_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_9_MASK (0x000C0000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_9_SHIFT (0x00000012u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_9_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_8_MASK (0x00030000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_8_SHIFT (0x00000010u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_8_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_7_MASK (0x0000C000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_7_SHIFT (0x0000000Eu)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_7_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_6_MASK (0x00003000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_6_SHIFT (0x0000000Cu)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_6_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_5_MASK (0x00000C00u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_5_SHIFT (0x0000000Au)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_5_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_4_MASK (0x00000300u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_4_SHIFT (0x00000008u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_4_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_3_MASK (0x000000C0u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_3_SHIFT (0x00000006u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_3_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_2_MASK (0x00000030u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_2_SHIFT (0x00000004u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_2_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_1_MASK (0x0000000Cu)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_1_SHIFT (0x00000002u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_1_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_0_MASK (0x00000003u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_0_SHIFT (0x00000000u)
#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_CPRI_FORMAT_AXC_0_RESETVAL (0x00000000u)

#define CSL_AIF_PD_LINK_CPRI_FORMAT_LUT_CFG_RESETVAL (0x00000000u)

/* PD_0_CFG */

#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_MASK (0x0C000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_SHIFT (0x0000001Au)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_RESETVAL (0x00000000u)

/*----CPRI_DATA_FORMAT_5 Tokens----*/
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_UL (0x00000001u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_PIC (0x00000002u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_5_GENERIC (0x00000003u)

#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_MASK (0x03000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_SHIFT (0x00000018u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_RESETVAL (0x00000000u)

/*----CPRI_DATA_FORMAT_4 Tokens----*/
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_UL (0x00000001u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_PIC (0x00000002u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_4_GENERIC (0x00000003u)

#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_MASK (0x00C00000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_SHIFT (0x00000016u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_RESETVAL (0x00000000u)

/*----CPRI_DATA_FORMAT_3 Tokens----*/
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_UL (0x00000001u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_PIC (0x00000002u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_3_GENERIC (0x00000003u)

#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_MASK (0x00300000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_SHIFT (0x00000014u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_RESETVAL (0x00000000u)

/*----CPRI_DATA_FORMAT_2 Tokens----*/
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_UL (0x00000001u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_PIC (0x00000002u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_2_GENERIC (0x00000003u)

#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_MASK (0x000C0000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_SHIFT (0x00000012u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_RESETVAL (0x00000000u)

/*----CPRI_DATA_FORMAT_1 Tokens----*/
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_UL (0x00000001u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_PIC (0x00000002u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_1_GENERIC (0x00000003u)

#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_MASK (0x00030000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_SHIFT (0x00000010u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_RESETVAL (0x00000000u)

/*----CPRI_DATA_FORMAT_0 Tokens----*/
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_UL (0x00000001u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_PIC (0x00000002u)
#define CSL_AIF_PD_0_CFG_CPRI_DATA_FORMAT_0_GENERIC (0x00000003u)

#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_5_MASK (0x00002000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_5_SHIFT (0x0000000Du)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_5_RESETVAL (0x00000000u)

/*----PD_LINK_BURST_8VS4_5 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_5_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_5_UL (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_4_MASK (0x00001000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_4_SHIFT (0x0000000Cu)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_4_RESETVAL (0x00000000u)

/*----PD_LINK_BURST_8VS4_4 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_4_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_4_UL (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_3_MASK (0x00000800u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_3_SHIFT (0x0000000Bu)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_3_RESETVAL (0x00000000u)

/*----PD_LINK_BURST_8VS4_3 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_3_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_3_UL (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_2_MASK (0x00000400u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_2_SHIFT (0x0000000Au)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_2_RESETVAL (0x00000000u)

/*----PD_LINK_BURST_8VS4_2 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_2_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_2_UL (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_1_MASK (0x00000200u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_1_SHIFT (0x00000009u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_1_RESETVAL (0x00000000u)

/*----PD_LINK_BURST_8VS4_1 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_1_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_1_UL (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_0_MASK (0x00000100u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_0_SHIFT (0x00000008u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_0_RESETVAL (0x00000000u)

/*----PD_LINK_BURST_8VS4_0 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_0_DL (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_BURST_8VS4_0_UL (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_EN_5_MASK (0x00000020u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_5_SHIFT (0x00000005u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_5_RESETVAL (0x00000000u)

/*----PD_LINK_EN_5 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_5_DISABLED (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_5_ENABLED (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_EN_4_MASK (0x00000010u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_4_SHIFT (0x00000004u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_4_RESETVAL (0x00000000u)

/*----PD_LINK_EN_4 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_4_DISABLED (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_4_ENABLED (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_EN_3_MASK (0x00000008u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_3_SHIFT (0x00000003u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_3_RESETVAL (0x00000000u)

/*----PD_LINK_EN_3 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_3_DISABLED (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_3_ENABLED (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_EN_2_MASK (0x00000004u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_2_SHIFT (0x00000002u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_2_RESETVAL (0x00000000u)

/*----PD_LINK_EN_2 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_2_DISABLED (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_2_ENABLED (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_EN_1_MASK (0x00000002u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_1_SHIFT (0x00000001u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_1_RESETVAL (0x00000000u)

/*----PD_LINK_EN_1 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_1_DISABLED (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_1_ENABLED (0x00000001u)

#define CSL_AIF_PD_0_CFG_PD_LINK_EN_0_MASK (0x00000001u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_0_SHIFT (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_0_RESETVAL (0x00000000u)

/*----PD_LINK_EN_0 Tokens----*/
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_0_DISABLED (0x00000000u)
#define CSL_AIF_PD_0_CFG_PD_LINK_EN_0_ENABLED (0x00000001u)

#define CSL_AIF_PD_0_CFG_RESETVAL        (0x00000000u)

/* PD_1_CFG */

#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_5_MASK (0x20000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_5_SHIFT (0x0000001Du)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_5_RESETVAL (0x00000000u)

/*----CPRI_PKTSW_EN_5 Tokens----*/
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_5_DISABLED (0x00000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_5_ENABLED (0x00000001u)

#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_4_MASK (0x10000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_4_SHIFT (0x0000001Cu)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_4_RESETVAL (0x00000000u)

/*----CPRI_PKTSW_EN_4 Tokens----*/
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_4_DISABLED (0x00000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_4_ENABLED (0x00000001u)

#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_3_MASK (0x08000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_3_SHIFT (0x0000001Bu)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_3_RESETVAL (0x00000000u)

/*----CPRI_PKTSW_EN_3 Tokens----*/
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_3_DISABLED (0x00000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_3_ENABLED (0x00000001u)

#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_2_MASK (0x04000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_2_SHIFT (0x0000001Au)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_2_RESETVAL (0x00000000u)

/*----CPRI_PKTSW_EN_2 Tokens----*/
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_2_DISABLED (0x00000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_2_ENABLED (0x00000001u)

#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_1_MASK (0x02000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_1_SHIFT (0x00000019u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_1_RESETVAL (0x00000000u)

/*----CPRI_PKTSW_EN_1 Tokens----*/
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_1_DISABLED (0x00000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_1_ENABLED (0x00000001u)

#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_0_MASK (0x01000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_0_SHIFT (0x00000018u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_0_RESETVAL (0x00000000u)

/*----CPRI_PKTSW_EN_0 Tokens----*/
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_0_DISABLED (0x00000000u)
#define CSL_AIF_PD_1_CFG_CPRI_PKTSW_EN_0_ENABLED (0x00000001u)

#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_5_MASK (0x00038000u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_5_SHIFT (0x0000000Fu)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_5_RESETVAL (0x00000000u)

#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_4_MASK (0x00007000u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_4_SHIFT (0x0000000Cu)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_4_RESETVAL (0x00000000u)

#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_3_MASK (0x00000E00u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_3_SHIFT (0x00000009u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_3_RESETVAL (0x00000000u)

#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_2_MASK (0x000001C0u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_2_SHIFT (0x00000006u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_2_RESETVAL (0x00000000u)

#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_1_MASK (0x00000038u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_1_SHIFT (0x00000003u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_1_RESETVAL (0x00000000u)

#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_0_MASK (0x00000007u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_0_SHIFT (0x00000000u)
#define CSL_AIF_PD_1_CFG_PD_OFFSET_ADR_0_RESETVAL (0x00000000u)

#define CSL_AIF_PD_1_CFG_RESETVAL        (0x00000000u)

/* PD_ADR_MUX_SEL_CFG */

#define CSL_AIF_PD_ADR_MUX_SEL_CFG_PD_ADR_MUX_CTRL_MASK (0x000FFFFFu)
#define CSL_AIF_PD_ADR_MUX_SEL_CFG_PD_ADR_MUX_CTRL_SHIFT (0x00000000u)
#define CSL_AIF_PD_ADR_MUX_SEL_CFG_PD_ADR_MUX_CTRL_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_MUX_SEL_CFG_RESETVAL (0x00000000u)

/* PD_TYPE_CIR_LUT_CFG */

#define CSL_AIF_PD_TYPE_CIR_LUT_CFG_PD_TYPE_LUT_CIR_SW_MASK (0xFFFFFFFFu)
#define CSL_AIF_PD_TYPE_CIR_LUT_CFG_PD_TYPE_LUT_CIR_SW_SHIFT (0x00000000u)
#define CSL_AIF_PD_TYPE_CIR_LUT_CFG_PD_TYPE_LUT_CIR_SW_RESETVAL (0x00000000u)

#define CSL_AIF_PD_TYPE_CIR_LUT_CFG_RESETVAL (0x00000000u)

/* PD_TYPE_PKT_LUT_CFG */

#define CSL_AIF_PD_TYPE_PKT_LUT_CFG_PD_TYPE_LUT_PKT_SW_MASK (0xFFFFFFFFu)
#define CSL_AIF_PD_TYPE_PKT_LUT_CFG_PD_TYPE_LUT_PKT_SW_SHIFT (0x00000000u)
#define CSL_AIF_PD_TYPE_PKT_LUT_CFG_PD_TYPE_LUT_PKT_SW_RESETVAL (0x00000000u)

#define CSL_AIF_PD_TYPE_PKT_LUT_CFG_RESETVAL (0x00000000u)

/* PD_TYPE_ERR_LUT_CFG */

#define CSL_AIF_PD_TYPE_ERR_LUT_CFG_PD_TYPE_LUT_ERR_MASK (0xFFFFFFFFu)
#define CSL_AIF_PD_TYPE_ERR_LUT_CFG_PD_TYPE_LUT_ERR_SHIFT (0x00000000u)
#define CSL_AIF_PD_TYPE_ERR_LUT_CFG_PD_TYPE_LUT_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_PD_TYPE_ERR_LUT_CFG_RESETVAL (0x00000000u)

/* PD_ADR_LUT */

#define CSL_AIF_PD_ADR_LUT_DATA_FORMAT1_LUT_MASK (0x000C0000u)
#define CSL_AIF_PD_ADR_LUT_DATA_FORMAT1_LUT_SHIFT (0x00000012u)
#define CSL_AIF_PD_ADR_LUT_DATA_FORMAT1_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_AXC_INDEX1_LUT_MASK (0x0003C000u)
#define CSL_AIF_PD_ADR_LUT_AXC_INDEX1_LUT_SHIFT (0x0000000Eu)
#define CSL_AIF_PD_ADR_LUT_AXC_INDEX1_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_MASK (0x00003000u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_SHIFT (0x0000000Cu)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_RESETVAL (0x00000000u)

/*----PKT_FIFO_INDEX1_LUT Tokens----*/
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_PS_FIFO0 (0x00000000u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_PS_FIFO1 (0x00000001u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_PS_FIFO2 (0x00000002u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX1_LUT_ERR_FIFO (0x00000003u)

#define CSL_AIF_PD_ADR_LUT_AXC_CAPT_EN1_LUT_MASK (0x00000800u)
#define CSL_AIF_PD_ADR_LUT_AXC_CAPT_EN1_LUT_SHIFT (0x0000000Bu)
#define CSL_AIF_PD_ADR_LUT_AXC_CAPT_EN1_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_BAD_ADR1_LUT_MASK (0x00000400u)
#define CSL_AIF_PD_ADR_LUT_BAD_ADR1_LUT_SHIFT (0x0000000Au)
#define CSL_AIF_PD_ADR_LUT_BAD_ADR1_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_DATA_FORMAT0_LUT_MASK (0x00000300u)
#define CSL_AIF_PD_ADR_LUT_DATA_FORMAT0_LUT_SHIFT (0x00000008u)
#define CSL_AIF_PD_ADR_LUT_DATA_FORMAT0_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_AXC_INDEX0_LUT_MASK (0x000000F0u)
#define CSL_AIF_PD_ADR_LUT_AXC_INDEX0_LUT_SHIFT (0x00000004u)
#define CSL_AIF_PD_ADR_LUT_AXC_INDEX0_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_MASK (0x0000000Cu)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_SHIFT (0x00000002u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_RESETVAL (0x00000000u)

/*----PKT_FIFO_INDEX0_LUT Tokens----*/
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_PS_FIFO0 (0x00000000u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_PS_FIFO1 (0x00000001u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_PS_FIFO2 (0x00000002u)
#define CSL_AIF_PD_ADR_LUT_PKT_FIFO_INDEX0_LUT_ERR_FIFO (0x00000003u)

#define CSL_AIF_PD_ADR_LUT_AXC_CAPT_EN0_LUT_MASK (0x00000002u)
#define CSL_AIF_PD_ADR_LUT_AXC_CAPT_EN0_LUT_SHIFT (0x00000001u)
#define CSL_AIF_PD_ADR_LUT_AXC_CAPT_EN0_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_BAD_ADR0_LUT_MASK (0x00000001u)
#define CSL_AIF_PD_ADR_LUT_BAD_ADR0_LUT_SHIFT (0x00000000u)
#define CSL_AIF_PD_ADR_LUT_BAD_ADR0_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PD_ADR_LUT_RESETVAL      (0x00000000u)

/* PE_LINK_84_EN_LUT0_CFG */

#define CSL_AIF_PE_LINK_84_EN_LUT0_CFG_MSG_SLOT_84_EN_LUT0_MASK (0xFFFFFFFFu)
#define CSL_AIF_PE_LINK_84_EN_LUT0_CFG_MSG_SLOT_84_EN_LUT0_SHIFT (0x00000000u)
#define CSL_AIF_PE_LINK_84_EN_LUT0_CFG_MSG_SLOT_84_EN_LUT0_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_84_EN_LUT0_CFG_RESETVAL (0x00000000u)

/* PE_LINK_84_EN_LUT1_CFG */

#define CSL_AIF_PE_LINK_84_EN_LUT1_CFG_MSG_SLOT_84_EN_LUT1_MASK (0xFFFFFFFFu)
#define CSL_AIF_PE_LINK_84_EN_LUT1_CFG_MSG_SLOT_84_EN_LUT1_SHIFT (0x00000000u)
#define CSL_AIF_PE_LINK_84_EN_LUT1_CFG_MSG_SLOT_84_EN_LUT1_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_84_EN_LUT1_CFG_RESETVAL (0x00000000u)

/* PE_LINK_84_EN_LUT2_CFG */

#define CSL_AIF_PE_LINK_84_EN_LUT2_CFG_MSG_SLOT_84_EN_LUT2_MASK (0x000FFFFFu)
#define CSL_AIF_PE_LINK_84_EN_LUT2_CFG_MSG_SLOT_84_EN_LUT2_SHIFT (0x00000000u)
#define CSL_AIF_PE_LINK_84_EN_LUT2_CFG_MSG_SLOT_84_EN_LUT2_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_84_EN_LUT2_CFG_RESETVAL (0x00000000u)

/* PE_TERM_CNT01_CFG */

#define CSL_AIF_PE_TERM_CNT01_CFG_CTRL_MSG_TERM_CNT1_MASK (0x07FF0000u)
#define CSL_AIF_PE_TERM_CNT01_CFG_CTRL_MSG_TERM_CNT1_SHIFT (0x00000010u)
#define CSL_AIF_PE_TERM_CNT01_CFG_CTRL_MSG_TERM_CNT1_RESETVAL (0x00000000u)

#define CSL_AIF_PE_TERM_CNT01_CFG_CTRL_MSG_TERM_CNT0_MASK (0x000007FFu)
#define CSL_AIF_PE_TERM_CNT01_CFG_CTRL_MSG_TERM_CNT0_SHIFT (0x00000000u)
#define CSL_AIF_PE_TERM_CNT01_CFG_CTRL_MSG_TERM_CNT0_RESETVAL (0x00000000u)

#define CSL_AIF_PE_TERM_CNT01_CFG_RESETVAL (0x00000000u)

/* PE_TERM_CNT23_CFG */

#define CSL_AIF_PE_TERM_CNT23_CFG_CTRL_MSG_TERM_CNT3_MASK (0x07FF0000u)
#define CSL_AIF_PE_TERM_CNT23_CFG_CTRL_MSG_TERM_CNT3_SHIFT (0x00000010u)
#define CSL_AIF_PE_TERM_CNT23_CFG_CTRL_MSG_TERM_CNT3_RESETVAL (0x00000000u)

#define CSL_AIF_PE_TERM_CNT23_CFG_CTRL_MSG_TERM_CNT2_MASK (0x000007FFu)
#define CSL_AIF_PE_TERM_CNT23_CFG_CTRL_MSG_TERM_CNT2_SHIFT (0x00000000u)
#define CSL_AIF_PE_TERM_CNT23_CFG_CTRL_MSG_TERM_CNT2_RESETVAL (0x00000000u)

#define CSL_AIF_PE_TERM_CNT23_CFG_RESETVAL (0x00000000u)

/* PE_LINK_84CNT_LUT */

#define CSL_AIF_PE_LINK_84CNT_LUT_INCR_COUNT_NOW_LUT_MASK (0x00000400u)
#define CSL_AIF_PE_LINK_84CNT_LUT_INCR_COUNT_NOW_LUT_SHIFT (0x0000000Au)
#define CSL_AIF_PE_LINK_84CNT_LUT_INCR_COUNT_NOW_LUT_RESETVAL (0x00000000u)

/*----INCR_COUNT_NOW_LUT Tokens----*/
#define CSL_AIF_PE_LINK_84CNT_LUT_INCR_COUNT_NOW_LUT_ICNR (0x00000001u)
#define CSL_AIF_PE_LINK_84CNT_LUT_INCR_COUNT_NOW_LUT_NO_INCR (0x00000000u)

#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_MASK (0x00000380u)
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_SHIFT (0x00000007u)
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_RESETVAL (0x00000000u)

/*----SELECT_COUNT_LUT Tokens----*/
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_CTRL0 (0x00000000u)
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_CTRL1 (0x00000001u)
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_CTRL2 (0x00000002u)
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_CTRL3 (0x00000003u)
#define CSL_AIF_PE_LINK_84CNT_LUT_SELECT_COUNT_LUT_DATA (0x00000004u)

#define CSL_AIF_PE_LINK_84CNT_LUT_TIME_STAMP_INCR_NXT_LUT_MASK (0x00000040u)
#define CSL_AIF_PE_LINK_84CNT_LUT_TIME_STAMP_INCR_NXT_LUT_SHIFT (0x00000006u)
#define CSL_AIF_PE_LINK_84CNT_LUT_TIME_STAMP_INCR_NXT_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_84CNT_LUT_CKT_VS_PKT_SWTCH_MSG_LUT_MASK (0x00000020u)
#define CSL_AIF_PE_LINK_84CNT_LUT_CKT_VS_PKT_SWTCH_MSG_LUT_SHIFT (0x00000005u)
#define CSL_AIF_PE_LINK_84CNT_LUT_CKT_VS_PKT_SWTCH_MSG_LUT_RESETVAL (0x00000000u)

/*----CKT_VS_PKT_SWTCH_MSG_LUT Tokens----*/
#define CSL_AIF_PE_LINK_84CNT_LUT_CKT_VS_PKT_SWTCH_MSG_LUT_PACKET (0x00000000u)
#define CSL_AIF_PE_LINK_84CNT_LUT_CKT_VS_PKT_SWTCH_MSG_LUT_CIRCUIT (0x00000001u)

#define CSL_AIF_PE_LINK_84CNT_LUT_AXC_OR_CTRL_INDEX_LUT_MASK (0x0000001Fu)
#define CSL_AIF_PE_LINK_84CNT_LUT_AXC_OR_CTRL_INDEX_LUT_SHIFT (0x00000000u)
#define CSL_AIF_PE_LINK_84CNT_LUT_AXC_OR_CTRL_INDEX_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_84CNT_LUT_RESETVAL (0x00000000u)

/* PE_LINK_ID_LUT0 */

#define CSL_AIF_PE_LINK_ID_LUT0_OBSAI_TYPE_LUT_MASK (0x3E000000u)
#define CSL_AIF_PE_LINK_ID_LUT0_OBSAI_TYPE_LUT_SHIFT (0x00000019u)
#define CSL_AIF_PE_LINK_ID_LUT0_OBSAI_TYPE_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_ID_LUT0_OBSAI_ADR_LUT_MASK (0x01FFF000u)
#define CSL_AIF_PE_LINK_ID_LUT0_OBSAI_ADR_LUT_SHIFT (0x0000000Cu)
#define CSL_AIF_PE_LINK_ID_LUT0_OBSAI_ADR_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_MASK (0x00000C00u)
#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_SHIFT (0x0000000Au)
#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_RESETVAL (0x00000000u)

/*----AGGR_CTL_LUT Tokens----*/
#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_NOP (0x00000000u)
#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_INSERT (0x00000001u)
#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_ADD15_16 (0x00000002u)
#define CSL_AIF_PE_LINK_ID_LUT0_AGGR_CTL_LUT_ADD7_8 (0x00000003u)

#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_MASK (0x00000300u)
#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_SHIFT (0x00000008u)
#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_RESETVAL (0x00000000u)

/*----DATA_FORMAT_LUT Tokens----*/
#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_DL_FMT (0x00000000u)
#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_UL_FMT (0x00000001u)
#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_PIC_FMT (0x00000002u)
#define CSL_AIF_PE_LINK_ID_LUT0_DATA_FORMAT_LUT_GEN_FMT (0x00000003u)

#define CSL_AIF_PE_LINK_ID_LUT0_OFFSET_ADR_LUT_MASK (0x000000E0u)
#define CSL_AIF_PE_LINK_ID_LUT0_OFFSET_ADR_LUT_SHIFT (0x00000005u)
#define CSL_AIF_PE_LINK_ID_LUT0_OFFSET_ADR_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_ID_LUT0_FIFO_INDEX_LUT_MASK (0x0000001Fu)
#define CSL_AIF_PE_LINK_ID_LUT0_FIFO_INDEX_LUT_SHIFT (0x00000000u)
#define CSL_AIF_PE_LINK_ID_LUT0_FIFO_INDEX_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_ID_LUT0_RESETVAL (0x00000000u)

/* PE_LINK_ID_LUT1 */

#define CSL_AIF_PE_LINK_ID_LUT1_TX_RULE_MCOMPARE_LUT_MASK (0x003FF800u)
#define CSL_AIF_PE_LINK_ID_LUT1_TX_RULE_MCOMPARE_LUT_SHIFT (0x0000000Bu)
#define CSL_AIF_PE_LINK_ID_LUT1_TX_RULE_MCOMPARE_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_ID_LUT1_TX_RULE_MASK_LUT_MASK (0x000007FFu)
#define CSL_AIF_PE_LINK_ID_LUT1_TX_RULE_MASK_LUT_SHIFT (0x00000000u)
#define CSL_AIF_PE_LINK_ID_LUT1_TX_RULE_MASK_LUT_RESETVAL (0x00000000u)

#define CSL_AIF_PE_LINK_ID_LUT1_RESETVAL (0x00000000u)

/* PE_CFG */

#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_5_MASK (0x00200000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_5_SHIFT (0x00000015u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_5_RESETVAL (0x00000000u)

/*----LINK_BURST_8VS4_5 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_5_DL (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_5_UL (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_4_MASK (0x00100000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_4_SHIFT (0x00000014u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_4_RESETVAL (0x00000000u)

/*----LINK_BURST_8VS4_4 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_4_DL (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_4_UL (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_3_MASK (0x00080000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_3_SHIFT (0x00000013u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_3_RESETVAL (0x00000000u)

/*----LINK_BURST_8VS4_3 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_3_DL (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_3_UL (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_2_MASK (0x00040000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_2_SHIFT (0x00000012u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_2_RESETVAL (0x00000000u)

/*----LINK_BURST_8VS4_2 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_2_DL (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_2_UL (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_1_MASK (0x00020000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_1_SHIFT (0x00000011u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_1_RESETVAL (0x00000000u)

/*----LINK_BURST_8VS4_1 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_1_DL (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_1_UL (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_0_MASK (0x00010000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_0_SHIFT (0x00000010u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_0_RESETVAL (0x00000000u)

/*----LINK_BURST_8VS4_0 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_0_DL (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_BURST_8VS4_0_UL (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_ENABLE_5_MASK (0x00002000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_5_SHIFT (0x0000000Du)
#define CSL_AIF_PE_CFG_LINK_ENABLE_5_RESETVAL (0x00000000u)

/*----LINK_ENABLE_5 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_ENABLE_5_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_5_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_ENABLE_4_MASK (0x00001000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_4_SHIFT (0x0000000Cu)
#define CSL_AIF_PE_CFG_LINK_ENABLE_4_RESETVAL (0x00000000u)

/*----LINK_ENABLE_4 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_ENABLE_4_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_4_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_ENABLE_3_MASK (0x00000800u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_3_SHIFT (0x0000000Bu)
#define CSL_AIF_PE_CFG_LINK_ENABLE_3_RESETVAL (0x00000000u)

/*----LINK_ENABLE_3 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_ENABLE_3_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_3_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_ENABLE_2_MASK (0x00000400u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_2_SHIFT (0x0000000Au)
#define CSL_AIF_PE_CFG_LINK_ENABLE_2_RESETVAL (0x00000000u)

/*----LINK_ENABLE_2 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_ENABLE_2_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_2_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_ENABLE_1_MASK (0x00000200u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_1_SHIFT (0x00000009u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_1_RESETVAL (0x00000000u)

/*----LINK_ENABLE_1 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_ENABLE_1_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_1_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_LINK_ENABLE_0_MASK (0x00000100u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_0_SHIFT (0x00000008u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_0_RESETVAL (0x00000000u)

/*----LINK_ENABLE_0 Tokens----*/
#define CSL_AIF_PE_CFG_LINK_ENABLE_0_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_LINK_ENABLE_0_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_5_MASK (0x00000020u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_5_SHIFT (0x00000005u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_5_RESETVAL (0x00000000u)

/*----PE_CPRI_CNTL_EN_5 Tokens----*/
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_5_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_5_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_4_MASK (0x00000010u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_4_SHIFT (0x00000004u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_4_RESETVAL (0x00000000u)

/*----PE_CPRI_CNTL_EN_4 Tokens----*/
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_4_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_4_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_3_MASK (0x00000008u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_3_SHIFT (0x00000003u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_3_RESETVAL (0x00000000u)

/*----PE_CPRI_CNTL_EN_3 Tokens----*/
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_3_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_3_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_2_MASK (0x00000004u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_2_SHIFT (0x00000002u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_2_RESETVAL (0x00000000u)

/*----PE_CPRI_CNTL_EN_2 Tokens----*/
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_2_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_2_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_1_MASK (0x00000002u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_1_SHIFT (0x00000001u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_1_RESETVAL (0x00000000u)

/*----PE_CPRI_CNTL_EN_1 Tokens----*/
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_1_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_1_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_0_MASK (0x00000001u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_0_SHIFT (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_0_RESETVAL (0x00000000u)

/*----PE_CPRI_CNTL_EN_0 Tokens----*/
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_0_DISABLED (0x00000000u)
#define CSL_AIF_PE_CFG_PE_CPRI_CNTL_EN_0_ENABLED (0x00000001u)

#define CSL_AIF_PE_CFG_RESETVAL          (0x00000000u)

/* EE_LINK_IRS_A */

#define CSL_AIF_EE_LINK_IRS_A_PD_CPRI_HFN_ERR_MASK (0x10000000u)
#define CSL_AIF_EE_LINK_IRS_A_PD_CPRI_HFN_ERR_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_LINK_IRS_A_PD_CPRI_HFN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_PD_OBSAI_TYPE_ERR_MASK (0x08000000u)
#define CSL_AIF_EE_LINK_IRS_A_PD_OBSAI_TYPE_ERR_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_LINK_IRS_A_PD_OBSAI_TYPE_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_PD_OBSAI_ADR_ERR_MASK (0x04000000u)
#define CSL_AIF_EE_LINK_IRS_A_PD_OBSAI_ADR_ERR_SHIFT (0x0000001Au)
#define CSL_AIF_EE_LINK_IRS_A_PD_OBSAI_ADR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_PD_FSYNC_OR_K_ERR_MASK (0x02000000u)
#define CSL_AIF_EE_LINK_IRS_A_PD_FSYNC_OR_K_ERR_SHIFT (0x00000019u)
#define CSL_AIF_EE_LINK_IRS_A_PD_FSYNC_OR_K_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_PD_TIME_STAMP_ERR_MASK (0x01000000u)
#define CSL_AIF_EE_LINK_IRS_A_PD_TIME_STAMP_ERR_SHIFT (0x00000018u)
#define CSL_AIF_EE_LINK_IRS_A_PD_TIME_STAMP_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_SD_LOS_MASK (0x00010000u)
#define CSL_AIF_EE_LINK_IRS_A_SD_LOS_SHIFT (0x00000010u)
#define CSL_AIF_EE_LINK_IRS_A_SD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_LOF_STATE_MASK (0x00008000u)
#define CSL_AIF_EE_LINK_IRS_A_RM_LOF_STATE_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_LINK_IRS_A_RM_LOF_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_HFNSYNC_STATE_MASK (0x00004000u)
#define CSL_AIF_EE_LINK_IRS_A_RM_HFNSYNC_STATE_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_LINK_IRS_A_RM_HFNSYNC_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_LOF_MASK (0x00002000u)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_LOF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_LOS_MASK (0x00001000u)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_LOS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_SDI_MASK (0x00000800u)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_SDI_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_RAI_MASK (0x00000400u)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_RAI_SHIFT (0x0000000Au)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_RST_MASK (0x00000200u)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_RST_SHIFT (0x00000009u)
#define CSL_AIF_EE_LINK_IRS_A_RM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_K30P7_DET_MASK (0x00000100u)
#define CSL_AIF_EE_LINK_IRS_A_RM_K30P7_DET_SHIFT (0x00000008u)
#define CSL_AIF_EE_LINK_IRS_A_RM_K30P7_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MASK (0x00000080u)
#define CSL_AIF_EE_LINK_IRS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_SHIFT (0x00000007u)
#define CSL_AIF_EE_LINK_IRS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_MISSING_FRAME_INDICATOR_MASK (0x00000040u)
#define CSL_AIF_EE_LINK_IRS_A_RM_MISSING_FRAME_INDICATOR_SHIFT (0x00000006u)
#define CSL_AIF_EE_LINK_IRS_A_RM_MISSING_FRAME_INDICATOR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_MISSING_K28P5_MASK (0x00000020u)
#define CSL_AIF_EE_LINK_IRS_A_RM_MISSING_K28P5_SHIFT (0x00000005u)
#define CSL_AIF_EE_LINK_IRS_A_RM_MISSING_K28P5_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_BLOCK_BNDRY_DET_MASK (0x00000010u)
#define CSL_AIF_EE_LINK_IRS_A_RM_BLOCK_BNDRY_DET_SHIFT (0x00000004u)
#define CSL_AIF_EE_LINK_IRS_A_RM_BLOCK_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_FRAME_BNDRY_DET_MASK (0x00000008u)
#define CSL_AIF_EE_LINK_IRS_A_RM_FRAME_BNDRY_DET_SHIFT (0x00000003u)
#define CSL_AIF_EE_LINK_IRS_A_RM_FRAME_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_8B10B_DECODE_ERROR_MASK (0x00000004u)
#define CSL_AIF_EE_LINK_IRS_A_RM_8B10B_DECODE_ERROR_SHIFT (0x00000002u)
#define CSL_AIF_EE_LINK_IRS_A_RM_8B10B_DECODE_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_LOS_DET_MASK (0x00000002u)
#define CSL_AIF_EE_LINK_IRS_A_RM_LOS_DET_SHIFT (0x00000001u)
#define CSL_AIF_EE_LINK_IRS_A_RM_LOS_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_LINK_IRS_A_RM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_LINK_IRS_A_RM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_A_RESETVAL   (0x00000000u)

/* EE_LINK_IRS_B */

#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_DMA_UFLOW_MASK (0x00100000u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_DMA_UFLOW_SHIFT (0x00000014u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_IN_DMA_UFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_IN_DMA_UFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_IN_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_BURST_OFLOW_MASK (0x00040000u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_BURST_OFLOW_SHIFT (0x00000012u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_BURST_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_DMA_OFLOW_MASK (0x00020000u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_DMA_OFLOW_SHIFT (0x00000011u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_OUT_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_IN_DMA_OFLOW_MASK (0x00010000u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_IN_DMA_OFLOW_SHIFT (0x00000010u)
#define CSL_AIF_EE_LINK_IRS_B_DB_CIRSW_IN_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_CD_OUT_FIFO_UNF_MASK (0x00002000u)
#define CSL_AIF_EE_LINK_IRS_B_CD_OUT_FIFO_UNF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_LINK_IRS_B_CD_OUT_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_CD_OUT_FIFO_OVF_MASK (0x00001000u)
#define CSL_AIF_EE_LINK_IRS_B_CD_OUT_FIFO_OVF_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_LINK_IRS_B_CD_OUT_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_AG_LINK_SUM_OVF_MASK (0x00000400u)
#define CSL_AIF_EE_LINK_IRS_B_AG_LINK_SUM_OVF_SHIFT (0x0000000Au)
#define CSL_AIF_EE_LINK_IRS_B_AG_LINK_SUM_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_AG_FRM_ALIGN_ERR_MASK (0x00000200u)
#define CSL_AIF_EE_LINK_IRS_B_AG_FRM_ALIGN_ERR_SHIFT (0x00000009u)
#define CSL_AIF_EE_LINK_IRS_B_AG_FRM_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_AG_LINK_HDR_ERR_MASK (0x00000100u)
#define CSL_AIF_EE_LINK_IRS_B_AG_LINK_HDR_ERR_SHIFT (0x00000008u)
#define CSL_AIF_EE_LINK_IRS_B_AG_LINK_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_TM_FIFO_UNF_MASK (0x00000010u)
#define CSL_AIF_EE_LINK_IRS_B_TM_FIFO_UNF_SHIFT (0x00000004u)
#define CSL_AIF_EE_LINK_IRS_B_TM_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_TM_FIFO_OVF_MASK (0x00000008u)
#define CSL_AIF_EE_LINK_IRS_B_TM_FIFO_OVF_SHIFT (0x00000003u)
#define CSL_AIF_EE_LINK_IRS_B_TM_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_TM_DATA_NOT_ALIGNED_MASK (0x00000004u)
#define CSL_AIF_EE_LINK_IRS_B_TM_DATA_NOT_ALIGNED_SHIFT (0x00000002u)
#define CSL_AIF_EE_LINK_IRS_B_TM_DATA_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_TM_FRAME_NOT_ALIGNED_MASK (0x00000002u)
#define CSL_AIF_EE_LINK_IRS_B_TM_FRAME_NOT_ALIGNED_SHIFT (0x00000001u)
#define CSL_AIF_EE_LINK_IRS_B_TM_FRAME_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_TM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_LINK_IRS_B_TM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_LINK_IRS_B_TM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_LINK_IRS_B_RESETVAL   (0x00000000u)

/* EE_EV0_LINK_IMS_A */

#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_CPRI_HFN_ERR_MASK (0x10000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_CPRI_HFN_ERR_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_CPRI_HFN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_OBSAI_TYPE_ERR_MASK (0x08000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_OBSAI_TYPE_ERR_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_OBSAI_TYPE_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_OBSAI_ADR_ERR_MASK (0x04000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_OBSAI_ADR_ERR_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_OBSAI_ADR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_FSYNC_OR_K_ERR_MASK (0x02000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_FSYNC_OR_K_ERR_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_FSYNC_OR_K_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_TIME_STAMP_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_TIME_STAMP_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_PD_TIME_STAMP_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_SD_LOS_MASK (0x00010000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_SD_LOS_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_SD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_LOF_STATE_MASK (0x00008000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_LOF_STATE_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_LOF_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_HFNSYNC_STATE_MASK (0x00004000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_HFNSYNC_STATE_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_HFNSYNC_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_LOF_MASK (0x00002000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_LOF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_LOS_MASK (0x00001000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_LOS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_SDI_MASK (0x00000800u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_SDI_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_RAI_MASK (0x00000400u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_RAI_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_RST_MASK (0x00000200u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_RST_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_K30P7_DET_MASK (0x00000100u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_K30P7_DET_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_K30P7_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MASK (0x00000080u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_MASK (0x00000040u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MISSING_K28P5_MASK (0x00000020u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MISSING_K28P5_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_MISSING_K28P5_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_BLOCK_BNDRY_DET_MASK (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_BLOCK_BNDRY_DET_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_BLOCK_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_FRAME_BNDRY_DET_MASK (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_FRAME_BNDRY_DET_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_FRAME_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_8B10B_DECODE_ERROR_MASK (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_8B10B_DECODE_ERROR_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_8B10B_DECODE_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_LOS_DET_MASK (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_LOS_DET_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_LOS_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_A_RESETVAL (0x00000000u)

/* EE_EV0_LINK_IMS_B */

#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_MASK (0x00100000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_MASK (0x00040000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_MASK (0x00020000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_MASK (0x00010000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_CD_OUT_FIFO_UNF_MASK (0x00002000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_CD_OUT_FIFO_UNF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV0_LINK_IMS_B_CD_OUT_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_CD_OUT_FIFO_OVF_MASK (0x00001000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_CD_OUT_FIFO_OVF_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV0_LINK_IMS_B_CD_OUT_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_LINK_SUM_OVF_MASK (0x00000400u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_LINK_SUM_OVF_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_LINK_SUM_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_FRM_ALIGN_ERR_MASK (0x00000200u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_FRM_ALIGN_ERR_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_FRM_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_LINK_HDR_ERR_MASK (0x00000100u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_LINK_HDR_ERR_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_AG_LINK_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FIFO_UNF_MASK (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FIFO_UNF_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FIFO_OVF_MASK (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FIFO_OVF_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_DATA_NOT_ALIGNED_MASK (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_DATA_NOT_ALIGNED_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_DATA_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_MASK (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV0_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_IMS_B_RESETVAL (0x00000000u)

/* EE_EV1_LINK_IMS_A */

#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_CPRI_HFN_ERR_MASK (0x10000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_CPRI_HFN_ERR_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_CPRI_HFN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_OBSAI_TYPE_ERR_MASK (0x08000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_OBSAI_TYPE_ERR_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_OBSAI_TYPE_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_OBSAI_ADR_ERR_MASK (0x04000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_OBSAI_ADR_ERR_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_OBSAI_ADR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_FSYNC_OR_K_ERR_MASK (0x02000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_FSYNC_OR_K_ERR_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_FSYNC_OR_K_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_TIME_STAMP_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_TIME_STAMP_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_PD_TIME_STAMP_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_SD_LOS_MASK (0x00010000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_SD_LOS_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_SD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_LOF_STATE_MASK (0x00008000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_LOF_STATE_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_LOF_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_HFNSYNC_STATE_MASK (0x00004000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_HFNSYNC_STATE_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_HFNSYNC_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_LOF_MASK (0x00002000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_LOF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_LOS_MASK (0x00001000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_LOS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_SDI_MASK (0x00000800u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_SDI_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_RAI_MASK (0x00000400u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_RAI_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_RST_MASK (0x00000200u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_RST_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_K30P7_DET_MASK (0x00000100u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_K30P7_DET_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_K30P7_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MASK (0x00000080u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_MASK (0x00000040u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MISSING_K28P5_MASK (0x00000020u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MISSING_K28P5_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_MISSING_K28P5_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_BLOCK_BNDRY_DET_MASK (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_BLOCK_BNDRY_DET_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_BLOCK_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_FRAME_BNDRY_DET_MASK (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_FRAME_BNDRY_DET_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_FRAME_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_8B10B_DECODE_ERROR_MASK (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_8B10B_DECODE_ERROR_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_8B10B_DECODE_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_LOS_DET_MASK (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_LOS_DET_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_LOS_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_A_RESETVAL (0x00000000u)

/* EE_EV1_LINK_IMS_B */

#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_MASK (0x00100000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_MASK (0x00040000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_MASK (0x00020000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_MASK (0x00010000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_CD_OUT_FIFO_UNF_MASK (0x00002000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_CD_OUT_FIFO_UNF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV1_LINK_IMS_B_CD_OUT_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_CD_OUT_FIFO_OVF_MASK (0x00001000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_CD_OUT_FIFO_OVF_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV1_LINK_IMS_B_CD_OUT_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_LINK_SUM_OVF_MASK (0x00000400u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_LINK_SUM_OVF_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_LINK_SUM_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_FRM_ALIGN_ERR_MASK (0x00000200u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_FRM_ALIGN_ERR_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_FRM_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_LINK_HDR_ERR_MASK (0x00000100u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_LINK_HDR_ERR_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_AG_LINK_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FIFO_UNF_MASK (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FIFO_UNF_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FIFO_OVF_MASK (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FIFO_OVF_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_DATA_NOT_ALIGNED_MASK (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_DATA_NOT_ALIGNED_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_DATA_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_MASK (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV1_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_IMS_B_RESETVAL (0x00000000u)

/* EE_EV0_LINK_MSK_SET_A */

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_A_RESETVAL (0x00000000u)

/* EE_EV0_LINK_MSK_SET_B */

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_SET_B_RESETVAL (0x00000000u)

/* EE_EV1_LINK_MSK_SET_A */

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_A_RESETVAL (0x00000000u)

/* EE_EV1_LINK_MSK_SET_B */

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_SET_B_RESETVAL (0x00000000u)

/* EE_EV0_LINK_MSK_CLR_A */

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_A_RESETVAL (0x00000000u)

/* EE_EV0_LINK_MSK_CLR_B */

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV0_LINK_MSK_CLR_B_RESETVAL (0x00000000u)

/* EE_EV1_LINK_MSK_CLR_A */

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_A_RESETVAL (0x00000000u)

/* EE_EV1_LINK_MSK_CLR_B */

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV1_LINK_MSK_CLR_B_RESETVAL (0x00000000u)

/* EE_CFG */

#define CSL_AIF_EE_CFG_AI_EVENT3_MODE_MASK (0x00000008u)
#define CSL_AIF_EE_CFG_AI_EVENT3_MODE_SHIFT (0x00000003u)
#define CSL_AIF_EE_CFG_AI_EVENT3_MODE_RESETVAL (0x00000000u)

/*----AI_EVENT3_MODE Tokens----*/
#define CSL_AIF_EE_CFG_AI_EVENT3_MODE_ERROR_MODE (0x00000000u)
#define CSL_AIF_EE_CFG_AI_EVENT3_MODE_TRIGGER_MODE (0x00000001u)

#define CSL_AIF_EE_CFG_AI_EVENT2_MODE_MASK (0x00000004u)
#define CSL_AIF_EE_CFG_AI_EVENT2_MODE_SHIFT (0x00000002u)
#define CSL_AIF_EE_CFG_AI_EVENT2_MODE_RESETVAL (0x00000000u)

/*----AI_EVENT2_MODE Tokens----*/
#define CSL_AIF_EE_CFG_AI_EVENT2_MODE_ERROR_MODE (0x00000000u)
#define CSL_AIF_EE_CFG_AI_EVENT2_MODE_TRIGGER_MODE (0x00000001u)

#define CSL_AIF_EE_CFG_AI_EVENT1_MODE_MASK (0x00000002u)
#define CSL_AIF_EE_CFG_AI_EVENT1_MODE_SHIFT (0x00000001u)
#define CSL_AIF_EE_CFG_AI_EVENT1_MODE_RESETVAL (0x00000000u)

/*----AI_EVENT1_MODE Tokens----*/
#define CSL_AIF_EE_CFG_AI_EVENT1_MODE_ERROR_MODE (0x00000000u)
#define CSL_AIF_EE_CFG_AI_EVENT1_MODE_TRIGGER_MODE (0x00000001u)

#define CSL_AIF_EE_CFG_AI_EVENT0_MODE_MASK (0x00000001u)
#define CSL_AIF_EE_CFG_AI_EVENT0_MODE_SHIFT (0x00000000u)
#define CSL_AIF_EE_CFG_AI_EVENT0_MODE_RESETVAL (0x00000000u)

/*----AI_EVENT0_MODE Tokens----*/
#define CSL_AIF_EE_CFG_AI_EVENT0_MODE_ERROR_MODE (0x00000000u)
#define CSL_AIF_EE_CFG_AI_EVENT0_MODE_TRIGGER_MODE (0x00000001u)

#define CSL_AIF_EE_CFG_RESETVAL          (0x00000000u)

/* EE_LINK_SEL_EV2A */

#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_MASK (0x07000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_SHIFT (0x00000018u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_RESETVAL (0x00000000u)

/*----DB_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_DB_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_MASK (0x00700000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_SHIFT (0x00000014u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_RESETVAL (0x00000000u)

/*----CD_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_CD_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_MASK (0x00070000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_SHIFT (0x00000010u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_RESETVAL (0x00000000u)

/*----AG_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_AG_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_MASK (0x00007000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_RESETVAL (0x00000000u)

/*----TM_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_TM_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_MASK (0x00000700u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_SHIFT (0x00000008u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_RESETVAL (0x00000000u)

/*----PD_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_PD_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_MASK (0x00000070u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_SHIFT (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_RESETVAL (0x00000000u)

/*----SD_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_SD_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_MASK (0x00000007u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_SHIFT (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_RESETVAL (0x00000000u)

/*----RM_LINK_SEL Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2A_RM_LINK_SEL_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2A_RESETVAL (0x00000000u)

/* EE_LINK_SEL_EV2B */

#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_MASK (0x00000070u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_SHIFT (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_RESETVAL (0x00000000u)

/*----PE_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2B_PE_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_MASK (0x00000007u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_SHIFT (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_RESETVAL (0x00000000u)

/*----CI_LINK_SEL Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV2B_CI_LINK_SEL_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV2B_RESETVAL (0x00000000u)

/* EE_LINK_SEL_EV3A */

#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_MASK (0x07000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_SHIFT (0x00000018u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_RESETVAL (0x00000000u)

/*----DB_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_DB_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_MASK (0x00700000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_SHIFT (0x00000014u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_RESETVAL (0x00000000u)

/*----CD_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_CD_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_MASK (0x00070000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_SHIFT (0x00000010u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_RESETVAL (0x00000000u)

/*----AG_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_AG_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_MASK (0x00007000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_RESETVAL (0x00000000u)

/*----TM_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_TM_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_MASK (0x00000700u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_SHIFT (0x00000008u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_RESETVAL (0x00000000u)

/*----PD_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_PD_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_MASK (0x00000070u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_SHIFT (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_RESETVAL (0x00000000u)

/*----SD_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_SD_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_MASK (0x00000007u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_SHIFT (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_RESETVAL (0x00000000u)

/*----RM_LINK_SEL Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3A_RM_LINK_SEL_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3A_RESETVAL (0x00000000u)

/* EE_LINK_SEL_EV3B */

#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_MASK (0x00000070u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_SHIFT (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_RESETVAL (0x00000000u)

/*----PE_LINK_SELECT Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3B_PE_LINK_SELECT_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_MASK (0x00000007u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_SHIFT (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_RESETVAL (0x00000000u)

/*----CI_LINK_SEL Tokens----*/
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_LINK0 (0x00000000u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_LINK1 (0x00000001u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_LINK2 (0x00000002u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_LINK3 (0x00000003u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_LINK4 (0x00000004u)
#define CSL_AIF_EE_LINK_SEL_EV3B_CI_LINK_SEL_LINK5 (0x00000005u)

#define CSL_AIF_EE_LINK_SEL_EV3B_RESETVAL (0x00000000u)

/* EE_INT_END */

#define CSL_AIF_EE_INT_END_INTR_EOI_MASK (0x00000003u)
#define CSL_AIF_EE_INT_END_INTR_EOI_SHIFT (0x00000000u)
#define CSL_AIF_EE_INT_END_INTR_EOI_RESETVAL (0x00000000u)

/*----INTR_EOI Tokens----*/
#define CSL_AIF_EE_INT_END_INTR_EOI_AI_EVT0 (0x00000000u)
#define CSL_AIF_EE_INT_END_INTR_EOI_AI_EVT1 (0x00000001u)
#define CSL_AIF_EE_INT_END_INTR_EOI_AI_EVT2 (0x00000002u)
#define CSL_AIF_EE_INT_END_INTR_EOI_AI_EVT3 (0x00000003u)

#define CSL_AIF_EE_INT_END_RESETVAL      (0x00000000u)

/* EE_AI_RUN */

#define CSL_AIF_EE_AI_RUN_RUN_STAT_MASK  (0x00000001u)
#define CSL_AIF_EE_AI_RUN_RUN_STAT_SHIFT (0x00000000u)
#define CSL_AIF_EE_AI_RUN_RUN_STAT_RESETVAL (0x00000000u)

/*----RUN_STAT Tokens----*/
#define CSL_AIF_EE_AI_RUN_RUN_STAT_NOT_RUNNING (0x00000000u)
#define CSL_AIF_EE_AI_RUN_RUN_STAT_RUNNING (0x00000001u)

#define CSL_AIF_EE_AI_RUN_RESETVAL       (0x00000000u)

/* EE_COMMON_IRS */

#define CSL_AIF_EE_COMMON_IRS_DB_CAPT_RAM_VBUS_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_IRS_DB_CAPT_RAM_VBUS_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_IRS_DB_CAPT_RAM_VBUS_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_CIRSW_OUT_RD_DEBUG_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_IRS_DB_CIRSW_OUT_RD_DEBUG_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_IRS_DB_CIRSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_CIRSW_IN_WR_DEBUG_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_IRS_DB_CIRSW_IN_WR_DEBUG_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_IRS_DB_CIRSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_RD_DEBUG_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_RD_DEBUG_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_WR_DEBUG_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_WR_DEBUG_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_FIFO_OFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_FIFO_OFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_FIFO_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_MEM_LEAK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_MEM_LEAK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_MEM_LEAK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_RAM_WR_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_RAM_WR_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_OUT_RAM_WR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_RAM_RD_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_RAM_RD_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_RAM_RD_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW3_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW3_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW2_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW2_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW1_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW1_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW0_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW0_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_UFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW3_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW3_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW2_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW2_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW1_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW1_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW0_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW0_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_IRS_DB_PKTSW_IN_FIFO_OFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_CD1_ALIGN_ERR_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_IRS_CD1_ALIGN_ERR_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_IRS_CD1_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_CD0_ALIGN_ERR_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_IRS_CD0_ALIGN_ERR_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_IRS_CD0_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IRS_RESETVAL   (0x00000000u)

/* EE_COMMON_IMS_EV0 */

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CAPT_RAM_VBUS_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CAPT_RAM_VBUS_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CAPT_RAM_VBUS_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CIRSW_OUT_RD_DEBUG_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CIRSW_OUT_RD_DEBUG_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CIRSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CIRSW_IN_WR_DEBUG_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CIRSW_IN_WR_DEBUG_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_CIRSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_RD_DEBUG_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_RD_DEBUG_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_WR_DEBUG_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_WR_DEBUG_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_FIFO_OFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_FIFO_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_MEM_LEAK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_MEM_LEAK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_MEM_LEAK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_RAM_WR_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_RAM_WR_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_OUT_RAM_WR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_RAM_RD_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_RAM_RD_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_RAM_RD_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW3_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW2_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW1_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW0_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_UFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW3_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW2_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW1_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW0_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_IMS_EV0_DB_PKTSW_IN_FIFO_OFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_CD1_ALIGN_ERR_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_IMS_EV0_CD1_ALIGN_ERR_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV0_CD1_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_CD0_ALIGN_ERR_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV0_CD0_ALIGN_ERR_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_IMS_EV0_CD0_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV0_RESETVAL (0x00000000u)

/* EE_COMMON_IMS_EV1 */

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CAPT_RAM_VBUS_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CAPT_RAM_VBUS_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CAPT_RAM_VBUS_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CIRSW_OUT_RD_DEBUG_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CIRSW_OUT_RD_DEBUG_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CIRSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CIRSW_IN_WR_DEBUG_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CIRSW_IN_WR_DEBUG_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_CIRSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_RD_DEBUG_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_RD_DEBUG_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_WR_DEBUG_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_WR_DEBUG_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_FIFO_OFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_FIFO_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_MEM_LEAK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_MEM_LEAK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_MEM_LEAK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_RAM_WR_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_RAM_WR_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_OUT_RAM_WR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_RAM_RD_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_RAM_RD_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_RAM_RD_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW3_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW2_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW1_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW0_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_UFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW3_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW2_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW1_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW0_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_IMS_EV1_DB_PKTSW_IN_FIFO_OFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_CD1_ALIGN_ERR_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_IMS_EV1_CD1_ALIGN_ERR_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV1_CD1_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_CD0_ALIGN_ERR_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV1_CD0_ALIGN_ERR_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_IMS_EV1_CD0_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV1_RESETVAL (0x00000000u)

/* EE_EV2_LINK_IMS_A */

#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_CPRI_HFN_ERR_MASK (0x10000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_CPRI_HFN_ERR_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_CPRI_HFN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_OBSAI_TYPE_ERR_MASK (0x08000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_OBSAI_TYPE_ERR_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_OBSAI_TYPE_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_OBSAI_ADR_ERR_MASK (0x04000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_OBSAI_ADR_ERR_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_OBSAI_ADR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_FSYNC_OR_K_ERR_MASK (0x02000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_FSYNC_OR_K_ERR_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_FSYNC_OR_K_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_TIME_STAMP_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_TIME_STAMP_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_PD_TIME_STAMP_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_SD_LOS_MASK (0x00010000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_SD_LOS_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_SD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_LOF_STATE_MASK (0x00008000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_LOF_STATE_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_LOF_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_HFNSYNC_STATE_MASK (0x00004000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_HFNSYNC_STATE_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_HFNSYNC_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_LOF_MASK (0x00002000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_LOF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_LOS_MASK (0x00001000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_LOS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_SDI_MASK (0x00000800u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_SDI_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_RAI_MASK (0x00000400u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_RAI_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_RST_MASK (0x00000200u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_RST_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_K30P7_DET_MASK (0x00000100u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_K30P7_DET_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_K30P7_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MASK (0x00000080u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_MASK (0x00000040u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MISSING_K28P5_MASK (0x00000020u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MISSING_K28P5_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_MISSING_K28P5_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_BLOCK_BNDRY_DET_MASK (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_BLOCK_BNDRY_DET_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_BLOCK_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_FRAME_BNDRY_DET_MASK (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_FRAME_BNDRY_DET_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_FRAME_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_8B10B_DECODE_ERROR_MASK (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_8B10B_DECODE_ERROR_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_8B10B_DECODE_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_LOS_DET_MASK (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_LOS_DET_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_LOS_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_A_RESETVAL (0x00000000u)

/* EE_EV2_LINK_IMS_B */

#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_MASK (0x00100000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_MASK (0x00040000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_MASK (0x00020000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_MASK (0x00010000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_CD_OUT_FIFO_UNF_MASK (0x00002000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_CD_OUT_FIFO_UNF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV2_LINK_IMS_B_CD_OUT_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_CD_OUT_FIFO_OVF_MASK (0x00001000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_CD_OUT_FIFO_OVF_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV2_LINK_IMS_B_CD_OUT_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_LINK_SUM_OVF_MASK (0x00000400u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_LINK_SUM_OVF_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_LINK_SUM_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_FRM_ALIGN_ERR_MASK (0x00000200u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_FRM_ALIGN_ERR_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_FRM_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_LINK_HDR_ERR_MASK (0x00000100u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_LINK_HDR_ERR_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_AG_LINK_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FIFO_UNF_MASK (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FIFO_UNF_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FIFO_OVF_MASK (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FIFO_OVF_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_DATA_NOT_ALIGNED_MASK (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_DATA_NOT_ALIGNED_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_DATA_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_MASK (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV2_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_IMS_B_RESETVAL (0x00000000u)

/* EE_COMMON_IMS_EV2 */

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CAPT_RAM_VBUS_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CAPT_RAM_VBUS_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CAPT_RAM_VBUS_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CIRSW_OUT_RD_DEBUG_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CIRSW_OUT_RD_DEBUG_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CIRSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CIRSW_IN_WR_DEBUG_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CIRSW_IN_WR_DEBUG_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_CIRSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_RD_DEBUG_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_RD_DEBUG_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_WR_DEBUG_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_WR_DEBUG_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_FIFO_OFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_FIFO_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_MEM_LEAK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_MEM_LEAK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_MEM_LEAK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_RAM_WR_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_RAM_WR_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_OUT_RAM_WR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_RAM_RD_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_RAM_RD_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_RAM_RD_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW3_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW2_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW1_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW0_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_UFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW3_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW2_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW1_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW0_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_IMS_EV2_DB_PKTSW_IN_FIFO_OFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_CD1_ALIGN_ERR_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_IMS_EV2_CD1_ALIGN_ERR_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV2_CD1_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_CD0_ALIGN_ERR_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV2_CD0_ALIGN_ERR_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_IMS_EV2_CD0_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV2_RESETVAL (0x00000000u)

/* EE_EV3_LINK_IMS_A */

#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_CPRI_HFN_ERR_MASK (0x10000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_CPRI_HFN_ERR_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_CPRI_HFN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_OBSAI_TYPE_ERR_MASK (0x08000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_OBSAI_TYPE_ERR_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_OBSAI_TYPE_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_OBSAI_ADR_ERR_MASK (0x04000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_OBSAI_ADR_ERR_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_OBSAI_ADR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_FSYNC_OR_K_ERR_MASK (0x02000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_FSYNC_OR_K_ERR_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_FSYNC_OR_K_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_TIME_STAMP_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_TIME_STAMP_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_PD_TIME_STAMP_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_SD_LOS_MASK (0x00010000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_SD_LOS_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_SD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_LOF_STATE_MASK (0x00008000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_LOF_STATE_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_LOF_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_HFNSYNC_STATE_MASK (0x00004000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_HFNSYNC_STATE_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_HFNSYNC_STATE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_LOF_MASK (0x00002000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_LOF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_LOF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_LOS_MASK (0x00001000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_LOS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_LOS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_SDI_MASK (0x00000800u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_SDI_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_SDI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_RAI_MASK (0x00000400u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_RAI_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_RAI_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_RST_MASK (0x00000200u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_RST_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_RCVD_RST_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_K30P7_DET_MASK (0x00000100u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_K30P7_DET_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_K30P7_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MASK (0x00000080u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_MASK (0x00000040u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MISSING_FRAME_INDICATOR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MISSING_K28P5_MASK (0x00000020u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MISSING_K28P5_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_MISSING_K28P5_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_BLOCK_BNDRY_DET_MASK (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_BLOCK_BNDRY_DET_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_BLOCK_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_FRAME_BNDRY_DET_MASK (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_FRAME_BNDRY_DET_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_FRAME_BNDRY_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_8B10B_DECODE_ERROR_MASK (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_8B10B_DECODE_ERROR_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_8B10B_DECODE_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_LOS_DET_MASK (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_LOS_DET_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_LOS_DET_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_A_RM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_A_RESETVAL (0x00000000u)

/* EE_EV3_LINK_IMS_B */

#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_MASK (0x00100000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_IN_DMA_UFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_MASK (0x00040000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_BURST_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_MASK (0x00020000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_OUT_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_MASK (0x00010000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_DB_CIRSW_IN_DMA_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_CD_OUT_FIFO_UNF_MASK (0x00002000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_CD_OUT_FIFO_UNF_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV3_LINK_IMS_B_CD_OUT_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_CD_OUT_FIFO_OVF_MASK (0x00001000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_CD_OUT_FIFO_OVF_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV3_LINK_IMS_B_CD_OUT_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_LINK_SUM_OVF_MASK (0x00000400u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_LINK_SUM_OVF_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_LINK_SUM_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_FRM_ALIGN_ERR_MASK (0x00000200u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_FRM_ALIGN_ERR_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_FRM_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_LINK_HDR_ERR_MASK (0x00000100u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_LINK_HDR_ERR_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_AG_LINK_HDR_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FIFO_UNF_MASK (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FIFO_UNF_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FIFO_UNF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FIFO_OVF_MASK (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FIFO_OVF_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FIFO_OVF_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_DATA_NOT_ALIGNED_MASK (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_DATA_NOT_ALIGNED_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_DATA_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_MASK (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_FRAME_NOT_ALIGNED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_MASK (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV3_LINK_IMS_B_TM_SYNC_STATUS_CHANGE_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_IMS_B_RESETVAL (0x00000000u)

/* EE_COMMON_IMS_EV3 */

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CAPT_RAM_VBUS_ERROR_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CAPT_RAM_VBUS_ERROR_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CAPT_RAM_VBUS_ERROR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CIRSW_OUT_RD_DEBUG_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CIRSW_OUT_RD_DEBUG_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CIRSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CIRSW_IN_WR_DEBUG_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CIRSW_IN_WR_DEBUG_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_CIRSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_RD_DEBUG_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_RD_DEBUG_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_RD_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_WR_DEBUG_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_WR_DEBUG_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_WR_DEBUG_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_FIFO_OFLOW_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_FIFO_OFLOW_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_MEM_LEAK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_MEM_LEAK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_MEM_LEAK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_RAM_WR_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_RAM_WR_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_OUT_RAM_WR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_RAM_RD_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_RAM_RD_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_RAM_RD_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW3_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW2_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW1_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW0_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_UFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW3_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW3_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW2_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW2_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW1_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW1_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW0_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_IMS_EV3_DB_PKTSW_IN_FIFO_OFLOW0_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_CD1_ALIGN_ERR_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_IMS_EV3_CD1_ALIGN_ERR_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV3_CD1_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_CD0_ALIGN_ERR_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_IMS_EV3_CD0_ALIGN_ERR_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_IMS_EV3_CD0_ALIGN_ERR_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_IMS_EV3_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_SET_EV0 */

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV0_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV0_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_SET_EV1 */

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV1_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV1_RESETVAL (0x00000000u)

/* EE_EV2_LINK_MSK_SET_A */

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_A_RESETVAL (0x00000000u)

/* EE_EV2_LINK_MSK_SET_B */

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_RESERVED_MASK (0x01E00000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_RESERVED_SHIFT (0x00000015u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_RESERVED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_SET_B_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_SET_EV2 */

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV2_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV2_RESETVAL (0x00000000u)

/* EE_EV3_LINK_MSK_SET_A */

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_8B10B_DECODE_ERR0R_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_A_RESETVAL (0x00000000u)

/* EE_EV3_LINK_MSK_SET_B */

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_RESERVED_MASK (0x01E00000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_RESERVED_SHIFT (0x00000015u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_RESERVED_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_TM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_SET_B_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_SET_EV3 */

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_SET_EV3_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_SET_EV3_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_CLR_EV0 */

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV0_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_CLR_EV1 */

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV1_RESETVAL (0x00000000u)

/* EE_EV2_LINK_MSK_CLR_A */

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_A_RESETVAL (0x00000000u)

/* EE_EV2_LINK_MSK_CLR_B */

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV2_LINK_MSK_CLR_B_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_CLR_EV2 */

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV2_RESETVAL (0x00000000u)

/* EE_EV3_LINK_MSK_CLR_A */

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_MASK (0x10000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_SHIFT (0x0000001Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_CPRI_HFN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_MASK (0x08000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_SHIFT (0x0000001Bu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_OBSAI_TYPE_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_MASK (0x04000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_SHIFT (0x0000001Au)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_OBSAI_ADR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_MASK (0x02000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_SHIFT (0x00000019u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_FSYNC_OR_K_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_PD_TIME_STAMP_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_SD_LOS_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_SD_LOS_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_SD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_LOF_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_HFNSYNC_STATE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_LOF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_LOS_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_SDI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_RAI_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_RCVD_RST_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_K30P7_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_MASK (0x00000080u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_SHIFT (0x00000007u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MSTR_FRAME_BNDY_OUT_OF_RANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_MASK (0x00000040u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_SHIFT (0x00000006u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MISSING_FRAME_INDICATOR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_MASK (0x00000020u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_SHIFT (0x00000005u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_MISSING_K28P5_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_BLOCK_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_FRAME_BNDRY_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_8B10B_DECODE_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_LOS_DET_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_LOS_DET_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_LOS_DET_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_A_RESETVAL (0x00000000u)

/* EE_EV3_LINK_MSK_CLR_B */

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_UFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_BURST_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_OUT_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_DB_CIRSW_IN_DMA_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_CD_OUT_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_CD_OUT_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_LINK_SUM_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_FRM_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_AG_LINK_HDR_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_MASK (0x00000010u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_SHIFT (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FIFO_UNF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_MASK (0x00000008u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_SHIFT (0x00000003u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FIFO_OVF_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_MASK (0x00000004u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_SHIFT (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_DATA_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_TM_FRAME_NOT_ALIGNED_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_RM_SYNC_STATUS_CHANGE_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_EV3_LINK_MSK_CLR_B_RESETVAL (0x00000000u)

/* EE_COMMON_MSK_CLR_EV3 */

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CAPT_RAM_VBUS_ERROR_MSK_MASK (0x01000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CAPT_RAM_VBUS_ERROR_MSK_SHIFT (0x00000018u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CAPT_RAM_VBUS_ERROR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CIRSW_OUT_RD_DEBUG_MSK_MASK (0x00800000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CIRSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000017u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CIRSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CIRSW_IN_WR_DEBUG_MSK_MASK (0x00400000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CIRSW_IN_WR_DEBUG_MSK_SHIFT (0x00000016u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_CIRSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_RD_DEBUG_MSK_MASK (0x00200000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_RD_DEBUG_MSK_SHIFT (0x00000015u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_RD_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_WR_DEBUG_MSK_MASK (0x00100000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_WR_DEBUG_MSK_SHIFT (0x00000014u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_WR_DEBUG_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MSK_MASK (0x00080000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MSK_SHIFT (0x00000013u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_FIFO_OFLOW_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_MEM_LEAK_MSK_MASK (0x00040000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_MEM_LEAK_MSK_SHIFT (0x00000012u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_MEM_LEAK_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_RAM_WR_MSK_MASK (0x00020000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_RAM_WR_MSK_SHIFT (0x00000011u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_OUT_RAM_WR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_RAM_RD_MSK_MASK (0x00010000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_RAM_RD_MSK_SHIFT (0x00000010u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_RAM_RD_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MSK_MASK (0x00008000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MSK_SHIFT (0x0000000Fu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MSK_MASK (0x00004000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MSK_SHIFT (0x0000000Eu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MSK_MASK (0x00002000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MSK_SHIFT (0x0000000Du)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MSK_MASK (0x00001000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MSK_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_UFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MSK_MASK (0x00000800u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MSK_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW3_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MSK_MASK (0x00000400u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MSK_SHIFT (0x0000000Au)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW2_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MSK_MASK (0x00000200u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MSK_SHIFT (0x00000009u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW1_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MSK_MASK (0x00000100u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MSK_SHIFT (0x00000008u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_DB_PKTSW_IN_FIFO_OFLOW0_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_CD1_ALIGN_ERR_MSK_MASK (0x00000002u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_CD1_ALIGN_ERR_MSK_SHIFT (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_CD1_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_CD0_ALIGN_ERR_MSK_MASK (0x00000001u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_CD0_ALIGN_ERR_MSK_SHIFT (0x00000000u)
#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_CD0_ALIGN_ERR_MSK_RESETVAL (0x00000000u)

#define CSL_AIF_EE_COMMON_MSK_CLR_EV3_RESETVAL (0x00000000u)

/* EE_INT_VECT_EV0 */

#define CSL_AIF_EE_INT_VECT_EV0_COMMON_STATUS_MASK (0x00001000u)
#define CSL_AIF_EE_INT_VECT_EV0_COMMON_STATUS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_INT_VECT_EV0_COMMON_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK5_B_STATUS_MASK (0x00000800u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK5_B_STATUS_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_INT_VECT_EV0_LINK5_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK5_A_STATUS_MASK (0x00000400u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK5_A_STATUS_SHIFT (0x0000000Au)
#define CSL_AIF_EE_INT_VECT_EV0_LINK5_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK4_B_STATUS_MASK (0x00000200u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK4_B_STATUS_SHIFT (0x00000009u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK4_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK4_A_STATUS_MASK (0x00000100u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK4_A_STATUS_SHIFT (0x00000008u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK4_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK3_B_STATUS_MASK (0x00000080u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK3_B_STATUS_SHIFT (0x00000007u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK3_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK3_A_STATUS_MASK (0x00000040u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK3_A_STATUS_SHIFT (0x00000006u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK3_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK2_B_STATUS_MASK (0x00000020u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK2_B_STATUS_SHIFT (0x00000005u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK2_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK2_A_STATUS_MASK (0x00000010u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK2_A_STATUS_SHIFT (0x00000004u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK2_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK1_B_STATUS_MASK (0x00000008u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK1_B_STATUS_SHIFT (0x00000003u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK1_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK1_A_STATUS_MASK (0x00000004u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK1_A_STATUS_SHIFT (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK1_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK0_B_STATUS_MASK (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK0_B_STATUS_SHIFT (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK0_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV0_LINK0_A_STATUS_MASK (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK0_A_STATUS_SHIFT (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK0_A_STATUS_RESETVAL (0x00000000u)

/*----LINK0_A_STATUS Tokens----*/
#define CSL_AIF_EE_INT_VECT_EV0_LINK0_A_STATUS_NO_ERRORS (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV0_LINK0_A_STATUS_ERRORS (0x00000001u)

#define CSL_AIF_EE_INT_VECT_EV0_RESETVAL (0x00000000u)

/* EE_INT_VECT_EV1 */

#define CSL_AIF_EE_INT_VECT_EV1_COMMON_STATUS_MASK (0x00001000u)
#define CSL_AIF_EE_INT_VECT_EV1_COMMON_STATUS_SHIFT (0x0000000Cu)
#define CSL_AIF_EE_INT_VECT_EV1_COMMON_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK5_B_STATUS_MASK (0x00000800u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK5_B_STATUS_SHIFT (0x0000000Bu)
#define CSL_AIF_EE_INT_VECT_EV1_LINK5_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK5_A_STATUS_MASK (0x00000400u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK5_A_STATUS_SHIFT (0x0000000Au)
#define CSL_AIF_EE_INT_VECT_EV1_LINK5_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK4_B_STATUS_MASK (0x00000200u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK4_B_STATUS_SHIFT (0x00000009u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK4_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK4_A_STATUS_MASK (0x00000100u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK4_A_STATUS_SHIFT (0x00000008u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK4_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK3_B_STATUS_MASK (0x00000080u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK3_B_STATUS_SHIFT (0x00000007u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK3_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK3_A_STATUS_MASK (0x00000040u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK3_A_STATUS_SHIFT (0x00000006u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK3_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK2_B_STATUS_MASK (0x00000020u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK2_B_STATUS_SHIFT (0x00000005u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK2_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK2_A_STATUS_MASK (0x00000010u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK2_A_STATUS_SHIFT (0x00000004u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK2_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK1_B_STATUS_MASK (0x00000008u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK1_B_STATUS_SHIFT (0x00000003u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK1_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK1_A_STATUS_MASK (0x00000004u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK1_A_STATUS_SHIFT (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK1_A_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK0_B_STATUS_MASK (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK0_B_STATUS_SHIFT (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK0_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV1_LINK0_A_STATUS_MASK (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK0_A_STATUS_SHIFT (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK0_A_STATUS_RESETVAL (0x00000000u)

/*----LINK0_A_STATUS Tokens----*/
#define CSL_AIF_EE_INT_VECT_EV1_LINK0_A_STATUS_NO_ERRORS (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV1_LINK0_A_STATUS_ERRORS (0x00000001u)

#define CSL_AIF_EE_INT_VECT_EV1_RESETVAL (0x00000000u)

/* EE_INT_VECT_EV2 */

#define CSL_AIF_EE_INT_VECT_EV2_COMMON_STATUS_MASK (0x00000004u)
#define CSL_AIF_EE_INT_VECT_EV2_COMMON_STATUS_SHIFT (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV2_COMMON_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV2_LINK0_B_STATUS_MASK (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV2_LINK0_B_STATUS_SHIFT (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV2_LINK0_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV2_LINK0_A_STATUS_MASK (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV2_LINK0_A_STATUS_SHIFT (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV2_LINK0_A_STATUS_RESETVAL (0x00000000u)

/*----LINK0_A_STATUS Tokens----*/
#define CSL_AIF_EE_INT_VECT_EV2_LINK0_A_STATUS_NO_ERRORS (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV2_LINK0_A_STATUS_ERRORS (0x00000001u)

#define CSL_AIF_EE_INT_VECT_EV2_RESETVAL (0x00000000u)

/* EE_INT_VECT_EV3 */

#define CSL_AIF_EE_INT_VECT_EV3_COMMON_STATUS_MASK (0x00000004u)
#define CSL_AIF_EE_INT_VECT_EV3_COMMON_STATUS_SHIFT (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV3_COMMON_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV3_LINK0_B_STATUS_MASK (0x00000002u)
#define CSL_AIF_EE_INT_VECT_EV3_LINK0_B_STATUS_SHIFT (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV3_LINK0_B_STATUS_RESETVAL (0x00000000u)

#define CSL_AIF_EE_INT_VECT_EV3_LINK0_A_STATUS_MASK (0x00000001u)
#define CSL_AIF_EE_INT_VECT_EV3_LINK0_A_STATUS_SHIFT (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV3_LINK0_A_STATUS_RESETVAL (0x00000000u)

/*----LINK0_A_STATUS Tokens----*/
#define CSL_AIF_EE_INT_VECT_EV3_LINK0_A_STATUS_NO_ERRORS (0x00000000u)
#define CSL_AIF_EE_INT_VECT_EV3_LINK0_A_STATUS_ERRORS (0x00000001u)

#define CSL_AIF_EE_INT_VECT_EV3_RESETVAL (0x00000000u)

/* VD_RD_BUSERR */

#define CSL_AIF_VD_RD_BUSERR_RESERVED_MASK (0x01000000u)
#define CSL_AIF_VD_RD_BUSERR_RESERVED_SHIFT (0x00000018u)
#define CSL_AIF_VD_RD_BUSERR_RESERVED_RESETVAL (0x00000000u)

#define CSL_AIF_VD_RD_BUSERR_ADDR_MASK   (0x00FFFFFFu)
#define CSL_AIF_VD_RD_BUSERR_ADDR_SHIFT  (0x00000000u)
#define CSL_AIF_VD_RD_BUSERR_ADDR_RESETVAL (0x00000000u)

#define CSL_AIF_VD_RD_BUSERR_RESETVAL    (0x00000000u)

/* VD_WR_BUSERR */

#define CSL_AIF_VD_WR_BUSERR_RESERVED_MASK (0x01000000u)
#define CSL_AIF_VD_WR_BUSERR_RESERVED_SHIFT (0x00000018u)
#define CSL_AIF_VD_WR_BUSERR_RESERVED_RESETVAL (0x00000000u)

#define CSL_AIF_VD_WR_BUSERR_ADDR_MASK   (0x00FFFFFFu)
#define CSL_AIF_VD_WR_BUSERR_ADDR_SHIFT  (0x00000000u)
#define CSL_AIF_VD_WR_BUSERR_ADDR_RESETVAL (0x00000000u)

#define CSL_AIF_VD_WR_BUSERR_RESETVAL    (0x00000000u)

/* DB_FORCE_SYSEVENT_CFG */


#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_SYS_EVENT_FORCE_CAPTBUF_MASK (0x00000080u)
#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_SYS_EVENT_FORCE_CAPTBUF_SHIFT (0x00000007u)
#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_SYS_EVENT_FORCE_CAPTBUF_RESETVAL (0x00000000u)

#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_SYS_EVENT_FORCE_INFIFO_MASK (0x0000007Fu)
#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_SYS_EVENT_FORCE_INFIFO_SHIFT (0x00000000u)
#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_SYS_EVENT_FORCE_INFIFO_RESETVAL (0x00000000u)

#define CSL_AIF_DB_FORCE_SYSEVENT_CFG_RESETVAL (0x00000000u)

/* DB_OUTB_TRK_AUTOSYNC_CFG */


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK5_OUTB_SYNC_VALUE_MASK (0x70000000u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK5_OUTB_SYNC_VALUE_SHIFT (0x0000001Cu)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK5_OUTB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK4_OUTB_SYNC_VALUE_MASK (0x07000000u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK4_OUTB_SYNC_VALUE_SHIFT (0x00000018u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK4_OUTB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK3_OUTB_SYNC_VALUE_MASK (0x00700000u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK3_OUTB_SYNC_VALUE_SHIFT (0x00000014u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK3_OUTB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK2_OUTB_SYNC_VALUE_MASK (0x00070000u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK2_OUTB_SYNC_VALUE_SHIFT (0x00000010u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK2_OUTB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK1_OUTB_SYNC_VALUE_MASK (0x00007000u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK1_OUTB_SYNC_VALUE_SHIFT (0x0000000Cu)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK1_OUTB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK0_OUTB_SYNC_VALUE_MASK (0x00000700u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK0_OUTB_SYNC_VALUE_SHIFT (0x00000008u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK0_OUTB_SYNC_VALUE_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK0_MASK (0x00000001u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK0_SHIFT (0x00000000u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK1_MASK (0x00000002u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK1_SHIFT (0x00000001u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK2_MASK (0x00000004u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK2_SHIFT (0x00000002u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK3_MASK (0x00000008u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK3_SHIFT (0x00000003u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK4_MASK (0x00000010u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK4_SHIFT (0x00000004u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK5_MASK (0x00000020u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK5_SHIFT (0x00000005u)
#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_TRK_OUTB_AUTO_SYNC_EN_LINK5_RESETVAL (0x00000000u)


#define CSL_AIF_DB_OUTB_TRK_AUTOSYNC_CFG_RESETVAL (0x00000000u)

/* DB_INB_TRK_AUTOSYNC_CFG */


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK5_INB_SYNC_VALUE_MASK (0x70000000u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK5_INB_SYNC_VALUE_SHIFT (0x0000001Cu)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK5_INB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK4_INB_SYNC_VALUE_MASK (0x07000000u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK4_INB_SYNC_VALUE_SHIFT (0x00000018u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK4_INB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK3_INB_SYNC_VALUE_MASK (0x00700000u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK3_INB_SYNC_VALUE_SHIFT (0x00000014u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK3_INB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK2_INB_SYNC_VALUE_MASK (0x00070000u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK2_INB_SYNC_VALUE_SHIFT (0x00000010u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK2_INB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK1_INB_SYNC_VALUE_MASK (0x00007000u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK1_INB_SYNC_VALUE_SHIFT (0x0000000Cu)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK1_INB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK0_INB_SYNC_VALUE_MASK (0x00000700u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK0_INB_SYNC_VALUE_SHIFT (0x00000008u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK0_INB_SYNC_VALUE_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK0_MASK (0x00000001u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK0_SHIFT (0x00000000u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK0_RESETVAL (0x00000000u)

#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK1_MASK (0x00000002u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK1_SHIFT (0x00000001u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK1_RESETVAL (0x00000000u)

#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK2_MASK (0x00000004u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK2_SHIFT (0x00000002u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK2_RESETVAL (0x00000000u)

#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK3_MASK (0x00000008u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK3_SHIFT (0x00000003u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK3_RESETVAL (0x00000000u)

#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK4_MASK (0x00000010u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK4_SHIFT (0x00000004u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK4_RESETVAL (0x00000000u)

#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK5_MASK (0x00000020u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK5_SHIFT (0x00000005u)
#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_TRK_INB_AUTO_SYNC_EN_LINK5_RESETVAL (0x00000000u)


#define CSL_AIF_DB_INB_TRK_AUTOSYNC_CFG_RESETVAL (0x00000000u)


#endif
