/* =============================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found in the
 *  license agreement under which this software has been supplied.
 *  ============================================================================
 */

/** ============================================================================
 *  @file  cslr_cic.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *  @desc  This file contains the Register Descriptions for CIC
 *  ===========================================================================
 */
#ifndef _CSLR_CIC_H_
#define _CSLR_CIC_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 EXEVTFLAG[2];
    volatile Uint8 RSVD0[8];
    volatile Uint32 EXEVTSET[2];
    volatile Uint8 RSVD1[8];
    volatile Uint32 EXEVTCLR[2];
    volatile Uint8 RSVD2[8];
    volatile Uint32 EXEVTMASK[2];
    volatile Uint8 RSVD3[8];
    volatile Uint32 MEXEVTFLAG[2];
    volatile Uint8 RSVD4[8];
    volatile Uint32 EXEVTMUX0;
    volatile Uint32 EXEVTMUX1;
    volatile Uint32 EXEVTMUX2;
    volatile Uint32 EXEVTMUX3;
} CSL_CicRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_CicRegs *CSL_CicRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* EXEVTFLAG */

#define CSL_CIC_EXEVTFLAG_EF31_MASK      (0x80000000u)
#define CSL_CIC_EXEVTFLAG_EF31_SHIFT     (0x0000001Fu)
#define CSL_CIC_EXEVTFLAG_EF31_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF30_MASK      (0x40000000u)
#define CSL_CIC_EXEVTFLAG_EF30_SHIFT     (0x0000001Eu)
#define CSL_CIC_EXEVTFLAG_EF30_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF29_MASK      (0x20000000u)
#define CSL_CIC_EXEVTFLAG_EF29_SHIFT     (0x0000001Du)
#define CSL_CIC_EXEVTFLAG_EF29_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF28_MASK      (0x10000000u)
#define CSL_CIC_EXEVTFLAG_EF28_SHIFT     (0x0000001Cu)
#define CSL_CIC_EXEVTFLAG_EF28_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF27_MASK      (0x08000000u)
#define CSL_CIC_EXEVTFLAG_EF27_SHIFT     (0x0000001Bu)
#define CSL_CIC_EXEVTFLAG_EF27_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF26_MASK      (0x04000000u)
#define CSL_CIC_EXEVTFLAG_EF26_SHIFT     (0x0000001Au)
#define CSL_CIC_EXEVTFLAG_EF26_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF25_MASK      (0x02000000u)
#define CSL_CIC_EXEVTFLAG_EF25_SHIFT     (0x00000019u)
#define CSL_CIC_EXEVTFLAG_EF25_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF24_MASK      (0x01000000u)
#define CSL_CIC_EXEVTFLAG_EF24_SHIFT     (0x00000018u)
#define CSL_CIC_EXEVTFLAG_EF24_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF23_MASK      (0x00800000u)
#define CSL_CIC_EXEVTFLAG_EF23_SHIFT     (0x00000017u)
#define CSL_CIC_EXEVTFLAG_EF23_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF22_MASK      (0x00400000u)
#define CSL_CIC_EXEVTFLAG_EF22_SHIFT     (0x00000016u)
#define CSL_CIC_EXEVTFLAG_EF22_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF21_MASK      (0x00200000u)
#define CSL_CIC_EXEVTFLAG_EF21_SHIFT     (0x00000015u)
#define CSL_CIC_EXEVTFLAG_EF21_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF20_MASK      (0x00100000u)
#define CSL_CIC_EXEVTFLAG_EF20_SHIFT     (0x00000014u)
#define CSL_CIC_EXEVTFLAG_EF20_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF19_MASK      (0x00080000u)
#define CSL_CIC_EXEVTFLAG_EF19_SHIFT     (0x00000013u)
#define CSL_CIC_EXEVTFLAG_EF19_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF18_MASK      (0x00040000u)
#define CSL_CIC_EXEVTFLAG_EF18_SHIFT     (0x00000012u)
#define CSL_CIC_EXEVTFLAG_EF18_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF17_MASK      (0x00020000u)
#define CSL_CIC_EXEVTFLAG_EF17_SHIFT     (0x00000011u)
#define CSL_CIC_EXEVTFLAG_EF17_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF16_MASK      (0x00010000u)
#define CSL_CIC_EXEVTFLAG_EF16_SHIFT     (0x00000010u)
#define CSL_CIC_EXEVTFLAG_EF16_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF15_MASK      (0x00008000u)
#define CSL_CIC_EXEVTFLAG_EF15_SHIFT     (0x0000000Fu)
#define CSL_CIC_EXEVTFLAG_EF15_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF14_MASK      (0x00004000u)
#define CSL_CIC_EXEVTFLAG_EF14_SHIFT     (0x0000000Eu)
#define CSL_CIC_EXEVTFLAG_EF14_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF13_MASK      (0x00002000u)
#define CSL_CIC_EXEVTFLAG_EF13_SHIFT     (0x0000000Du)
#define CSL_CIC_EXEVTFLAG_EF13_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF12_MASK      (0x00001000u)
#define CSL_CIC_EXEVTFLAG_EF12_SHIFT     (0x0000000Cu)
#define CSL_CIC_EXEVTFLAG_EF12_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF11_MASK      (0x00000800u)
#define CSL_CIC_EXEVTFLAG_EF11_SHIFT     (0x0000000Bu)
#define CSL_CIC_EXEVTFLAG_EF11_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF10_MASK      (0x00000400u)
#define CSL_CIC_EXEVTFLAG_EF10_SHIFT     (0x0000000Au)
#define CSL_CIC_EXEVTFLAG_EF10_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF9_MASK       (0x00000200u)
#define CSL_CIC_EXEVTFLAG_EF9_SHIFT      (0x00000009u)
#define CSL_CIC_EXEVTFLAG_EF9_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF8_MASK       (0x00000100u)
#define CSL_CIC_EXEVTFLAG_EF8_SHIFT      (0x00000008u)
#define CSL_CIC_EXEVTFLAG_EF8_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF7_MASK       (0x00000080u)
#define CSL_CIC_EXEVTFLAG_EF7_SHIFT      (0x00000007u)
#define CSL_CIC_EXEVTFLAG_EF7_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF6_MASK       (0x00000040u)
#define CSL_CIC_EXEVTFLAG_EF6_SHIFT      (0x00000006u)
#define CSL_CIC_EXEVTFLAG_EF6_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF5_MASK       (0x00000020u)
#define CSL_CIC_EXEVTFLAG_EF5_SHIFT      (0x00000005u)
#define CSL_CIC_EXEVTFLAG_EF5_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF4_MASK       (0x00000010u)
#define CSL_CIC_EXEVTFLAG_EF4_SHIFT      (0x00000004u)
#define CSL_CIC_EXEVTFLAG_EF4_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF3_MASK       (0x00000008u)
#define CSL_CIC_EXEVTFLAG_EF3_SHIFT      (0x00000003u)
#define CSL_CIC_EXEVTFLAG_EF3_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF2_MASK       (0x00000004u)
#define CSL_CIC_EXEVTFLAG_EF2_SHIFT      (0x00000002u)
#define CSL_CIC_EXEVTFLAG_EF2_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF1_MASK       (0x00000002u)
#define CSL_CIC_EXEVTFLAG_EF1_SHIFT      (0x00000001u)
#define CSL_CIC_EXEVTFLAG_EF1_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_EF0_MASK       (0x00000001u)
#define CSL_CIC_EXEVTFLAG_EF0_SHIFT      (0x00000000u)
#define CSL_CIC_EXEVTFLAG_EF0_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTFLAG_RESETVAL       (0x00000000u)

/* EXEVTSET */

#define CSL_CIC_EXEVTSET_ES31_MASK       (0x80000000u)
#define CSL_CIC_EXEVTSET_ES31_SHIFT      (0x0000001Fu)
#define CSL_CIC_EXEVTSET_ES31_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES30_MASK       (0x40000000u)
#define CSL_CIC_EXEVTSET_ES30_SHIFT      (0x0000001Eu)
#define CSL_CIC_EXEVTSET_ES30_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES29_MASK       (0x20000000u)
#define CSL_CIC_EXEVTSET_ES29_SHIFT      (0x0000001Du)
#define CSL_CIC_EXEVTSET_ES29_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES28_MASK       (0x10000000u)
#define CSL_CIC_EXEVTSET_ES28_SHIFT      (0x0000001Cu)
#define CSL_CIC_EXEVTSET_ES28_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES27_MASK       (0x08000000u)
#define CSL_CIC_EXEVTSET_ES27_SHIFT      (0x0000001Bu)
#define CSL_CIC_EXEVTSET_ES27_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES26_MASK       (0x04000000u)
#define CSL_CIC_EXEVTSET_ES26_SHIFT      (0x0000001Au)
#define CSL_CIC_EXEVTSET_ES26_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES25_MASK       (0x02000000u)
#define CSL_CIC_EXEVTSET_ES25_SHIFT      (0x00000019u)
#define CSL_CIC_EXEVTSET_ES25_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES24_MASK       (0x01000000u)
#define CSL_CIC_EXEVTSET_ES24_SHIFT      (0x00000018u)
#define CSL_CIC_EXEVTSET_ES24_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES23_MASK       (0x00800000u)
#define CSL_CIC_EXEVTSET_ES23_SHIFT      (0x00000017u)
#define CSL_CIC_EXEVTSET_ES23_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES22_MASK       (0x00400000u)
#define CSL_CIC_EXEVTSET_ES22_SHIFT      (0x00000016u)
#define CSL_CIC_EXEVTSET_ES22_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES21_MASK       (0x00200000u)
#define CSL_CIC_EXEVTSET_ES21_SHIFT      (0x00000015u)
#define CSL_CIC_EXEVTSET_ES21_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES20_MASK       (0x00100000u)
#define CSL_CIC_EXEVTSET_ES20_SHIFT      (0x00000014u)
#define CSL_CIC_EXEVTSET_ES20_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES19_MASK       (0x00080000u)
#define CSL_CIC_EXEVTSET_ES19_SHIFT      (0x00000013u)
#define CSL_CIC_EXEVTSET_ES19_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES18_MASK       (0x00040000u)
#define CSL_CIC_EXEVTSET_ES18_SHIFT      (0x00000012u)
#define CSL_CIC_EXEVTSET_ES18_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES17_MASK       (0x00020000u)
#define CSL_CIC_EXEVTSET_ES17_SHIFT      (0x00000011u)
#define CSL_CIC_EXEVTSET_ES17_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES16_MASK       (0x00010000u)
#define CSL_CIC_EXEVTSET_ES16_SHIFT      (0x00000010u)
#define CSL_CIC_EXEVTSET_ES16_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES15_MASK       (0x00008000u)
#define CSL_CIC_EXEVTSET_ES15_SHIFT      (0x0000000Fu)
#define CSL_CIC_EXEVTSET_ES15_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES14_MASK       (0x00004000u)
#define CSL_CIC_EXEVTSET_ES14_SHIFT      (0x0000000Eu)
#define CSL_CIC_EXEVTSET_ES14_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES13_MASK       (0x00002000u)
#define CSL_CIC_EXEVTSET_ES13_SHIFT      (0x0000000Du)
#define CSL_CIC_EXEVTSET_ES13_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES12_MASK       (0x00001000u)
#define CSL_CIC_EXEVTSET_ES12_SHIFT      (0x0000000Cu)
#define CSL_CIC_EXEVTSET_ES12_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES11_MASK       (0x00000800u)
#define CSL_CIC_EXEVTSET_ES11_SHIFT      (0x0000000Bu)
#define CSL_CIC_EXEVTSET_ES11_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES10_MASK       (0x00000400u)
#define CSL_CIC_EXEVTSET_ES10_SHIFT      (0x0000000Au)
#define CSL_CIC_EXEVTSET_ES10_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTSET_ES9_MASK        (0x00000200u)
#define CSL_CIC_EXEVTSET_ES9_SHIFT       (0x00000009u)
#define CSL_CIC_EXEVTSET_ES9_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES8_MASK        (0x00000100u)
#define CSL_CIC_EXEVTSET_ES8_SHIFT       (0x00000008u)
#define CSL_CIC_EXEVTSET_ES8_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES7_MASK        (0x00000080u)
#define CSL_CIC_EXEVTSET_ES7_SHIFT       (0x00000007u)
#define CSL_CIC_EXEVTSET_ES7_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES6_MASK        (0x00000040u)
#define CSL_CIC_EXEVTSET_ES6_SHIFT       (0x00000006u)
#define CSL_CIC_EXEVTSET_ES6_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES5_MASK        (0x00000020u)
#define CSL_CIC_EXEVTSET_ES5_SHIFT       (0x00000005u)
#define CSL_CIC_EXEVTSET_ES5_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES4_MASK        (0x00000010u)
#define CSL_CIC_EXEVTSET_ES4_SHIFT       (0x00000004u)
#define CSL_CIC_EXEVTSET_ES4_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES3_MASK        (0x00000008u)
#define CSL_CIC_EXEVTSET_ES3_SHIFT       (0x00000003u)
#define CSL_CIC_EXEVTSET_ES3_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES2_MASK        (0x00000004u)
#define CSL_CIC_EXEVTSET_ES2_SHIFT       (0x00000002u)
#define CSL_CIC_EXEVTSET_ES2_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES1_MASK        (0x00000002u)
#define CSL_CIC_EXEVTSET_ES1_SHIFT       (0x00000001u)
#define CSL_CIC_EXEVTSET_ES1_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_ES0_MASK        (0x00000001u)
#define CSL_CIC_EXEVTSET_ES0_SHIFT       (0x00000000u)
#define CSL_CIC_EXEVTSET_ES0_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTSET_RESETVAL        (0x00000000u)

/* EXEVTCLR */

#define CSL_CIC_EXEVTCLR_EC31_MASK       (0x80000000u)
#define CSL_CIC_EXEVTCLR_EC31_SHIFT      (0x0000001Fu)
#define CSL_CIC_EXEVTCLR_EC31_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC30_MASK       (0x40000000u)
#define CSL_CIC_EXEVTCLR_EC30_SHIFT      (0x0000001Eu)
#define CSL_CIC_EXEVTCLR_EC30_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC29_MASK       (0x20000000u)
#define CSL_CIC_EXEVTCLR_EC29_SHIFT      (0x0000001Du)
#define CSL_CIC_EXEVTCLR_EC29_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC28_MASK       (0x10000000u)
#define CSL_CIC_EXEVTCLR_EC28_SHIFT      (0x0000001Cu)
#define CSL_CIC_EXEVTCLR_EC28_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC27_MASK       (0x08000000u)
#define CSL_CIC_EXEVTCLR_EC27_SHIFT      (0x0000001Bu)
#define CSL_CIC_EXEVTCLR_EC27_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC26_MASK       (0x04000000u)
#define CSL_CIC_EXEVTCLR_EC26_SHIFT      (0x0000001Au)
#define CSL_CIC_EXEVTCLR_EC26_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC25_MASK       (0x02000000u)
#define CSL_CIC_EXEVTCLR_EC25_SHIFT      (0x00000019u)
#define CSL_CIC_EXEVTCLR_EC25_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC24_MASK       (0x01000000u)
#define CSL_CIC_EXEVTCLR_EC24_SHIFT      (0x00000018u)
#define CSL_CIC_EXEVTCLR_EC24_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC23_MASK       (0x00800000u)
#define CSL_CIC_EXEVTCLR_EC23_SHIFT      (0x00000017u)
#define CSL_CIC_EXEVTCLR_EC23_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC22_MASK       (0x00400000u)
#define CSL_CIC_EXEVTCLR_EC22_SHIFT      (0x00000016u)
#define CSL_CIC_EXEVTCLR_EC22_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC21_MASK       (0x00200000u)
#define CSL_CIC_EXEVTCLR_EC21_SHIFT      (0x00000015u)
#define CSL_CIC_EXEVTCLR_EC21_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC20_MASK       (0x00100000u)
#define CSL_CIC_EXEVTCLR_EC20_SHIFT      (0x00000014u)
#define CSL_CIC_EXEVTCLR_EC20_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC19_MASK       (0x00080000u)
#define CSL_CIC_EXEVTCLR_EC19_SHIFT      (0x00000013u)
#define CSL_CIC_EXEVTCLR_EC19_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC18_MASK       (0x00040000u)
#define CSL_CIC_EXEVTCLR_EC18_SHIFT      (0x00000012u)
#define CSL_CIC_EXEVTCLR_EC18_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC17_MASK       (0x00020000u)
#define CSL_CIC_EXEVTCLR_EC17_SHIFT      (0x00000011u)
#define CSL_CIC_EXEVTCLR_EC17_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC16_MASK       (0x00010000u)
#define CSL_CIC_EXEVTCLR_EC16_SHIFT      (0x00000010u)
#define CSL_CIC_EXEVTCLR_EC16_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC15_MASK       (0x00008000u)
#define CSL_CIC_EXEVTCLR_EC15_SHIFT      (0x0000000Fu)
#define CSL_CIC_EXEVTCLR_EC15_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC14_MASK       (0x00004000u)
#define CSL_CIC_EXEVTCLR_EC14_SHIFT      (0x0000000Eu)
#define CSL_CIC_EXEVTCLR_EC14_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC13_MASK       (0x00002000u)
#define CSL_CIC_EXEVTCLR_EC13_SHIFT      (0x0000000Du)
#define CSL_CIC_EXEVTCLR_EC13_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC12_MASK       (0x00001000u)
#define CSL_CIC_EXEVTCLR_EC12_SHIFT      (0x0000000Cu)
#define CSL_CIC_EXEVTCLR_EC12_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC11_MASK       (0x00000800u)
#define CSL_CIC_EXEVTCLR_EC11_SHIFT      (0x0000000Bu)
#define CSL_CIC_EXEVTCLR_EC11_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC10_MASK       (0x00000400u)
#define CSL_CIC_EXEVTCLR_EC10_SHIFT      (0x0000000Au)
#define CSL_CIC_EXEVTCLR_EC10_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC9_MASK        (0x00000200u)
#define CSL_CIC_EXEVTCLR_EC9_SHIFT       (0x00000009u)
#define CSL_CIC_EXEVTCLR_EC9_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC8_MASK        (0x00000100u)
#define CSL_CIC_EXEVTCLR_EC8_SHIFT       (0x00000008u)
#define CSL_CIC_EXEVTCLR_EC8_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC7_MASK        (0x00000080u)
#define CSL_CIC_EXEVTCLR_EC7_SHIFT       (0x00000007u)
#define CSL_CIC_EXEVTCLR_EC7_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC6_MASK        (0x00000040u)
#define CSL_CIC_EXEVTCLR_EC6_SHIFT       (0x00000006u)
#define CSL_CIC_EXEVTCLR_EC6_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC5_MASK        (0x00000020u)
#define CSL_CIC_EXEVTCLR_EC5_SHIFT       (0x00000005u)
#define CSL_CIC_EXEVTCLR_EC5_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC4_MASK        (0x00000010u)
#define CSL_CIC_EXEVTCLR_EC4_SHIFT       (0x00000004u)
#define CSL_CIC_EXEVTCLR_EC4_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC3_MASK        (0x00000008u)
#define CSL_CIC_EXEVTCLR_EC3_SHIFT       (0x00000003u)
#define CSL_CIC_EXEVTCLR_EC3_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC2_MASK        (0x00000004u)
#define CSL_CIC_EXEVTCLR_EC2_SHIFT       (0x00000002u)
#define CSL_CIC_EXEVTCLR_EC2_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC1_MASK        (0x00000002u)
#define CSL_CIC_EXEVTCLR_EC1_SHIFT       (0x00000001u)
#define CSL_CIC_EXEVTCLR_EC1_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_EC0_MASK        (0x00000001u)
#define CSL_CIC_EXEVTCLR_EC0_SHIFT       (0x00000000u)
#define CSL_CIC_EXEVTCLR_EC0_RESETVAL    (0x00000000u)

#define CSL_CIC_EXEVTCLR_RESETVAL        (0x00000000u)

/* EXEVTMASK */

#define CSL_CIC_EXEVTMASK_EM31_MASK      (0x80000000u)
#define CSL_CIC_EXEVTMASK_EM31_SHIFT     (0x0000001Fu)
#define CSL_CIC_EXEVTMASK_EM31_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM30_MASK      (0x40000000u)
#define CSL_CIC_EXEVTMASK_EM30_SHIFT     (0x0000001Eu)
#define CSL_CIC_EXEVTMASK_EM30_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM29_MASK      (0x20000000u)
#define CSL_CIC_EXEVTMASK_EM29_SHIFT     (0x0000001Du)
#define CSL_CIC_EXEVTMASK_EM29_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM28_MASK      (0x10000000u)
#define CSL_CIC_EXEVTMASK_EM28_SHIFT     (0x0000001Cu)
#define CSL_CIC_EXEVTMASK_EM28_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM27_MASK      (0x08000000u)
#define CSL_CIC_EXEVTMASK_EM27_SHIFT     (0x0000001Bu)
#define CSL_CIC_EXEVTMASK_EM27_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM26_MASK      (0x04000000u)
#define CSL_CIC_EXEVTMASK_EM26_SHIFT     (0x0000001Au)
#define CSL_CIC_EXEVTMASK_EM26_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM25_MASK      (0x02000000u)
#define CSL_CIC_EXEVTMASK_EM25_SHIFT     (0x00000019u)
#define CSL_CIC_EXEVTMASK_EM25_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM24_MASK      (0x01000000u)
#define CSL_CIC_EXEVTMASK_EM24_SHIFT     (0x00000018u)
#define CSL_CIC_EXEVTMASK_EM24_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM23_MASK      (0x00800000u)
#define CSL_CIC_EXEVTMASK_EM23_SHIFT     (0x00000017u)
#define CSL_CIC_EXEVTMASK_EM23_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM22_MASK      (0x00400000u)
#define CSL_CIC_EXEVTMASK_EM22_SHIFT     (0x00000016u)
#define CSL_CIC_EXEVTMASK_EM22_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM21_MASK      (0x00200000u)
#define CSL_CIC_EXEVTMASK_EM21_SHIFT     (0x00000015u)
#define CSL_CIC_EXEVTMASK_EM21_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM20_MASK      (0x00100000u)
#define CSL_CIC_EXEVTMASK_EM20_SHIFT     (0x00000014u)
#define CSL_CIC_EXEVTMASK_EM20_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM19_MASK      (0x00080000u)
#define CSL_CIC_EXEVTMASK_EM19_SHIFT     (0x00000013u)
#define CSL_CIC_EXEVTMASK_EM19_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM18_MASK      (0x00040000u)
#define CSL_CIC_EXEVTMASK_EM18_SHIFT     (0x00000012u)
#define CSL_CIC_EXEVTMASK_EM18_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM17_MASK      (0x00020000u)
#define CSL_CIC_EXEVTMASK_EM17_SHIFT     (0x00000011u)
#define CSL_CIC_EXEVTMASK_EM17_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM16_MASK      (0x00010000u)
#define CSL_CIC_EXEVTMASK_EM16_SHIFT     (0x00000010u)
#define CSL_CIC_EXEVTMASK_EM16_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM15_MASK      (0x00008000u)
#define CSL_CIC_EXEVTMASK_EM15_SHIFT     (0x0000000Fu)
#define CSL_CIC_EXEVTMASK_EM15_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM14_MASK      (0x00004000u)
#define CSL_CIC_EXEVTMASK_EM14_SHIFT     (0x0000000Eu)
#define CSL_CIC_EXEVTMASK_EM14_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM13_MASK      (0x00002000u)
#define CSL_CIC_EXEVTMASK_EM13_SHIFT     (0x0000000Du)
#define CSL_CIC_EXEVTMASK_EM13_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM12_MASK      (0x00001000u)
#define CSL_CIC_EXEVTMASK_EM12_SHIFT     (0x0000000Cu)
#define CSL_CIC_EXEVTMASK_EM12_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM11_MASK      (0x00000800u)
#define CSL_CIC_EXEVTMASK_EM11_SHIFT     (0x0000000Bu)
#define CSL_CIC_EXEVTMASK_EM11_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM10_MASK      (0x00000400u)
#define CSL_CIC_EXEVTMASK_EM10_SHIFT     (0x0000000Au)
#define CSL_CIC_EXEVTMASK_EM10_RESETVAL  (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM9_MASK       (0x00000200u)
#define CSL_CIC_EXEVTMASK_EM9_SHIFT      (0x00000009u)
#define CSL_CIC_EXEVTMASK_EM9_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM8_MASK       (0x00000100u)
#define CSL_CIC_EXEVTMASK_EM8_SHIFT      (0x00000008u)
#define CSL_CIC_EXEVTMASK_EM8_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM7_MASK       (0x00000080u)
#define CSL_CIC_EXEVTMASK_EM7_SHIFT      (0x00000007u)
#define CSL_CIC_EXEVTMASK_EM7_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM6_MASK       (0x00000040u)
#define CSL_CIC_EXEVTMASK_EM6_SHIFT      (0x00000006u)
#define CSL_CIC_EXEVTMASK_EM6_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM5_MASK       (0x00000020u)
#define CSL_CIC_EXEVTMASK_EM5_SHIFT      (0x00000005u)
#define CSL_CIC_EXEVTMASK_EM5_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM4_MASK       (0x00000010u)
#define CSL_CIC_EXEVTMASK_EM4_SHIFT      (0x00000004u)
#define CSL_CIC_EXEVTMASK_EM4_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM3_MASK       (0x00000008u)
#define CSL_CIC_EXEVTMASK_EM3_SHIFT      (0x00000003u)
#define CSL_CIC_EXEVTMASK_EM3_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM2_MASK       (0x00000004u)
#define CSL_CIC_EXEVTMASK_EM2_SHIFT      (0x00000002u)
#define CSL_CIC_EXEVTMASK_EM2_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM1_MASK       (0x00000002u)
#define CSL_CIC_EXEVTMASK_EM1_SHIFT      (0x00000001u)
#define CSL_CIC_EXEVTMASK_EM1_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_EM0_MASK       (0x00000001u)
#define CSL_CIC_EXEVTMASK_EM0_SHIFT      (0x00000000u)
#define CSL_CIC_EXEVTMASK_EM0_RESETVAL   (0x00000000u)

#define CSL_CIC_EXEVTMASK_RESETVAL       (0x00000000u)

/* MEXEVTFLAG */

#define CSL_CIC_MEXEVTFLAG_MEVT31_MASK   (0x80000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT31_SHIFT  (0x0000001Fu)
#define CSL_CIC_MEXEVTFLAG_MEVT31_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT30_MASK   (0x40000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT30_SHIFT  (0x0000001Eu)
#define CSL_CIC_MEXEVTFLAG_MEVT30_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT29_MASK   (0x20000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT29_SHIFT  (0x0000001Du)
#define CSL_CIC_MEXEVTFLAG_MEVT29_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT28_MASK   (0x10000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT28_SHIFT  (0x0000001Cu)
#define CSL_CIC_MEXEVTFLAG_MEVT28_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT27_MASK   (0x08000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT27_SHIFT  (0x0000001Bu)
#define CSL_CIC_MEXEVTFLAG_MEVT27_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT26_MASK   (0x04000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT26_SHIFT  (0x0000001Au)
#define CSL_CIC_MEXEVTFLAG_MEVT26_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT25_MASK   (0x02000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT25_SHIFT  (0x00000019u)
#define CSL_CIC_MEXEVTFLAG_MEVT25_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT24_MASK   (0x01000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT24_SHIFT  (0x00000018u)
#define CSL_CIC_MEXEVTFLAG_MEVT24_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT23_MASK   (0x00800000u)
#define CSL_CIC_MEXEVTFLAG_MEVT23_SHIFT  (0x00000017u)
#define CSL_CIC_MEXEVTFLAG_MEVT23_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT22_MASK   (0x00400000u)
#define CSL_CIC_MEXEVTFLAG_MEVT22_SHIFT  (0x00000016u)
#define CSL_CIC_MEXEVTFLAG_MEVT22_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT21_MASK   (0x00200000u)
#define CSL_CIC_MEXEVTFLAG_MEVT21_SHIFT  (0x00000015u)
#define CSL_CIC_MEXEVTFLAG_MEVT21_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT20_MASK   (0x00100000u)
#define CSL_CIC_MEXEVTFLAG_MEVT20_SHIFT  (0x00000014u)
#define CSL_CIC_MEXEVTFLAG_MEVT20_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT19_MASK   (0x00080000u)
#define CSL_CIC_MEXEVTFLAG_MEVT19_SHIFT  (0x00000013u)
#define CSL_CIC_MEXEVTFLAG_MEVT19_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT18_MASK   (0x00040000u)
#define CSL_CIC_MEXEVTFLAG_MEVT18_SHIFT  (0x00000012u)
#define CSL_CIC_MEXEVTFLAG_MEVT18_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT17_MASK   (0x00020000u)
#define CSL_CIC_MEXEVTFLAG_MEVT17_SHIFT  (0x00000011u)
#define CSL_CIC_MEXEVTFLAG_MEVT17_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT16_MASK   (0x00010000u)
#define CSL_CIC_MEXEVTFLAG_MEVT16_SHIFT  (0x00000010u)
#define CSL_CIC_MEXEVTFLAG_MEVT16_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT15_MASK   (0x00008000u)
#define CSL_CIC_MEXEVTFLAG_MEVT15_SHIFT  (0x0000000Fu)
#define CSL_CIC_MEXEVTFLAG_MEVT15_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT14_MASK   (0x00004000u)
#define CSL_CIC_MEXEVTFLAG_MEVT14_SHIFT  (0x0000000Eu)
#define CSL_CIC_MEXEVTFLAG_MEVT14_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT13_MASK   (0x00002000u)
#define CSL_CIC_MEXEVTFLAG_MEVT13_SHIFT  (0x0000000Du)
#define CSL_CIC_MEXEVTFLAG_MEVT13_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT12_MASK   (0x00001000u)
#define CSL_CIC_MEXEVTFLAG_MEVT12_SHIFT  (0x0000000Cu)
#define CSL_CIC_MEXEVTFLAG_MEVT12_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT11_MASK   (0x00000800u)
#define CSL_CIC_MEXEVTFLAG_MEVT11_SHIFT  (0x0000000Bu)
#define CSL_CIC_MEXEVTFLAG_MEVT11_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT10_MASK   (0x00000400u)
#define CSL_CIC_MEXEVTFLAG_MEVT10_SHIFT  (0x0000000Au)
#define CSL_CIC_MEXEVTFLAG_MEVT10_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT9_MASK    (0x00000200u)
#define CSL_CIC_MEXEVTFLAG_MEVT9_SHIFT   (0x00000009u)
#define CSL_CIC_MEXEVTFLAG_MEVT9_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT8_MASK    (0x00000100u)
#define CSL_CIC_MEXEVTFLAG_MEVT8_SHIFT   (0x00000008u)
#define CSL_CIC_MEXEVTFLAG_MEVT8_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT7_MASK    (0x00000080u)
#define CSL_CIC_MEXEVTFLAG_MEVT7_SHIFT   (0x00000007u)
#define CSL_CIC_MEXEVTFLAG_MEVT7_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT6_MASK    (0x00000040u)
#define CSL_CIC_MEXEVTFLAG_MEVT6_SHIFT   (0x00000006u)
#define CSL_CIC_MEXEVTFLAG_MEVT6_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT5_MASK    (0x00000020u)
#define CSL_CIC_MEXEVTFLAG_MEVT5_SHIFT   (0x00000005u)
#define CSL_CIC_MEXEVTFLAG_MEVT5_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT4_MASK    (0x00000010u)
#define CSL_CIC_MEXEVTFLAG_MEVT4_SHIFT   (0x00000004u)
#define CSL_CIC_MEXEVTFLAG_MEVT4_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT3_MASK    (0x00000008u)
#define CSL_CIC_MEXEVTFLAG_MEVT3_SHIFT   (0x00000003u)
#define CSL_CIC_MEXEVTFLAG_MEVT3_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT2_MASK    (0x00000004u)
#define CSL_CIC_MEXEVTFLAG_MEVT2_SHIFT   (0x00000002u)
#define CSL_CIC_MEXEVTFLAG_MEVT2_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT1_MASK    (0x00000002u)
#define CSL_CIC_MEXEVTFLAG_MEVT1_SHIFT   (0x00000001u)
#define CSL_CIC_MEXEVTFLAG_MEVT1_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_MEVT0_MASK    (0x00000001u)
#define CSL_CIC_MEXEVTFLAG_MEVT0_SHIFT   (0x00000000u)
#define CSL_CIC_MEXEVTFLAG_MEVT0_RESETVAL (0x00000000u)

#define CSL_CIC_MEXEVTFLAG_RESETVAL      (0x00000000u)

/* EXEVTMUX0 */

#define CSL_CIC_EXEVTMUX0_OUTEVTSEL3_MASK (0x3F000000u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL3_SHIFT (0x00000018u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL3_RESETVAL (0x00000003u)

#define CSL_CIC_EXEVTMUX0_OUTEVTSEL2_MASK (0x003F0000u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL2_SHIFT (0x00000010u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL2_RESETVAL (0x00000002u)

#define CSL_CIC_EXEVTMUX0_OUTEVTSEL1_MASK (0x00003F00u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL1_SHIFT (0x00000008u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL1_RESETVAL (0x00000001u)

#define CSL_CIC_EXEVTMUX0_OUTEVTSEL0_MASK (0x0000003Fu)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL0_SHIFT (0x00000000u)
#define CSL_CIC_EXEVTMUX0_OUTEVTSEL0_RESETVAL (0x00000000u)

#define CSL_CIC_EXEVTMUX0_RESETVAL       (0x03020100u)

/* EXEVTMUX1 */

#define CSL_CIC_EXEVTMUX1_OUTEVTSEL7_MASK (0x3F000000u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL7_SHIFT (0x00000018u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL7_RESETVAL (0x00000003u)

#define CSL_CIC_EXEVTMUX1_OUTEVTSEL6_MASK (0x003F0000u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL6_SHIFT (0x00000010u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL6_RESETVAL (0x00000002u)

#define CSL_CIC_EXEVTMUX1_OUTEVTSEL5_MASK (0x00003F00u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL5_SHIFT (0x00000008u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL5_RESETVAL (0x00000001u)

#define CSL_CIC_EXEVTMUX1_OUTEVTSEL4_MASK (0x0000003Fu)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL4_SHIFT (0x00000000u)
#define CSL_CIC_EXEVTMUX1_OUTEVTSEL4_RESETVAL (0x00000000u)

#define CSL_CIC_EXEVTMUX1_RESETVAL       (0x03020100u)

/* EXEVTMUX2 */

#define CSL_CIC_EXEVTMUX2_OUTEVTSEL11_MASK (0x3F000000u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL11_SHIFT (0x00000018u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL11_RESETVAL (0x00000003u)

#define CSL_CIC_EXEVTMUX2_OUTEVTSEL10_MASK (0x003F0000u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL10_SHIFT (0x00000010u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL10_RESETVAL (0x00000002u)

#define CSL_CIC_EXEVTMUX2_OUTEVTSEL9_MASK (0x00003F00u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL9_SHIFT (0x00000008u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL9_RESETVAL (0x00000001u)

#define CSL_CIC_EXEVTMUX2_OUTEVTSEL8_MASK (0x0000003Fu)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL8_SHIFT (0x00000000u)
#define CSL_CIC_EXEVTMUX2_OUTEVTSEL8_RESETVAL (0x00000000u)

#define CSL_CIC_EXEVTMUX2_RESETVAL       (0x03020100u)

/* EXEVTMUX3 */

#define CSL_CIC_EXEVTMUX3_OUTEVTSEL15_MASK (0x3F000000u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL15_SHIFT (0x00000018u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL15_RESETVAL (0x00000003u)

#define CSL_CIC_EXEVTMUX3_OUTEVTSEL14_MASK (0x003F0000u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL14_SHIFT (0x00000010u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL14_RESETVAL (0x00000002u)

#define CSL_CIC_EXEVTMUX3_OUTEVTSEL13_MASK (0x00003F00u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL13_SHIFT (0x00000008u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL13_RESETVAL (0x00000001u)

#define CSL_CIC_EXEVTMUX3_OUTEVTSEL12_MASK (0x0000003Fu)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL12_SHIFT (0x00000000u)
#define CSL_CIC_EXEVTMUX3_OUTEVTSEL12_RESETVAL (0x00000000u)

#define CSL_CIC_EXEVTMUX3_RESETVAL       (0x03020100u)

#endif
