/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_pllc.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for PLLC
 *
 */

#ifndef _CSLR_PLLC_H_
#define _CSLR_PLLC_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint8 RSVD0[220];
    volatile Uint32 FUSERR;
    volatile Uint32 RSTYPE;
    volatile Uint32 RSTDEF;
    volatile Uint8 RSVD1[20];
    volatile Uint32 PLLCTL;
    volatile Uint32 OCSEL;
    volatile Uint32 SECCTL;
    volatile Uint8 RSVD2[4];
    volatile Uint32 PLLM;
    volatile Uint32 PREDIV;
    volatile Uint32 PLLDIV1;
    volatile Uint32 PLLDIV2;
    volatile Uint32 PLLDIV3;
    volatile Uint32 OSCDIV1;
    volatile Uint32 POSTDIV;
    volatile Uint32 BPDIV;
    volatile Uint32 WAKEUP;
    volatile Uint8 RSVD3[4];
    volatile Uint32 PLLCMD;
    volatile Uint32 PLLSTAT;
    volatile Uint32 ALNCTL;
    volatile Uint32 DCHANGE;
    volatile Uint32 CKEN;
    volatile Uint32 CKSTAT;
    volatile Uint32 SYSTAT;
    volatile Uint8 RSVD4[12];
    volatile Uint32 PLLDIV4;
    volatile Uint32 PLLDIV5;
    volatile Uint32 PLLDIV6;
    volatile Uint32 PLLDIV7;
    volatile Uint32 PLLDIV8;
    volatile Uint32 PLLDIV9;
    volatile Uint32 PLLDIV10;
    volatile Uint32 PLLDIV11;
    volatile Uint32 PLLDIV12;
    volatile Uint32 PLLDIV13;
    volatile Uint32 PLLDIV14;
} CSL_PllcRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_PllcRegs             *CSL_PllcRegsOvly;


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */


#define CSL_PLLC_PID_TYPE_MASK           (0x00FF0000u)
#define CSL_PLLC_PID_TYPE_SHIFT          (0x00000010u)
#define CSL_PLLC_PID_TYPE_RESETVAL       (0x00000001u)

#define CSL_PLLC_PID_CLASS_MASK          (0x0000FF00u)
#define CSL_PLLC_PID_CLASS_SHIFT         (0x00000008u)
#define CSL_PLLC_PID_CLASS_RESETVAL      (0x00000008u)

#define CSL_PLLC_PID_REV_MASK            (0x000000FFu)
#define CSL_PLLC_PID_REV_SHIFT           (0x00000000u)
#define CSL_PLLC_PID_REV_RESETVAL        (0x0000000Du)

#define CSL_PLLC_PID_RESETVAL            (0x0001080Du)

/* FUSERR */


#define CSL_PLLC_FUSERR_ERR_MASK         (0x0000001Fu)
#define CSL_PLLC_FUSERR_ERR_SHIFT        (0x00000000u)
#define CSL_PLLC_FUSERR_ERR_RESETVAL     (0x00000000u)

#define CSL_PLLC_FUSERR_RESETVAL         (0x00000000u)

/* RSTYPE */


#define CSL_PLLC_RSTYPE_SRST_MASK        (0x00000008u)
#define CSL_PLLC_RSTYPE_SRST_SHIFT       (0x00000003u)
#define CSL_PLLC_RSTYPE_SRST_RESETVAL    (0x00000000u)
/*----SRST Tokens----*/
#define CSL_PLLC_RSTYPE_SRST_NO          (0x00000000u)
#define CSL_PLLC_RSTYPE_SRST_YES         (0x00000001u)

#define CSL_PLLC_RSTYPE_MRST_MASK        (0x00000004u)
#define CSL_PLLC_RSTYPE_MRST_SHIFT       (0x00000002u)
#define CSL_PLLC_RSTYPE_MRST_RESETVAL    (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PLLC_RSTYPE_MRST_NO          (0x00000000u)
#define CSL_PLLC_RSTYPE_MRST_YES         (0x00000001u)

#define CSL_PLLC_RSTYPE_XWRST_MASK       (0x00000002u)
#define CSL_PLLC_RSTYPE_XWRST_SHIFT      (0x00000001u)
#define CSL_PLLC_RSTYPE_XWRST_RESETVAL   (0x00000000u)
/*----XWRST Tokens----*/
#define CSL_PLLC_RSTYPE_XWRST_NO         (0x00000000u)
#define CSL_PLLC_RSTYPE_XWRST_YES        (0x00000001u)

#define CSL_PLLC_RSTYPE_POR_MASK         (0x00000001u)
#define CSL_PLLC_RSTYPE_POR_SHIFT        (0x00000000u)
#define CSL_PLLC_RSTYPE_POR_RESETVAL     (0x00000001u)
/*----POR Tokens----*/
#define CSL_PLLC_RSTYPE_POR_NO           (0x00000000u)
#define CSL_PLLC_RSTYPE_POR_YES          (0x00000001u)

#define CSL_PLLC_RSTYPE_RESETVAL         (0x00000001u)

/* RSTDEF */


#define CSL_PLLC_RSTDEF_XWFUNC_MASK      (0x00000001u)
#define CSL_PLLC_RSTDEF_XWFUNC_SHIFT     (0x00000000u)
#define CSL_PLLC_RSTDEF_XWFUNC_RESETVAL  (0x00000000u)
/*----XWFUNC Tokens----*/
#define CSL_PLLC_RSTDEF_XWFUNC_NORM      (0x00000000u)
#define CSL_PLLC_RSTDEF_XWFUNC_FAST      (0x00000001u)

#define CSL_PLLC_RSTDEF_RESETVAL         (0x00000000u)

/* PLLCTL */


#define CSL_PLLC_PLLCTL_CLKMODE_MASK     (0x00000100u)
#define CSL_PLLC_PLLCTL_CLKMODE_SHIFT    (0x00000008u)
#define CSL_PLLC_PLLCTL_CLKMODE_RESETVAL (0x00000000u)
/*----CLKMODE Tokens----*/
#define CSL_PLLC_PLLCTL_CLKMODE_OSCIN    (0x00000000u)
#define CSL_PLLC_PLLCTL_CLKMODE_CLKIN    (0x00000001u)

#define CSL_PLLC_PLLCTL_PLLSELB_MASK     (0x00000080u)
#define CSL_PLLC_PLLCTL_PLLSELB_SHIFT    (0x00000007u)
#define CSL_PLLC_PLLCTL_PLLSELB_RESETVAL (0x00000000u)
/*----PLLSELB Tokens----*/
#define CSL_PLLC_PLLCTL_PLLSELB_PLLA     (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLSELB_PLLB     (0x00000001u)


#define CSL_PLLC_PLLCTL_PLLENSRC_MASK    (0x00000020u)
#define CSL_PLLC_PLLCTL_PLLENSRC_SHIFT   (0x00000005u)
#define CSL_PLLC_PLLCTL_PLLENSRC_RESETVAL (0x00000000u)
/*----PLLENSRC Tokens----*/
#define CSL_PLLC_PLLCTL_PLLENSRC_REGBIT  (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLENSRC_PORT    (0x00000001u)

#define CSL_PLLC_PLLCTL_PLLDIS_MASK      (0x00000010u)
#define CSL_PLLC_PLLCTL_PLLDIS_SHIFT     (0x00000004u)
#define CSL_PLLC_PLLCTL_PLLDIS_RESETVAL  (0x00000000u)
/*----PLLDIS Tokens----*/
#define CSL_PLLC_PLLCTL_PLLDIS_NO        (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLDIS_YES       (0x00000001u)

#define CSL_PLLC_PLLCTL_PLLRST_MASK      (0x00000008u)
#define CSL_PLLC_PLLCTL_PLLRST_SHIFT     (0x00000003u)
#define CSL_PLLC_PLLCTL_PLLRST_RESETVAL  (0x00000001u)
/*----PLLRST Tokens----*/
#define CSL_PLLC_PLLCTL_PLLRST_NO        (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLRST_YES       (0x00000001u)


#define CSL_PLLC_PLLCTL_PLLPWRDN_MASK    (0x00000002u)
#define CSL_PLLC_PLLCTL_PLLPWRDN_SHIFT   (0x00000001u)
#define CSL_PLLC_PLLCTL_PLLPWRDN_RESETVAL (0x00000000u)
/*----PLLPWRDN Tokens----*/
#define CSL_PLLC_PLLCTL_PLLPWRDN_NO      (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLPWRDN_YES     (0x00000001u)

#define CSL_PLLC_PLLCTL_PLLEN_MASK       (0x00000001u)
#define CSL_PLLC_PLLCTL_PLLEN_SHIFT      (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLEN_RESETVAL   (0x00000000u)
/*----PLLEN Tokens----*/
#define CSL_PLLC_PLLCTL_PLLEN_BYPASS     (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLEN_PLL        (0x00000001u)

#define CSL_PLLC_PLLCTL_RESETVAL         (0x00000048u)

/* OCSEL */


#define CSL_PLLC_OCSEL_OCSRC_MASK        (0x0000001Fu)
#define CSL_PLLC_OCSEL_OCSRC_SHIFT       (0x00000000u)
#define CSL_PLLC_OCSEL_OCSRC_RESETVAL    (0x00000000u)
/*----OCSRC Tokens----*/
#define CSL_PLLC_OCSEL_OCSRC_OBSCLK      (0x00000000u)
#define CSL_PLLC_OCSEL_OCSRC_DISABLE     (0x00010000u)

#define CSL_PLLC_OCSEL_RESETVAL          (0x00000000u)

/* SECCTL */


#define CSL_PLLC_SECCTL_CTL7_MASK        (0x00800000u)
#define CSL_PLLC_SECCTL_CTL7_SHIFT       (0x00000017u)
#define CSL_PLLC_SECCTL_CTL7_RESETVAL    (0x00000001u)

#define CSL_PLLC_SECCTL_CTL6_MASK        (0x00400000u)
#define CSL_PLLC_SECCTL_CTL6_SHIFT       (0x00000016u)
#define CSL_PLLC_SECCTL_CTL6_RESETVAL    (0x00000000u)

#define CSL_PLLC_SECCTL_CTL5_MASK        (0x00200000u)
#define CSL_PLLC_SECCTL_CTL5_SHIFT       (0x00000015u)
#define CSL_PLLC_SECCTL_CTL5_RESETVAL    (0x00000000u)

#define CSL_PLLC_SECCTL_CTL4_MASK        (0x00100000u)
#define CSL_PLLC_SECCTL_CTL4_SHIFT       (0x00000014u)
#define CSL_PLLC_SECCTL_CTL4_RESETVAL    (0x00000000u)

#define CSL_PLLC_SECCTL_CTL3_MASK        (0x00080000u)
#define CSL_PLLC_SECCTL_CTL3_SHIFT       (0x00000013u)
#define CSL_PLLC_SECCTL_CTL3_RESETVAL    (0x00000000u)

#define CSL_PLLC_SECCTL_CTL2_MASK        (0x00040000u)
#define CSL_PLLC_SECCTL_CTL2_SHIFT       (0x00000012u)
#define CSL_PLLC_SECCTL_CTL2_RESETVAL    (0x00000000u)

#define CSL_PLLC_SECCTL_CTL1_MASK        (0x00020000u)
#define CSL_PLLC_SECCTL_CTL1_SHIFT       (0x00000011u)
#define CSL_PLLC_SECCTL_CTL1_RESETVAL    (0x00000000u)

#define CSL_PLLC_SECCTL_CTL0_MASK        (0x00010000u)
#define CSL_PLLC_SECCTL_CTL0_SHIFT       (0x00000010u)
#define CSL_PLLC_SECCTL_CTL0_RESETVAL    (0x00000001u)


#define CSL_PLLC_SECCTL_RESETVAL         (0x00810000u)

/* PLLM */


#define CSL_PLLC_PLLM_PLLM_MASK          (0x0000003Fu)
#define CSL_PLLC_PLLM_PLLM_SHIFT         (0x00000000u)
#define CSL_PLLC_PLLM_PLLM_RESETVAL      (0x00000000u)

#define CSL_PLLC_PLLM_RESETVAL           (0x00000000u)

/* PREDIV */


#define CSL_PLLC_PREDIV_PREDEN_MASK      (0x00008000u)
#define CSL_PLLC_PREDIV_PREDEN_SHIFT     (0x0000000Fu)
#define CSL_PLLC_PREDIV_PREDEN_RESETVAL  (0x00000000u)
/*----PREDEN Tokens----*/
#define CSL_PLLC_PREDIV_PREDEN_DISABLE   (0x00000000u)
#define CSL_PLLC_PREDIV_PREDEN_ENABLE    (0x00000001u)


#define CSL_PLLC_PREDIV_RATIO_MASK       (0x0000001Fu)
#define CSL_PLLC_PREDIV_RATIO_SHIFT      (0x00000000u)
#define CSL_PLLC_PREDIV_RATIO_RESETVAL   (0x00000000u)

#define CSL_PLLC_PREDIV_RESETVAL         (0x00000000u)

/* PLLDIV1 */


#define CSL_PLLC_PLLDIV1_D1EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV1_D1EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV1_D1EN_RESETVAL   (0x00000000u)
/*----D1EN Tokens----*/
#define CSL_PLLC_PLLDIV1_D1EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV1_D1EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV1_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV1_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV1_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV1_RESETVAL        (0x00000000u)

/* PLLDIV2 */


#define CSL_PLLC_PLLDIV2_D2EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV2_D2EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV2_D2EN_RESETVAL   (0x00000000u)
/*----D2EN Tokens----*/
#define CSL_PLLC_PLLDIV2_D2EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV2_D2EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV2_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV2_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV2_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV2_RESETVAL        (0x00000000u)

/* PLLDIV3 */


#define CSL_PLLC_PLLDIV3_D3EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV3_D3EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV3_D3EN_RESETVAL   (0x00000000u)
/*----D3EN Tokens----*/
#define CSL_PLLC_PLLDIV3_D3EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV3_D3EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV3_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV3_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV3_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV3_RESETVAL        (0x00000000u)

/* OSCDIV1 */


#define CSL_PLLC_OSCDIV1_OD1EN_MASK      (0x00008000u)
#define CSL_PLLC_OSCDIV1_OD1EN_SHIFT     (0x0000000Fu)
#define CSL_PLLC_OSCDIV1_OD1EN_RESETVAL  (0x00000000u)
/*----OD1EN Tokens----*/
#define CSL_PLLC_OSCDIV1_OD1EN_DISABLE   (0x00000000u)
#define CSL_PLLC_OSCDIV1_OD1EN_ENABLE    (0x00000001u)


#define CSL_PLLC_OSCDIV1_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_OSCDIV1_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_OSCDIV1_RATIO_RESETVAL  (0x00000010u)

#define CSL_PLLC_OSCDIV1_RESETVAL        (0x00000010u)

/* POSTDIV */


#define CSL_PLLC_POSTDIV_POSTDEN_MASK    (0x00008000u)
#define CSL_PLLC_POSTDIV_POSTDEN_SHIFT   (0x0000000Fu)
#define CSL_PLLC_POSTDIV_POSTDEN_RESETVAL (0x00000000u)
/*----POSTDEN Tokens----*/
#define CSL_PLLC_POSTDIV_POSTDEN_DISABLE (0x00000000u)
#define CSL_PLLC_POSTDIV_POSTDEN_ENABLE  (0x00000001u)


#define CSL_PLLC_POSTDIV_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_POSTDIV_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_POSTDIV_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_POSTDIV_RESETVAL        (0x00000000u)

/* BPDIV */


#define CSL_PLLC_BPDIV_BPDEN_MASK        (0x00008000u)
#define CSL_PLLC_BPDIV_BPDEN_SHIFT       (0x0000000Fu)
#define CSL_PLLC_BPDIV_BPDEN_RESETVAL    (0x00000000u)
/*----BPDEN Tokens----*/
#define CSL_PLLC_BPDIV_BPDEN_DISABLE     (0x00000000u)
#define CSL_PLLC_BPDIV_BPDEN_ENABLE      (0x00000001u)


#define CSL_PLLC_BPDIV_RATIO_MASK        (0x0000001Fu)
#define CSL_PLLC_BPDIV_RATIO_SHIFT       (0x00000000u)
#define CSL_PLLC_BPDIV_RATIO_RESETVAL    (0x00000000u)

#define CSL_PLLC_BPDIV_RESETVAL          (0x00000000u)

/* WAKEUP */


#define CSL_PLLC_WAKEUP_WKEN15_MASK      (0x00008000u)
#define CSL_PLLC_WAKEUP_WKEN15_SHIFT     (0x0000000Fu)
#define CSL_PLLC_WAKEUP_WKEN15_RESETVAL  (0x00000000u)
/*----WKEN15 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN15_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN15_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN14_MASK      (0x00004000u)
#define CSL_PLLC_WAKEUP_WKEN14_SHIFT     (0x0000000Eu)
#define CSL_PLLC_WAKEUP_WKEN14_RESETVAL  (0x00000000u)
/*----WKEN14 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN14_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN14_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN13_MASK      (0x00002000u)
#define CSL_PLLC_WAKEUP_WKEN13_SHIFT     (0x0000000Du)
#define CSL_PLLC_WAKEUP_WKEN13_RESETVAL  (0x00000000u)
/*----WKEN13 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN13_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN13_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN12_MASK      (0x00001000u)
#define CSL_PLLC_WAKEUP_WKEN12_SHIFT     (0x0000000Cu)
#define CSL_PLLC_WAKEUP_WKEN12_RESETVAL  (0x00000000u)
/*----WKEN12 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN12_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN12_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN11_MASK      (0x00000800u)
#define CSL_PLLC_WAKEUP_WKEN11_SHIFT     (0x0000000Bu)
#define CSL_PLLC_WAKEUP_WKEN11_RESETVAL  (0x00000000u)
/*----WKEN11 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN11_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN11_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN10_MASK      (0x00000400u)
#define CSL_PLLC_WAKEUP_WKEN10_SHIFT     (0x0000000Au)
#define CSL_PLLC_WAKEUP_WKEN10_RESETVAL  (0x00000000u)
/*----WKEN10 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN10_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN10_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN09_MASK      (0x00000200u)
#define CSL_PLLC_WAKEUP_WKEN09_SHIFT     (0x00000009u)
#define CSL_PLLC_WAKEUP_WKEN09_RESETVAL  (0x00000000u)
/*----WKEN09 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN09_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN09_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN08_MASK      (0x00000100u)
#define CSL_PLLC_WAKEUP_WKEN08_SHIFT     (0x00000008u)
#define CSL_PLLC_WAKEUP_WKEN08_RESETVAL  (0x00000000u)
/*----WKEN08 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN08_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN08_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN07_MASK      (0x00000080u)
#define CSL_PLLC_WAKEUP_WKEN07_SHIFT     (0x00000007u)
#define CSL_PLLC_WAKEUP_WKEN07_RESETVAL  (0x00000000u)
/*----WKEN07 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN07_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN07_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN06_MASK      (0x00000040u)
#define CSL_PLLC_WAKEUP_WKEN06_SHIFT     (0x00000006u)
#define CSL_PLLC_WAKEUP_WKEN06_RESETVAL  (0x00000000u)
/*----WKEN06 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN06_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN06_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN05_MASK      (0x00000020u)
#define CSL_PLLC_WAKEUP_WKEN05_SHIFT     (0x00000005u)
#define CSL_PLLC_WAKEUP_WKEN05_RESETVAL  (0x00000000u)
/*----WKEN05 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN05_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN05_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN04_MASK      (0x00000010u)
#define CSL_PLLC_WAKEUP_WKEN04_SHIFT     (0x00000004u)
#define CSL_PLLC_WAKEUP_WKEN04_RESETVAL  (0x00000000u)
/*----WKEN04 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN04_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN04_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN03_MASK      (0x00000008u)
#define CSL_PLLC_WAKEUP_WKEN03_SHIFT     (0x00000003u)
#define CSL_PLLC_WAKEUP_WKEN03_RESETVAL  (0x00000000u)
/*----WKEN03 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN03_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN03_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN02_MASK      (0x00000004u)
#define CSL_PLLC_WAKEUP_WKEN02_SHIFT     (0x00000002u)
#define CSL_PLLC_WAKEUP_WKEN02_RESETVAL  (0x00000000u)
/*----WKEN02 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN02_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN02_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN01_MASK      (0x00000002u)
#define CSL_PLLC_WAKEUP_WKEN01_SHIFT     (0x00000001u)
#define CSL_PLLC_WAKEUP_WKEN01_RESETVAL  (0x00000000u)
/*----WKEN01 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN01_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN01_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_WKEN00_MASK      (0x00000001u)
#define CSL_PLLC_WAKEUP_WKEN00_SHIFT     (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN00_RESETVAL  (0x00000000u)
/*----WKEN00 Tokens----*/
#define CSL_PLLC_WAKEUP_WKEN00_DISABLE   (0x00000000u)
#define CSL_PLLC_WAKEUP_WKEN00_ENABLE    (0x00000001u)

#define CSL_PLLC_WAKEUP_RESETVAL         (0x00000000u)

/* PLLCMD */


#define CSL_PLLC_PLLCMD_OSCPWRDN_MASK    (0x00000002u)
#define CSL_PLLC_PLLCMD_OSCPWRDN_SHIFT   (0x00000001u)
#define CSL_PLLC_PLLCMD_OSCPWRDN_RESETVAL (0x00000001u)
/*----OSCPWRDN Tokens----*/
#define CSL_PLLC_PLLCMD_OSCPWRDN_CLRBIT  (0x00000000u)
#define CSL_PLLC_PLLCMD_OSCPWRDN_SET     (0x00000001u)

#define CSL_PLLC_PLLCMD_GOSET_MASK       (0x00000001u)
#define CSL_PLLC_PLLCMD_GOSET_SHIFT      (0x00000000u)
#define CSL_PLLC_PLLCMD_GOSET_RESETVAL   (0x00000001u)
/*----GOSET Tokens----*/
#define CSL_PLLC_PLLCMD_GOSET_CLRBIT     (0x00000000u)
#define CSL_PLLC_PLLCMD_GOSET_SET        (0x00000001u)

#define CSL_PLLC_PLLCMD_RESETVAL         (0x00000003u)

/* PLLSTAT */


#define CSL_PLLC_PLLSTAT_STABLE_MASK     (0x00000004u)
#define CSL_PLLC_PLLSTAT_STABLE_SHIFT    (0x00000002u)
#define CSL_PLLC_PLLSTAT_STABLE_RESETVAL (0x00000001u)
/*----STABLE Tokens----*/
#define CSL_PLLC_PLLSTAT_STABLE_NO       (0x00000000u)
#define CSL_PLLC_PLLSTAT_STABLE_YES      (0x00000001u)

#define CSL_PLLC_PLLSTAT_LOCK_MASK       (0x00000002u)
#define CSL_PLLC_PLLSTAT_LOCK_SHIFT      (0x00000001u)
#define CSL_PLLC_PLLSTAT_LOCK_RESETVAL   (0x00000000u)
/*----LOCK Tokens----*/
#define CSL_PLLC_PLLSTAT_LOCK_NO         (0x00000000u)
#define CSL_PLLC_PLLSTAT_LOCK_YES        (0x00000001u)

#define CSL_PLLC_PLLSTAT_GOSTAT_MASK     (0x00000001u)
#define CSL_PLLC_PLLSTAT_GOSTAT_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLSTAT_GOSTAT_RESETVAL (0x00000000u)
/*----GOSTAT Tokens----*/
#define CSL_PLLC_PLLSTAT_GOSTAT_NONE     (0x00000000u)
#define CSL_PLLC_PLLSTAT_GOSTAT_INPROG   (0x00000001u)

#define CSL_PLLC_PLLSTAT_RESETVAL        (0x00000004u)

/* ALNCTL */


#define CSL_PLLC_ALNCTL_ALN14_MASK       (0x00002000u)
#define CSL_PLLC_ALNCTL_ALN14_SHIFT      (0x0000000Du)
#define CSL_PLLC_ALNCTL_ALN14_RESETVAL   (0x00000001u)
/*----ALN14 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN14_NO         (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN14_YES        (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN13_MASK       (0x00001000u)
#define CSL_PLLC_ALNCTL_ALN13_SHIFT      (0x0000000Cu)
#define CSL_PLLC_ALNCTL_ALN13_RESETVAL   (0x00000001u)
/*----ALN13 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN13_NO         (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN13_YES        (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN12_MASK       (0x00000800u)
#define CSL_PLLC_ALNCTL_ALN12_SHIFT      (0x0000000Bu)
#define CSL_PLLC_ALNCTL_ALN12_RESETVAL   (0x00000001u)
/*----ALN12 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN12_NO         (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN12_YES        (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN11_MASK       (0x00000400u)
#define CSL_PLLC_ALNCTL_ALN11_SHIFT      (0x0000000Au)
#define CSL_PLLC_ALNCTL_ALN11_RESETVAL   (0x00000001u)
/*----ALN11 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN11_NO         (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN11_YES        (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN10_MASK       (0x00000200u)
#define CSL_PLLC_ALNCTL_ALN10_SHIFT      (0x00000009u)
#define CSL_PLLC_ALNCTL_ALN10_RESETVAL   (0x00000001u)
/*----ALN10 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN10_NO         (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN10_YES        (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN9_MASK        (0x00000100u)
#define CSL_PLLC_ALNCTL_ALN9_SHIFT       (0x00000008u)
#define CSL_PLLC_ALNCTL_ALN9_RESETVAL    (0x00000001u)
/*----ALN9 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN9_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN9_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN8_MASK        (0x00000080u)
#define CSL_PLLC_ALNCTL_ALN8_SHIFT       (0x00000007u)
#define CSL_PLLC_ALNCTL_ALN8_RESETVAL    (0x00000001u)
/*----ALN8 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN8_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN8_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN7_MASK        (0x00000040u)
#define CSL_PLLC_ALNCTL_ALN7_SHIFT       (0x00000006u)
#define CSL_PLLC_ALNCTL_ALN7_RESETVAL    (0x00000001u)
/*----ALN7 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN7_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN7_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN6_MASK        (0x00000020u)
#define CSL_PLLC_ALNCTL_ALN6_SHIFT       (0x00000005u)
#define CSL_PLLC_ALNCTL_ALN6_RESETVAL    (0x00000001u)
/*----ALN6 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN6_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN6_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN5_MASK        (0x00000010u)
#define CSL_PLLC_ALNCTL_ALN5_SHIFT       (0x00000004u)
#define CSL_PLLC_ALNCTL_ALN5_RESETVAL    (0x00000001u)
/*----ALN5 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN5_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN5_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN4_MASK        (0x00000008u)
#define CSL_PLLC_ALNCTL_ALN4_SHIFT       (0x00000003u)
#define CSL_PLLC_ALNCTL_ALN4_RESETVAL    (0x00000001u)
/*----ALN4 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN4_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN4_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN3_MASK        (0x00000004u)
#define CSL_PLLC_ALNCTL_ALN3_SHIFT       (0x00000002u)
#define CSL_PLLC_ALNCTL_ALN3_RESETVAL    (0x00000001u)
/*----ALN3 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN3_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN3_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN2_MASK        (0x00000002u)
#define CSL_PLLC_ALNCTL_ALN2_SHIFT       (0x00000001u)
#define CSL_PLLC_ALNCTL_ALN2_RESETVAL    (0x00000001u)
/*----ALN2 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN2_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN2_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN1_MASK        (0x00000001u)
#define CSL_PLLC_ALNCTL_ALN1_SHIFT       (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN1_RESETVAL    (0x00000001u)
/*----ALN1 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN1_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN1_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_RESETVAL         (0x00003FFFu)

/* DCHANGE */


#define CSL_PLLC_DCHANGE_SYS14_MASK      (0x00002000u)
#define CSL_PLLC_DCHANGE_SYS14_SHIFT     (0x0000000Du)
#define CSL_PLLC_DCHANGE_SYS14_RESETVAL  (0x00000000u)
/*----SYS14 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS14_NO        (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS14_YES       (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS13_MASK      (0x00001000u)
#define CSL_PLLC_DCHANGE_SYS13_SHIFT     (0x0000000Cu)
#define CSL_PLLC_DCHANGE_SYS13_RESETVAL  (0x00000000u)
/*----SYS13 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS13_NO        (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS13_YES       (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS12_MASK      (0x00000800u)
#define CSL_PLLC_DCHANGE_SYS12_SHIFT     (0x0000000Bu)
#define CSL_PLLC_DCHANGE_SYS12_RESETVAL  (0x00000000u)
/*----SYS12 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS12_NO        (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS12_YES       (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS11_MASK      (0x00000400u)
#define CSL_PLLC_DCHANGE_SYS11_SHIFT     (0x0000000Au)
#define CSL_PLLC_DCHANGE_SYS11_RESETVAL  (0x00000000u)
/*----SYS11 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS11_NO        (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS11_YES       (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS10_MASK      (0x00000200u)
#define CSL_PLLC_DCHANGE_SYS10_SHIFT     (0x00000009u)
#define CSL_PLLC_DCHANGE_SYS10_RESETVAL  (0x00000000u)
/*----SYS10 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS10_NO        (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS10_YES       (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS9_MASK       (0x00000100u)
#define CSL_PLLC_DCHANGE_SYS9_SHIFT      (0x00000008u)
#define CSL_PLLC_DCHANGE_SYS9_RESETVAL   (0x00000000u)
/*----SYS9 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS9_NO         (0x00000000u)

#define CSL_PLLC_DCHANGE_SYS8_MASK       (0x00000080u)
#define CSL_PLLC_DCHANGE_SYS8_SHIFT      (0x00000007u)
#define CSL_PLLC_DCHANGE_SYS8_RESETVAL   (0x00000000u)
/*----SYS8 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS8_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS8_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS7_MASK       (0x00000040u)
#define CSL_PLLC_DCHANGE_SYS7_SHIFT      (0x00000006u)
#define CSL_PLLC_DCHANGE_SYS7_RESETVAL   (0x00000000u)
/*----SYS7 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS7_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS7_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS6_MASK       (0x00000020u)
#define CSL_PLLC_DCHANGE_SYS6_SHIFT      (0x00000005u)
#define CSL_PLLC_DCHANGE_SYS6_RESETVAL   (0x00000000u)
/*----SYS6 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS6_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS6_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS5_MASK       (0x00000010u)
#define CSL_PLLC_DCHANGE_SYS5_SHIFT      (0x00000004u)
#define CSL_PLLC_DCHANGE_SYS5_RESETVAL   (0x00000000u)
/*----SYS5 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS5_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS5_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS4_MASK       (0x00000008u)
#define CSL_PLLC_DCHANGE_SYS4_SHIFT      (0x00000003u)
#define CSL_PLLC_DCHANGE_SYS4_RESETVAL   (0x00000000u)
/*----SYS4 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS4_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS4_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS3_MASK       (0x00000004u)
#define CSL_PLLC_DCHANGE_SYS3_SHIFT      (0x00000002u)
#define CSL_PLLC_DCHANGE_SYS3_RESETVAL   (0x00000000u)
/*----SYS3 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS3_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS3_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS2_MASK       (0x00000002u)
#define CSL_PLLC_DCHANGE_SYS2_SHIFT      (0x00000001u)
#define CSL_PLLC_DCHANGE_SYS2_RESETVAL   (0x00000000u)
/*----SYS2 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS2_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS2_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS1_MASK       (0x00000001u)
#define CSL_PLLC_DCHANGE_SYS1_SHIFT      (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS1_RESETVAL   (0x00000000u)
/*----SYS1 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS1_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS1_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_RESETVAL        (0x00000000u)

/* CKEN */


#define CSL_PLLC_CKEN_OBSEN_MASK         (0x00000002u)
#define CSL_PLLC_CKEN_OBSEN_SHIFT        (0x00000001u)
#define CSL_PLLC_CKEN_OBSEN_RESETVAL     (0x00000000u)
/*----OBSEN Tokens----*/
#define CSL_PLLC_CKEN_OBSEN_DISABLE      (0x00000000u)
#define CSL_PLLC_CKEN_OBSEN_ENABLE       (0x00000001u)

#define CSL_PLLC_CKEN_AUXEN_MASK         (0x00000001u)
#define CSL_PLLC_CKEN_AUXEN_SHIFT        (0x00000000u)
#define CSL_PLLC_CKEN_AUXEN_RESETVAL     (0x00000000u)
/*----AUXEN Tokens----*/
#define CSL_PLLC_CKEN_AUXEN_DISABLE      (0x00000000u)
#define CSL_PLLC_CKEN_AUXEN_ENABLE       (0x00000001u)

#define CSL_PLLC_CKEN_RESETVAL           (0x00000000u)

/* CKSTAT */


#define CSL_PLLC_CKSTAT_BPON_MASK        (0x00000008u)
#define CSL_PLLC_CKSTAT_BPON_SHIFT       (0x00000003u)
#define CSL_PLLC_CKSTAT_BPON_RESETVAL    (0x00000000u)
/*----BPON Tokens----*/
#define CSL_PLLC_CKSTAT_BPON_OFF         (0x00000000u)
#define CSL_PLLC_CKSTAT_BPON_ON          (0x00000001u)

#define CSL_PLLC_CKSTAT_OBSEN_MASK       (0x00000002u)
#define CSL_PLLC_CKSTAT_OBSEN_SHIFT      (0x00000001u)
#define CSL_PLLC_CKSTAT_OBSEN_RESETVAL   (0x00000000u)
/*----OBSEN Tokens----*/
#define CSL_PLLC_CKSTAT_OBSEN_OFF        (0x00000000u)
#define CSL_PLLC_CKSTAT_OBSEN_ON         (0x00000001u)

#define CSL_PLLC_CKSTAT_AUXEN_MASK       (0x00000001u)
#define CSL_PLLC_CKSTAT_AUXEN_SHIFT      (0x00000000u)
#define CSL_PLLC_CKSTAT_AUXEN_RESETVAL   (0x00000000u)

/*----AUXEN Tokens----*/
#define CSL_PLLC_CKSTAT_AUXEN_OFF        (0x00000000u)
#define CSL_PLLC_CKSTAT_AUXEN_ON         (0x00000001u)

#define CSL_PLLC_CKSTAT_RESETVAL         (0x00000000u)

/* SYSTAT */


#define CSL_PLLC_SYSTAT_SYS14ON_MASK     (0x00002000u)
#define CSL_PLLC_SYSTAT_SYS14ON_SHIFT    (0x0000000Du)
#define CSL_PLLC_SYSTAT_SYS14ON_RESETVAL (0x00000000u)
/*----SYS14ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS14ON_OFF      (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS14ON_ON       (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS13ON_MASK     (0x00001000u)
#define CSL_PLLC_SYSTAT_SYS13ON_SHIFT    (0x0000000Cu)
#define CSL_PLLC_SYSTAT_SYS13ON_RESETVAL (0x00000000u)
/*----SYS13ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS13ON_OFF      (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS13ON_ON       (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS12ON_MASK     (0x00000800u)
#define CSL_PLLC_SYSTAT_SYS12ON_SHIFT    (0x0000000Bu)
#define CSL_PLLC_SYSTAT_SYS12ON_RESETVAL (0x00000001u)
/*----SYS12ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS12ON_OFF      (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS12ON_ON       (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS11ON_MASK     (0x00000400u)
#define CSL_PLLC_SYSTAT_SYS11ON_SHIFT    (0x0000000Au)
#define CSL_PLLC_SYSTAT_SYS11ON_RESETVAL (0x00000000u)
/*----SYS11ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS11ON_OFF      (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS11ON_ON       (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS10ON_MASK     (0x00000200u)
#define CSL_PLLC_SYSTAT_SYS10ON_SHIFT    (0x00000009u)
#define CSL_PLLC_SYSTAT_SYS10ON_RESETVAL (0x00000001u)
/*----SYS10ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS10ON_OFF      (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS10ON_ON       (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS9ON_MASK      (0x00000100u)
#define CSL_PLLC_SYSTAT_SYS9ON_SHIFT     (0x00000008u)
#define CSL_PLLC_SYSTAT_SYS9ON_RESETVAL  (0x00000001u)
/*----SYS9ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS9ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS9ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS8ON_MASK      (0x00000080u)
#define CSL_PLLC_SYSTAT_SYS8ON_SHIFT     (0x00000007u)
#define CSL_PLLC_SYSTAT_SYS8ON_RESETVAL  (0x00000001u)
/*----SYS8ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS8ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS8ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS7ON_MASK      (0x00000040u)
#define CSL_PLLC_SYSTAT_SYS7ON_SHIFT     (0x00000006u)
#define CSL_PLLC_SYSTAT_SYS7ON_RESETVAL  (0x00000001u)
/*----SYS7ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS7ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS7ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS6ON_MASK      (0x00000020u)
#define CSL_PLLC_SYSTAT_SYS6ON_SHIFT     (0x00000005u)
#define CSL_PLLC_SYSTAT_SYS6ON_RESETVAL  (0x00000000u)
/*----SYS6ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS6ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS6ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS5ON_MASK      (0x00000010u)
#define CSL_PLLC_SYSTAT_SYS5ON_SHIFT     (0x00000004u)
#define CSL_PLLC_SYSTAT_SYS5ON_RESETVAL  (0x00000000u)
/*----SYS5ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS5ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS5ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS4ON_MASK      (0x00000008u)
#define CSL_PLLC_SYSTAT_SYS4ON_SHIFT     (0x00000003u)
#define CSL_PLLC_SYSTAT_SYS4ON_RESETVAL  (0x00000000u)

/*----SYS4ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS4ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS4ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS3ON_MASK      (0x00000004u)
#define CSL_PLLC_SYSTAT_SYS3ON_SHIFT     (0x00000002u)
#define CSL_PLLC_SYSTAT_SYS3ON_RESETVAL  (0x00000000u)

/*----SYS3ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS3ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS3ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS2ON_MASK      (0x00000002u)
#define CSL_PLLC_SYSTAT_SYS2ON_SHIFT     (0x00000001u)
#define CSL_PLLC_SYSTAT_SYS2ON_RESETVAL  (0x00000000u)
/*----SYS2ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS2ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS2ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS1ON_MASK      (0x00000001u)
#define CSL_PLLC_SYSTAT_SYS1ON_SHIFT     (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS1ON_RESETVAL  (0x00000000u)
/*----SYS1ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS1ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS1ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_RESETVAL         (0x00000BC0u)

/* PLLDIV4 */


#define CSL_PLLC_PLLDIV4_D4EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV4_D4EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV4_D4EN_RESETVAL   (0x00000000u)
/*----D4EN Tokens----*/
#define CSL_PLLC_PLLDIV4_D4EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV4_D4EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV4_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV4_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV4_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV4_RESETVAL        (0x00000000u)

/* PLLDIV5 */


#define CSL_PLLC_PLLDIV5_D5EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV5_D5EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV5_D5EN_RESETVAL   (0x00000000u)
/*----D5EN Tokens----*/
#define CSL_PLLC_PLLDIV5_D5EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV5_D5EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV5_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV5_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV5_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV5_RESETVAL        (0x00000000u)

/* PLLDIV6 */


#define CSL_PLLC_PLLDIV6_D6EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV6_D6EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV6_D6EN_RESETVAL   (0x00000000u)
/*----D6EN Tokens----*/
#define CSL_PLLC_PLLDIV6_D6EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV6_D6EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV6_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV6_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV6_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV6_RESETVAL        (0x00000000u)

/* PLLDIV7 */


#define CSL_PLLC_PLLDIV7_D7EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV7_D7EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV7_D7EN_RESETVAL   (0x00000001u)
/*----D7EN Tokens----*/
#define CSL_PLLC_PLLDIV7_D7EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV7_D7EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV7_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV7_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV7_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV7_RESETVAL        (0x00008000u)

/* PLLDIV8 */


#define CSL_PLLC_PLLDIV8_D8EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV8_D8EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV8_D8EN_RESETVAL   (0x00000001u)
/*----D8EN Tokens----*/
#define CSL_PLLC_PLLDIV8_D8EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV8_D8EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV8_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV8_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV8_RATIO_RESETVAL  (0x00000003u)

#define CSL_PLLC_PLLDIV8_RESETVAL        (0x00008003u)

/* PLLDIV9 */


#define CSL_PLLC_PLLDIV9_D9EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV9_D9EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV9_D9EN_RESETVAL   (0x00000001u)
/*----D9EN Tokens----*/
#define CSL_PLLC_PLLDIV9_D9EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV9_D9EN_ENABLE     (0x00000001u)


#define CSL_PLLC_PLLDIV9_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV9_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV9_RATIO_RESETVAL  (0x00000002u)

#define CSL_PLLC_PLLDIV9_RESETVAL        (0x00008002u)

/* PLLDIV10 */


#define CSL_PLLC_PLLDIV10_D10EN_MASK     (0x00008000u)
#define CSL_PLLC_PLLDIV10_D10EN_SHIFT    (0x0000000Fu)
#define CSL_PLLC_PLLDIV10_D10EN_RESETVAL (0x00000001u)
/*----D10EN Tokens----*/
#define CSL_PLLC_PLLDIV10_D10EN_DISABLE  (0x00000000u)
#define CSL_PLLC_PLLDIV10_D10EN_ENABLE   (0x00000001u)


#define CSL_PLLC_PLLDIV10_RATIO_MASK     (0x0000001Fu)
#define CSL_PLLC_PLLDIV10_RATIO_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLDIV10_RATIO_RESETVAL (0x00000005u)

#define CSL_PLLC_PLLDIV10_RESETVAL       (0x00008005u)

/* PLLDIV11 */


#define CSL_PLLC_PLLDIV11_D11EN_MASK     (0x00008000u)
#define CSL_PLLC_PLLDIV11_D11EN_SHIFT    (0x0000000Fu)
#define CSL_PLLC_PLLDIV11_D11EN_RESETVAL (0x00000000u)
/*----D11EN Tokens----*/
#define CSL_PLLC_PLLDIV11_D11EN_DISABLE  (0x00000000u)
#define CSL_PLLC_PLLDIV11_D11EN_ENABLE   (0x00000001u)


#define CSL_PLLC_PLLDIV11_RATIO_MASK     (0x0000001Fu)
#define CSL_PLLC_PLLDIV11_RATIO_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLDIV11_RATIO_RESETVAL (0x00000001u)

#define CSL_PLLC_PLLDIV11_RESETVAL       (0x00000001u)

/* PLLDIV12 */


#define CSL_PLLC_PLLDIV12_D12EN_MASK     (0x00008000u)
#define CSL_PLLC_PLLDIV12_D12EN_SHIFT    (0x0000000Fu)
#define CSL_PLLC_PLLDIV12_D12EN_RESETVAL (0x00000001u)
/*----D12EN Tokens----*/
#define CSL_PLLC_PLLDIV12_D12EN_DISABLE  (0x00000000u)
#define CSL_PLLC_PLLDIV12_D12EN_ENABLE   (0x00000001u)


#define CSL_PLLC_PLLDIV12_RATIO_MASK     (0x0000001Fu)
#define CSL_PLLC_PLLDIV12_RATIO_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLDIV12_RATIO_RESETVAL (0x00000001u)

#define CSL_PLLC_PLLDIV12_RESETVAL       (0x00008001u)

/* PLLDIV13 */


#define CSL_PLLC_PLLDIV13_D13EN_MASK     (0x00008000u)
#define CSL_PLLC_PLLDIV13_D13EN_SHIFT    (0x0000000Fu)
#define CSL_PLLC_PLLDIV13_D13EN_RESETVAL (0x00000000u)
/*----D13EN Tokens----*/
#define CSL_PLLC_PLLDIV13_D13EN_DISABLE  (0x00000000u)
#define CSL_PLLC_PLLDIV13_D13EN_ENABLE   (0x00000001u)


#define CSL_PLLC_PLLDIV13_RATIO_MASK     (0x0000001Fu)
#define CSL_PLLC_PLLDIV13_RATIO_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLDIV13_RATIO_RESETVAL (0x00000004u)

#define CSL_PLLC_PLLDIV13_RESETVAL       (0x00000004u)

/* PLLDIV14 */


#define CSL_PLLC_PLLDIV14_D14EN_MASK     (0x00008000u)
#define CSL_PLLC_PLLDIV14_D14EN_SHIFT    (0x0000000Fu)
#define CSL_PLLC_PLLDIV14_D14EN_RESETVAL (0x00000000u)
/*----D14EN Tokens----*/
#define CSL_PLLC_PLLDIV14_D14EN_DISABLE  (0x00000000u)
#define CSL_PLLC_PLLDIV14_D14EN_ENABLE   (0x00000001u)


#define CSL_PLLC_PLLDIV14_RATIO_MASK     (0x0000001Fu)
#define CSL_PLLC_PLLDIV14_RATIO_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLDIV14_RATIO_RESETVAL (0x00000015u)

#define CSL_PLLC_PLLDIV14_RESETVAL       (0x00000015u)

#endif
