/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_vcp2.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for VCP2
 *
 */

#ifndef _CSLR_VCP2_H_
#define _CSLR_VCP2_H_

#include <cslr.h>
#include <tistdtypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Register Overlay Structure for registers accessible through Config bus
 */
typedef struct {
    /** Peripheral identification register */ 
    volatile Uint32 VCP_ID;
    /** Reserved field */
    volatile Uint8 RSVD0[20];
    /** VCP execution register */
    volatile Uint32 VCP_EXE;
    /** Reserved field */
    volatile Uint8 RSVD1[4];
    /** VCP endian register */
    volatile Uint32 VCP_END;
    /** Reserved field */
    volatile Uint8 RSVD2[28];
    /** VCP status register 0 */
    volatile Uint32 VCP_STAT0;
    /** VCP status register 1 */
    volatile Uint32 VCP_STAT1;
    /** Reserved field */
    volatile Uint8 RSVD3[8];
    /** VCP error register */
    volatile Uint32 VCP_ERR;
    /** Reserved field */
    volatile Uint8 RSVD4[12];
    /** VCP emulation register */
    volatile Uint32 VCP_EMU;
} CSL_Vcp2ConfigRegs;

/**
 * Register Overlay Structure for registers accessible through EDMA bus
 */
typedef struct  {
    /** VCP input configuration register 0 */
    volatile Uint32 VCP_IC0;
    /** VCP input configuration register 1 */
    volatile Uint32 VCP_IC1;
    /** VCP input configuration register 2 */
    volatile Uint32 VCP_IC2;
    /** VCP input configuration register 3 */
    volatile Uint32 VCP_IC3;
    /** VCP input configuration register 4 */
    volatile Uint32 VCP_IC4;
    /** VCP input configuration register 5 */
    volatile Uint32 VCP_IC5;
    /** Reserved field */
    volatile Uint8 RSVD0[48];
    /** VCP output register 0 */
    volatile Uint32 VCP_OUT0;
    /** VCP output register 1 */
    volatile Uint32 VCP_OUT1;
    /** Reserved field */
    volatile Uint8 RSVD1[48];
    /** VCP branch metrics write register */
    volatile Uint32 VCP_WBM;
    /** Reserved field */
    volatile Uint8 RSVD2[60];
    /** VCP decisions read register */
    volatile Uint32 VCP_RDECS;
} CSL_Vcp2EdmaRegs;

/**************************************************************************\
* Field Definition Macros for registers accessible through config bus
\**************************************************************************/

/** VCP_ID */
#define CSL_VCP2_VCP_ID_TYPE_MASK               (0x00FF0000u)
#define CSL_VCP2_VCP_ID_TYPE_SHIFT              (0x00000010u)
#define CSL_VCP2_VCP_ID_TYPE_RESETVAL           (0x00000000u)

#define CSL_VCP2_VCP_ID_CLASS_MASK              (0x0000FF00u)
#define CSL_VCP2_VCP_ID_CLASS_SHIFT             (0x00000008u)
#define CSL_VCP2_VCP_ID_CLASS_RESETVAL          (0x00000000u)

#define CSL_VCP2_VCP_ID_REV_MASK                (0x000000FFu)
#define CSL_VCP2_VCP_ID_REV_SHIFT               (0x00000000u)
#define CSL_VCP2_VCP_ID_REV_RESETVAL            (0x00000000u)

#define CSL_VCP2_VCP_ID_RESETVAL                (0x00000000u)

/** VCP_EXE */
#define CSL_VCP2_VCP_EXE_COMMAND_MASK           (0x0000000Fu)
#define CSL_VCP2_VCP_EXE_COMMAND_SHIFT          (0x00000000u)
#define CSL_VCP2_VCP_EXE_COMMAND_RESETVAL       (0x00000000u)
#define CSL_VCP2_VCP_EXE_COMMAND_NOCMD          (0x00000000u)
#define CSL_VCP2_VCP_EXE_COMMAND_START          (0x00000001u)
#define CSL_VCP2_VCP_EXE_COMMAND_PAUSE          (0x00000002u)
#define CSL_VCP2_VCP_EXE_COMMAND_RESTART_PAUSE  (0x00000003u)
#define CSL_VCP2_VCP_EXE_COMMAND_RESTART        (0x00000004u)
#define CSL_VCP2_VCP_EXE_COMMAND_STOP           (0x00000005u)

#define CSL_VCP2_VCP_EXE_RESETVAL               (0x00000000u)

/** VCP_END */
#define CSL_VCP2_VCP_END_SLPZVSS_EN_MASK        (0x00000200u)
#define CSL_VCP2_VCP_END_SLPZVSS_EN_SHIFT       (0x00000009u)
#define CSL_VCP2_VCP_END_SLPZVSS_EN_RESETVAL    (0x00000001u)
#define CSL_VCP2_VCP_END_SLPZVSS_EN_SLEEP_DIS   (0x00000000u)
#define CSL_VCP2_VCP_END_SLPZVSS_EN_SLPVSS_EN   (0x00000001u)

#define CSL_VCP2_VCP_END_SLPZVDD_EN_MASK        (0x00000100u)
#define CSL_VCP2_VCP_END_SLPZVDD_EN_SHIFT       (0x00000008u)
#define CSL_VCP2_VCP_END_SLPZVDD_EN_RESETVAL    (0x00000001u)
#define CSL_VCP2_VCP_END_SLPZVDD_EN_SLEEP_DIS   (0x00000000u)
#define CSL_VCP2_VCP_END_SLPZVDD_EN_SLPVDD_EN   (0x00000001u)

#define CSL_VCP2_VCP_END_SD_MASK                (0x00000002u)
#define CSL_VCP2_VCP_END_SD_SHIFT               (0x00000001u)
#define CSL_VCP2_VCP_END_SD_RESETVAL            (0x00000000u)
#define CSL_VCP2_VCP_END_SD_32BIT               (0x00000000u)
#define CSL_VCP2_VCP_END_SD_NATIVE              (0x00000001u)

#define CSL_VCP2_VCP_END_BM_MASK                (0x00000001u)
#define CSL_VCP2_VCP_END_BM_SHIFT               (0x00000000u)
#define CSL_VCP2_VCP_END_BM_RESETVAL            (0x00000000u)
#define CSL_VCP2_VCP_END_BM_32BIT               (0x00000000u)
#define CSL_VCP2_VCP_END_BM_NATIVE              (0x00000001u)

#define CSL_VCP2_VCP_END_RESETVAL               (0x00000300u)

/** VCP_STAT0 */
#define CSL_VCP2_VCP_STAT0_NSYMPROC_MASK        (0x1FFFF000u)
#define CSL_VCP2_VCP_STAT0_NSYMPROC_SHIFT       (0x0000000Cu)
#define CSL_VCP2_VCP_STAT0_NSYMPROC_RESETVAL    (0x00000000u)

#define CSL_VCP2_VCP_STAT0_EMUHALT_MASK         (0x00000040u)
#define CSL_VCP2_VCP_STAT0_EMUHALT_SHIFT        (0x00000006u)
#define CSL_VCP2_VCP_STAT0_EMUHALT_RESETVAL     (0x00000000u)
#define CSL_VCP2_VCP_STAT0_EMUHALT_NO           (0x00000000u)
#define CSL_VCP2_VCP_STAT0_EMUHALT_YES          (0x00000001u)

#define CSL_VCP2_VCP_STAT0_OFFUL_MASK           (0x00000020u)
#define CSL_VCP2_VCP_STAT0_OFFUL_SHIFT          (0x00000005u)
#define CSL_VCP2_VCP_STAT0_OFFUL_RESETVAL       (0x00000000u)
#define CSL_VCP2_VCP_STAT0_OFFUL_NO             (0x00000000u)
#define CSL_VCP2_VCP_STAT0_OFFUL_YES            (0x00000001u)

#define CSL_VCP2_VCP_STAT0_IFEMP_MASK           (0x00000010u)
#define CSL_VCP2_VCP_STAT0_IFEMP_SHIFT          (0x00000004u)
#define CSL_VCP2_VCP_STAT0_IFEMP_RESETVAL       (0x00000000u)
#define CSL_VCP2_VCP_STAT0_IFEMP_NO             (0x00000000u)
#define CSL_VCP2_VCP_STAT0_IFEMP_YES            (0x00000001u)

#define CSL_VCP2_VCP_STAT0_WIC_MASK             (0x00000008u)
#define CSL_VCP2_VCP_STAT0_WIC_SHIFT            (0x00000003u)
#define CSL_VCP2_VCP_STAT0_WIC_RESETVAL         (0x00000000u)
#define CSL_VCP2_VCP_STAT0_WIC_NO               (0x00000000u)
#define CSL_VCP2_VCP_STAT0_WIC_YES              (0x00000001u)

#define CSL_VCP2_VCP_STAT0_ERR_MASK             (0x00000004u)
#define CSL_VCP2_VCP_STAT0_ERR_SHIFT            (0x00000002u)
#define CSL_VCP2_VCP_STAT0_ERR_RESETVAL         (0x00000000u)
#define CSL_VCP2_VCP_STAT0_ERR_NO               (0x00000000u)
#define CSL_VCP2_VCP_STAT0_ERR_YES              (0x00000001u)

#define CSL_VCP2_VCP_STAT0_RUN_MASK             (0x00000002u)
#define CSL_VCP2_VCP_STAT0_RUN_SHIFT            (0x00000001u)
#define CSL_VCP2_VCP_STAT0_RUN_RESETVAL         (0x00000000u)
#define CSL_VCP2_VCP_STAT0_RUN_NO               (0x00000000u)
#define CSL_VCP2_VCP_STAT0_RUN_YES              (0x00000001u)

#define CSL_VCP2_VCP_STAT0_PAUSE_MASK           (0x00000001u)
#define CSL_VCP2_VCP_STAT0_PAUSE_SHIFT          (0x00000000u)
#define CSL_VCP2_VCP_STAT0_PAUSE_RESETVAL       (0x00000000u)
#define CSL_VCP2_VCP_STAT0_PAUSE_NO             (0x00000000u)
#define CSL_VCP2_VCP_STAT0_PAUSE_YES            (0x00000001u)

#define CSL_VCP2_VCP_STAT0_RESETVAL             (0x00000000u)

/** VCP_STAT1 */
#define CSL_VCP2_VCP_STAT1_NSYMOF_MASK          (0xFFFF0000u)
#define CSL_VCP2_VCP_STAT1_NSYMOF_SHIFT         (0x00000010u)
#define CSL_VCP2_VCP_STAT1_NSYMOF_RESETVAL      (0x00000000u)

#define CSL_VCP2_VCP_STAT1_NSYMIF_MASK          (0x0000FFFFu)
#define CSL_VCP2_VCP_STAT1_NSYMIF_SHIFT         (0x00000000u)
#define CSL_VCP2_VCP_STAT1_NSYMIF_RESETVAL      (0x00000000u)

#define CSL_VCP2_VCP_STAT1_RESETVAL             (0x00000000u)

/** VCP_ERR */
#define CSL_VCP2_VCP_ERR_E_SYMR_MASK            (0x00000040u)
#define CSL_VCP2_VCP_ERR_E_SYMR_SHIFT           (0x00000006u)
#define CSL_VCP2_VCP_ERR_E_SYMR_RESETVAL        (0x00000000u)
#define CSL_VCP2_VCP_ERR_E_SYMR_NO              (0x00000000u)
#define CSL_VCP2_VCP_ERR_E_SYMR_YES             (0x00000001u)

#define CSL_VCP2_VCP_ERR_E_SYMX_MASK            (0x00000020u)
#define CSL_VCP2_VCP_ERR_E_SYMX_SHIFT           (0x00000005u)
#define CSL_VCP2_VCP_ERR_E_SYMX_RESETVAL        (0x00000000u)
#define CSL_VCP2_VCP_ERR_E_SYMX_NO              (0x00000000u)
#define CSL_VCP2_VCP_ERR_E_SYMX_YES             (0x00000001u)

#define CSL_VCP2_VCP_ERR_MAXMINERR_MASK         (0x00000010u)
#define CSL_VCP2_VCP_ERR_MAXMINERR_SHIFT        (0x00000004u)
#define CSL_VCP2_VCP_ERR_MAXMINERR_RESETVAL     (0x00000000u)
#define CSL_VCP2_VCP_ERR_MAXMINERR_NO           (0x00000000u)
#define CSL_VCP2_VCP_ERR_MAXMINERR_YES          (0x00000001u)

#define CSL_VCP2_VCP_ERR_FCTLERR_MASK           (0x00000008u)
#define CSL_VCP2_VCP_ERR_FCTLERR_SHIFT          (0x00000003u)
#define CSL_VCP2_VCP_ERR_FCTLERR_RESETVAL       (0x00000000u)
#define CSL_VCP2_VCP_ERR_FCTLERR_NO             (0x00000000u)
#define CSL_VCP2_VCP_ERR_FCTLERR_YES            (0x00000001u)

#define CSL_VCP2_VCP_ERR_FTLERR_MASK            (0x00000004u)
#define CSL_VCP2_VCP_ERR_FTLERR_SHIFT           (0x00000002u)
#define CSL_VCP2_VCP_ERR_FTLERR_RESETVAL        (0x00000000u)
#define CSL_VCP2_VCP_ERR_FTLERR_NO              (0x00000000u)
#define CSL_VCP2_VCP_ERR_FTLERR_YES             (0x00000001u)

#define CSL_VCP2_VCP_ERR_TBNAERR_MASK           (0x00000002u)
#define CSL_VCP2_VCP_ERR_TBNAERR_SHIFT          (0x00000001u)
#define CSL_VCP2_VCP_ERR_TBNAERR_RESETVAL       (0x00000000u)
#define CSL_VCP2_VCP_ERR_TBNAERR_NO             (0x00000000u)
#define CSL_VCP2_VCP_ERR_TBNAERR_YES            (0x00000001u)

#define CSL_VCP2_VCP_ERR_ERROR_MASK             (0x00000001u)
#define CSL_VCP2_VCP_ERR_ERROR_SHIFT            (0x00000000u)
#define CSL_VCP2_VCP_ERR_ERROR_RESETVAL         (0x00000000u)
#define CSL_VCP2_VCP_ERR_ERROR_NO               (0x00000000u)
#define CSL_VCP2_VCP_ERR_ERROR_YES              (0x00000001u)

#define CSL_VCP2_VCP_ERR_RESETVAL               (0x00000000u)

/** VCP_EMU */
#define CSL_VCP2_VCP_EMU_SOFT_MASK              (0x00000002u)
#define CSL_VCP2_VCP_EMU_SOFT_SHIFT             (0x00000001u)
#define CSL_VCP2_VCP_EMU_SOFT_RESETVAL          (0x00000000u)
#define CSL_VCP2_VCP_EMU_SOFT_HALT_DEFAULT      (0x00000000u)
#define CSL_VCP2_VCP_EMU_SOFT_HALT_FRAMEEND     (0x00000001u)

#define CSL_VCP2_VCP_EMU_FREE_MASK              (0x00000001u)
#define CSL_VCP2_VCP_EMU_FREE_SHIFT             (0x00000000u)
#define CSL_VCP2_VCP_EMU_FREE_RESETVAL          (0x00000000u)
#define CSL_VCP2_VCP_EMU_FREE_SOFT_EN           (0x00000000u)
#define CSL_VCP2_VCP_EMU_FREE_FREE              (0x00000001u)

#define CSL_VCP2_VCP_EMU_RESETVAL               (0x00000000u)

/**************************************************************************\
* Field Definition Macros for registers accessible through EDMA bus
\**************************************************************************/

/** VCP_IC0 */
#define CSL_VCP2_VCP_IC0_POLY3_OF_MASK   (0xFF000000u)
#define CSL_VCP2_VCP_IC0_POLY3_OF_SHIFT  (0x00000018u)
#define CSL_VCP2_VCP_IC0_POLY3_OF_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_IC0_POLY2_OF_MASK   (0x00FF0000u)
#define CSL_VCP2_VCP_IC0_POLY2_OF_SHIFT  (0x00000010u)
#define CSL_VCP2_VCP_IC0_POLY2_OF_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_IC0_POLY1_OF_MASK   (0x0000FF00u)
#define CSL_VCP2_VCP_IC0_POLY1_OF_SHIFT  (0x00000008u)
#define CSL_VCP2_VCP_IC0_POLY1_OF_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_IC0_POLY0_OF_MASK   (0x000000FFu)
#define CSL_VCP2_VCP_IC0_POLY0_OF_SHIFT  (0x00000000u)
#define CSL_VCP2_VCP_IC0_POLY0_OF_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_IC0_RESETVAL        (0x00000000u)

/** VCP_IC1 */

#define CSL_VCP2_VCP_IC1_YAMEN_MASK      (0x10000000u)
#define CSL_VCP2_VCP_IC1_YAMEN_SHIFT     (0x0000001Cu)
#define CSL_VCP2_VCP_IC1_YAMEN_RESETVAL  (0x00000000u)
#define CSL_VCP2_VCP_IC1_YAMEN_DISABLE   (0x00000000u)
#define CSL_VCP2_VCP_IC1_YAMEN_ENABLE    (0x00000001u)

#define CSL_VCP2_VCP_IC1_YAMT_MASK       (0x0FFF0000u)
#define CSL_VCP2_VCP_IC1_YAMT_SHIFT      (0x00000010u)
#define CSL_VCP2_VCP_IC1_YAMT_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCP_IC1_RESETVAL        (0x00000000u)

/** VCP_IC2 */

#define CSL_VCP2_VCP_IC2_R_MASK          (0xFFFF0000u)
#define CSL_VCP2_VCP_IC2_R_SHIFT         (0x00000010u)
#define CSL_VCP2_VCP_IC2_R_RESETVAL      (0x00000000u)

#define CSL_VCP2_VCP_IC2_F_MASK          (0x0000FFFFu)
#define CSL_VCP2_VCP_IC2_F_SHIFT         (0x00000000u)
#define CSL_VCP2_VCP_IC2_F_RESETVAL      (0x00000000u)

#define CSL_VCP2_VCP_IC2_RESETVAL        (0x00000000u)

/** VCP_IC3 */

#define CSL_VCP2_VCP_IC3_OUT_ORDER_MASK  (0x10000000u)
#define CSL_VCP2_VCP_IC3_OUT_ORDER_SHIFT (0x0000001Cu)
#define CSL_VCP2_VCP_IC3_OUT_ORDER_RESETVAL (0x00000000u)
#define CSL_VCP2_VCP_IC3_OUT_ORDER_0_31   (0x00000000u)
#define CSL_VCP2_VCP_IC3_OUT_ORDER_31_0   (0x00000001u)

#define CSL_VCP2_VCP_IC3_ITBEN_MASK      (0x01000000u)
#define CSL_VCP2_VCP_IC3_ITBEN_SHIFT     (0x00000018u)
#define CSL_VCP2_VCP_IC3_ITBEN_RESETVAL  (0x00000000u)
#define CSL_VCP2_VCP_IC3_ITBEN_DISABLE   (0x00000000u)
#define CSL_VCP2_VCP_IC3_ITBEN_ENABLE    (0x00000001u)

#define CSL_VCP2_VCP_IC3_ITBI_MASK       (0x00FF0000u)
#define CSL_VCP2_VCP_IC3_ITBI_SHIFT      (0x00000010u)
#define CSL_VCP2_VCP_IC3_ITBI_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCP_IC3_C_MASK          (0x0000FFFFu)
#define CSL_VCP2_VCP_IC3_C_SHIFT         (0x00000000u)
#define CSL_VCP2_VCP_IC3_C_RESETVAL      (0x00000000u)

#define CSL_VCP2_VCP_IC3_RESETVAL        (0x00000000u)

/** VCP_IC4 */

#define CSL_VCP2_VCP_IC4_IMINS_MASK      (0x1FFF0000u)
#define CSL_VCP2_VCP_IC4_IMINS_SHIFT     (0x00000010u)
#define CSL_VCP2_VCP_IC4_IMINS_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCP_IC4_IMAXS_MASK      (0x00001FFFu)
#define CSL_VCP2_VCP_IC4_IMAXS_SHIFT     (0x00000000u)
#define CSL_VCP2_VCP_IC4_IMAXS_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCP_IC4_RESETVAL        (0x00000000u)

/** VCP_IC5 */

#define CSL_VCP2_VCP_IC5_SDHD_MASK       (0x80000000u)
#define CSL_VCP2_VCP_IC5_SDHD_SHIFT      (0x0000001Fu)
#define CSL_VCP2_VCP_IC5_SDHD_RESETVAL   (0x00000000u)
#define CSL_VCP2_VCP_IC5_SDHD_HARD       (0x00000000u)
#define CSL_VCP2_VCP_IC5_SDHD_SOFT       (0x00000001u)

#define CSL_VCP2_VCP_IC5_OUTF_MASK       (0x40000000u)
#define CSL_VCP2_VCP_IC5_OUTF_SHIFT      (0x0000001Eu)
#define CSL_VCP2_VCP_IC5_OUTF_RESETVAL   (0x00000000u)
#define CSL_VCP2_VCP_IC5_OUTF_NO         (0x00000000u)
#define CSL_VCP2_VCP_IC5_OUTF_YES        (0x00000001u)

#define CSL_VCP2_VCP_IC5_TB_MASK         (0x30000000u)
#define CSL_VCP2_VCP_IC5_TB_SHIFT        (0x0000001Cu)
#define CSL_VCP2_VCP_IC5_TB_RESETVAL     (0x00000000u)
#define CSL_VCP2_VCP_IC5_TB_NO           (0x00000000u)
#define CSL_VCP2_VCP_IC5_TB_TAIL         (0x00000001u)
#define CSL_VCP2_VCP_IC5_TB_CONV         (0x00000002u)
#define CSL_VCP2_VCP_IC5_TB_MIX          (0x00000003u)

#define CSL_VCP2_VCP_IC5_SYMR_MASK       (0x01F00000u)
#define CSL_VCP2_VCP_IC5_SYMR_SHIFT      (0x00000014u)
#define CSL_VCP2_VCP_IC5_SYMR_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCP_IC5_SYMX_MASK       (0x000F0000u)
#define CSL_VCP2_VCP_IC5_SYMX_SHIFT      (0x00000010u)
#define CSL_VCP2_VCP_IC5_SYMX_RESETVAL   (0x00000000u)

#define CSL_VCP2_VCP_IC5_IMAXI_MASK      (0x000000FFu)
#define CSL_VCP2_VCP_IC5_IMAXI_SHIFT     (0x00000000u)
#define CSL_VCP2_VCP_IC5_IMAXI_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCP_IC5_RESETVAL        (0x00000000u)

/** VCP_OUT0 */

#define CSL_VCP2_VCP_OUT0_FMINS_MASK     (0x1FFF0000u)
#define CSL_VCP2_VCP_OUT0_FMINS_SHIFT    (0x00000010u)
#define CSL_VCP2_VCP_OUT0_FMINS_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_OUT0_FMAXS_MASK     (0x00001FFFu)
#define CSL_VCP2_VCP_OUT0_FMAXS_SHIFT    (0x00000000u)
#define CSL_VCP2_VCP_OUT0_FMAXS_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_OUT0_RESETVAL       (0x00000000u)

/** VCP_OUT1 */

#define CSL_VCP2_VCP_OUT1_YAM_MASK       (0x00010000u)
#define CSL_VCP2_VCP_OUT1_YAM_SHIFT      (0x00000010u)
#define CSL_VCP2_VCP_OUT1_YAM_RESETVAL   (0x00000000u)
#define CSL_VCP2_VCP_OUT1_YAM_NO         (0x00000000u)
#define CSL_VCP2_VCP_OUT1_YAM_YES        (0x00000001u)

#define CSL_VCP2_VCP_OUT1_FMAXI_MASK     (0x000000FFu)
#define CSL_VCP2_VCP_OUT1_FMAXI_SHIFT    (0x00000000u)
#define CSL_VCP2_VCP_OUT1_FMAXI_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_OUT1_RESETVAL       (0x00000000u)

/** VCP_WBM */

#define CSL_VCP2_VCP_WBM_WRITE_MASK      (0xFFFFFFFFu)
#define CSL_VCP2_VCP_WBM_WRITE_SHIFT     (0x00000000u)
#define CSL_VCP2_VCP_WBM_WRITE_RESETVAL  (0x00000000u)

#define CSL_VCP2_VCP_WBM_RESETVAL        (0x00000000u)

/** VCP_RDECS */

#define CSL_VCP2_VCP_RDECS_READ_MASK     (0xFFFFFFFFu)
#define CSL_VCP2_VCP_RDECS_READ_SHIFT    (0x00000000u)
#define CSL_VCP2_VCP_RDECS_READ_RESETVAL (0x00000000u)

#define CSL_VCP2_VCP_RDECS_RESETVAL      (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif
