/* =============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */

/** ============================================================================
 *   @file  csl_rac_regsFETypes.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains all the RAC CSL specific data types and enumeration
 *          types definitions. 
 */
 
/* =============================================================================
 *  Revision History
 *  ================
 *  31-May-2005   RDefosseux     File Created.
 * =============================================================================
 */

#ifndef _CSL_RAC_FE_TYPES_H_
#define _CSL_RAC_FE_TYPES_H_

#include <csl_types.h>

/** 
 *  @name    CSL_RAC_FE_transferState
 *
 *  @desc    Enumeration for specifying getFEStatus output.
 * 
 *  @field   CSL_RAC_FE_transferState_WaitingTimestamp
 *               The Front End is waiting for the timestamp write.
 * 
 *  @field   CSL_RAC_FE_transferState_ReceivingSamples
 *               The Front End receives samples.
 * 
 *  @field   CSL_RAC_FE_transferState_ReadyToStart
 *               The Front End has received all samples and is ready to start the GCCPs.
 * 
 *  @field   CSL_RAC_FE_transferState_StartGccpIteration
 *               The Front End enables the GCCPs.
 * 
 *  @see    
 *  
 */
typedef enum
{
	CSL_RAC_FE_transferState_WaitingTimestamp   = 0,
	CSL_RAC_FE_transferState_ReceivingSamples   = 1,
	CSL_RAC_FE_transferState_ReadyToStart       = 2,
	CSL_RAC_FE_transferState_StartGccpIteration = 3
} CSL_RAC_FE_transferState;

/** 
 *  @name    CSL_RAC_FE_gccpStatus
 *
 *  @desc    Enumeration for specifying getGccpStatus output.
 * 
 *  @field   CSL_RAC_FE_gccpStatus_Idle
 *               The GCCP is idle. The Data memories are accessible for debug.
 * 
 *  @field   CSL_RAC_FE_gccpStatus_Busy
 *               The GCCP is busy. The Data memories are not accessible for debug.
 * 
 *  @see    
 *  
 */
typedef enum
{
	CSL_RAC_FE_gccpStatus_Idle   = 0,
	CSL_RAC_FE_gccpStatus_Busy   = 1
} CSL_RAC_FE_gccpStatus;

/** 
 *  @name    CSL_RAC_FE_wdInterruptStatus
 *
 *  @desc    Enumeration for specifying getWatchDogInterruptStatus output.
 * 
 *  @field   CSL_RAC_FE_wdInterruptStatus_NoInt
 *               No interrupt has been generated.
 * 
 *  @field   CSL_RAC_FE_wdInterruptStatus_Int
 *               An interrupt has been generated and forwarded to the BEII.
 * 
 *  @see    
 *  
 */
typedef enum
{
	CSL_RAC_FE_wdInterruptStatus_NoInt = 0,
	CSL_RAC_FE_wdInterruptStatus_Int   = 1
} CSL_RAC_FE_wdInterruptStatus;

/**
 *  @name    CSL_RAC_FE_Timestamp_req
 *
 *  @desc    This descriptor specifies the parameters required to setup a
 *           timestamp. 
 * 
 *  @field   chipId
 *               Specifies the chip value. 
 *
 *  @field   slotId
 *               Specifies the slot value. 
 *
 *  @field   frameId
 *               Specifies the frame value. 
 *
 *
 *  @see
 *
 */
typedef struct _CSL_RAC_FE_Timestamp_req
{
    Uint16 chipId;
    Uint16 frameId;
    Uint8  slotId;
} CSL_RAC_FE_Timestamp_req;

#endif

