/* =============================================================================
 *   @copy    Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */                                                         
 
/** ============================================================================
 *   @file  csl_rac_regsGCCPTypes.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains all the RAC CSL specific data types and enumeration
 *          types definitions. 
 */                            

/* =============================================================================
 *  Revision History
 *  ================
 *  31-May-2005   RDefosseux     File Created.
 *  05-Jan-2006   RDefosseux     Removed some APIs for optimization
 *
 * =============================================================================
 */

#ifndef _CSL_RAC_GCCP_TYPES_H_
#define _CSL_RAC_GCCP_TYPES_H_

#include <csl_types.h>

/**
 *  @name    CSL_RAC_GCCP_cycleOverflowStatus
 *
 *  @desc    This descriptor specifies the parameters required obtained
 *           when reading the cycle overflow status register. 
 * 
 *  @field   iteNb
 *               Denotes the iteration Number.
 *
 *  @field   cycOverFlag
 *               Denotes the cycle overflow flag
 *
 *  @field   pageIdx
 *               Denotes the page index.
 *
 *  @field   taskIdx
 *               Denotes the task index.
 *
 *  @see
 *
 */
typedef struct _CSL_RAC_GCCP_cycleOverflowStatus
{
    Uint16 iteNb;
    Uint8  cycOverFlag;
    Uint8  pageIdx;
    Uint8  taskIdx;
} CSL_RAC_GCCP_cycleOverflowStatus;

/**
 *  @name    CSL_RAC_GCCP_fifoOverflowStatus
 *
 *  @desc    This descriptor specifies the parameters required obtained
 *           when reading the fifo overflow status register. 
 * 
 *  @field   iteNb
 *               Denotes the iteration Number.
 *
 *  @field   fifoId
 *               Denotes the FIFO ID
 *
 *  @field   cycOverFlag
 *               Denotes the cycle overflow flag
 *
 *  @field   pageIdx
 *               Denotes the page index.
 *
 *  @field   taskIdx
 *               Denotes the task index.
 *
 *  @see
 *
 */
typedef struct _CSL_RAC_GCCP_fifoOverflowStatus
{
    Uint16 iteNb;
	Uint8  fifoId;
    Uint8  cycOverFlag;
    Uint8  pageIdx;
    Uint8  taskIdx;
} CSL_RAC_GCCP_fifoOverflowStatus;

#endif
