/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_sgmii.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for SGMII
 *
 */
#ifndef _CSLR_SGMII_H_
#define _CSLR_SGMII_H_

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 IDVER;
    volatile Uint32 SOFT_RESET;
    volatile Uint8 RSVD0[8];
    volatile Uint32 CONTROL;
    volatile Uint32 STATUS;
    volatile Uint32 MR_ADV_ABILITY;
    volatile Uint32 MR_NP_TX;
    volatile Uint32 MR_LP_ADV_ABILITY;
    volatile Uint32 MR_LP_NP_RX;
    volatile Uint8 RSVD1[8];
    volatile Uint32 TX_CFG;
    volatile Uint32 RX_CFG;
    volatile Uint32 AUX_CFG;
    volatile Uint8 RSVD2[4];
    volatile Uint32 DIAG_CLEAR;
    volatile Uint32 DIAG_CONTROL;
    volatile Uint32 DIAG_STATUS;
} CSL_SgmiiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IDVER */

#define CSL_SGMII_IDVER_TX_IDENT_MASK    (0xFFFF0000u)
#define CSL_SGMII_IDVER_TX_IDENT_SHIFT   (0x00000010u)
#define CSL_SGMII_IDVER_TX_IDENT_RESETVAL (0x0000002Cu)

#define CSL_SGMII_IDVER_RTL_VER_MASK     (0x0000F800u)
#define CSL_SGMII_IDVER_RTL_VER_SHIFT    (0x0000000Bu)
#define CSL_SGMII_IDVER_RTL_VER_RESETVAL (0x00000000u)

#define CSL_SGMII_IDVER_MAJOR_VER_MASK   (0x00000700u)
#define CSL_SGMII_IDVER_MAJOR_VER_SHIFT  (0x00000008u)
#define CSL_SGMII_IDVER_MAJOR_VER_RESETVAL (0x00000001u)

#define CSL_SGMII_IDVER_MINOR_VER_MASK   (0x000000FFu)
#define CSL_SGMII_IDVER_MINOR_VER_SHIFT  (0x00000000u)
#define CSL_SGMII_IDVER_MINOR_VER_RESETVAL (0x00000000u)

#define CSL_SGMII_IDVER_RESETVAL         (0x002C0100u)

/* SOFT_RESET */

#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_MASK (0x00000002u)
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_SHIFT (0x00000001u)
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_RESETVAL (0x00000000u)

/*----RT_SOFT_RESET Tokens----*/
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_YES (0x00000001u)
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_NO (0x00000000u)

#define CSL_SGMII_SOFT_RESET_SOFT_RESET_MASK (0x00000001u)
#define CSL_SGMII_SOFT_RESET_SOFT_RESET_SHIFT (0x00000000u)
#define CSL_SGMII_SOFT_RESET_SOFT_RESET_RESETVAL (0x00000000u)

/*----SOFT_RESET Tokens----*/
#define CSL_SGMII_SOFT_RESET_SOFT_RESET_YES (0x00000001u)

#define CSL_SGMII_SOFT_RESET_RESETVAL    (0x00000000u)

/* CONTROL */

#define CSL_SGMII_CONTROL_TEST_PATTERN_EN_MASK (0x00000040u)
#define CSL_SGMII_CONTROL_TEST_PATTERN_EN_SHIFT (0x00000006u)
#define CSL_SGMII_CONTROL_TEST_PATTERN_EN_RESETVAL (0x00000000u)

#define CSL_SGMII_CONTROL_MASTER_MASK    (0x00000020u)
#define CSL_SGMII_CONTROL_MASTER_SHIFT   (0x00000005u)
#define CSL_SGMII_CONTROL_MASTER_RESETVAL (0x00000000u)

/*----MASTER Tokens----*/
#define CSL_SGMII_CONTROL_MASTER_MASTER  (0x00000001u)
#define CSL_SGMII_CONTROL_MASTER_SLAVE   (0x00000000u)

#define CSL_SGMII_CONTROL_LOOPBACK_MASK  (0x00000010u)
#define CSL_SGMII_CONTROL_LOOPBACK_SHIFT (0x00000004u)
#define CSL_SGMII_CONTROL_LOOPBACK_RESETVAL (0x00000000u)

/*----LOOPBACK Tokens----*/
#define CSL_SGMII_CONTROL_LOOPBACK_YES   (0x00000001u)
#define CSL_SGMII_CONTROL_LOOPBACK_NO    (0x00000000u)

#define CSL_SGMII_CONTROL_MR_NP_LOADED_MASK (0x00000008u)
#define CSL_SGMII_CONTROL_MR_NP_LOADED_SHIFT (0x00000003u)
#define CSL_SGMII_CONTROL_MR_NP_LOADED_RESETVAL (0x00000000u)

#define CSL_SGMII_CONTROL_FAST_LINK_TIMER_MASK (0x00000004u)
#define CSL_SGMII_CONTROL_FAST_LINK_TIMER_SHIFT (0x00000002u)
#define CSL_SGMII_CONTROL_FAST_LINK_TIMER_RESETVAL (0x00000000u)

#define CSL_SGMII_CONTROL_MR_AN_RESTART_MASK (0x00000002u)
#define CSL_SGMII_CONTROL_MR_AN_RESTART_SHIFT (0x00000001u)
#define CSL_SGMII_CONTROL_MR_AN_RESTART_RESETVAL (0x00000000u)

/*----MR_AN_RESTART Tokens----*/
#define CSL_SGMII_CONTROL_MR_AN_RESTART_YES (0x00000001u)

#define CSL_SGMII_CONTROL_MR_AN_ENABLE_MASK (0x00000001u)
#define CSL_SGMII_CONTROL_MR_AN_ENABLE_SHIFT (0x00000000u)
#define CSL_SGMII_CONTROL_MR_AN_ENABLE_RESETVAL (0x00000000u)

/*----MR_AN_ENABLE Tokens----*/
#define CSL_SGMII_CONTROL_MR_AN_ENABLE_YES (0x00000001u)

#define CSL_SGMII_CONTROL_RESETVAL       (0x00000000u)

/* STATUS */

#define CSL_SGMII_STATUS_FIB_SIG_DETECT_MASK (0x00000020u)
#define CSL_SGMII_STATUS_FIB_SIG_DETECT_SHIFT (0x00000005u)
#define CSL_SGMII_STATUS_FIB_SIG_DETECT_RESETVAL (0x00000000u)

#define CSL_SGMII_STATUS_LOCK_MASK       (0x00000010u)
#define CSL_SGMII_STATUS_LOCK_SHIFT      (0x00000004u)
#define CSL_SGMII_STATUS_LOCK_RESETVAL   (0x00000000u)

#define CSL_SGMII_STATUS_MR_PAGE_RX_MASK (0x00000008u)
#define CSL_SGMII_STATUS_MR_PAGE_RX_SHIFT (0x00000003u)
#define CSL_SGMII_STATUS_MR_PAGE_RX_RESETVAL (0x00000000u)

#define CSL_SGMII_STATUS_MR_AN_COMPLETE_MASK (0x00000004u)
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_SHIFT (0x00000002u)
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_RESETVAL (0x00000000u)

/*----MR_AN_COMPLETE Tokens----*/
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_DONE (0x00000001u)
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_NOT_DONE (0x00000000u)

#define CSL_SGMII_STATUS_AN_ERROR_MASK   (0x00000002u)
#define CSL_SGMII_STATUS_AN_ERROR_SHIFT  (0x00000001u)
#define CSL_SGMII_STATUS_AN_ERROR_RESETVAL (0x00000000u)

/*----AN_ERROR Tokens----*/
#define CSL_SGMII_STATUS_AN_ERROR_OCCURED (0x00000001u)
#define CSL_SGMII_STATUS_AN_ERROR_NOT_OCCURED (0x00000000u)

#define CSL_SGMII_STATUS_LINK_MASK       (0x00000001u)
#define CSL_SGMII_STATUS_LINK_SHIFT      (0x00000000u)
#define CSL_SGMII_STATUS_LINK_RESETVAL   (0x00000000u)

/*----LINK Tokens----*/
#define CSL_SGMII_STATUS_LINK_UP         (0x00000001u)
#define CSL_SGMII_STATUS_LINK_NOT_UP     (0x00000000u)

#define CSL_SGMII_STATUS_RESETVAL        (0x00000000u)

/* MR_ADV_ABILITY */

#define CSL_SGMII_MR_ADV_ABILITY_MR_ADV_ABILITY_MASK (0x0000FFFFu)
#define CSL_SGMII_MR_ADV_ABILITY_MR_ADV_ABILITY_SHIFT (0x00000000u)
#define CSL_SGMII_MR_ADV_ABILITY_MR_ADV_ABILITY_RESETVAL (0x00000000u)

#define CSL_SGMII_MR_ADV_ABILITY_RESETVAL (0x00000000u)

/* MR_NP_TX */

#define CSL_SGMII_MR_NP_TX_MR_NP_TX_MASK (0x0000FFFFu)
#define CSL_SGMII_MR_NP_TX_MR_NP_TX_SHIFT (0x00000000u)
#define CSL_SGMII_MR_NP_TX_MR_NP_TX_RESETVAL (0x00000000u)

#define CSL_SGMII_MR_NP_TX_RESETVAL      (0x00000000u)

/* MR_LP_ADV_ABILITY */

#define CSL_SGMII_MR_LP_ADV_ABILITY_MR_LP_ADV_ABILITY_MASK (0x0000FFFFu)
#define CSL_SGMII_MR_LP_ADV_ABILITY_MR_LP_ADV_ABILITY_SHIFT (0x00000000u)
#define CSL_SGMII_MR_LP_ADV_ABILITY_MR_LP_ADV_ABILITY_RESETVAL (0x00000000u)

#define CSL_SGMII_MR_LP_ADV_ABILITY_RESETVAL (0x00000000u)

/* MR_LP_NP_RX */

#define CSL_SGMII_MR_LP_NP_RX_MR_LP_NP_RX_MASK (0x0000FFFFu)
#define CSL_SGMII_MR_LP_NP_RX_MR_LP_NP_RX_SHIFT (0x00000000u)
#define CSL_SGMII_MR_LP_NP_RX_MR_LP_NP_RX_RESETVAL (0x00000000u)

#define CSL_SGMII_MR_LP_NP_RX_RESETVAL   (0x00000000u)

/* TX_CFG */

#define CSL_SGMII_TX_CFG_TX_CFG_MASK     (0xFFFFFFFFu)
#define CSL_SGMII_TX_CFG_TX_CFG_SHIFT    (0x00000000u)
#define CSL_SGMII_TX_CFG_TX_CFG_RESETVAL (0x00000000u)

#define CSL_SGMII_TX_CFG_RESETVAL        (0x00000000u)

/* RX_CFG */

#define CSL_SGMII_RX_CFG_RX_CFG_MASK     (0xFFFFFFFFu)
#define CSL_SGMII_RX_CFG_RX_CFG_SHIFT    (0x00000000u)
#define CSL_SGMII_RX_CFG_RX_CFG_RESETVAL (0x00000000u)

#define CSL_SGMII_RX_CFG_RESETVAL        (0x00000000u)

/* AUX_CFG */

#define CSL_SGMII_AUX_CFG_AUX_CFG_MASK   (0xFFFFFFFFu)
#define CSL_SGMII_AUX_CFG_AUX_CFG_SHIFT  (0x00000000u)
#define CSL_SGMII_AUX_CFG_AUX_CFG_RESETVAL (0x00000000u)

#define CSL_SGMII_AUX_CFG_RESETVAL       (0x00000000u)

/* DIAG_CLEAR */

#define CSL_SGMII_DIAG_CLEAR_DIAG_CLEAR_MASK (0x00000001u)
#define CSL_SGMII_DIAG_CLEAR_DIAG_CLEAR_SHIFT (0x00000000u)
#define CSL_SGMII_DIAG_CLEAR_DIAG_CLEAR_RESETVAL (0x00000000u)

/*----DIAG_CLEAR Tokens----*/
#define CSL_SGMII_DIAG_CLEAR_DIAG_CLEAR_SET (0x00000001u)

#define CSL_SGMII_DIAG_CLEAR_RESETVAL    (0x00000000u)

/* DIAG_CONTROL */

#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_MASK (0x00000070u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_SHIFT (0x00000004u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_RESETVAL (0x00000000u)

/*----DIAG_SM_SEL Tokens----*/
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_HOLD_SIGNAL (0x00000001u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_SYNC_STATUS (0x00000002u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_AN_STATUS (0x00000003u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_TXOS_STATUS (0x00000004u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_TXCG_STATUS (0x00000005u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_RXSM_LOW_STATUS (0x00000006u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_SM_SEL_RXSM_HIGH_STATUS (0x00000007u)

#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_MASK (0x00000003u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_SHIFT (0x00000000u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_RESETVAL (0x00000000u)

/*----DIAG_EDGE_SEL Tokens----*/
#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_LEVEL_SENSITIVE (0x00000000u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_RISING_EDGE (0x00000002u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_FALLING_EDGE (0x00000003u)
#define CSL_SGMII_DIAG_CONTROL_DIAG_EDGE_SEL_EITHER_EDGE (0x00000004u)

#define CSL_SGMII_DIAG_CONTROL_RESETVAL  (0x00000000u)

/* DIAG_STATUS */

#define CSL_SGMII_DIAG_STATUS_DIAG_STATUS_MASK (0x0000FFFFu)
#define CSL_SGMII_DIAG_STATUS_DIAG_STATUS_SHIFT (0x00000000u)
#define CSL_SGMII_DIAG_STATUS_DIAG_STATUS_RESETVAL (0x00000000u)

#define CSL_SGMII_DIAG_STATUS_RESETVAL   (0x00000000u)

#endif
