/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */                

/** ===========================================================================
 *   @file  csl_aifClose.c
 *
 *   @path  $(CSLPATH)\src\aif
 *
 *   @desc  Antenna Interface.
 *
 */                         

/* =============================================================================
 * Revision History
 * ===============
 *  26-Oct-2004 Pd File Created.
 *  21-Feb-2006 Naveen Shetti updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */

#include <csl_aif.h>
/** ============================================================================
 *   @n@b CSL_aifClose
 *
 *   @b Description
 *   @n The Close call releases the resources of the peripheral.
 *
 *   @b Arguments
 *   @verbatim
            hAifLink        Handle to the aif instance
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Close successful
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *
 *   <b> Usage Constraints: </b>
 *   Both @a CSL_aifInit() and @a CSL_aifOpen() must be called successfully
 *   in that order before CSL_aifClose() can be called.
 *   @b Example
 *   @verbatim
       CSL_AifHandle hAifLink;
       // Properly initialize and open desired link for use
       hAifLink = CSL_aifOpen(&AifLinkObj0, CSL_AIF, &aifParam, &status);
       CSL_aifClose(hAifLink);
     @endverbatim
 * =============================================================================
 */

#pragma CODE_SECTION (CSL_aifClose, ".text:csl_section:aif");
CSL_Status  CSL_aifClose(
    /** Pointer to the object that holds reference to the
     *  instance of AIF  link requested after the CSL_aifOpen(...) call
    */
    CSL_AifHandle         hAifLink
)
{
    CSL_Status  st;
    
    if (hAifLink != NULL) {
        hAifLink->regs = (CSL_AifRegsOvly)NULL;
        hAifLink->perNum   = (CSL_InstNum)-1;
        hAifLink->linkIndex = 0;        
        st = CSL_SOK;
    }
    else {
        st = CSL_ESYS_BADHANDLE;
    }
    return st;
}
