/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */



/** ===========================================================================
 *   @file  csl_aifInit.c
 *
 *   @path  $(CSLPATH)\src\aif
 *
 *   @desc  Antenna Interface Intialization.
 *
 */


/* =============================================================================
 *  Revision History
 * ===============
 *  26-Oct-2004 Pd File Created.
 *  21-Feb-2006 Naveen Shetti updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */

#include <csl_aif.h>


/** global variable definitions **/

#pragma DATA_SECTION (aifIntMemStruct, ".bss:csl_section:aif");
CSL_AifIntMemStruct aifIntMemStruct;


/**************************************************************************\
* AIF global function declarations
\**************************************************************************/

/** ============================================================================
 *   @n@b CSL_aifInit
 *   @brief Peripheral specific initialization function.
 *
 *   @b Description
 *   @n This is the peripheral specific intialization function. This function is
 *   idempotent in that calling it many times is same as calling it once.
 *   This function initializes the CSL data structures, and doesn't touches
 *   the hardware.
 *
 *   @b Arguments
 *   @verbatim
        pContext    Pointer to module-context. As AIF doesn't
                    have any context based information user is expected to pass
                    NULL.
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li  CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n  This function should be called before using any of the CSL APIs in the AIF
 *   module.
 *
 *   <b> Post Condition </b>
 *   @n  The CSL for AIF is initialized
 *
 *   @b Modifies    
 *   @n  None
 *
 *   @b Example
 *   @verbatim
          CSL_aifInit(NULL); // Init CSL for Aif module
     @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_aifInit, ".text:csl_section:aif");
CSL_Status  CSL_aifInit(
    CSL_AifContext    *pContext
)
{
   *pContext = (CSL_AifContext)&aifIntMemStruct;
   //pContext = pContext; /* To remove compiler warning/remarks */
    return CSL_SOK;
}
