/* ============================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005                 
 *                                                                             
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied.             
 * ============================================================================
 */ 

/** ===========================================================================
 * @file csl_cfgClose.c
 *
 * @brief File for functional layer of CSL API @a CSL_cfgClose()
 *
 * @path $(CSLPATH)\cfg\src
 * 
 * Description
 *   - The @a CSL_cfgClose() function definition & it's associated functions
 *
 * @date 3rd June, 2004
 * @author Chad Courtney
 * ============================================================================
 */

/* ============================================================================
 * Revision History
 * ===============
 * 11-Apr-2005 Brn updated the file for doxygen compatibiliy
 * ============================================================================
 */

#include <csl_cfg.h>

/** ===========================================================================
 *   @n@b CSL_cfgClose
 *
 *   @b Description
 *   @n This function closes the specified instance of CFG.
 *
 * <b> Usage Constraints: </b>
 * Both @a CSL_cfgInit() and @a CSL_cfgOpen() must be called successfully
 * in that order before @a CSL_cfgClose() can be called.
 *
 *   @arg  hCfg             Handle to the CFG instance
 *
 *   <b> Return Value </b>  CSL_Status
 *                          CSL_SOK            - Close successful
 *                          CSL_ESYS_BADHANDLE - Invalid handle
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n None
 *
 *   @b Example
 *   @verbatim
 
       CSL_cfgClose(hCfg);
       
    @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_cfgClose, ".text:csl_section:cfg");
CSL_Status CSL_cfgClose (
    /* Handle to the CFG instance */
    CSL_CfgHandle hCfg
)
{
    CSL_Status status;

    if (hCfg != NULL) {
        hCfg->regs = (CSL_CfgRegsOvly)NULL;
        hCfg->cfgNum = (CSL_InstNum)-1;
        
        status = CSL_SOK;
    }
    else {
        status = CSL_ESYS_BADHANDLE;
    }

    return status;
}

