/* ============================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006                 
 *                                                                              
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied.             
 * ============================================================================
 */  
 
/** ===========================================================================  
 * @file csl_cfgInit.c
 *
 * @brief File for functional layer of CSL API @a CSL_cfgInit()
 *
 * @path $(CSLPATH)\cfg\src
 * 
 * Description
 *   - The @a CSL_cfgInit() function definition & it's associated functions
 *
 * @date 14th Apr, 2005
 * @author BRN
 * ============================================================================ 
 */
 
/* =============================================================================
 * Revision History
 * ===============
 * 14-Apr-2005 Brn File Created
 * =============================================================================
 */
 
#include <csl_cfg.h>

/** ============================================================================
 *   @n@b CSL_cfgInit
 *
 *   @b Description
 *   @n This is the initialization function for the CFG. This function is
 *      idempotent in that calling it many times is same as calling it once.
 *      This function initializes the CSL data structures, and doesn't affect
 *      the H/W.
 *
 *   @b Arguments
     @verbatim
            pContext   Context information for the instance. Should be NULL
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n  None
 *
 *   @b Example
 *   @verbatim
   
        CSL_cfgInit();

     @endverbatim
 *  ===========================================================================
 */
#pragma CODE_SECTION (CSL_cfgInit, ".text:csl_section:cfg");
CSL_Status CSL_cfgInit(
    CSL_CfgContext * pContext
)
{
    return CSL_SOK;
}

