/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006                
 *                                                                              
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.             
 *   ===========================================================================
 */

/** ===========================================================================
 *  @file  csl_cicInit.c
 *
 *  @brief File for functional layer of CSL API CSL_cicInit()
 *
 *  @PATH  $(CSLPATH)\src\cic
 */

/* =============================================================================
 *  Revision History
 *  ===============
 *  1-feb-2006 Pd File Created
 * =============================================================================
 */

#include <csl_cic.h>
#include <csl_cicAux.h>

/** ============================================================================
 *   @n@b CSL_cicInit
 *
 *   @b Description
 *   @n This is the initialization function for the CIC. This function is
 *      idempotent in that calling it many times is same as calling it once.
 *      This function initializes the CSL data structures, and doesn't affect
 *      the H/W.
 *
 *   @b Arguments
 *   @verbatim
              pContext     Pointer to module-context structure
             
    @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n  None
 *
 *   @b Example
 *   @verbatim
    
    // Init Module
   ...
   if (CSL_cicInit(&context) != CSL_SOK) {
       exit;
   }
     @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_cicInit, ".text:csl_section:cic");
CSL_Status CSL_cicInit (
    CSL_CicContext   *pContext
)
{
	Uint8 i, j;
    CSL_Status status = CSL_SOK;

    if (pContext != NULL) {
         for (i = 0; i < NUM_CIC_INST; i++) {
            _CSL_cicAllocMask[i] = pContext->eventAllocMask[i];      

            for (j = 0; j < ((CSL_CIC_EVENTID_CNT + 31) / 32); j++)
                _CSL_cicAllocMask[i][j] = 0;
         }
    } 
 
    return status;
}

