/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ===========================================================================
 *   @file  csl_fsyncGetBaseAddress.c
 *
 *   @brief File for functional layer of CSL API  CSL_fsyncGetBaseAddress () 
 *
 *   @path  $(CSLPATH)\src\common
 *
 *   @desc  The  CSL_fsyncGetBaseAddress  function definition.
 */
/* =============================================================================
 * Revision History
 * ===============
 *  07-Mar-2006 NS updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */

#include <soc.h>
#include <cslr_fsync.h>
#include <csl_fsync.h>

/** ============================================================================
 *   @n@b CSL_fsyncGetBaseAddress
 *
 *   @b Description
 *   @n  This function is used for getting the base-address of the peripheral
 *       instance. This function will be called inside the @ CSL_fsyncOpen()
 *       function call. 
 *
 *       Note: This function is open for re-implementing if the user wants to 
 *       modify the base address of the peripheral object to point to a different
 *       location and there by allow CSL initiated write/reads into peripheral
 *       MMR's go to an alternate location.
 *
 *   @b Arguments
 *   @verbatim      
            fsyncNum         Specifies the instance of the FSYNC to be opened.
 
            pFsyncParam      Module specific parameters.
 
            pBaseAddress     Pointer to baseaddress structure containing base 
                             address details.
            
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK            successful on getting the base address
 *   @li                    CSL_ESYS_FAIL      The instance number is invalid.
 *   @author                CSL_ESYS_INVPARAMS Invalid parameters
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  Base Address structure is populated
 *
 *   @b Modifies
 *   @li    The status variable
 *   @li    Base address structure is modified.
 *
 *   @b Example
 *   @verbatim
        CSL_Status                status;
        CSL_FsyncBaseAddress      baseAddress;

        ...
        status = CSL_fsyncGetBaseAddress(CSL_FSYNC, NULL, &baseAddress);

    @endverbatim
 * ===========================================================================
 */
#pragma CODE_SECTION (CSL_fsyncGetBaseAddress, ".text:csl_section:fsync");

CSL_Status
CSL_fsyncGetBaseAddress (
    CSL_InstNum          fsyncNum,
    CSL_FsyncParam *          pFsyncParam,
    CSL_FsyncBaseAddress *    pBaseAddress 
)
{
    CSL_Status st = CSL_SOK;
    if (pBaseAddress == NULL) {
        return CSL_ESYS_INVPARAMS;
    }


    switch (fsyncNum)
    {
    case CSL_FSYNC:
        pBaseAddress->regs = (CSL_FsyncRegsOvly)CSL_FSYNC_0_REGS;
        break;

    default:
        pBaseAddress->regs = (CSL_FsyncRegsOvly)NULL;
        st = CSL_ESYS_FAIL;
        break;
    }

    return st;
}

