/*  ===========================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in 
 *   the license agreement under which this software has been supplied.
 *   ===========================================================================
 */
 
/** ===========================================================================
 *  @file csl_semGetBaseAddress.c
 *
 *  @brief File for functional layer of CSL API @a CSL_semGetBaseAddress()
 *
 *  @path $(CSLPATH)\sem\src
 * 
 *  Description
 *    - The @a CSL_semGetBaseAddress() function definition .
 * ============================================================================
 */ 


/* =============================================================================
 * Revision History
 * ===============
 *  10-Apr-2006 NS updated the file for DOXYGEN compatibiliy
 * =============================================================================
 */
#include <soc.h>
#include <csl_sem.h>
/** ===========================================================================
 *   @n@b CSL_semGetBaseAddress
 *
 *   @b Description
 *   @n  This function gets the base address of the given semaphore
 *       instance.
 *
 *   @b Arguments
 *   @verbatim
            semNum        Module instance number 

            pSemParam     Module specific parameters

            pBaseAddress  Pointer to base address structure containing base
                          address details
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li					CSL_SOK             Successful on getting base address of SEM module
 *   @li					CSL_ESYS_FAIL       semaphore instance is not available.
 *   @li                    CSL_ESYS_INVPARAMS  Inavlid parameters
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  Base address structure is populated
 *
 *   @b Modifies
 *   @n    1. The status variable
 *
 *         2. Base address structure is modified.
 * 
 * @b Example:
 * @verbatim

      CSL_Status status;
      CSL_semGetBaseAddress   baseAddress;

       ...
      status = CSL_semGetBaseAddress(CSL_SEM, NULL, &baseAddress);
   @endverbatim
 * ============================================================================
 */
#pragma CODE_SECTION (CSL_semGetBaseAddress, ".text:csl_section:sem");
CSL_Status  CSL_semGetBaseAddress(
	/**  Module instance number 
	 */ 	    
    CSL_InstNum        instNum,
	/** Module specific parameters.
	 */ 
    CSL_SemParam       *pSemParam,
	/** Base address details.
	 */ 
    CSL_SemBaseAddress *pBaseAddress 
)
{
    CSL_Status st = CSL_SOK;

    if (pBaseAddress == NULL) {
        return CSL_ESYS_INVPARAMS;
    }
    switch (instNum) {
        case CSL_SEM:
            pBaseAddress->regs = (CSL_SemRegsOvly)CSL_SEM_0_REGS;
            break;
            
        default:
            pBaseAddress->regs = (CSL_SemRegsOvly)NULL;
            st = CSL_ESYS_FAIL;
            break;
    }

    return st;
}
