/*  ===========================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 *   ==========================================================================
 */
/** @file  csl_dtfClose.c
 *
 *  @path $(CSLPATH)\dtf\src
 *
 *  @brief File for functional layer of CSL API @a CSL_dtfClose()
 *
 */
/* ============================================================================
 *  Revision History
 *  ===============
 *  
 *  12-Apr-2006 NG   File Created.                    
 * ============================================================================
 */
#include <csl_dtf.h>

/** ===========================================================================
 *   @n@b CSL_dtfClose
 *
 *   @b Description
 *   @n This function closes the specified instance of DTF.
 *
 *   @b Arguments
 *   @verbatim
            hDtf            Handle to the DTF

     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Close successful
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *
 *   <b> Pre Condition </b>
 *   @n  Both CSL_dtfInit() and CSL_dtfOpen() must be called successfully 
 *       in order before calling CSL_dtfClose(). 
 * 
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n DTF Handle
 *
 *   @b Example
 *   @verbatim
            CSL_DtfHandle      hDtf;
            CSL_Status         status;
            ...

            status = CSL_dtfClose(hDtf);
            ...

     @endverbatim
 * ===========================================================================
 */
#pragma CODE_SECTION (CSL_dtfClose, ".text:csl_section:dtf");

CSL_Status CSL_dtfClose (
    CSL_DtfHandle	hDtf
)
{
    CSL_Status	status;

    if (hDtf != NULL) {
        hDtf->regs = (CSL_DtfRegsOvly) NULL;
        hDtf->dtfNum = (CSL_InstNum) -1;
        status = CSL_SOK;
    }
    else {
        status = CSL_ESYS_BADHANDLE;
    }

    return status;
}

