/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  csl_edcDisable.c
 *
 *   @path  $(CSLPATH)\src\edc
 *
 *   @desc  File for functional layer of CSL API CSL_edcDisable()
 *
 */

/* =============================================================================
 *  Revision History
 *  ===============
 *  08-Jul-2004 Chad Courtney File created.
 *
 *  02-Sept-2005 ds modified.
 *
 * =============================================================================
 */
  
#include <csl_edc.h>

/** ============================================================================
 *   @n@b CSL_edcDisable
 *
 *   @b Description
 *   @n Disables the EDC for the specified memory
 *
 *   @b Arguments
 *   @verbatim
            edcMem          Specificies what memory EDC is to be disabled
 
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status 
 *   @li                    CSL_SOK            - EDC disable for specified
 *                                                memory is successful
 *   @li                    CSL_ESYS_INVPARAMS - The parameter passed is invalid
 *                                                
 *   <b> Pre Condition </b>
 *   @n  None
 *       
 *
 *   <b> Post Condition </b>
 *   @n  None
 *       
 *   @b Modifies
 *   @n None
 *
 *   @b Example
 *   @verbatim
            CSL_Status          status;
            ...
            status = CSL_edcDisable (CSL_EDC_L1P);
            ...
    @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_edcDisable, ".text:csl_section:edc");
CSL_Status  CSL_edcDisable (
    CSL_EdcMem      edcMem
)
{
    CSL_Status status = CSL_SOK;
    
    switch (edcMem) {
        case CSL_EDC_L2:
            ((CSL_EdcRegs*)CSL_EDC_0_REGS)->L2EDCMD = 
                                          CSL_FMKT(EDC_L2EDCMD_LOGICDIS, YES);
            break;
        
        case CSL_EDC_L1P:
            ((CSL_EdcRegs*)CSL_EDC_0_REGS)->L1PEDCMD =
                                         CSL_FMKT(EDC_L1PEDCMD_LOGICDIS, YES);
            break;
        
        default:
            status = CSL_ESYS_INVPARAMS;         
    }
    
    return status;  
}
