/* ============================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 * Use of this software is controlled by the terms and conditions found
 * in the license agreement under which this software has been supplied
 * priovided
 * ============================================================================
 */
/** ===========================================================================
 * @file csl_etbInit.c
 *
 * @brief File for functional layer of CSL API @a CSL_etbInit()
 *
 * @path $(CSLPATH)etb\src
 * 
 * Description
 *   - The CSL_etbInit() function definition & it's associated functions
 * ============================================================================
 */
/* =============================================================================
 * Revision History
 * ===============
 *  10-Apr-2006 NG  Author File created
 *  
 * =============================================================================
 */
#include <csl_etb.h>

/** ============================================================================
 *   @n@b CSL_etbInit
 *
 *   @b Description
 *   @n This is the initialization function for the ETB. This function must
 *      be called before calling any other API from this CSL. This function is
 *		idem-potent. Currently, the function just returns status CSL_SOK, 
 *      without doing anything.
 *
 *   @b Arguments
     @verbatim
            pContext   Context information for the instance. Should be NULL
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n  None
 *
 *   @b Example
 *   @verbatim
         CSL_Status    status;
         ...
         status = CSL_etbInit(NULL);
         ...

     @endverbatim
 *  ===========================================================================
 */
#pragma CODE_SECTION (CSL_etbInit, ".text:csl_section:etb");
CSL_Status CSL_etbInit (
    CSL_EtbContext *pContext
)
{
    return CSL_SOK;
}

