/* =============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 * =============================================================================
 */ 
/** ============================================================================
 *   @file  csl_etbRead.c
 *
 *   @path  $(CSLPATH)\etb\src
 *
 *   @desc  File for functional layer of CSL API @a CSL_etbRead()
 *
 */
/* =============================================================================
 *  Revision History
 *  ===============
 *  12-Apr-2006 NG  Author File Created 
 *
 * =============================================================================
 */
#include <csl_etb.h>

/** ============================================================================
 *   @n@b CSL_etbRead
 *
 *   @b Description
 *   @n This function reads ETB data.
 *
 *   @b Arguments
 *   @verbatim
            hEtb          Handle to ETB instance
            
            rdData        read data from the RRD

     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Read operation successful
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *   
 *   <b> Pre Condition </b>
 *   @n  Both @a CSL_etbInit() and @a CSL_etbOpen() must be called 
 *       successfully in order before calling @a CSL_etbRead().
 *
 *   <b> Post Condition </b>
 *   @n None
 *
 *   @b Modifies
 *   @n None
 *
 * @b Example:
 * @verbatim

        Uint32           rdData;
        CSL_Status       status;
        CSL_EtbHandle    hEtb;
        ...
        status = CSL_etbRead(hEtb, &rdData);
        ...

   @endverbatim
 * ===========================================================================
 */
#pragma CODE_SECTION (CSL_etbRead, ".text:csl_section:etb");

CSL_Status CSL_etbRead (
    CSL_EtbHandle    hEtb,
    void*            rdData
)
{	

	if (hEtb == NULL) {
		return CSL_ESYS_BADHANDLE;
	}	

    *((Uint32 *)rdData) = (CSL_FEXT(hEtb->regs->RRD, ETB_RRD_RRD));
	    
	return CSL_SOK;
}                          

