/* =============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 * =============================================================================
 */ 
/** ============================================================================
 *   @file  csl_etbWrite.c
 *
 *   @path  $(CSLPATH)\etb\src
 *
 *   @desc  File for functional layer of CSL API @a CSL_etbWrite()
 *
 */
/* =============================================================================
 *  Revision History
 *  ===============
 *  12-Apr-2006 NG  Author File Created 
 *
 * =============================================================================
 */
#include <csl_etb.h>

/** ============================================================================
 *   @n@b CSL_etbWrite
 *
 *   @b Description
 *   @n This function writes the specified data into ETB data register.
 *
 *   @b Arguments
 *   @verbatim
            hEtb        Handle to ETB instance
            
            wrData      write data into the RWD

     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Success (doesnot verify 
                                                           written data)
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *   @li                    CSL_ESYS_INVPARAMS  - Invalid parameter
 *
 *   <b> Pre Condition </b>
 *   @n  Both @a CSL_etbInit() and @a CSL_etbOpen() must be called 
 *       successfully in order before calling @a CSL_etbWrite().
 *
 *   <b> Post Condition </b>
 *    @n Data is written to ETB RAM Write register
 *
 *   @b Modifies
 *   @n  ETB register
 *
 * @b Example:
 * @verbatim

      Uint32           wrData;
      CSL_Status       status;
      CSL_EtbHandle    hEtb;
      ...

      status = CSL_etbWrite(hEtb, &wrData);
      ...

   @endverbatim
 * ===========================================================================
 */
#pragma CODE_SECTION (CSL_etbWrite, ".text:csl_section:etb");

CSL_Status CSL_etbWrite ( 
    CSL_EtbHandle    hEtb,
    void             *wrData
)
{   

    if (hEtb == NULL) {
		return CSL_ESYS_BADHANDLE;
	}
    else if (wrData == NULL) {
        return CSL_ESYS_INVPARAMS;
    }

    CSL_FINS(hEtb->regs->RWD, ETB_RWD_RWD, *(Uint32 *)wrData);
	return CSL_SOK;
}

