/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
  
/** ===========================================================================
 *   @file  csl_fsyncClose.c
 *
 *   @brief File for functional layer of CSL API CSL_fsyncClose() 
 *
 *   @path  $(CSLPATH)\src\fsync
 *
 *   @desc  The CSL_fsyncClose function definition.
 */
 

/* =============================================================================
 * Revision History
 * ===============
 *  07-Mar-2006 NS updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */

#include <csl_fsync.h>

/** ============================================================================
 *   @n@b CSL_fsyncClose
 *
 *   @b Description
 *   @n This function closes the specified instance of FSYNC.
 *
 *   @b Arguments
 *   @verbatim
            hFsync            Handle to the FSYNC instance
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Close successful
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *
 *   @b Example
 *   @verbatim
        // handle for Fsync
        CSL_FsyncHandle handleFsync;
        //  Fsync object
        CSL_FsyncObj myFsyncObj;
        // CSL status
        CSL_Status status;

        // Initialize CSL library, this step is not required 
        CSL_fsyncInit(NULL);

        // Open handle to FSync 
        handleFsync = CSL_fsyncOpen(&myFsyncObj, CSL_FSYNC, NULL, &status);

        . . . 
        . . .
        . . .

        CSL_fsyncClose(handleFsync);
     @endverbatim
 * =============================================================================
 */


#pragma CODE_SECTION (CSL_fsyncClose, ".text:csl_section:fsync");
CSL_Status  CSL_fsyncClose(
    /** Pointer to the object that holds reference to the
     *  instance of FSYNC  link requested after the CSL_fsyncOpen(...) call
    */
    CSL_FsyncHandle           hFsync
)
{
   CSL_Status  status;                                                            
                                                                               
    if (hFsync != NULL) {                                                        
        hFsync->regs    = (CSL_FsyncRegsOvly)NULL;                                 
        hFsync->perNum  = (CSL_InstNum)-1;                                       
        status            = CSL_SOK;                                               
    }                                                                          
    else {                                                                     
        status = CSL_ESYS_BADHANDLE;                                               
    }                                                                          
    return status;

}
