/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
 
/** ===========================================================================
 *   @file  csl_fsyncInit.c
 *
 *   @brief File for functional layer of CSL API CSL_fsyncInit () 
 *
 *   @path  $(CSLPATH)\src\fsync
 *
 *   @desc  The CSL_fsyncInit() function definition.
 */ 

/* =============================================================================
 * Revision History
 * ===============
 *  07-Mar-2006 NS updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */

#include  <csl_fsync.h>
/** ============================================================================
 *   @n@b CSL_fsyncInit
 *
 *   @b Description
 *   @n This is the initialization function for the FSYNC CSL.
 *      The function must be called before calling any other API from this CSL.
 *      This function is idem-potent. Currently, the function just return
 *      status CSL_SOK, without doing anything.
 *
 *   @b Arguments
 *   @verbatim
        pContext    Pointer to module-context. As FSYNC doesn't
                    have any context based information user is expected to pass
                    NULL.
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li  CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n This function should be called before using any of the CSL APIs in the FSYNC
 *   module.
 *
 *   <b> Post Condition </b>
 *   @n  The CSL for FSYNC is initialized
 *
 *   @b Modifies    
 *   @n  None
 *
 *   @b Example
 *   @verbatim
          CSL_fsyncInit(NULL); // Init CSL for FSync module
     @endverbatim
 * =============================================================================
 */


#pragma CODE_SECTION (CSL_fsyncInit, ".text:csl_section:fsync");
CSL_Status CSL_fsyncInit(CSL_FsyncContext *pContext)
{
   // nothing to do, so return CSL_OK
   return CSL_SOK;

}



