/* ============================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 * Use of this software is controlled by the terms and conditions found
 * in the license agreement under which this software has been supplied
 * provided
 * ============================================================================
*/

/** ==========================================================================
 * @file csl_gpioGetHwSetup.c
 *
 * @brief File for functional layer of CSL API CSL_gpioGetHwSetup() 
 * 
 * @path $(CSLPATH)\src\gpio
 * 
 * @desc The CSL_gpioGetHwSetup() function definition & it's associated functions
 * ============================================================================
 */

/* ============================================================================
 * Revision History
 * ===============
 * 10-Jun-2004 PGR file created
 * 04-Sep-2004 Nsr File Created from CSL_gpioHwControl.c And 
 *                  CSL_gpioGetHwStatus.c.
 * 04-Sep-2004 Nsr Added inline functions for query commands also.
 * 11-Oct-2004 Nsr Changed this file according to review commnets.
 * 22-Feb-2005 Nsr Added CSL_gpioGetBit API according to TI Issue PSG00000310.
 * 03-Mar-2005 Nsr Updated changes (PSG00000289) in CSL_gpioSetBit and 
 *                 CSL_gpioClearBit.
 * 28-Jul-2005 PSK Updated CSL source to supportonly ONE BANK.
 *                 bank "index" is removed.
 * ============================================================================
 */
 
#include <csl_gpio.h>

/** ============================================================================
 *   @n@b CSL_gpioGetHwSetup
 *
 *   @b Description
 *   @n Gets the current setup of GPIO. Here it is dummy function.
 *
 *   @b Arguments
 *   @verbatim
            hGpio            Handle to the GPIO instance

            setup           Pointer to setup structure to hold the
                            setup information of GPIO.
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Always returns.
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n Hardware registers of the specified GPIO instance.
 *
 *   @b Example
 *   @verbatim
        CSL_GpioHandle       hGpio;
        CSL_GpioHwSetup      setup;
        CSL_Status           status;

        status = CSL_gpioGetHwSetup(hGpio, &setup);
     @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_gpioGetHwSetup, ".text:csl_section:gpio");
CSL_Status CSL_gpioGetHwSetup ( 
    CSL_GpioHandle  hGpio,
    CSL_GpioHwSetup *setup
)
{
    return CSL_SOK;
}
