/* ==========================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 * Use of this software is controlled by the terms and conditions found
 * in the license agreement under which this software has been supplied
 * provided
 * ==========================================================================
*/

/** ===========================================================================
 * @file csl_gpioHwSetup.c
 *
 * @brief File for functional layer of CSL API CSL_gpioHwSetup()
 *
 * @path $(CSLPATH)\src\gpio
 *
 * @Desc The CSL_gpioHwSetup() function definition,currently just a place 
 *       holder
 * ============================================================================
 */
 
/* ============================================================================ 
 * Revision History
 * =================
 * 10-Jun-2004 PGR file created
 * ============================================================================
 */

#include <csl_gpio.h>

/** ============================================================================
 *   @n@b CSL_gpioHwSetup
 *
 *   @b Description
 *   @n It configures the gpio registers as per the values passed
 *      in the hardware setup structure. But here it is a dummy function
 *
 *   @b Arguments
 *   @verbatim
            hGpio            Handle to the GPIO instance

            hwSetup          Pointer to hardware setup structure
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Always returns
 *
 *   @b Modifies
 *   @n The hardware registers of GPIO.
 *
 *   @b Example
 *   @verbatim
        CSL_GpioHandle    hGpio;
        CSL_GpioObj       gpioObj;
        CSL_GpioHwSetup   hwSetup;
        CSL_status       status;

        ...

        hGpio = CSL_gpioOpen(&gpioObj, CSL_GPIO, NULL, &status);

        status = CSL_gpioHwSetup(hGpio, &hwSetup);
 *   @endverbatim
 * =============================================================================
 */ 
#pragma CODE_SECTION (CSL_gpioHwSetup, ".text:csl_section:gpio");
CSL_Status CSL_gpioHwSetup (
    CSL_GpioHandle  hGpio, 
    CSL_GpioHwSetup *setup
)
{
    return CSL_SOK;
}

