/* ==========================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005 
 *
 * Use of this software is controlled by the terms and conditions found
 * in the license agreement under which this software has been supplied
 * provided
 * ==========================================================================
*/

/** ===========================================================================
 * @file csl_gpioInit.c
 *
 * @brief File for functional layer of CSL API CSL_gpioInit() 
 * 
 * @path $(CSLPATH)\src\gpio
 * 
 * @Desc The CSL_gpioInit() function definition & it's associated functions
 * ============================================================================
 */
 
/* ============================================================================
 * Revision History
 * ===============
 * 09-Jun-2004 PGR File created
 * 04-Sep-2004 Nsr Updated the function and documentation for CSL_gpioInit.
 * 11-oct-2004 Nsr updated the code to avoid compiler warning/remark.
 * 28-Jul-2005 PSK updated changes to support only one BANK
 * ============================================================================
 */
 

#include <csl_gpio.h>

/** ===========================================================================
 *   @n@b CSL_gpioInit
 *
 *   @b Description
 *   @n This is the initialization function for the GPIO. This function is
 *      idempotent in that calling it many times is same as calling it once.
 *      This function initializes the CSL data structures, and doesn't affect
 *      the H/W.
 *
 *   @b Arguments
 *   @verbatim
 *          pContext   Context information for the instance. Should be NULL
 *   @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n  None
 *
 *   <b> Post Condition </b>
 *   @n  None
 *
 *   @b Modifies
 *   @n  None
 *
 *   @b Example
 *   @verbatim
 *    ...
 *      CSL_gpioInit();
 *   @endverbatim
 *  ===========================================================================
 */ 
#pragma CODE_SECTION (CSL_gpioInit, ".text:csl_section:gpio");
CSL_Status CSL_gpioInit (
    CSL_GpioContext *pContext
)
{
    *pContext = *pContext;
    
    return CSL_SOK;
}

