/* ============================================================================
 * Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005                 
 *                                                                              
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied.             
 * ============================================================================
 */ 

/** =========================================================================== 
 *  @file csl_pwrdwnClose.c
 *
 *  @brief File for functional layer of CSL API @a CSL_pwrdwnClose()
 *
 *  @path $(CSLPATH)\memprot\src
 * 
 *  Description
 *   - The @a CSL_pwrdwnClose() function definition & it's associated functions
 *
 *  Modification 1
 *    - Modified on: 7/16/2004
 *    - Reason: created the sources
 *
 *  @author Ruchika Kharwar.
 *  ===========================================================================
 */

#include <csl_memprot.h>

/** ===========================================================================
 *   @n@b CSL_memprotClose
 *
 *   @b Description
 *   @n This function closes the specified instance of MEMPROT.
 *
 *   @b Arguments
 *   @verbatim
            hMem            Handle to the MEMPROT instance
     @endverbatim
 *    
 *   <b> Usage Constraints: </b>
 *   CSL_memprotInit(), CSL_memprotOpen() must be opened prior to this call.
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Close successful
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *
 *   @b Example
 *   @verbatim
            CSL_MemprotHandle   hMem;
            CSL_status          status;

            ...   
            status = CSL_memprotClose(hMem);
     @endverbatim
 * ============================================================================
 */ 
#pragma CODE_SECTION (CSL_memprotClose, ".text:csl_section:memprot");
CSL_Status CSL_memprotClose (
    /* Pointer to the object that holds reference to the
     * instance of I2C requested after the call 
     */
    CSL_MemprotHandle hMemprot
)
{
    /* Indicate in the CSL global data structure that the peripheral
     * has been unreserved   */
    if (hMemprot == NULL) {
        return CSL_ESYS_BADHANDLE; 
    }

    return(CSL_SOK);
}

