/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */

/** ============================================================================
 *   @file  csl_psc.c
 *
 *   PATH:  \$(CSLPATH)\\src\\psc
 *
 *   @brief  PSC CSL Implementation on DSP side
 *           This file contains functions definations to enable peripherals, like
 *           TCP, VCP, SRIO, RAC, AIF and RSAs on DSP chip
 * =============================================================================
 */

/* =============================================================================
 *  Revision History
 *  ===============
 *  14-Mar-06 PSK File created
 * =============================================================================
 */


// Various functions to enable specific module in Faraday PSC.
#include <csl_types.h>

#define PSC_BASE    0x02AC0000

#define PSC_PTCMD   PSC_BASE + 0x120
#define PSC_PTSTAT  PSC_BASE + 0x128

#define PSC_PDCTL0  PSC_BASE + 0x300
#define PSC_PDCTL1  PSC_BASE + 0x304
#define PSC_PDCTL2  PSC_BASE + 0x308
#define PSC_PDCTL3  PSC_BASE + 0x30C
#define PSC_PDCTL4  PSC_BASE + 0x310
#define PSC_PDCTL5  PSC_BASE + 0x314

#define PSC_MDCTL0  PSC_BASE + 0xA00
#define PSC_MDCTL1  PSC_BASE + 0xA04
#define PSC_MDCTL2  PSC_BASE + 0xA08
#define PSC_MDCTL6  PSC_BASE + 0xA18
#define PSC_MDCTL7  PSC_BASE + 0xA1C
#define PSC_MDCTL8  PSC_BASE + 0xA20
#define PSC_MDCTL9  PSC_BASE + 0xA24
#define PSC_MDCTL10 PSC_BASE + 0xA28

Uint32 readperiph (Uint32 Addr)
{
  Uint32 *Loc;
  Loc = (Uint32 *) Addr;
  return (*Loc);
}

void writeperiph (Uint32 Addr, Uint32 Data)
{
  Uint32 *Loc;
  Loc  = (Uint32 *) Addr;
  *Loc = Data;
}

// This function is used to Enable AIF in PSC control module.
void enableAIF(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL1);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL1, data);

        data = readperiph(PSC_MDCTL6);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL6, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000002;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000002 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

// This function is used to Enable RAC in PSC control module.
void enableRAC(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL3);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL3, data);

        data = readperiph(PSC_MDCTL8);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL8, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000008;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000008 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

// This function is used to Enable SRIO in PSC control module.
void enableSRIO(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL2);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL2, data);

        data = readperiph(PSC_MDCTL7);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL7, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000004;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000004 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

// This function is used to Enable TCP in PSC control module.
void enableTCP(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL4);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL4, data);

        data = readperiph(PSC_MDCTL9);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL9, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000010;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000010 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

// This function is used to Enable VCP in PSC control module.
void enableVCP(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL5);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL5, data);

        data = readperiph(PSC_MDCTL10);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL10, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000020;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000020 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

// This function is used to Enable RSA0 in PSC control module.
void enableRSA0(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL0);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL0, data);

        data = readperiph(PSC_MDCTL0);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL0, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000001;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000001 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

// This function is used to Enable RSA1 in PSC control module.
void enableRSA1(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL0);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL0, data);

        data = readperiph(PSC_MDCTL1);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL1, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000001;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000001 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}


// This function is used to Enable RSA2 in PSC control module.
void enableRSA2(void)

{
        Uint32 data;

        data = readperiph(PSC_PDCTL0);
        data = data | 0x00000001;
        writeperiph(PSC_PDCTL0, data);

        data = readperiph(PSC_MDCTL2);
        data = data | 0x00000003;
        writeperiph(PSC_MDCTL2, data);

        data = readperiph(PSC_PTCMD);
        data = data | 0x00000001;
        writeperiph(PSC_PTCMD, data);

        /* wait till ptstat.go goes to zero */
        do { data = 0x00000001 & readperiph(PSC_PTSTAT); } while (data != 0x0);

}

