/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
 
/** ===========================================================================
 *  @file csl_semClose.c
 *
 *  @brief File for functional layer of CSL API @a CSL_semClose()
 *
 *  @path $(CSLPATH)\sem\src
 * 
 *  Description
 *    - The @a CSL_semClose() function definition. 
 */ 

/* =============================================================================
 * Revision History
 * ===============
 *  10-Apr-2006 NS updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */
 
#include <csl_sem.h>

/** ============================================================================
 *   @n@b CSL_semClose
 *
 *   @b Description
 *   @n The Close call releases the channel of the peripheral.
 *
 *   @b Arguments
 *   @verbatim
            hSem            Handle to the SEM instance
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li                    CSL_SOK             - Close successful
 *   @li                    CSL_ESYS_BADHANDLE  - Invalid handle
 *
 *   @b Example
 *   @verbatim
        // handle for SEM
          CSL_SemHandle handleSem;
          //  SEM object 
          CSL_SemObj            *pSemObj;
          // CSL status
          CSL_Status status;
          CSL_SemParam       pSemParam;
          //Number of SEM resources    
          pSemParam.flags = 2

  
          CSL_semInit(NULL); // Init CSL for SEM module, this step is not required
 
          // Open handle for SEM module 
          handleSem = CSL_semOpen (pSemObj, CSL_SEM, &pSemParam, &status);

          . . . 
          . . .
          . . .

        CSL_semClose(handleSem);
     @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_semClose, ".text:csl_section:sem");
CSL_Status CSL_semClose (
    /*
     * Pointer to the object that holds reference to the
     * instance of SEM requested after the call
     */
    CSL_SemHandle   hSem
)
{
    CSL_Status status;

    if (hSem != NULL) {
        hSem->regs = (CSL_SemRegsOvly)NULL;
        hSem->instNum = (CSL_InstNum)-1;
        hSem->semNum = -1;        
        status = CSL_SOK;
    }
    else {
        status = CSL_ESYS_BADHANDLE;
    }
    
    return status;
}
