/*   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
 
/** ===========================================================================
 *   @file  csl_semInit.c
 *
 *   @brief File for the functional layer API's of sem @a CSL_semInit()
 *
 *   @path  $(CSLPATH)sem\src
 *
 *   @desc  - The CSL_semInit() function definition.
 */ 

/* =============================================================================
 * Revision History
 * ===============
 *  10-Apr-2006 NS updated the file for DOXYGEN compatibiliy
 *
 * =============================================================================
 */

#include <csl_sem.h>

/** ============================================================================
 *   @n@b CSL_semInit
 *
 *   @b Description
 *   @n This is the initialization function for the SEM CSL.
 *      The function must be called before calling any other API from this CSL.
 *      This function is idem-potent. Currently, the function just return
 *      status CSL_SOK, without doing anything.
 *
 *   @b Arguments
 *   @verbatim
        pContext    Pointer to module-context. As SEM doesn't
                    have any context based information user is expected to pass
                    NULL.
     @endverbatim
 *
 *   <b> Return Value </b>  CSL_Status
 *   @li  CSL_SOK - Always returns
 *
 *   <b> Pre Condition </b>
 *   @n This function should be called before using any of the CSL APIs in the SEM
 *   module.
 *
 *   <b> Post Condition </b>
 *   @n  The CSL for SEM is initialized
 *
 *   @b Modifies    
 *   @n  None
 *
 *   @b Example
 *   @verbatim
        CSL_SemContext SemContext;  
       if (CSL_SOK != CSL_semInit(&SemContext) {     // Init CSL for sem module

           return;
          }
     @endverbatim
 * =============================================================================
 */
#pragma CODE_SECTION (CSL_semInit, ".text:csl_section:sem"); 
CSL_Status CSL_semInit(
    CSL_SemContext *pContext
)
{
    pContext = pContext;

	return CSL_SOK;
}
