#include <cslr.h>
#include <cslr_srio.h>


/**************************************************************************\
* Peripheral Instance count
\**************************************************************************/

 #define SRIO_PER_CNT                  1

  extern cregister volatile unsigned int NRP;
 #define SET_TRACE(val) NRP = val

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
  typedef CSL_SrioRegs    SRIO_Regs;
// Powersaver Registers
  #define PSVR_LCKREG       ((Uint32 *) 0x02AC0004u)
  #define PSVR_MDCTL0       ((Uint32 *) 0x02AC0008u)
  #define PSVR_SRIOEN       0xC0000000
  #define PSVR_LCKVAL       0x0F0A0B00

#define PSC_BASE   0x02AC0000
#define PSC_PDCTL1 PSC_BASE + 0x304
#define PSC_PDCTL2 PSC_BASE + 0x308
#define PSC_PDCTL3 PSC_BASE + 0x30C
#define PSC_MDCTL6 PSC_BASE + 0xA18
#define PSC_MDCTL7 PSC_BASE + 0xA1C
#define PSC_MDCTL8 PSC_BASE + 0xA20
#define PSC_PTCMD  PSC_BASE + 0x120
#define PSC_PTSTAT PSC_BASE + 0x128



  /**************************************************************************\
* Peripheral Base Address
\**************************************************************************/
  #define SRIO_BASEADDR                						(0x02D00000u)
  #define SRIO_REGS                    		((CSL_SrioRegs *) 0x02D00000u)
	//pointer to a structure of type CSL_SrioRegs

    #define SRIO_CPPI_RAM_BASEADDR		(0x02E00000u) //CPPI RAM
    #define Device_Status_Register		(0x01B3F004u)

    //pointer to buffer descriptor

    #define TXU_DESC_BASE (0x20000000u)
    #define TXU_DATA_BASE (0x30000000u)
    #define TX_DESC       ((CSL_SrioTxdesc *) TXU_DESC_BASE)
    #define RXU_DESC_BASE (0x20000000u)
    #define RXU_DATA_BASE (0x30000000u)
    #define RX_DESC       ((CSL_SrioRxdesc *) RXU_DESC_BASE)

    //TX Buffer Descriptors
    #define TX_DESCP0_0       ((CSL_SrioTxdesc *) 0x02E00000u)
    #define TX_DESCP0_1       ((CSL_SrioTxdesc *) 0x02E00010u)
    #define TX_DESCP0_2       ((CSL_SrioTxdesc *) 0x02E00020u)
    #define TX_DESCP0_3       ((CSL_SrioTxdesc *) 0x02E00030u)
    #define TX_DESCP0_4       ((CSL_SrioTxdesc *) 0x02E00040u)
    #define TX_DESCP0_5       ((CSL_SrioTxdesc *) 0x02E00050u)
    #define TX_DESCP0_6       ((CSL_SrioTxdesc *) 0x02e00060u)
    #define TX_DESCP0_7       ((CSL_SrioTxdesc *) 0x02e00070u)
    #define TX_DESCP0_8       ((CSL_SrioTxdesc *) 0x02e00080u)
    #define TX_DESCP0_9       ((CSL_SrioTxdesc *) 0x02e00090u)
    #define TX_DESCP0_10       ((CSL_SrioTxdesc *) 0x02e000a0u)
    #define TX_DESCP0_11       ((CSL_SrioTxdesc *) 0x02e000b0u)
    #define TX_DESCP0_12       ((CSL_SrioTxdesc *) 0x02e000c0u)
    #define TX_DESCP0_13       ((CSL_SrioTxdesc *) 0x02e000d0u)
    #define TX_DESCP0_14       ((CSL_SrioTxdesc *) 0x02e000e0u)
    #define TX_DESCP0_15       ((CSL_SrioTxdesc *) 0x02e000f0u)

    #define TX_DESCP1_0       ((CSL_SrioTxdesc *) 0x02E00200u)
    #define TX_DESCP1_1       ((CSL_SrioTxdesc *) 0x02E00210u)
    #define TX_DESCP1_2       ((CSL_SrioTxdesc *) 0x02E00220u)
    #define TX_DESCP1_3       ((CSL_SrioTxdesc *) 0x02E00230u)
    #define TX_DESCP1_4       ((CSL_SrioTxdesc *) 0x02E00240u)
    #define TX_DESCP1_5       ((CSL_SrioTxdesc *) 0x02E00250u)
	#define TX_DESCP1_6       ((CSL_SrioTxdesc *) 0x02e00260u)
    #define TX_DESCP1_7       ((CSL_SrioTxdesc *) 0x02e00270u)
    #define TX_DESCP1_8       ((CSL_SrioTxdesc *) 0x02e00280u)
    #define TX_DESCP1_9       ((CSL_SrioTxdesc *) 0x02e00290u)
    #define TX_DESCP1_10       ((CSL_SrioTxdesc *) 0x02e002a0u)
    #define TX_DESCP1_11       ((CSL_SrioTxdesc *) 0x02e002b0u)
    #define TX_DESCP1_12       ((CSL_SrioTxdesc *) 0x02e002c0u)
    #define TX_DESCP1_13       ((CSL_SrioTxdesc *) 0x02e002d0u)
    #define TX_DESCP1_14       ((CSL_SrioTxdesc *) 0x02e002e0u)
    #define TX_DESCP1_15       ((CSL_SrioTxdesc *) 0x02e002f00u)

    #define TX_DESCP2_0       ((CSL_SrioTxdesc *) 0x02E00410u)
    #define TX_DESCP2_1       ((CSL_SrioTxdesc *) 0x02E00420u)
    #define TX_DESCP2_2       ((CSL_SrioTxdesc *) 0x02E00430u)
    #define TX_DESCP2_3       ((CSL_SrioTxdesc *) 0x02E00440u)
    #define TX_DESCP2_4       ((CSL_SrioTxdesc *) 0x02E00450u)
    #define TX_DESCP2_5       ((CSL_SrioTxdesc *) 0x02E00460u)
    #define TX_DESCP2_6       ((CSL_SrioTxdesc *) 0x02e00470u)
    #define TX_DESCP2_7       ((CSL_SrioTxdesc *) 0x02e00480u)
    #define TX_DESCP2_8       ((CSL_SrioTxdesc *) 0x02e00490u)
    #define TX_DESCP2_9       ((CSL_SrioTxdesc *) 0x02e004a0u)
    #define TX_DESCP2_10       ((CSL_SrioTxdesc *) 0x02e004b0u)
    #define TX_DESCP2_11       ((CSL_SrioTxdesc *) 0x02e004c0u)
    #define TX_DESCP2_12       ((CSL_SrioTxdesc *) 0x02e004d0u)
    #define TX_DESCP2_13       ((CSL_SrioTxdesc *) 0x02e004e0u)
    #define TX_DESCP2_14       ((CSL_SrioTxdesc *) 0x02e004f0u)
    #define TX_DESCP2_15       ((CSL_SrioTxdesc *) 0x02e00500u)

    #define TX_DESCP3_0       ((CSL_SrioTxdesc *) 0x02E00610u)
    #define TX_DESCP3_1       ((CSL_SrioTxdesc *) 0x02E00620u)
    #define TX_DESCP3_2       ((CSL_SrioTxdesc *) 0x02E00630u)
    #define TX_DESCP3_3       ((CSL_SrioTxdesc *) 0x02E00640u)
    #define TX_DESCP3_4       ((CSL_SrioTxdesc *) 0x02E00650u)
    #define TX_DESCP3_5       ((CSL_SrioTxdesc *) 0x02E00660u)
  	#define TX_DESCP3_6       ((CSL_SrioTxdesc *) 0x02e00670u)
    #define TX_DESCP3_7       ((CSL_SrioTxdesc *) 0x02e00680u)
    #define TX_DESCP3_8       ((CSL_SrioTxdesc *) 0x02e00690u)
    #define TX_DESCP3_9       ((CSL_SrioTxdesc *) 0x02e006a0u)
    #define TX_DESCP3_10       ((CSL_SrioTxdesc *) 0x02e006b0u)
    #define TX_DESCP3_11       ((CSL_SrioTxdesc *) 0x02e006c0u)
    #define TX_DESCP3_12       ((CSL_SrioTxdesc *) 0x02e006d0u)
    #define TX_DESCP3_13       ((CSL_SrioTxdesc *) 0x02e006e0u)
    #define TX_DESCP3_14       ((CSL_SrioTxdesc *) 0x02e006f0u)
    #define TX_DESCP3_15       ((CSL_SrioTxdesc *) 0x02e00700u)



    //RX Buffer Descriptors
    #define RX_DESCP0_0       ((CSL_SrioRxdesc *) 0x02E02000u)
    #define RX_DESCP0_1       ((CSL_SrioRxdesc *) 0x02E02010u)
    #define RX_DESCP0_2       ((CSL_SrioRxdesc *) 0x02E02020u)
    #define RX_DESCP0_3       ((CSL_SrioRxdesc *) 0x02E02030u)
    #define RX_DESCP0_4       ((CSL_SrioRxdesc *) 0x02E02040u)
    #define RX_DESCP0_5       ((CSL_SrioRxdesc *) 0x02E02050u)
	#define RX_DESCP0_6       ((CSL_SrioRxdesc *) 0x02e02060u)
    #define RX_DESCP0_7       ((CSL_SrioRxdesc *) 0x02e02070u)
    #define RX_DESCP0_8       ((CSL_SrioRxdesc *) 0x02e02080u)
    #define RX_DESCP0_9       ((CSL_SrioRxdesc *) 0x02e02090u)
    #define RX_DESCP0_10       ((CSL_SrioRxdesc *) 0x02e020a0u)
    #define RX_DESCP0_11       ((CSL_SrioRxdesc *) 0x02e020b0u)
    #define RX_DESCP0_12       ((CSL_SrioRxdesc *) 0x02e020c0u)
    #define RX_DESCP0_13       ((CSL_SrioRxdesc *) 0x02e020d0u)
    #define RX_DESCP0_14       ((CSL_SrioRxdesc *) 0x02e020e0u)
    #define RX_DESCP0_15       ((CSL_SrioRxdesc *) 0x02e020f0u)
    
    #define RX_DESCP1_0       ((CSL_SrioRxdesc *) 0x02E02210u)
    #define RX_DESCP1_1       ((CSL_SrioRxdesc *) 0x02E02220u)
    #define RX_DESCP1_2       ((CSL_SrioRxdesc *) 0x02E02230u)
    #define RX_DESCP1_3       ((CSL_SrioRxdesc *) 0x02E02240u)
    #define RX_DESCP1_4       ((CSL_SrioRxdesc *) 0x02E02250u)
    #define RX_DESCP1_5       ((CSL_SrioRxdesc *) 0x02E02260u)


    #define RX_DESCP2_0       ((CSL_SrioRxdesc *) 0x02E02410u)
    #define RX_DESCP2_1       ((CSL_SrioRxdesc *) 0x02E02420u)
    #define RX_DESCP2_2       ((CSL_SrioRxdesc *) 0x02E02430u)
    #define RX_DESCP2_3       ((CSL_SrioRxdesc *) 0x02E02440u)
    #define RX_DESCP2_4       ((CSL_SrioRxdesc *) 0x02E02450u)
    #define RX_DESCP2_5       ((CSL_SrioRxdesc *) 0x02E02460u)

    #define RX_DESCP3_0       ((CSL_SrioRxdesc *) 0x02E02610u)
    #define RX_DESCP3_1       ((CSL_SrioRxdesc *) 0x02E02620u)
    #define RX_DESCP3_2       ((CSL_SrioRxdesc *) 0x02E02630u)
    #define RX_DESCP3_3       ((CSL_SrioRxdesc *) 0x02E02640u)
    #define RX_DESCP3_4       ((CSL_SrioRxdesc *) 0x02E02650u)
    #define RX_DESCP3_5       ((CSL_SrioRxdesc *) 0x02E02660u)

	#define REQ_MAINT_RD  	0x80 //0b10000000  // ftype=8
	#define REQ_MAINT_WR  	0x81 //0b10000001  // ftype=8
	#define REQ_MAINT_RD_R  0x82 //0b10000010  // ftype=8
	#define REQ_MAINT_WR_R  0x83 //0b10000011  // ftype=8
	#define REQ_MAINT_PW  	0x84 //0b10000100  // ftype=8
	#define REQ_ATOMIC_INC	0x2C //0b00101100  // ftype=2
	#define REQ_ATOMIC_DEC	0x2D //0b00101101  // ftype=2
	#define REQ_ATOMIC_SET	0x2E //0b00101110  // ftype=2
	#define REQ_ATOMIC_CLR	0x2F //0b00101111  // ftype=2
	#define REQ_ATOMIC_TNS	0x5E //0b01011110  // ftype=5
	#define REQ_NREAD     	0x24 //0b00100100  // ftype=2
	#define REQ_NWRITE    	0x54 //0b01010100  // ftype=5
	#define REQ_NWRITE_R  	0x55 //0b01010101  // fypte=5
	#define REQ_SWRITE    	0x60 //0b01100000  // ftype=6
	#define REQ_DOORBELL  	0xA0 //0b10100000  // ftype=10

	#define SSIZE_8B        0x9 //     0b1001
	#define SSIZE_16B       0xA //     0b1010
	#define SSIZE_32B       0xB //     0b1011
	#define SSIZE_64B       0xC //     0b1100
	#define SSIZE_128B      0xD //     0b1101
	#define SSIZE_256B      0xE //     0b1110

	#define MLEN_1DW		0x01
	#define MLEN_2DW		0x02
	#define MLEN_10DW		0x0A
	#define MLEN_20DW		0x14
	#define MLEN_16DW		0x10
	#define MLEN_32DW       0x20
	#define MLEN_64DW       0x40
	#define MLEN_128DW      0x80
	#define MLEN_256DW      0x100
	#define MLEN_512DW      0x000 
	#define MLEN_511DW      0x1ff

//  extern volatile int RxCount,TxCount,ErrCount;   	/* RX, TX, and Error counted in ISR */

	// _20 RIO_INT RapidIO interrupt
	//Device Status Register Description bit16 RIO_EN (0x01B3F004u)

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 TXDESC0;
    volatile Uint32 TXDESC1;
    volatile Uint32 TXDESC2;
    volatile Uint32 TXDESC3;
} CSL_SrioTxdesc;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 RXDESC0;
    volatile Uint32 RXDESC1;
    volatile Uint32 RXDESC2;
    volatile Uint32 RXDESC3;
} CSL_SrioRxdesc;

#define SRIO_DSC_FLAG_SOP 				0x80000000 
#define SRIO_DSC_FLAG_EOP 				0x40000000 
#define SRIO_DSC_FLAG_OWNERSHIP         0x20000000 
#define SRIO_DSC_FLAG_EOQ               0x10000000 
#define SRIO_DSC_FLAG_TDOWNCMPLT        0x08000000 
