/*****************************************************************************/
/*          Copyright (C) 2003-2004 Texas Instruments Incorporated.          */
/*                          All Rights Reserved                              */
/*---------------------------------------------------------------------------*/
/* File Name     : val_util.h                                                */
/* Created on    : Sept 26, 2005                                             */
/* Created By    :                                                           */
/* Last modified :                                                           */
/*---------------------------------------------------------------------------*/
/* Description   : Contains common utility and test reporting functions      */
/*                 for Faraday                                               */
/* History       :                                                           */
/*****************************************************************************/

#ifndef _VAL_UTIL_H_
#define _VAL_UTIL_H_

#include <csl.h>

#define PASS		(0)
#define FAIL		(1)

#define SUCCESS		PASS
#define FAILURE		FAIL

#define FILL_FIX    (0) /* Used for DataFill function */
#define FILL_INC    (1)
#define FILL_DEC    (2)

/*---------------------------------------------------------------------------*/
/* Macros for tracing debug info into NRP register                           */
/*---------------------------------------------------------------------------*/
extern __cregister volatile Uint32 NRP;
#define VAL_TRACE(value) NRP = ((Uint32)(value)) 

/*---------------------------------------------------------------------------*/
/* Function Prototypes                                                       */
/*---------------------------------------------------------------------------*/
Uint32 VAL_chipInit (void *Ptr);
Uint32 VAL_envInit (void *Ptr);
void VAL_testExit (Uint32 result);
Uint32 DataFill (Uint32 *start_location, Uint32 length, Uint32 fill_value, 
                 Uint32 fill_type);
Uint32 DataCompare (Uint32 *src_location, Uint32 *dst_location, Uint32 length);

void VAL_reportToRegs(Uint32 *repPtr);


#endif /* _VAL_UTIL_H_ */

/*****************************************************************************/
/*                       End of val_util.h file                              */
/*****************************************************************************/
