	.include "../../common/src/faraday.asm"
  	.include "../../common/src/srio_const.asm" 
  	.include "../../common/src/srio_macro.asm"


        .global test_start



c_or_asm_MVK .macro a, b, c
  .if $isdefed(a)
     MVKL :a:,:c:
     MVKH :a:,:c:
  .else
     MVKL :b:,:c:
     MVKH :b:,:c:
  .endif
 .endm


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                 Boot code with interrupt vector table starts                 ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .sect   ".boot"

;;;;;;;;;;;;;;;;;;;;;;;Setting the Interrupt Vector Table;;;;;;;;;;;;;;;;;;;;;;;

        srio_int_handler

boot_load:

    test_start_pulse
    clear_reg_file
    
;   .global ___text__
;   c_or_asm_MVK	_c_int00, ___text__, A5
        .global         _c_int00
        MVKL    _c_int00, A5
        MVKH    _c_int00, A5

 		SRIO_MAP_INT      
 		; Enable exceptions
      ;  MVK             0x4,B10
     ;   MVC             B10,TSR

      ;  MVK     0,B10   ; clear all registers for cosim
 
;;;;;;;;;;;;;;;;;;;;;;;;Globally enbling the interrupts;;;;;;;;;;;;;;;;;;;;;;;;;

        MVC     CSR, B3
        SET     B3, 0, 0, B3
        MVC     B3, CSR

	    ; Enable exceptions
        MVK             0x4,B10
        MVC             B10,TSR

        MVK     0,B10   ; clear all registers for cosim

        B       A5
        MVK     0,A5    ; clear A5 too
        NOP     5
;;;;;;;;;;;;;;;;;;;;;;;;Enabling the maskable interrupts;;;;;;;;;;;;;;;;;;;;;;;;;

        ZERO    B3
        SET     B3, 1, 1, B3
        MVC     B3, IER
        SET     B3, 5, 5, B3
        MVC     B3, IER
        SET     B3, 6, 6, B3
        MVC     B3, IER

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Mapping Interrupts;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;        SRIO_MAP_INT

;
;        ZERO    A3          ; clear all registers for cosim
;        ZERO    A4          ; clear all registers for cosim


;        B    	A5
 ;       MVK     0, A5       ; clear A5 
;	NOP	5

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                  Boot code with interrupt vector table ends                  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    default_end_macro
