/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
*
*  Property of Texas Instruments
*  For  Unrestricted  Internal  Use  Only
*  Unauthorized reproduction and/or distribution is strictly prohibited.
*  This product is protected under copyright law and trade secret law
*  as an unpublished work.
*  Created 2004, (C) Copyright 2003 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : srio_doTest.c
*  Date Created   : 9/28/2004
*  Last Modified  : /2005
*  Description    : Performs SRIO Message Passing
*  History        :
*  Project        : Himalaya
*  Author         : Yi Luo
\*****************************************************************************/
#include <csl_intc.h>
#include <cslr_srio.h>
#include <val_util.h>
#include <srio.h>


#define TX_BUF	256
#define RX_BUF	256

#pragma DATA_SECTION(xmtBuff1, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff1,8)
Uint32  xmtBuff1[TX_BUF] = 
#include <data1.h> 

#pragma DATA_SECTION(xmtBuff2, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff2,8)
Uint32  xmtBuff2[TX_BUF] = 
#include <data2.h> 

#pragma DATA_SECTION(xmtBuff3, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff3,8)
Uint32  xmtBuff3[TX_BUF] = 
#include <data3.h> 

#pragma DATA_SECTION(xmtBuff4, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff4,8)
Uint32  xmtBuff4[TX_BUF] = 
#include <data4.h> 


#pragma DATA_SECTION(xmtBuff5, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff5,8)
Uint32  xmtBuff5[TX_BUF] = 
#include <data5.h> 

#pragma DATA_SECTION(xmtBuff6, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff6,8)
Uint32  xmtBuff6[TX_BUF] = 
#include <data6.h> 

#pragma DATA_SECTION(xmtBuff7, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff7,8)
Uint32  xmtBuff7[TX_BUF] = 
#include <data7.h> 

#pragma DATA_SECTION(xmtBuff8, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff8,8)
Uint32  xmtBuff8[TX_BUF] = 
#include <data8.h> 


#pragma DATA_SECTION(xmtBuff9, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff9,8)
Uint32  xmtBuff9[TX_BUF] = 
#include <data9.h> 

#pragma DATA_SECTION(xmtBuff10, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff10,8)
Uint32  xmtBuff10[TX_BUF] = 
#include <data10.h> 

#pragma DATA_SECTION(xmtBuff11, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff11,8)
Uint32  xmtBuff11[TX_BUF] = 
#include <data11.h> 

#pragma DATA_SECTION(xmtBuff12, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff12,8)
Uint32  xmtBuff12[TX_BUF] = 
#include <data12.h> 


#pragma DATA_SECTION(xmtBuff13, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff13,8)
Uint32  xmtBuff13[TX_BUF] = 
#include <data13.h> 

#pragma DATA_SECTION(xmtBuff14, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff14,8)
Uint32  xmtBuff14[TX_BUF] = 
#include <data14.h> 

#pragma DATA_SECTION(xmtBuff15, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff15,8)
Uint32  xmtBuff15[TX_BUF] = 
#include <data15.h> 

#pragma DATA_SECTION(xmtBuff16, "Int_Dat")
#pragma DATA_ALIGN(  xmtBuff16,8)
Uint32  xmtBuff16[TX_BUF] = 
#include <data16.h> 

#pragma DATA_SECTION(rcvBuff1, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff1,8)
Uint32  rcvBuff1[RX_BUF] = 
#include <data17.h> 

#pragma DATA_SECTION(rcvBuff2, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff2,8)
Uint32  rcvBuff2[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff3, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff3,8)
Uint32  rcvBuff3[RX_BUF] = 
#include <data17.h>

#pragma DATA_SECTION(rcvBuff4, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff4,8)
Uint32  rcvBuff4[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff5, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff5,8)
Uint32  rcvBuff5[RX_BUF] = 
#include <data17.h> 

#pragma DATA_SECTION(rcvBuff6, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff6,8)
Uint32  rcvBuff6[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff7, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff7,8)
Uint32  rcvBuff7[RX_BUF] = 
#include <data17.h>

#pragma DATA_SECTION(rcvBuff8, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff8,8)
Uint32  rcvBuff8[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff9, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff9,8)
Uint32  rcvBuff9[RX_BUF] = 
#include <data17.h> 

#pragma DATA_SECTION(rcvBuff10, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff10,8)
Uint32  rcvBuff10[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff11, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff11,8)
Uint32  rcvBuff11[RX_BUF] = 
#include <data17.h>

#pragma DATA_SECTION(rcvBuff12, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff12,8)
Uint32  rcvBuff12[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff13, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff13,8)
Uint32  rcvBuff13[RX_BUF] = 
#include <data17.h> 

#pragma DATA_SECTION(rcvBuff14, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff14,8)
Uint32  rcvBuff14[RX_BUF] = 
#include <data17.h>  

#pragma DATA_SECTION(rcvBuff15, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff15,8)
Uint32  rcvBuff15[RX_BUF] = 
#include <data17.h>

#pragma DATA_SECTION(rcvBuff16, "Int_Dat")
#pragma DATA_ALIGN(  rcvBuff16,8)
Uint32  rcvBuff16[RX_BUF] = 
#include <data17.h>   

int byte_count = 1024;
int port = 0;

extern Uint32 Txcount, Rxcount;

Uint32 testresult = 0;

srio_doTest()
{
	enableSRIO();
	
	Setup_Interrupt();
	
	SET_TRACE(0xa);

	srio_init();

	SET_TRACE(0xb);

	srio_start_trxu(&xmtBuff1, &rcvBuff1, &xmtBuff2, &rcvBuff2, &xmtBuff3, &rcvBuff3, &xmtBuff4, &rcvBuff4,
		&xmtBuff5, &rcvBuff5, &xmtBuff6, &rcvBuff6, &xmtBuff7, &rcvBuff7, &xmtBuff8, &rcvBuff8,
		&xmtBuff9, &rcvBuff9, &xmtBuff10, &rcvBuff10, &xmtBuff11, &rcvBuff11, &xmtBuff12, &rcvBuff12,
		&xmtBuff13, &rcvBuff13, &xmtBuff14, &rcvBuff14, &xmtBuff15, &rcvBuff15, &xmtBuff16, &rcvBuff16,
		port);
	
	SET_TRACE(0xc);
	
	while( Txcount!=16 || Rxcount!=16 ) // wait till interrupts get generated.
    {
        SET_TRACE(Txcount<<16|Rxcount|0x80008000);
        SET_TRACE(0xEEEE0000 | testresult);
	} 


	SET_TRACE(0xd);

	testresult += DataCompare1(&xmtBuff1, &rcvBuff1, byte_count);
	testresult += DataCompare1(&xmtBuff2, &rcvBuff2, byte_count);
	testresult += DataCompare1(&xmtBuff3, &rcvBuff3, byte_count);
	testresult += DataCompare1(&xmtBuff4, &rcvBuff4, byte_count);
	testresult += DataCompare1(&xmtBuff5, &rcvBuff5, byte_count);
	testresult += DataCompare1(&xmtBuff6, &rcvBuff6, byte_count);
	testresult += DataCompare1(&xmtBuff7, &rcvBuff7, byte_count);
	testresult += DataCompare1(&xmtBuff8, &rcvBuff8, byte_count);
	testresult += DataCompare1(&xmtBuff9, &rcvBuff9, byte_count);
	testresult += DataCompare1(&xmtBuff10, &rcvBuff10, byte_count);
	testresult += DataCompare1(&xmtBuff11, &rcvBuff11, byte_count);
	testresult += DataCompare1(&xmtBuff12, &rcvBuff12, byte_count);
	testresult += DataCompare1(&xmtBuff13, &rcvBuff13, byte_count);
	testresult += DataCompare1(&xmtBuff14, &rcvBuff14, byte_count);
	testresult += DataCompare1(&xmtBuff15, &rcvBuff15, byte_count);
	testresult += DataCompare1(&xmtBuff16, &rcvBuff16, byte_count);
	
	SET_TRACE(testresult);

	Close_Interrupt();

    SET_TRACE(0xe);
   
    return(testresult);
	
	
}

