/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
*
*  Property of Texas Instruments
*  For  Unrestricted  Internal  Use  Only
*  Unauthorized reproduction and/or distribution is strictly prohibited.
*  This product is protected under copyright law and trade secret law
*  as an unpublished work.
*  Created 2004, (C) Copyright 2003 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : srio_init.c
*  Date Created   : 8/28/2004
*  Last Modified  : /2005
*  Description    : Performs SRIO initialization
*  History        :
*  Project        : Himalaya
*  Author         : Yi Luo
\*****************************************************************************/

#include <cslr_srio.h>
#include <srio.h>

int output;
extern Uint32 testresult;


/*
//  SRIO  initialization function
*/
void srio_init()
{
	
    Uint32 srio2p1x_mode=1, rdata=0, wdata=0, mdata=0, mask=0;
    	
    /* Glb enable srio */
    SRIO_REGS->GBL_EN 	= 0x00000001 ;
    SRIO_REGS->BLK_ENABLE[0].BLK_EN 	= 0x00000001 ;	//MMR_EN
    SRIO_REGS->BLK_ENABLE[5].BLK_EN 	= 0x00000001 ;  //PORT0_EN
    SRIO_REGS->BLK_ENABLE[1].BLK_EN 	= 0x00000001 ;	//LSU_EN
    SRIO_REGS->BLK_ENABLE[2].BLK_EN 	= 0x00000001 ;	//MAU_EN
    SRIO_REGS->BLK_ENABLE[3].BLK_EN 	= 0x00000001 ;	//TXU_EN
    SRIO_REGS->BLK_ENABLE[4].BLK_EN 	= 0x00000001 ;	//RXU_EN
    SRIO_REGS->BLK_ENABLE[6].BLK_EN 	= 0x00000001 ;  //PORT1_EN
    SRIO_REGS->BLK_ENABLE[7].BLK_EN 	= 0x00000001 ;  //PORT2_EN
    SRIO_REGS->BLK_ENABLE[8].BLK_EN 	= 0x00000001 ;  //PORT3_EN

	
    if (srio2p1x_mode){
		rdata = SRIO_REGS->PER_SET_CNTL;
		wdata = 0x02000101; 
		mask  = 0x020001FF;
		mdata = (wdata & mask) | (rdata & ~mask);
		SRIO_REGS->PER_SET_CNTL	= mdata ;  
	}
	else{
		wdata =  0x02000061; 
		rdata = SRIO_REGS->PER_SET_CNTL;
		mask  = 0x020001FF;
		mdata = (wdata & mask) | (rdata & ~mask);
		SRIO_REGS->PER_SET_CNTL	= mdata ;  
	}
	
	rdata = SRIO_REGS->SERDES_CFG_CNTL[0];
	wdata = 0x0000000F;  
	mask  = 0x00000FFF;
    mdata = (wdata & mask) | (rdata & ~mask);
	SRIO_REGS->SERDES_CFG_CNTL[0]		 = mdata ;  
		
   /*	SRIO_REGS->SERDES_CFGRX_CNTL[0] 	= 0x00015001 ;  // enable rx, rate 1
	SRIO_REGS->SERDES_CFGRX_CNTL[1] 	= 0x00015001 ;  // enable rx, rate 1
	SRIO_REGS->SERDES_CFGRX_CNTL[2] 	= 0x00015001 ;  // enable rx, rate 1
	SRIO_REGS->SERDES_CFGRX_CNTL[3] 	= 0x00015001 ;  // enable rx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[0] 	= 0x00010001 ;  // enable tx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[1] 	= 0x00010001 ;  // enable tx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[2] 	= 0x00010001 ;  // enable tx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[3] 	= 0x00010001 ;  // enable tx, rate 1 */

	SRIO_REGS->SERDES_CFGRX_CNTL[0] 	= 0x00081101; // enable rx, rate 1
	SRIO_REGS->SERDES_CFGRX_CNTL[1] 	= 0x00081101; // enable rx, rate 1
	SRIO_REGS->SERDES_CFGRX_CNTL[2] 	= 0x00081101; // enable rx, rate 1
	SRIO_REGS->SERDES_CFGRX_CNTL[3] 	= 0x00081101; // enable rx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[0] 	= 0x00010801;   // enable tx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[1] 	= 0x00010801;   // enable tx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[2] 	= 0x00010801;   // enable tx, rate 1
	SRIO_REGS->SERDES_CFGTX_CNTL[3] 	= 0x00010801;   // enable tx, rate 1

	
	rdata = SRIO_REGS->DEVICEID_REG1;
	wdata = 0x00ABBEEF;
	mask  = 0x00FFFFFF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->DEVICEID_REG1 	= mdata ;  // id-16b=BEEF, id-08b=AB
	
	rdata = SRIO_REGS->DEVICEID_REG2;
	wdata = 0x00ABBEEF;
	mask  = 0x00FFFFFF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->DEVICEID_REG2 	= mdata ;  // id-16b=BEEF, id-08b=AB
	
    SRIO_REGS->TX_CPPI_ICCR		= 0xFFFFFFFF;    
    SRIO_REGS->TX_CPPI_ICRR		= 0x00000000; 
    SRIO_REGS->TX_CPPI_ICRR2  	= 0xFFFFFFFF; 
	
    SRIO_REGS->RX_CPPI_ICCR		= 0xFFFFFFFF;  
    SRIO_REGS->RX_CPPI_ICRR    	= 0x11111111; 
    SRIO_REGS->RX_CPPI_ICRR2   	= 0xFFFFFFFF; 
	
    rdata = SRIO_REGS->PER_SET_CNTL;
    wdata = 0x00000000;
    mask  = 0x01000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PER_SET_CNTL = mdata;  // bootcmpl=0
	
    SRIO_REGS->DEV_ID		 		= 0xBEEF0030 ;  // id=BEEF, ti=0x0030
    SRIO_REGS->DEV_INFO		 		= 0x00000000 ;  // 0
    SRIO_REGS->ASBLY_ID		 		= 0x00000030 ;  // ti=0x0030
	
    rdata = SRIO_REGS->ASBLY_INFO;
    wdata = 0x00000000;
    mask  = 0xFFFF0000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->ASBLY_INFO		 	= mdata ;  
	
    SRIO_REGS->PE_FEAT		 		= 0x20000119 ;  
	
    rdata = SRIO_REGS->SRC_OP;
    wdata = 0x0000FDF4;
    mask  = 0x0000FFFF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->SRC_OP		 		= mdata ;  
	
    rdata = SRIO_REGS->DEST_OP;
    wdata = 0x0000FC04;
    mask  = 0x0000FFFF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->DEST_OP		 		= mdata ;  
	
    rdata = SRIO_REGS->PE_LL_CTL;
    wdata = 0x00000001;
    mask  = 0x00000007;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PE_LL_CTL		 	= mdata ;  
	
    SRIO_REGS->LCL_CFG_HBAR		 	= 0x00000000 ;  
	
    rdata = SRIO_REGS->LCL_CFG_BAR;
    wdata = 0x00000000;
    mask  = 0xFFFFC000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->LCL_CFG_BAR		 	= mdata ;  
	
    rdata = SRIO_REGS->BASE_ID;
    wdata = 0x00ABBEEF;
    mask  = 0x00FFFFFF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->BASE_ID		 		= mdata ;  // 16b-id=BEEF, 08b-id=AB
	
    rdata = SRIO_REGS->HOST_BASE_ID_LOCK;
    wdata = 0x0000BEEF;
    mask  = 0x0000FFFF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->HOST_BASE_ID_LOCK	= mdata ;  // id=BEEF, lock
	
    rdata = SRIO_REGS->COMP_TAG;
    wdata = 0x00000000;
    mask  = 0x00000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->COMP_TAG		 		= mdata ;  // not touched
	
    rdata = SRIO_REGS->SP_IP_DISCOVERY_TIMER;
    wdata = 0x90000000; //default
    mask  = 0xF0000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->SP_IP_DISCOVERY_TIMER		= mdata ;  // 0, short cycles for sim
	
	//INIT_MAC0
    if (srio2p1x_mode){
		rdata = SRIO_REGS->SP_IP_MODE;
		wdata = 0x44000000;
		mask  = 0xFE000000;
		mdata = (wdata & mask) | (rdata & ~mask);
		SRIO_REGS->SP_IP_MODE		 		= mdata ;  
	}
	else{
		rdata = SRIO_REGS->SP_IP_MODE;
		wdata = 0x04000000;

		mask  = 0xFE000000;
		mdata = (wdata & mask) | (rdata & ~mask);
		SRIO_REGS->SP_IP_MODE		 		= mdata ; 
	}
	
    rdata = SRIO_REGS->IP_PRESCAL;
    wdata = 0x00000000;  //12.5MHz
    mask  = 0x000000FF;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->IP_PRESCAL		= mdata ;  
	
    rdata = SRIO_REGS->PORT_OPTION[0].SP_SILENCE_TIMER;
    wdata = 0x20000000;
    mask  = 0xF0000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT_OPTION[0].SP_SILENCE_TIMER		 	= mdata ;  
	
    rdata = SRIO_REGS->PORT_OPTION[1].SP_SILENCE_TIMER;
    wdata = 0x20000000;
    mask  = 0xF0000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT_OPTION[1].SP_SILENCE_TIMER		 	= mdata ;  
	
    rdata = SRIO_REGS->PORT_OPTION[2].SP_SILENCE_TIMER;
    wdata = 0x20000000;
    mask  = 0xF0000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT_OPTION[2].SP_SILENCE_TIMER		 	= mdata ;  
	
    rdata = SRIO_REGS->PORT_OPTION[3].SP_SILENCE_TIMER;
    wdata = 0x20000000;
    mask  = 0xF0000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT_OPTION[3].SP_SILENCE_TIMER		 	= mdata ;  
    	
    rdata = SRIO_REGS->PER_SET_CNTL;
    wdata = 0x01000000;
    mask  = 0x01000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PER_SET_CNTL = mdata;  
	
    rdata = SRIO_REGS->SP_LT_CTL;
	wdata = 0xFFFFFF00;  //long
    mask  = 0xFFFFFF00;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->SP_LT_CTL  		= mdata ;  
	
    rdata = SRIO_REGS->SP_RT_CTL;
    wdata = 0xFFFFFF00;  //long
    mask  = 0xFFFFFF00;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->SP_RT_CTL 		= mdata ;  
	
    rdata = SRIO_REGS->SP_GEN_CTL;
    wdata = 0x40000000;
    mask  = 0xE0000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->SP_GEN_CTL 		= mdata ;  
	
    rdata = SRIO_REGS->PORT[0].SP_CTL;
    wdata = 0x00600000;
    mask  = 0x00600000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT[0].SP_CTL	 		= mdata ;  
	
    rdata = SRIO_REGS->PORT[1].SP_CTL;
    wdata = 0x00600000;
    mask  = 0x00600000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT[1].SP_CTL	 		= mdata ;  // enable i/o
	
    rdata = SRIO_REGS->PORT[2].SP_CTL;
    wdata = 0x00600000;
    mask  = 0x00600000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT[2].SP_CTL	 		= mdata ;  // enable i/o
	
    rdata = SRIO_REGS->PORT[3].SP_CTL;
    wdata = 0x00600000;
    mask  = 0x00600000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PORT[3].SP_CTL	 		= mdata ;  // enable i/o
	
	
    rdata = SRIO_REGS->ERR_RPT_BH;
    wdata = 0x00000000;
    mask  = 0x00000000;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->ERR_RPT_BH	 		= mdata ;  // next ext=0x0000(last)
	
    SRIO_REGS->ERR_DET	 			= 0x00000000 ;  // clear
    SRIO_REGS->ERR_EN		 		= 0x00000000 ;  // disable
    SRIO_REGS->H_ADDR_CAPT	 		= 0x00000000 ;  // clear
    SRIO_REGS->ADDR_CAPT		 	= 0x00000000 ;  // clear
    SRIO_REGS->ID_CAPT		 		= 0x00000000 ;  // clear
    SRIO_REGS->CTRL_CAPT		 	= 0x00000000 ;  // clear
	
   SRIO_REGS->MAP[0].RXU_MAP_L = 	CSL_FMK( SRIO_RXU_MAP_L_LETTER_MASK, 0)|
		CSL_FMK( SRIO_RXU_MAP_L_MAILBOX_MASK, 0x0)|
		CSL_FMK( SRIO_RXU_MAP_L_LETTER, 0)|
		CSL_FMK( SRIO_RXU_MAP_L_MAILBOX, 0)|
		CSL_FMK( SRIO_RXU_MAP_L_SOURCEID, 0xBEEF);
	
    SRIO_REGS->MAP[0].RXU_MAP_H = 	CSL_FMK( SRIO_RXU_MAP_H_TT, 1)|
		CSL_FMK( SRIO_RXU_MAP_H_QUEUE_ID, 0)|
		CSL_FMK( SRIO_RXU_MAP_H_PROMISCUOUS, 1)| //0)|
		CSL_FMK( SRIO_RXU_MAP_H_SEGMENT_MAPPING, 1);  //1 multi-seg
	
    SRIO_REGS->MAP[1].RXU_MAP_L = 	CSL_FMK( SRIO_RXU_MAP_L_LETTER_MASK, 0)|
		CSL_FMK( SRIO_RXU_MAP_L_MAILBOX_MASK, 0x0)|
		CSL_FMK( SRIO_RXU_MAP_L_LETTER, 0)|
		CSL_FMK( SRIO_RXU_MAP_L_MAILBOX, 0)|
		CSL_FMK( SRIO_RXU_MAP_L_SOURCEID, 0xBEEF);
	
    SRIO_REGS->MAP[1].RXU_MAP_H = 	CSL_FMK( SRIO_RXU_MAP_H_TT, 1)|
		CSL_FMK( SRIO_RXU_MAP_H_QUEUE_ID, 1)|
		CSL_FMK( SRIO_RXU_MAP_H_PROMISCUOUS, 1)| //0)|
		CSL_FMK( SRIO_RXU_MAP_H_SEGMENT_MAPPING, 0);  //0 single-seg

	SRIO_REGS->RX_CPPI_CNTL = 0x3;
	
	
	SRIO_REGS->QUEUE_TXDMA_HDP[0] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[1] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[2] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[3] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[4] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[5] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[6] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[7] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[8] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[9] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[10] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[11] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[12] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[13] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[14] 	= 0 ;
	SRIO_REGS->QUEUE_TXDMA_HDP[15] 	= 0 ;
	
	//RXU Queue initialization
	
	SRIO_REGS->QUEUE_RXDMA_HDP[0] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[1] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[2] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[3] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[4] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[5] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[6] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[7] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[8] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[9] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[10] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[11] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[12] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[13] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[14] 	= 0 ;
	SRIO_REGS->QUEUE_RXDMA_HDP[15] 	= 0 ;

	SRIO_REGS->RX_CPPI_CNTL = 0x1;
	
    rdata = SRIO_REGS->SP_IP_MODE;
    wdata = 0x0000003F;
    mask  = 0x0000003F;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->SP_IP_MODE		 		= mdata ;  // mltc/rst/pw enable, clear
	
    SRIO_REGS->SP_IP_PW_IN_CAPT[0]		= 0x00000000 ;  // clear
    SRIO_REGS->SP_IP_PW_IN_CAPT[1]		= 0x00000000 ;  // clear
    SRIO_REGS->SP_IP_PW_IN_CAPT[2]		= 0x00000000 ;  // clear
    SRIO_REGS->SP_IP_PW_IN_CAPT[3]		= 0x00000000 ;  // clear
	
	
    rdata = SRIO_REGS->PORT[0].SP_ERR_STAT ;
    while ((rdata & 0x00000002) != 0x00000002)
    {
		rdata = SRIO_REGS->PORT[0].SP_ERR_STAT ;
    }
	
    rdata = SRIO_REGS->PCR;
    wdata = 0x00000004;
    mask  = 0x00000004;
    mdata = (wdata & mask) | (rdata & ~mask);
    SRIO_REGS->PCR = mdata ;  // peren
	
	SET_TRACE(0x10);

	// Program the pacing registers
	SRIO_REGS->INTDST_RATE_CNTL[0] = 0x1;
	SRIO_REGS->INTDST_RATE_CNTL[1] = 0x1;

	
	}
	

int DataCompare1(Uint16 *xmtBuff, Uint16 *rcvBuff, int len)
{
	int i;
	
	for (i = 0; i<(len/2); i++){
		if (xmtBuff[i]!=rcvBuff[i]){
			output = 1;
			break;
		}
		else {
			output = 0;
		}
	}
	return (output);
}

