#include <stdio.h>
#include <csl_intc.h>
#include <cslr_srio.h>
#include <srio.h>

CSL_IntcEventHandlerRecord EventHandler[30];

void event20Handler(void *handle);

void event21Handler(void *handle);

void event22Handler(void *handle);

CSL_IntcContext context;

Uint32 Txcount = 0, Rxcount = 0;
volatile Uint32 addrtx1, *addrtx2;
volatile Uint32 addrrx1, *addrrx2;
extern Uint32 testresult;

CSL_IntcObj intcObj70,intcObj71,intcObj72; // Events SRIO
CSL_IntcHandle hIntc70,hIntc71,hIntc72; //,hIntc0;
CSL_IntcGlobalEnableState state;
CSL_IntcEventHandlerRecord EventRecord;
CSL_Status intStat;
CSL_IntcParam vectId1, vectId2;
CSL_BitMask32 evtEn;
int pass = 0;
CSL_IntcEventHandlerRecord Record[4];
int temp1 = 0; 

void Setup_Interrupt()
{
		
    // Since there are only 4 events in the system table of 4 elements are enough
	
    context.numEvtEntries = 4;
    context.eventhandlerRecord = Record;
    // Initializes the CPU vector table, dispatchr
	CSL_intcInit(&context);
	
	/* Enable NMIs */
	CSL_intcGlobalNmiEnable();
	
	/* Enable Global Interrupts */
	//intStat = CSL_intcGlobalEnable(&state);
	CSL_intcGlobalEnable(NULL);
	
	/* Opening a handle for CPU vector 10 */
	vectId1 = CSL_INTC_VECTID_5;
	hIntc70 = CSL_intcOpen (&intcObj70, CSL_INTC_EVENTID_71, &vectId1 , NULL);
	
	EventRecord.handler = &event20Handler;
	EventRecord.arg = hIntc70;
    CSL_intcPlugEventHandler(hIntc70,&EventRecord);
	
	/* Open even 21 and setup the handler */
	vectId2 = CSL_INTC_VECTID_6;
	hIntc71 = CSL_intcOpen (&intcObj71, CSL_INTC_EVENTID_72, &vectId2 , NULL);
	
	EventRecord.handler = &event21Handler;
	EventRecord.arg = hIntc71;
    CSL_intcPlugEventHandler(hIntc71,&EventRecord);


	CSL_intcHwControl(hIntc70,CSL_INTC_CMD_EVTENABLE,NULL);
	CSL_intcHwControl(hIntc71,CSL_INTC_CMD_EVTENABLE,NULL);


	
}

void Close_Interrupt(){
	CSL_intcClose(hIntc72);
	CSL_intcClose(hIntc71);
	CSL_intcClose(hIntc70);

}

void event20Handler(void *handle)
{
	Uint32 tmp, data;	
	SET_TRACE(0x7000);

	temp1 = SRIO_REGS->TX_CPPI_ICSR;
    if ((temp1 & 0x00000001) == 0x00000001)
    {
		SET_TRACE(0x7B00);
		SET_TRACE(0xEEEE0000 + Txcount);
	
		if(Txcount == 0)
		{
		addrtx1 = (Uint32)TX_DESCP0_0; // get the starting address of the descriptor
		}
	

Next_Desc: 

		addrtx2 = (Uint32 *)addrtx1;

		tmp = addrtx2[0];
	
		data = addrtx2[3];

		if(data & SRIO_DSC_FLAG_OWNERSHIP)
		{
			goto skipout;  // wait for next interrupt
		}
		else
		{
			if(!(data & SRIO_DSC_FLAG_SOP) && ( data & SRIO_DSC_FLAG_EOP)) 
			{
          		SET_TRACE(0x777e0030); 
          		testresult++;
         	} 
			

			if(tmp == 0x0 && (data & SRIO_DSC_FLAG_EOQ)) //end of queue
			{
				SET_TRACE(0xE0E0);
				Txcount++; // Last descriptor
				goto skipout;
			}	
			Txcount++; // increment the txcount as you have already processed the desc
			addrtx1 = addrtx1 + 0x10;
			goto Next_Desc;
					
    }
	}

skipout:
		SRIO_REGS->TX_CPPI_ICCR		= 0xFFFFFFFF;	
		SRIO_REGS->INTDST_RATE_CNTL[0] = 0x1;
}

void event21Handler(void *handle)
{
	Uint32 tmp, data;	
	SET_TRACE(0x8000);

	temp1 = SRIO_REGS->RX_CPPI_ICSR;
    if ((temp1 & 0x00000001) == 0x00000001)
    {
		SET_TRACE(0x7C00);
		SET_TRACE(0xFFFF0000 + Rxcount);
	
		if(Rxcount == 0)
		{
		addrrx1 = (Uint32)RX_DESCP0_0; // get the starting address of the Desc
		}

Next_Desc: 

		addrrx2 = (Uint32 *)addrrx1;

		tmp = addrrx2[0];
	
		data = addrrx2[3];

		if(data & SRIO_DSC_FLAG_OWNERSHIP)
		{
			goto skipout;  // wait for next interrupt
		}
		else
		{
			if(!(data & SRIO_DSC_FLAG_SOP) && ( data & SRIO_DSC_FLAG_EOP)) 
			{
          		SET_TRACE(0x777e0030); 
          		testresult++;
         	} 

			if(tmp == 0x0 && (data & SRIO_DSC_FLAG_EOQ) ) //end of queue
			{
				SET_TRACE(0xF0F0);
				Rxcount++; // Last descriptor
				goto skipout;
			}	
			Rxcount++; // increment the txcount as you have already processed the desc
			addrrx1 = addrrx1 + 0x10;
			goto Next_Desc;
					
    }
	}

skipout:
		SRIO_REGS->RX_CPPI_ICCR		= 0xFFFFFFFF;	
		SRIO_REGS->INTDST_RATE_CNTL[1] = 0x1;
}


// dummy ISR
void event22Handler(void *handle)
{
	SET_TRACE(0x9000);
}
