/*****************************************************************************/
/*          Copyright (C) 2003-2004 Texas Instruments Incorporated.          */
/*                          All Rights Reserved                              */
/*---------------------------------------------------------------------------*/
/* File Name     : val_util.c                                                */
/* Created on    : Sept 24, 2005                                             */
/* Created By    :                                                           */
/* Last modified :                                                           */
/*---------------------------------------------------------------------------*/
/* Description   : Contains common utility and test reporting functions      */
/*                 for Faraday                                               */
/* History       :                                                           */
/*****************************************************************************/

#include <val_util.h>

 asm("   .global     passed");
 asm("   .global     failed");

/******************************************************************************
* Function : VAL_chipInit (void *Ptr)
* 
* Description : Performs Chip Initialization
*
* Inputs:
*
* Returns:
******************************************************************************/
Uint32 VAL_chipInit (void *Ptr)
{

 /* Place holder for future compatibility */

    return (SUCCESS);
}

/******************************************************************************
* Function : VAL_envInit (void *Ptr)
* 
* Description : Performs Environment Initialization
*
* Inputs:
*
* Returns:
******************************************************************************/
Uint32 VAL_envInit (void *Ptr)
{

 /* Place holder for future compatibility */

    return (SUCCESS);
}

/******************************************************************************
* Function : VAL_testExit (Uint32 result)
* 
* Description : Performs test reporting by indicating PASS or FAIL
*               to the Test Bench and termitates.
*
* Inputs: result = PASS (0) when the test is passed
*                  FAIL (1) or any non-zero value when the test is failed
*
* Returns: None
******************************************************************************/
void VAL_testExit (Uint32 result)
{
    if(result == 0)
    {
        passed();
        asm("   NOP 5  ");
    }
    else
    {
        failed();
        asm("   NOP 5  ");
    }
}

/******************************************************************************
* Function:  DataFill ( Uint32 *start_location, Uint32 length,
*                      Uint32 fill_value, Uint8 fill_type )
*
* Purpose:   Fills a memory location with a pattern as requested. 
*            Beginning at 'start_location', 'length' words (32-bit) are filled,
*            starting with 'fill_value'.  After the initial value, the
*            other memory locations are filled with either a constant
*            value, incrementing values, or decrementing values.
*
* Inputs:    Uint32 *start_location : Memory location to start filling.
*            Uint32 length : Number of 32-bit words to fill.
*            Uint32 fill_value : 32-bit value to start filling with.
*            Uint32 fill_type : Type of fill: 
*                               FILL_FIX, FILL_INC, FILL_DEC
*
* Returns:   Uint32 flag : SUCCESS (0) for a success
*                          FAILURE (1) for a failure
******************************************************************************/

Uint32 DataFill (Uint32 *start_location, Uint32 length, Uint32 fill_value, 
                 Uint32 fill_type)
{
    Uint32  i;
  
    for (i = 0; i < length; i++) {

      if (fill_type == FILL_FIX) {
          *start_location = fill_value;
          /* Check that value was written correctly */
          if (*start_location != fill_value)    
              return FAILURE;
      }
      else if (fill_type == FILL_INC) {
          *start_location = (Uint32)(fill_value+i);
          /* Check that value was written correctly */
          if (*start_location != (Uint32)(fill_value+i))
              return FAILURE;
      }
      else if (fill_type == FILL_DEC) {
          *start_location = (Uint32)(fill_value-i);
          /* Check that value was written correctly */
          if (*start_location != (Uint32)(fill_value-i))
              return FAILURE;
      }
      else {                  
          /* Error if non-valid fill type */
          return FAILURE;
      }
    
      start_location++;
    }

    VAL_TRACE(0xF000A000); /* Set this value into the NRP register for debugging */
    VAL_TRACE(0xF000B000);
  
    return SUCCESS;
}

/******************************************************************************
* Function: DataCompare (Uint32 *src_location, Uint32 *dst_location, 
*                        Uint32 length)
*
* Purpose:  Checks that a transfer was successful by comparing the data
*           in the source buffer against the data in the destination buffer.
*           The total amount of data compared is "length" 32-bit words.
*
* Inputs:   Uint32 *src_location: Source address
*                                       
*           Uint32 *dst_location: Destination address
*
*           Uint32 length  : Number of 32-bit words to check
*
* Returns:  Uint32 flag : PASS for a matching comparison
*                         FAIL for a mis-match
******************************************************************************/
Uint32 DataCompare (Uint32 *src_location, Uint32 *dst_location, Uint32 length )
{
    Uint32  i;
  
    for (i = 0; i < length; i++) {
  
      if (*src_location != *dst_location) { 
           VAL_TRACE (0xF000DBAD);
           VAL_TRACE (i);
           VAL_TRACE (*src_location);
           VAL_TRACE (*dst_location);
           return FAIL; /* Data mis-match */
      }     

      src_location++;
      dst_location++;
  }
  
  return PASS;  /* Data matches */
}

/* For reporting use A7 to A31 and B7 to B31 (excluding B15). Hence total values that can be dumped is 49 */

/******************************************************************************
* Function : VAL_reportToRegs(Uint32 *repPtr)
* 
* Description :   
*               
*
* Inputs: Uint32 *repPtr
*
* Returns: None
******************************************************************************/
void VAL_reportToRegs(Uint32 *repPtr)
{
   /* Copy into A Registers */
   asm(" LDW *A4++,A7");    asm(" LDW *A4++,A8");    asm(" LDW *A4++,A9"); 
   asm(" LDW *A4++,A10");   asm(" LDW *A4++,A11");   asm(" LDW *A4++,A12"); 
   asm(" LDW *A4++,A13");   asm(" LDW *A4++,A14");   asm(" LDW *A4++,A15"); 
   asm(" LDW *A4++,A16");   asm(" LDW *A4++,A17");   asm(" LDW *A4++,A18"); 
   asm(" LDW *A4++,A19");   asm(" LDW *A4++,A20");   asm(" LDW *A4++,A21"); 
   asm(" LDW *A4++,A22");   asm(" LDW *A4++,A23");   asm(" LDW *A4++,A24"); 
   asm(" LDW *A4++,A25");   asm(" LDW *A4++,A26");   asm(" LDW *A4++,A27"); 
   asm(" LDW *A4++,A28");   asm(" LDW *A4++,A29");   asm(" LDW *A4++,A30"); 
   asm(" LDW *A4++,A31"); 
   
   /* Copy into B Registers */
   asm(" LDW *A4++,B7");    asm(" LDW *A4++,B8");    asm(" LDW *A4++,B9"); 
   asm(" LDW *A4++,B10");   asm(" LDW *A4++,B11");   asm(" LDW *A4++,B12"); 
   asm(" LDW *A4++,B13");   asm(" LDW *A4++,B14");    
   asm(" LDW *A4++,B16");   asm(" LDW *A4++,B17");   asm(" LDW *A4++,B18"); 
   asm(" LDW *A4++,B19");   asm(" LDW *A4++,B20");   asm(" LDW *A4++,B21"); 
   asm(" LDW *A4++,B22");   asm(" LDW *A4++,B23");   asm(" LDW *A4++,B24"); 
   asm(" LDW *A4++,B25");   asm(" LDW *A4++,B26");   asm(" LDW *A4++,B27"); 
   asm(" LDW *A4++,B28");   asm(" LDW *A4++,B29");   asm(" LDW *A4++,B30"); 
   asm(" LDW *A4++,B31"); 
}

/*****************************************************************************/
/*                       End of val_util.c file                              */
/*****************************************************************************/
