/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2011
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
EDMA configuration for UART
 * =============================================================================
 *  Revision History
 *  ===============
 *  2011-12 Zhan  file created
 * =============================================================================
 */

#include <csl_edma3.h>
#include <csl_idma.h>
#include "uart_edma_setup.h"
#include "Keystone_UART_Init_drv.h"
#include "KeyStone_common.h"

void UART_EDMA_init()
{
		int i;
		int uartNumber = 0;
		unsigned int *uipPaRAM;
		CSL_UartRegs * localUartRegs = (CSL_UartRegs *)((Uint32)UART_Regs + uartNumber * 0x1000);

		uipPaRAM= (unsigned int *)&(gEDMACC2Regs->PARAMSET[0]);
		for(i=0; i<8*CSL_EDMA3_TPCC2_NUM_PARAMSETS; i++)
			*uipPaRAM++=0;

		for(i=0; i<CSL_EDMA3_TPCC2_NUM_DMACH; i++)
			gEDMACC2Regs->TPCC_DCHMAP[i] = i<< CSL_TPCC_TPCC_DCHMAP0_PAENTRY_SHIFT;

		gEDMACC2Regs->TPCC_DMAQNUM[0]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[1]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[2]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[3]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[4]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[5]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[6]= 0x32103210;
		gEDMACC2Regs->TPCC_DMAQNUM[7]= 0x32103210;

		gEDMACC2Regs->TPCC_ECR= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_ECRH= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_EECR= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_EECRH= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_ICR= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_ICRH= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_IECR= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_IECRH= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_EMCR= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_EMCRH= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_SECR= 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_SECRH= 0xFFFFFFFF;

		/*the UART Rx use channel 40 with TC2*/
		{
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].OPT=
					CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS,
							CSL_EDMA3_TCCH_DIS,
							CSL_EDMA3_ITCINT_DIS,
							CSL_EDMA3_TCINT_EN,
							UART_RX_EDMA_CHA,
							CSL_EDMA3_TCC_NORMAL,
							CSL_EDMA3_FIFOWIDTH_NONE,
							CSL_EDMA3_STATIC_DIS,
							CSL_EDMA3_SYNC_AB,
							CSL_EDMA3_ADDRMODE_INCR,
							CSL_EDMA3_ADDRMODE_INCR);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].SRC= (Uint32)(&localUartRegs->RBR);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].DST= GLOBAL_ADDR(&UART_Rx_Buf[0][0]);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].SRC_DST_BIDX= 4<<16;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].LINK_BCNTRLD= UART_RX_EDMA_PONG*32;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].SRC_DST_CIDX= 0<<16;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].A_B_CNT= (8<<16)|(4);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_CHA].CCNT= 1;

		}

		{
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].OPT=
					CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS,
							CSL_EDMA3_TCCH_DIS,
							CSL_EDMA3_ITCINT_DIS,
							CSL_EDMA3_TCINT_EN,
							UART_RX_EDMA_CHA,
							CSL_EDMA3_TCC_NORMAL,
							CSL_EDMA3_FIFOWIDTH_NONE,
							CSL_EDMA3_STATIC_DIS,
							CSL_EDMA3_SYNC_AB,
							CSL_EDMA3_ADDRMODE_INCR,
							CSL_EDMA3_ADDRMODE_INCR);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].SRC= (Uint32)(&localUartRegs->RBR);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].DST= GLOBAL_ADDR(&UART_Rx_Buf[1][0]);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].SRC_DST_BIDX= 4<<16;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].LINK_BCNTRLD= UART_RX_EDMA_PING*32;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].SRC_DST_CIDX= 0<<16;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].A_B_CNT= (8<<16)|(4);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PONG].CCNT= 1;

		}

		{
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].OPT=
					CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS,
							CSL_EDMA3_TCCH_DIS,
							CSL_EDMA3_ITCINT_DIS,
							CSL_EDMA3_TCINT_EN,
							UART_RX_EDMA_CHA,
							CSL_EDMA3_TCC_NORMAL,
							CSL_EDMA3_FIFOWIDTH_NONE,
							CSL_EDMA3_STATIC_DIS,
							CSL_EDMA3_SYNC_AB,
							CSL_EDMA3_ADDRMODE_INCR,
							CSL_EDMA3_ADDRMODE_INCR);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].SRC= (Uint32)(&localUartRegs->RBR);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].DST= GLOBAL_ADDR(&UART_Rx_Buf[0][0]);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].SRC_DST_BIDX= 4<<16;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].LINK_BCNTRLD= UART_RX_EDMA_PONG*32;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].SRC_DST_CIDX= 0<<16;
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].A_B_CNT= (8<<16)|(4);
			gEDMACC2Regs->PARAMSET[UART_RX_EDMA_PING].CCNT= 1;

		}
		gEDMACC2Regs->TPCC_EESRH = 1<<(UART_RX_EDMA_CHA-32);
		gEDMACC2Regs->TPCC_IESR = 0;
		gEDMACC2Regs->TPCC_IESRH = 1<<(UART_RX_EDMA_CHA-32);// enable 40 and 41 edma interrupt
}



