/* --------------------------------------------------------------------------
    FILE        : uart_test.c 				                             	 	        
    PURPOSE     : uart hardware test
    PROJECT     : Keystone CCS UART Utility
    AUTHOR      : Zhan Xiang 2011-12-29
    DESC        : Main function for UART on KeyStone device
 ----------------------------------------------------------------------------- */
#include <stdio.h>
#include "KeyStone_common.h"
#include "Keystone_DDR_Init.h"
#include "KeyStone_UART_Init_drv.h"
#include "uart_Intc_setup.h"
#include "uart_edma_setup.h"


/************************************************************
* Explicit External Declarations                            *
************************************************************/


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/



/************************************************************
* Local Variable Definitions                                *
************************************************************/
char * uart_err_str[]=
{
	"UART_Receive_FIFO_Error",
	"UART_Break_Error       ",
	"UART_Frame_Error       ",
	"UART_Parity_Error      ",
	"UART_Overrun_Error     ",
};
static int pingpongFlag = 1;
/************************************************************
* Global Variable Definitions
************************************************************/
volatile Uint32 gTxCheckEnable = 1;
volatile Uint32 g_BufferIdx = 0;

/************************************************************
* Global Function Definitions                               *
************************************************************/

void main( void )
{
	int i;
	TDSP_Type dspType;
	int uartNum = 0;
	char rxChar[9];
	char text[] = {'H', 'E', 'L', 'L', 'O'};


#if 0
	char string1[256];
	char *textS = "\n";
	CSL_UartRegs * localUART_Regs = (CSL_UartRegs *)((Uint32)UART_Regs + uartNum * 0x1000);
#endif


	printf("UART test start\n");
	
    CACHE_setL1PSize(CACHE_L1_32KCACHE);
    CACHE_setL1DSize(CACHE_L1_32KCACHE);
    CACHE_setL2Size(CACHE_256KCACHE);
	CACHE_invAllL1p(CACHE_WAIT);
	CACHE_wbInvAllL1d(CACHE_WAIT);
	CACHE_wbInvAllL2(CACHE_WAIT);

	/*make other cores local memory cacheable and prefetchable*/
	for(i=16; i<24; i++)
		CGEM_regs->MAR[i]=1|(1<<CSL_CGEM_MAR0_PFX_SHIFT);	

	/*make DDR cacheable and prefetchable*/
	for(i=128; i<256; i++)
		CGEM_regs->MAR[i]=1|(1<<CSL_CGEM_MAR0_PFX_SHIFT);	

	/*make other space non-cacheable and non-prefetchable*/
	for(i=24; i<128; i++)
		CGEM_regs->MAR[i]=0;	

	/*XMC memory address extension/mapping and memory protection*/
	KeyStone_XM_cfg();

	if(DNUM ==0)
	{
		dspType= Get_dsp_type();
		if(TCI6616 == dspType||TCI6618==dspType)
		{
			//DSP core speed
			KeyStone_main_PLL_init (236, 29); 	//for 122.88MHz input clock

			//DDR speed = 66.67*20/1= 1333
			KeyStone_DDR_PLL_init (20, 1);

			TCI6618_EVM_DDR_Init(666.667); 	//for 1333Mbps
		
		}
		else if(TCI6608==dspType)
		{
			//DSP core speed
			//KeyStone_main_PLL_init (20, 1); 	//for 50MHz input clock
			KeyStone_main_PLL_init (10, 1); 	//for 100MHz input clock

			//DDR speed = 66.67*20/1= 1333
			KeyStone_DDR_PLL_init (20, 1);

			TCI6608_EVM_DDR_Init(666.667); 	//for 1333Mbps

		}
		printf("UART setup started.\n");
		KeyStone_UART_calc();
		KeyStone_UART_init(&gUARTCfg, uartNum);
		UART_EDMA_init();
		UART_Interrupts_Init();
	}
	
	printf("Hello from your Keystone board!\n");	

	printf("UART%d sending a few characters one at a time...\n",uartNum);

	Keystone_uartWrite_Busy(uartNum, text[0]);
	Keystone_uartWrite_Busy(uartNum, text[1]);
	Keystone_uartWrite_Busy(uartNum, text[2]);
	Keystone_uartWrite_Busy(uartNum, text[3]);
	Keystone_uartWrite_Busy(uartNum, text[4]);
	

	printf("UART%d sending a string all at once...\n");

	for(;;)
	{
#if 0
		if(gTxCheckEnable)
		{
			printf("Please input your string\n");
			status = Keystone_uartWrite_Busy(uartNum, *textS);
			scanf("%s",string1);
			fflush(stdin);
			status = Keystone_uartWrite_String(uartNum, string1);
			if(status)
			{
				printf("UART Tx - No Errors Detected :)\n");
			}
			else
			{
				printf("UART Tx - Errors Detected :(\n");
			}
		}
#endif

		if(g_BufferIdx)
		{
			for(i=0; i<8; i++)
			{
				rxChar[i] = UART_Rx_Buf[pingpongFlag][i];
			    printf("%c", rxChar[i]);
			}
			rxChar[8] = '\0';
		    Keystone_uartWrite_String(0,rxChar);
			printf("\n");
			g_BufferIdx=0;
		}

	}

}


interrupt void UartISR()
{
	Uint32 uartNum = 0;
	Uint32 i;
	Uint32 uLSR;
	Uint32 uartErrShift[5] = {CSL_UART_LSR_RXFIFOE_SHIFT,
							  CSL_UART_LSR_BI_SHIFT,
							  CSL_UART_LSR_FE_SHIFT,
							  CSL_UART_LSR_PE_SHIFT,
							  CSL_UART_LSR_OE_SHIFT};


	CSL_UartRegs * localUART_Regs = (CSL_UartRegs *)((Uint32)UART_Regs + uartNum * 0x1000);

	uLSR = localUART_Regs->LSR;
	for(i=0; i<5; i++)
	{
		if((uLSR >> uartErrShift[i])& 1)
		{
			printf("UART error is %s\n",uart_err_str[i]);
		}

	}

	cpIntc0Regs->STATUS_CLR_INDEX_REG= uiUart_event_num;
}


interrupt void UartEDMA()
{

	Uint32 IPRH = 0;
	IPRH = gEDMACC2Regs->TPCC_IPRH;
	if(IPRH & (1<<(40-32)))
	{
		pingpongFlag = (pingpongFlag ==0);
		g_BufferIdx=1;
		gEDMACC2Regs->TPCC_ICRH = 1<<(40-32);
	}
	else
	{
		gEDMACC2Regs->TPCC_ICRH = 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_ICR = 0xFFFFFFFF;
	}
	IPRH = gEDMACC2Regs->TPCC_IPRH;
    //if(IPRH)
    {
    	gEDMACC2Regs->TPCC_IEVAL = 1;
    }
	cpIntc0Regs->STATUS_CLR_INDEX_REG= uiEdmaGint_event_num;
}
/************************************************************
* Local Function Definitions                                *
************************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/

