/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2012
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 Example of SPI configuration
 * =============================================================================
 *  Revision History
 *  ===============
 *  Jan 15, 2012 Brighton created
 * =============================================================================
 */
#ifndef _KEYSTONE_SPI_INIT_H_
#define _KEYSTONE_SPI_INIT_H_

#include <tistdtypes.h>
#include <cslr_spi.h>

typedef enum {
	SPI_CLOCK_LOW_INACTIVE= 0,
	SPI_CLOCK_HIGH_INACTIVE
}SPI_Clock_Polarity;

typedef enum {
	SPI_CS_LOW_ACTIVE= 0,
	SPI_CS_HIGH_ACTIVE
}SPI_CS_Polarity;

typedef enum {
	SPI_CS_0= 0,
	SPI_CS_1,
	SPI_CS_2,
	SPI_CS_3
}SPI_CS_Select;

typedef struct  {
    /*Delay in between transmissions in ns. Idle time that will be 
    applied at the end of the current transmission if the bit
    WDEL is set in the current buffer*/
    Uint32              delayBetweenTrans_ns;   
    Uint8               ShifDirection; 
    /*No C2TDELAY or T2CDELAY is inserted in the chip select timings.*/
    Uint8               disable_CS_timing;
    SPI_Clock_Polarity  clockPolarity;
    Uint8               clockPhase;
    /*SPI external clock speed in KHz < 66,000KHz*/
    Uint16              clockSpeedKHz;
    /*SPI data word length. Legal values are 2h (data word length = 2 bit)
    to 10h (data word length = 16).*/
    Uint8               wordLength;
} SPI_Data_Format;

typedef struct  {
    Bool    TX_interruptEnable;
    Bool    RX_interruptEnable;
    Bool    overrunInterruptEnable;
    Bool    bitErrorInterruptEnable;
    Uint8   TX_INT_map;
    Uint8   RX_INT_map;
    Uint8   overrun_INT_map;
    Uint8   bitError_INT_map;
} SPI_Interrupt_Config;

typedef struct  {

	SPI_Data_Format * dataFormat[4];
	Bool loopBack;
	Bool DMA_requestEnable;
	SPI_Interrupt_Config * interruptCfg;
	/*number of SPI pins defined as:
	3: SPISIMO, SPISOMI, SPICLK
	4: SPISIMO, SPISOMI, SPICLK, SPISCS0
	5: SPISIMO, SPISOMI, SPICLK, SPISCS0, SPISCS1
	6: SPISIMO, SPISOMI, SPICLK, SPISCS0, SPISCS1, SPISCS2
	......	*/
	Uint8 number_SPI_pins;
	/*Chip-select-active-to-transmit-start-delay. It defines a setup time 
	for the slave device that delays the data transmission from the chip 
	select active edge, in ns*/
	Uint32 C2T_delay_ns;
	/*Transmit-end-to-chip-select-inactive-delay. It defines a hold time 
	for the slave device that delays the chip select deactivation (in ns)
	after the last bit is transferred*/
	Uint32 T2C_delay_ns;
	SPI_CS_Polarity CS_polarity;
} SPI_Config;

extern CSL_SpiRegs * spiRegs;

/*make the higher 16-bit of the SPIDAT1 register*/
#define SPI_TRANSMIT_FORMAT_MAKE(CS_hold_enable, delay_enable, formatSelect, CS_select)\
(Uint32)(\
     CSL_FMKR(28,28,CS_hold_enable) \
    |CSL_FMKR(26,26,delay_enable) \
    |CSL_FMKR(25,24,formatSelect) \
    |CSL_FMKR(23,16,CS_select)) 

extern void KeyStone_SPI_init(SPI_Config *spiCfg);

#endif
