/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2011
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
	UART configuration
 * =============================================================================
 *  Revision History
 *  ===============
 *  2011.12 Zhan Xiang  file created
 * =============================================================================
 */
#ifndef _KEYSTONE_UART_INIT_DRV_H_
#define _KEYSTONE_UART_INIT_DRV_H_

#include <tistdtypes.h>
#include <cslr_uart.h>

#define UART_FIFO_MODE		(1)
#undef  UART_NON_FIFO_MODE  (1)

typedef enum {
	NON_FIFO_MODE = 0,
	FIFO_MODE = 1
}UART_OpMode;

#define PARITY_SET_MASK    (CSL_UART_LCR_PEN_MASK|CSL_UART_LCR_EPS_MASK|CSL_UART_LCR_SP_MASK)


typedef enum {

	ParityDisable =         ((CSL_UART_LCR_PEN_DISABLE << CSL_UART_LCR_PEN_SHIFT)&CSL_UART_LCR_PEN_MASK)
						   |((CSL_UART_LCR_EPS_ODD << CSL_UART_LCR_EPS_SHIFT)&CSL_UART_LCR_EPS_MASK)
						   |((CSL_UART_LCR_SP_DISABLE << CSL_UART_LCR_SP_SHIFT)&CSL_UART_LCR_SP_MASK),

	ODD_ParityEnable_SET1 = ((CSL_UART_LCR_PEN_ENABLE << CSL_UART_LCR_PEN_SHIFT)&CSL_UART_LCR_PEN_MASK)
						   |((CSL_UART_LCR_EPS_ODD << CSL_UART_LCR_EPS_SHIFT)&CSL_UART_LCR_EPS_MASK)
						   |((CSL_UART_LCR_SP_DISABLE << CSL_UART_LCR_SP_SHIFT)&CSL_UART_LCR_SP_MASK),

	Even_ParityEnable_SET1 = ((CSL_UART_LCR_PEN_ENABLE << CSL_UART_LCR_PEN_SHIFT)&CSL_UART_LCR_PEN_MASK)
						   |((CSL_UART_LCR_EPS_EVEN << CSL_UART_LCR_EPS_SHIFT)&CSL_UART_LCR_EPS_MASK)
						   |((CSL_UART_LCR_SP_DISABLE << CSL_UART_LCR_SP_SHIFT)&CSL_UART_LCR_SP_MASK),

	StickParityEnable_SET = ((CSL_UART_LCR_PEN_ENABLE << CSL_UART_LCR_PEN_SHIFT)&CSL_UART_LCR_PEN_MASK)
						   |((CSL_UART_LCR_EPS_ODD << CSL_UART_LCR_EPS_SHIFT)&CSL_UART_LCR_EPS_MASK)
						   |((CSL_UART_LCR_SP_ENABLE << CSL_UART_LCR_SP_SHIFT)&CSL_UART_LCR_SP_MASK),

	StickParityEnable_CLR = ((CSL_UART_LCR_PEN_ENABLE << CSL_UART_LCR_PEN_SHIFT)&CSL_UART_LCR_PEN_MASK)
						   |((CSL_UART_LCR_EPS_EVEN << CSL_UART_LCR_EPS_SHIFT)&CSL_UART_LCR_EPS_MASK)
						   |((CSL_UART_LCR_SP_ENABLE << CSL_UART_LCR_SP_SHIFT)&CSL_UART_LCR_SP_MASK)
	
}UART_parityMode;

typedef enum{

	One_StopBit = ((CSL_UART_LCR_STB_1BIT << CSL_UART_LCR_STB_SHIFT) & CSL_UART_LCR_STB_MASK),

	WLS_StopBit = ((CSL_UART_LCR_STB_WLS << CSL_UART_LCR_STB_SHIFT) & CSL_UART_LCR_STB_MASK)
		
}UART_stopMode;

typedef enum{
	
	DataLen_5bit = ((CSL_UART_LCR_WLS_5BITS<<CSL_UART_LCR_WLS_SHIFT) & CSL_UART_LCR_WLS_MASK),
	DataLen_6bit = ((CSL_UART_LCR_WLS_6BITS<<CSL_UART_LCR_WLS_SHIFT) & CSL_UART_LCR_WLS_MASK),
	DataLen_7bit = ((CSL_UART_LCR_WLS_7BITS<<CSL_UART_LCR_WLS_SHIFT) & CSL_UART_LCR_WLS_MASK),
	DataLen_8bit = ((CSL_UART_LCR_WLS_8BITS<<CSL_UART_LCR_WLS_SHIFT) & CSL_UART_LCR_WLS_MASK)
	
}UART_dataLength;

#define AUTO_FLOW_CTRL_MASK (CSL_UART_MCR_AFE_MASK | CSL_UART_MCR_RTS_MASK)

typedef enum{
	
	AutoFlowDisable = ((CSL_UART_MCR_AFE_DISABLE << CSL_UART_MCR_AFE_SHIFT) & CSL_UART_MCR_AFE_MASK)
		             |((CSL_UART_MCR_RTS_DISABLE << CSL_UART_MCR_RTS_SHIFT) & CSL_UART_MCR_RTS_MASK),

	AutoFlow_CTS_Enable = ((CSL_UART_MCR_AFE_ENABLE << CSL_UART_MCR_AFE_SHIFT) & CSL_UART_MCR_AFE_MASK)
						 |((CSL_UART_MCR_RTS_DISABLE << CSL_UART_MCR_RTS_SHIFT) & CSL_UART_MCR_RTS_MASK),

	AutoFlow_RTS_CTS_Enable = ((CSL_UART_MCR_AFE_ENABLE << CSL_UART_MCR_AFE_SHIFT) & CSL_UART_MCR_AFE_MASK)
						 |((CSL_UART_MCR_RTS_ENABLE << CSL_UART_MCR_RTS_SHIFT) & CSL_UART_MCR_RTS_MASK)
}UART_autoFlow;
typedef enum{
	
	OverSampling_16x = 0,
	OverSampling_13x = 1
}UART_overSampling;

typedef enum{
	TriggerLevel_1Byte = 0,
	TriggerLevel_4Byte,
	TriggerLevel_8Byte,
	TriggerLevel_14Byte
}UART_triLevel;
typedef struct{
	Uint32 				baudRate;
	Uint32 				loopBackEnable;
	Uint32 				corePllInput;
	UART_OpMode         opMode;
	UART_parityMode 	parityMode;
	UART_stopMode   	stopMode;
	UART_dataLength 	dataLen;
	UART_autoFlow   	autoFlow;	
	UART_overSampling	osmSel;
	UART_triLevel   	fifoRxTriBytes;

}UART_Config;


extern int UART_Rx_Buf[2][8];

extern int Keystone_uartWrite_Busy(Uint32 uartNumber, char c);

extern int Keystone_uartWrite_String(Uint32 uartNumber, char *s);


extern UART_Config    gUARTCfg;
extern CSL_UartRegs   * UART_Regs;

extern void KeyStone_UART_init(UART_Config *pUARTCfg, Uint32 uartNumber);
extern void KeyStone_UART_calc();
extern void Keystone_uartInterrupt_Cfg();


#endif
