/* =========================================================================*
 * OMAPL138_ARM.cmd - Linker Command File for Linking OMAPL138 ARM Programs	*
 * 																			*
 * These linker options are for command line linking only. For IDE linking, *
 * you should set your linker options in Project Properties.				*
 * 		-c					Link Using C Conventions						*
 *		-stack 	0x1000		Software Stack Size								*
 *		-heap	0x1000		Heap Area Size									*
 * =========================================================================*/
-m test.map
-stack 0x1000
-heap 0x1000
-e _init_stack
--diag_remark=10063

/* =========================================================================*
 * 						Specify the System Memory Map						*
 * =========================================================================*/
MEMORY
{
	SHAREDRAM:		o = 0x80000000		l = 0x00020000
	ARMRAM:			o = 0xFFFF0000		l = 0x00002000
}

/* =========================================================================*
 * 				Specify the Sections Allocation into Memory					*
 * =========================================================================*/
SECTIONS
{
	.cinit		>		SHAREDRAM		/* Initialization Tables			*/
	.pinit		>		SHAREDRAM		/* C++ Constructor Tables			*/
	.const		>		SHAREDRAM		/* Constant Data					*/
	.switch		>		SHAREDRAM		/* Jump Tables						*/
	.text		>		SHAREDRAM		/* Executable Code					*/
	
	.bss		>		SHAREDRAM		/* Global & Static Variables 		*/
	.far		>		SHAREDRAM		/* Far Global & Static Variables	*/
	.stack		>		SHAREDRAM		/* Software System Stack			*/
	.svcstack	>		SHAREDRAM		/* Supervisor Mode Stack			*/
	.irqstack	>		SHAREDRAM		/* IRQ Interrupt Stack				*/
	.fiqstack	>		SHAREDRAM		/* FIQ Interrupt Stack				*/
	.sysmem		>		SHAREDRAM		/* Dynamic Memory Allocation Area 	*/

	.cio		>		SHAREDRAM		/* C I/O Buffer						*/
	.intvecs	>		ARMRAM			/* Interrupt Vectors				*/
	.data		>		SHAREDRAM
}