/*
 * cslr_syscfg1_OMAPL138.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** ============================================================================
 *   @file  cslr_sys.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for SYS
 */

#ifndef _CSLR_SYSCFG1_H_
#define _CSLR_SYSCFG1_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 VTPIO_CTL;
    volatile Uint32 DDR_SLEW;
    volatile Uint32 DEEPSLEEP;
    volatile Uint32 PUPD_ENA;
    volatile Uint32 PUPD_SEL;
    volatile Uint32 RXACTIVE;
    volatile Uint32 PWRDN;
} CSL_Syscfg1Regs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_Syscfg1Regs             *CSL_Syscfg1RegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* VTPIO_CTL */


#define CSL_SYSCFG1_VTPIO_CTL_VREFEN_MASK (0x00040000u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFEN_SHIFT (0x00000012u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFEN_RESETVAL (0x00000000u)
/*----VREFEN Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_VREFEN_EXTERNAL (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFEN_INTERNAL (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_VREFTAP_MASK (0x00030000u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFTAP_SHIFT (0x00000010u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFTAP_RESETVAL (0x00000000u)
/*----VREFTAP Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_VREFTAP_50_0 (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFTAP_47_5 (0x00000001u)
#define CSL_SYSCFG1_VTPIO_CTL_VREFTAP_52_5 (0x00000002u)

#define CSL_SYSCFG1_VTPIO_CTL_READY_MASK (0x00008000u)
#define CSL_SYSCFG1_VTPIO_CTL_READY_SHIFT (0x0000000Fu)
#define CSL_SYSCFG1_VTPIO_CTL_READY_RESETVAL (0x00000000u)
/*----READY Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_READY_NOT_READY (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_READY_READY (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_IOPWRDN_MASK (0x00004000u)
#define CSL_SYSCFG1_VTPIO_CTL_IOPWRDN_SHIFT (0x0000000Eu)
#define CSL_SYSCFG1_VTPIO_CTL_IOPWRDN_RESETVAL (0x00000000u)
/*----IOPWRDN Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_IOPWRDN_DISABLE (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_IOPWRDN_ENABLE (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_CLKRZ_MASK (0x00002000u)
#define CSL_SYSCFG1_VTPIO_CTL_CLKRZ_SHIFT (0x0000000Du)
#define CSL_SYSCFG1_VTPIO_CTL_CLKRZ_RESETVAL (0x00000000u)
/*----CLKRZ Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_CLKRZ_CLEAR (0x00000000u)

#define CSL_SYSCFG1_VTPIO_CTL_FORCEDNP_MASK (0x00001000u)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEDNP_SHIFT (0x0000000Cu)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEDNP_RESETVAL (0x00000000u)

#define CSL_SYSCFG1_VTPIO_CTL_FORCEDNN_MASK (0x00000800u)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEDNN_SHIFT (0x0000000Bu)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEDNN_RESETVAL (0x00000000u)

#define CSL_SYSCFG1_VTPIO_CTL_FORCEUPP_MASK (0x00000400u)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEUPP_SHIFT (0x0000000Au)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEUPP_RESETVAL (0x00000000u)

#define CSL_SYSCFG1_VTPIO_CTL_FORCEUPN_MASK (0x00000200u)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEUPN_SHIFT (0x00000009u)
#define CSL_SYSCFG1_VTPIO_CTL_FORCEUPN_RESETVAL (0x00000000u)

#define CSL_SYSCFG1_VTPIO_CTL_PWRSAVE_MASK (0x00000100u)
#define CSL_SYSCFG1_VTPIO_CTL_PWRSAVE_SHIFT (0x00000008u)
#define CSL_SYSCFG1_VTPIO_CTL_PWRSAVE_RESETVAL (0x00000000u)
/*----PWRSAVE Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_PWRSAVE_DISABLE (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_PWRSAVE_ENABLE (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_LOCK_MASK  (0x00000080u)
#define CSL_SYSCFG1_VTPIO_CTL_LOCK_SHIFT (0x00000007u)
#define CSL_SYSCFG1_VTPIO_CTL_LOCK_RESETVAL (0x00000000u)
/*----LOCK Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_LOCK_UNLOCK (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_LOCK_LOCK  (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_POWERDN_MASK (0x00000040u)
#define CSL_SYSCFG1_VTPIO_CTL_POWERDN_SHIFT (0x00000006u)
#define CSL_SYSCFG1_VTPIO_CTL_POWERDN_RESETVAL (0x00000001u)
/*----POWERDN Tokens----*/
#define CSL_SYSCFG1_VTPIO_CTL_POWERDN_DISABLE (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_POWERDN_ENABLE (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_D0_MASK    (0x00000020u)
#define CSL_SYSCFG1_VTPIO_CTL_D0_SHIFT   (0x00000005u)
#define CSL_SYSCFG1_VTPIO_CTL_D0_RESETVAL (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_D1_MASK    (0x00000010u)
#define CSL_SYSCFG1_VTPIO_CTL_D1_SHIFT   (0x00000004u)
#define CSL_SYSCFG1_VTPIO_CTL_D1_RESETVAL (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_D2_MASK    (0x00000008u)
#define CSL_SYSCFG1_VTPIO_CTL_D2_SHIFT   (0x00000003u)
#define CSL_SYSCFG1_VTPIO_CTL_D2_RESETVAL (0x00000000u)

#define CSL_SYSCFG1_VTPIO_CTL_F0_MASK    (0x00000004u)
#define CSL_SYSCFG1_VTPIO_CTL_F0_SHIFT   (0x00000002u)
#define CSL_SYSCFG1_VTPIO_CTL_F0_RESETVAL (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_F1_MASK    (0x00000002u)
#define CSL_SYSCFG1_VTPIO_CTL_F1_SHIFT   (0x00000001u)
#define CSL_SYSCFG1_VTPIO_CTL_F1_RESETVAL (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_F2_MASK    (0x00000001u)
#define CSL_SYSCFG1_VTPIO_CTL_F2_SHIFT   (0x00000000u)
#define CSL_SYSCFG1_VTPIO_CTL_F2_RESETVAL (0x00000001u)

#define CSL_SYSCFG1_VTPIO_CTL_RESETVAL   (0x00000077u)

/* DDR_SLEW */


#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMON_MASK (0x00000C00u)
#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMON_SHIFT (0x0000000Au)
#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMON_RESETVAL (0x00000000u)
/*----ODT_TERMON Tokens----*/
#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMON_NONE (0x00000000u)

#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMOFF_MASK (0x00000300u)
#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMOFF_SHIFT (0x00000008u)
#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMOFF_RESETVAL (0x00000000u)
/*----ODT_TERMOFF Tokens----*/
#define CSL_SYSCFG1_DDR_SLEW_ODT_TERMOFF_NONE (0x00000000u)


#define CSL_SYSCFG1_DDR_SLEW_DDR_PDENA_MASK (0x00000020u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_PDENA_SHIFT (0x00000005u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_PDENA_RESETVAL (0x00000000u)
/*----DDR_PDENA Tokens----*/
#define CSL_SYSCFG1_DDR_SLEW_DDR_PDENA_DISABLE (0x00000000u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_PDENA_ENABLE (0x00000001u)

#define CSL_SYSCFG1_DDR_SLEW_CMOSEN_MASK (0x00000010u)
#define CSL_SYSCFG1_DDR_SLEW_CMOSEN_SHIFT (0x00000004u)
#define CSL_SYSCFG1_DDR_SLEW_CMOSEN_RESETVAL (0x00000000u)
/*----CMOSEN Tokens----*/
#define CSL_SYSCFG1_DDR_SLEW_CMOSEN_SSTL (0x00000000u)
#define CSL_SYSCFG1_DDR_SLEW_CMOSEN_LVCMOS (0x00000001u)

#define CSL_SYSCFG1_DDR_SLEW_DDR_DATASLEW_MASK (0x0000000Cu)
#define CSL_SYSCFG1_DDR_SLEW_DDR_DATASLEW_SHIFT (0x00000002u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_DATASLEW_RESETVAL (0x00000000u)
/*----DDR_DATASLEW Tokens----*/
#define CSL_SYSCFG1_DDR_SLEW_DDR_DATASLEW_OFF (0x00000000u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_DATASLEW_ON (0x00000001u)

#define CSL_SYSCFG1_DDR_SLEW_DDR_CMDSLEW_MASK (0x00000003u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_CMDSLEW_SHIFT (0x00000000u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_CMDSLEW_RESETVAL (0x00000000u)
/*----DDR_CMDSLEW Tokens----*/
#define CSL_SYSCFG1_DDR_SLEW_DDR_CMDSLEW_OFF (0x00000000u)
#define CSL_SYSCFG1_DDR_SLEW_DDR_CMDSLEW_ON (0x00000001u)

#define CSL_SYSCFG1_DDR_SLEW_RESETVAL    (0x00000000u)

/* DEEPSLEEP */

#define CSL_SYSCFG1_DEEPSLEEP_SLEEPENABLE_MASK (0x80000000u)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPENABLE_SHIFT (0x0000001Fu)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPENABLE_RESETVAL (0x00000000u)
/*----SLEEPENABLE Tokens----*/
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPENABLE_NORMAL (0x00000000u)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPENABLE_DEEPSLEEP (0x00000001u)

#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOMPLETE_MASK (0x40000000u)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOMPLETE_SHIFT (0x0000001Eu)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOMPLETE_RESETVAL (0x00000000u)
/*----SLEEPCOMPLETE Tokens----*/
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOMPLETE_CONTINUE (0x00000000u)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOMPLETE_DONE (0x00000001u)


#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOUNT_MASK (0x0000FFFFu)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOUNT_SHIFT (0x00000000u)
#define CSL_SYSCFG1_DEEPSLEEP_SLEEPCOUNT_RESETVAL (0x0000FFFFu)

#define CSL_SYSCFG1_DEEPSLEEP_RESETVAL   (0x0000FFFFu)

/* PUPD_ENA */

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA31_MASK (0x80000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA31_SHIFT (0x0000001Fu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA31_RESETVAL (0x00000001u)
/*----PUPDENA31 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA31_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA31_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA30_MASK (0x40000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA30_SHIFT (0x0000001Eu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA30_RESETVAL (0x00000001u)
/*----PUPDENA30 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA30_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA30_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA29_MASK (0x20000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA29_SHIFT (0x0000001Du)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA29_RESETVAL (0x00000001u)
/*----PUPDENA29 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA29_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA29_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA28_MASK (0x10000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA28_RESETVAL (0x00000001u)
/*----PUPDENA28 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA28_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA28_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA27_MASK (0x08000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA27_SHIFT (0x0000001Bu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA27_RESETVAL (0x00000001u)
/*----PUPDENA27 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA27_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA27_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA26_MASK (0x04000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA26_SHIFT (0x0000001Au)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA26_RESETVAL (0x00000001u)
/*----PUPDENA26 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA26_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA26_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA25_MASK (0x02000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA25_SHIFT (0x00000019u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA25_RESETVAL (0x00000001u)
/*----PUPDENA25 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA25_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA25_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA24_MASK (0x01000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA24_SHIFT (0x00000018u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA24_RESETVAL (0x00000001u)
/*----PUPDENA24 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA24_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA24_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA23_MASK (0x00800000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA23_SHIFT (0x00000017u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA23_RESETVAL (0x00000001u)
/*----PUPDENA23 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA23_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA23_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA22_MASK (0x00400000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA22_SHIFT (0x00000016u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA22_RESETVAL (0x00000001u)
/*----PUPDENA22 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA22_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA22_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA21_MASK (0x00200000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA21_SHIFT (0x00000015u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA21_RESETVAL (0x00000001u)
/*----PUPDENA21 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA21_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA21_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA20_MASK (0x00100000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA20_SHIFT (0x00000014u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA20_RESETVAL (0x00000001u)
/*----PUPDENA20 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA20_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA20_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA19_MASK (0x00080000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA19_SHIFT (0x00000013u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA19_RESETVAL (0x00000001u)
/*----PUPDENA19 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA19_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA19_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA18_MASK (0x00040000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA18_SHIFT (0x00000012u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA18_RESETVAL (0x00000001u)
/*----PUPDENA18 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA18_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA18_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA17_MASK (0x00020000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA17_SHIFT (0x00000011u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA17_RESETVAL (0x00000001u)
/*----PUPDENA17 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA17_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA17_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA16_MASK (0x00010000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA16_SHIFT (0x00000010u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA16_RESETVAL (0x00000001u)
/*----PUPDENA16 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA16_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA16_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA15_MASK (0x00008000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA15_SHIFT (0x0000000Fu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA15_RESETVAL (0x00000001u)
/*----PUPDENA15 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA15_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA15_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA14_MASK (0x00004000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA14_SHIFT (0x0000000Eu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA14_RESETVAL (0x00000001u)
/*----PUPDENA14 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA14_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA14_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA13_MASK (0x00002000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA13_SHIFT (0x0000000Du)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA13_RESETVAL (0x00000001u)
/*----PUPDENA13 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA13_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA13_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA12_MASK (0x00001000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA12_RESETVAL (0x00000001u)
/*----PUPDENA12 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA12_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA12_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA11_MASK (0x00000800u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA11_SHIFT (0x0000000Bu)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA11_RESETVAL (0x00000001u)
/*----PUPDENA11 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA11_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA11_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA10_MASK (0x00000400u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA10_SHIFT (0x0000000Au)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA10_RESETVAL (0x00000001u)
/*----PUPDENA10 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA10_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA10_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA9_MASK (0x00000200u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA9_SHIFT (0x00000009u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA9_RESETVAL (0x00000001u)
/*----PUPDENA9 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA9_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA9_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA8_MASK (0x00000100u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA8_SHIFT (0x00000008u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA8_RESETVAL (0x00000001u)
/*----PUPDENA8 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA8_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA8_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA7_MASK (0x00000080u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA7_SHIFT (0x00000007u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA7_RESETVAL (0x00000001u)
/*----PUPDENA7 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA7_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA7_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA6_MASK (0x00000040u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA6_SHIFT (0x00000006u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA6_RESETVAL (0x00000001u)
/*----PUPDENA6 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA6_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA6_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA5_MASK (0x00000020u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA5_SHIFT (0x00000005u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA5_RESETVAL (0x00000001u)
/*----PUPDENA5 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA5_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA5_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA4_MASK (0x00000010u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA4_SHIFT (0x00000004u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA4_RESETVAL (0x00000001u)
/*----PUPDENA4 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA4_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA4_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA3_MASK (0x00000008u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA3_SHIFT (0x00000003u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA3_RESETVAL (0x00000001u)
/*----PUPDENA3 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA3_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA3_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA2_MASK (0x00000004u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA2_SHIFT (0x00000002u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA2_RESETVAL (0x00000001u)
/*----PUPDENA2 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA2_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA2_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA1_MASK (0x00000002u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA1_SHIFT (0x00000001u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA1_RESETVAL (0x00000001u)
/*----PUPDENA1 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA1_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA1_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_PUPDENA0_MASK (0x00000001u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA0_SHIFT (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA0_RESETVAL (0x00000001u)
/*----PUPDENA0 Tokens----*/
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA0_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PUPD_ENA_PUPDENA0_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PUPD_ENA_RESETVAL    (0xFFFFFFFFu)

/* PUPD_SEL */

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL31_MASK (0x80000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL31_SHIFT (0x0000001Fu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL31_RESETVAL (0x00000001u)
/*----PUPDSEL31 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL31_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL31_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL30_MASK (0x40000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL30_SHIFT (0x0000001Eu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL30_RESETVAL (0x00000001u)
/*----PUPDSEL30 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL30_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL30_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL29_MASK (0x20000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL29_SHIFT (0x0000001Du)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL29_RESETVAL (0x00000001u)
/*----PUPDSEL29 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL29_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL29_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL28_MASK (0x10000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL28_RESETVAL (0x00000001u)
/*----PUPDSEL28 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL28_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL28_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL27_MASK (0x08000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL27_SHIFT (0x0000001Bu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL27_RESETVAL (0x00000001u)
/*----PUPDSEL27 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL27_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL27_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL26_MASK (0x04000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL26_SHIFT (0x0000001Au)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL26_RESETVAL (0x00000001u)
/*----PUPDSEL26 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL26_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL26_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL25_MASK (0x02000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL25_SHIFT (0x00000019u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL25_RESETVAL (0x00000001u)
/*----PUPDSEL25 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL25_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL25_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL24_MASK (0x01000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL24_SHIFT (0x00000018u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL24_RESETVAL (0x00000001u)
/*----PUPDSEL24 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL24_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL24_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL23_MASK (0x00800000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL23_SHIFT (0x00000017u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL23_RESETVAL (0x00000001u)
/*----PUPDSEL23 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL23_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL23_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL22_MASK (0x00400000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL22_SHIFT (0x00000016u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL22_RESETVAL (0x00000001u)
/*----PUPDSEL22 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL22_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL22_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL21_MASK (0x00200000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL21_SHIFT (0x00000015u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL21_RESETVAL (0x00000001u)
/*----PUPDSEL21 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL21_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL21_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL20_MASK (0x00100000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL20_SHIFT (0x00000014u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL20_RESETVAL (0x00000001u)
/*----PUPDSEL20 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL20_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL20_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL19_MASK (0x00080000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL19_SHIFT (0x00000013u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL19_RESETVAL (0x00000001u)
/*----PUPDSEL19 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL19_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL19_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL18_MASK (0x00040000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL18_SHIFT (0x00000012u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL18_RESETVAL (0x00000001u)
/*----PUPDSEL18 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL18_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL18_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL17_MASK (0x00020000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL17_SHIFT (0x00000011u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL17_RESETVAL (0x00000001u)
/*----PUPDSEL17 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL17_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL17_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL16_MASK (0x00010000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL16_SHIFT (0x00000010u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL16_RESETVAL (0x00000001u)
/*----PUPDSEL16 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL16_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL16_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL15_MASK (0x00008000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL15_SHIFT (0x0000000Fu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL15_RESETVAL (0x00000001u)
/*----PUPDSEL15 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL15_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL15_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL14_MASK (0x00004000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL14_SHIFT (0x0000000Eu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL14_RESETVAL (0x00000001u)
/*----PUPDSEL14 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL14_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL14_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL13_MASK (0x00002000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL13_SHIFT (0x0000000Du)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL13_RESETVAL (0x00000001u)
/*----PUPDSEL13 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL13_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL13_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL12_MASK (0x00001000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL12_RESETVAL (0x00000001u)
/*----PUPDSEL12 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL12_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL12_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL11_MASK (0x00000800u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL11_SHIFT (0x0000000Bu)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL11_RESETVAL (0x00000001u)
/*----PUPDSEL11 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL11_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL11_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL10_MASK (0x00000400u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL10_SHIFT (0x0000000Au)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL10_RESETVAL (0x00000001u)
/*----PUPDSEL10 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL10_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL10_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL9_MASK (0x00000200u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL9_SHIFT (0x00000009u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL9_RESETVAL (0x00000001u)
/*----PUPDSEL9 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL9_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL9_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL8_MASK (0x00000100u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL8_SHIFT (0x00000008u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL8_RESETVAL (0x00000001u)
/*----PUPDSEL8 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL8_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL8_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL7_MASK (0x00000080u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL7_SHIFT (0x00000007u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL7_RESETVAL (0x00000001u)
/*----PUPDSEL7 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL7_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL7_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL6_MASK (0x00000040u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL6_SHIFT (0x00000006u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL6_RESETVAL (0x00000001u)
/*----PUPDSEL6 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL6_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL6_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL5_MASK (0x00000020u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL5_SHIFT (0x00000005u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL5_RESETVAL (0x00000001u)
/*----PUPDSEL5 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL5_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL5_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL4_MASK (0x00000010u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL4_SHIFT (0x00000004u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL4_RESETVAL (0x00000001u)
/*----PUPDSEL4 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL4_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL4_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL3_MASK (0x00000008u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL3_SHIFT (0x00000003u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL3_RESETVAL (0x00000001u)
/*----PUPDSEL3 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL3_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL3_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL2_MASK (0x00000004u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL2_SHIFT (0x00000002u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL2_RESETVAL (0x00000001u)
/*----PUPDSEL2 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL2_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL2_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL1_MASK (0x00000002u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL1_SHIFT (0x00000001u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL1_RESETVAL (0x00000001u)
/*----PUPDSEL1 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL1_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL1_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL0_MASK (0x00000001u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL0_SHIFT (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL0_RESETVAL (0x00000001u)
/*----PUPDSEL0 Tokens----*/
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL0_PULLDOWN (0x00000000u)
#define CSL_SYSCFG1_PUPD_SEL_PUPDSEL0_PULLUP (0x00000001u)

#define CSL_SYSCFG1_PUPD_SEL_RESETVAL    (0xFFFFFFFFu)

/* RXACTIVE */

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE31_MASK (0x80000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE31_SHIFT (0x0000001Fu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE31_RESETVAL (0x00000001u)
/*----RXACTIVE31 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE31_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE31_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE30_MASK (0x40000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE30_SHIFT (0x0000001Eu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE30_RESETVAL (0x00000001u)
/*----RXACTIVE30 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE30_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE30_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE29_MASK (0x20000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE29_SHIFT (0x0000001Du)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE29_RESETVAL (0x00000001u)
/*----RXACTIVE29 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE29_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE29_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE28_MASK (0x10000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE28_RESETVAL (0x00000001u)
/*----RXACTIVE28 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE28_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE28_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE27_MASK (0x08000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE27_SHIFT (0x0000001Bu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE27_RESETVAL (0x00000001u)
/*----RXACTIVE27 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE27_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE27_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE26_MASK (0x04000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE26_SHIFT (0x0000001Au)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE26_RESETVAL (0x00000001u)
/*----RXACTIVE26 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE26_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE26_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE25_MASK (0x02000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE25_SHIFT (0x00000019u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE25_RESETVAL (0x00000001u)
/*----RXACTIVE25 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE25_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE25_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE24_MASK (0x01000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE24_SHIFT (0x00000018u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE24_RESETVAL (0x00000001u)
/*----RXACTIVE24 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE24_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE24_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE23_MASK (0x00800000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE23_SHIFT (0x00000017u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE23_RESETVAL (0x00000001u)
/*----RXACTIVE23 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE23_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE23_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE22_MASK (0x00400000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE22_SHIFT (0x00000016u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE22_RESETVAL (0x00000001u)
/*----RXACTIVE22 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE22_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE22_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE21_MASK (0x00200000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE21_SHIFT (0x00000015u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE21_RESETVAL (0x00000001u)
/*----RXACTIVE21 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE21_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE21_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE20_MASK (0x00100000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE20_SHIFT (0x00000014u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE20_RESETVAL (0x00000001u)
/*----RXACTIVE20 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE20_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE20_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE19_MASK (0x00080000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE19_SHIFT (0x00000013u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE19_RESETVAL (0x00000001u)
/*----RXACTIVE19 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE19_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE19_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE18_MASK (0x00040000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE18_SHIFT (0x00000012u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE18_RESETVAL (0x00000001u)
/*----RXACTIVE18 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE18_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE18_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE17_MASK (0x00020000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE17_SHIFT (0x00000011u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE17_RESETVAL (0x00000001u)
/*----RXACTIVE17 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE17_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE17_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE16_MASK (0x00010000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE16_SHIFT (0x00000010u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE16_RESETVAL (0x00000001u)
/*----RXACTIVE16 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE16_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE16_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE15_MASK (0x00008000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE15_SHIFT (0x0000000Fu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE15_RESETVAL (0x00000001u)
/*----RXACTIVE15 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE15_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE15_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE14_MASK (0x00004000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE14_SHIFT (0x0000000Eu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE14_RESETVAL (0x00000001u)
/*----RXACTIVE14 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE14_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE14_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE13_MASK (0x00002000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE13_SHIFT (0x0000000Du)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE13_RESETVAL (0x00000001u)
/*----RXACTIVE13 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE13_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE13_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE12_MASK (0x00001000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE12_RESETVAL (0x00000001u)
/*----RXACTIVE12 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE12_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE12_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE11_MASK (0x00000800u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE11_SHIFT (0x0000000Bu)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE11_RESETVAL (0x00000001u)
/*----RXACTIVE11 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE11_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE11_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE10_MASK (0x00000400u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE10_SHIFT (0x0000000Au)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE10_RESETVAL (0x00000001u)
/*----RXACTIVE10 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE10_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE10_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE9_MASK (0x00000200u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE9_SHIFT (0x00000009u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE9_RESETVAL (0x00000001u)
/*----RXACTIVE9 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE9_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE9_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE8_MASK (0x00000100u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE8_SHIFT (0x00000008u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE8_RESETVAL (0x00000001u)
/*----RXACTIVE8 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE8_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE8_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE7_MASK (0x00000080u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE7_SHIFT (0x00000007u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE7_RESETVAL (0x00000001u)
/*----RXACTIVE7 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE7_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE7_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE6_MASK (0x00000040u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE6_SHIFT (0x00000006u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE6_RESETVAL (0x00000001u)
/*----RXACTIVE6 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE6_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE6_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE5_MASK (0x00000020u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE5_SHIFT (0x00000005u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE5_RESETVAL (0x00000001u)
/*----RXACTIVE5 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE5_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE5_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE4_MASK (0x00000010u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE4_SHIFT (0x00000004u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE4_RESETVAL (0x00000001u)
/*----RXACTIVE4 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE4_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE4_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE3_MASK (0x00000008u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE3_SHIFT (0x00000003u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE3_RESETVAL (0x00000001u)
/*----RXACTIVE3 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE3_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE3_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE2_MASK (0x00000004u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE2_SHIFT (0x00000002u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE2_RESETVAL (0x00000001u)
/*----RXACTIVE2 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE2_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE2_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE1_MASK (0x00000002u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE1_SHIFT (0x00000001u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE1_RESETVAL (0x00000001u)
/*----RXACTIVE1 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE1_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE1_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RXACTIVE0_MASK (0x00000001u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE0_SHIFT (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE0_RESETVAL (0x00000001u)
/*----RXACTIVE0 Tokens----*/
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE0_DISABLE (0x00000000u)
#define CSL_SYSCFG1_RXACTIVE_RXACTIVE0_ENABLE (0x00000001u)

#define CSL_SYSCFG1_RXACTIVE_RESETVAL    (0xFFFFFFFFu)

/* PWRDN */


#define CSL_SYSCFG1_PWRDN_SATACLK_PWRDN_MASK (0x00000001u)
#define CSL_SYSCFG1_PWRDN_SATACLK_PWRDN_SHIFT (0x00000000u)
#define CSL_SYSCFG1_PWRDN_SATACLK_PWRDN_RESETVAL (0x00000001u)
/*----SATACLK_PWRDN Tokens----*/
#define CSL_SYSCFG1_PWRDN_SATACLK_PWRDN_DISABLE (0x00000000u)
#define CSL_SYSCFG1_PWRDN_SATACLK_PWRDN_ENABLE (0x00000001u)

#define CSL_SYSCFG1_PWRDN_RESETVAL       (0x00000003u)

#ifdef __cplusplus
}
#endif/* #ifdef __cplusplus */
#endif  /* _CSLR_SYSCFG1_H_ */
