/*
 * cslr_syscfg_OMAPL137.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** ============================================================================
 *   @file  cslr_sys.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for SYS
 */

#ifndef _CSLR_SYS_H_
#define _CSLR_SYS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint8 RSVD0[4];
    volatile Uint32 DIEIDR0;
    volatile Uint32 DIEIDR1;
    volatile Uint32 DIEIDR2;
    volatile Uint32 DIEIDR3;
    volatile Uint32 DEVIDR0;
    volatile Uint32 DEVIDR1;
    volatile Uint32 BOOTCFG;
    volatile Uint32 CHIPREVIDR;
    volatile Uint8 RSVD1[16];
    volatile Uint32 KICK0R;
    volatile Uint32 KICK1R;
    volatile Uint32 HOST0CFG;
    volatile Uint32 HOST1CFG;
    volatile Uint8 RSVD2[152];
    volatile Uint32 IRAWSTAT;
    volatile Uint32 IENSTAT;
    volatile Uint32 IENSET;
    volatile Uint32 IENCLR;
    volatile Uint32 EOI;
    volatile Uint32 FLTADDRR;
    volatile Uint32 FLTSTAT;
    volatile Uint8 RSVD3[20];
    volatile Uint32 MSTPRI0;
    volatile Uint32 MSTPRI1;
    volatile Uint32 MSTPRI2;
    volatile Uint8 RSVD4[4];
    volatile Uint32 PINMUX0;
    volatile Uint32 PINMUX1;
    volatile Uint32 PINMUX2;
    volatile Uint32 PINMUX3;
    volatile Uint32 PINMUX4;
    volatile Uint32 PINMUX5;
    volatile Uint32 PINMUX6;
    volatile Uint32 PINMUX7;
    volatile Uint32 PINMUX8;
    volatile Uint32 PINMUX9;
    volatile Uint32 PINMUX10;
    volatile Uint32 PINMUX11;
    volatile Uint32 PINMUX12;
    volatile Uint32 PINMUX13;
    volatile Uint32 PINMUX14;
    volatile Uint32 PINMUX15;
    volatile Uint32 PINMUX16;
    volatile Uint32 PINMUX17;
    volatile Uint32 PINMUX18;
    volatile Uint32 PINMUX19;
    volatile Uint32 SUSPSRC;
    volatile Uint32 CHIPSIG;
    volatile Uint32 CHIPSIG_CLR;
    volatile Uint32 CFGCHIP0;
    volatile Uint32 CFGCHIP1;
    volatile Uint32 CFGCHIP2;
    volatile Uint32 CFGCHIP3;
    volatile Uint32 CFGCHIP4;
} CSL_SyscfgRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_SyscfgRegs             *CSL_SyscfgRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_SYSCFG_REVID_REVID_MASK      (0xFFFFFFFFu)
#define CSL_SYSCFG_REVID_REVID_SHIFT     (0x00000000u)
#define CSL_SYSCFG_REVID_REVID_RESETVAL  (0x00000000u)

#define CSL_SYSCFG_REVID_RESETVAL        (0x00000000u)

/* DIEIDR0 */

#define CSL_SYSCFG_DIEIDR0_DIEID0_MASK   (0xFFFFFFFFu)
#define CSL_SYSCFG_DIEIDR0_DIEID0_SHIFT  (0x00000000u)
#define CSL_SYSCFG_DIEIDR0_DIEID0_RESETVAL (0x00000000u)

#define CSL_SYSCFG_DIEIDR0_RESETVAL      (0x00000000u)

/* DIEIDR1 */

#define CSL_SYSCFG_DIEIDR1_DIEID1_MASK   (0xFFFFFFFFu)
#define CSL_SYSCFG_DIEIDR1_DIEID1_SHIFT  (0x00000000u)
#define CSL_SYSCFG_DIEIDR1_DIEID1_RESETVAL (0x00000000u)

#define CSL_SYSCFG_DIEIDR1_RESETVAL      (0x00000000u)

/* DIEIDR2 */

#define CSL_SYSCFG_DIEIDR2_DIEID2_MASK   (0xFFFFFFFFu)
#define CSL_SYSCFG_DIEIDR2_DIEID2_SHIFT  (0x00000000u)
#define CSL_SYSCFG_DIEIDR2_DIEID2_RESETVAL (0x00000000u)

#define CSL_SYSCFG_DIEIDR2_RESETVAL      (0x00000000u)

/* DIEIDR3 */

#define CSL_SYSCFG_DIEIDR3_DIEID3_MASK   (0xFFFFFFFFu)
#define CSL_SYSCFG_DIEIDR3_DIEID3_SHIFT  (0x00000000u)
#define CSL_SYSCFG_DIEIDR3_DIEID3_RESETVAL (0x00000000u)

#define CSL_SYSCFG_DIEIDR3_RESETVAL      (0x00000000u)

/* DEVIDR0 */

#define CSL_SYSCFG_DEVIDR0_DEVID0_MASK   (0xFFFFFFFFu)
#define CSL_SYSCFG_DEVIDR0_DEVID0_SHIFT  (0x00000000u)
#define CSL_SYSCFG_DEVIDR0_DEVID0_RESETVAL (0x00000000u)

#define CSL_SYSCFG_DEVIDR0_RESETVAL      (0x00000000u)

/* DEVIDR1 */

#define CSL_SYSCFG_DEVIDR1_DEVID1_MASK   (0xFFFFFFFFu)
#define CSL_SYSCFG_DEVIDR1_DEVID1_SHIFT  (0x00000000u)
#define CSL_SYSCFG_DEVIDR1_DEVID1_RESETVAL (0x00000000u)

#define CSL_SYSCFG_DEVIDR1_RESETVAL      (0x00000000u)

/* BOOTCFG */


#define CSL_SYSCFG_BOOTCFG_SMARTRFLX_MASK (0x0FFF0000u)
#define CSL_SYSCFG_BOOTCFG_SMARTRFLX_SHIFT (0x00000010u)
#define CSL_SYSCFG_BOOTCFG_SMARTRFLX_RESETVAL (0x00000000u)

#define CSL_SYSCFG_BOOTCFG_BOOTMODE_MASK (0x0000FFFFu)
#define CSL_SYSCFG_BOOTCFG_BOOTMODE_SHIFT (0x00000000u)
#define CSL_SYSCFG_BOOTCFG_BOOTMODE_RESETVAL (0x00000000u)

#define CSL_SYSCFG_BOOTCFG_RESETVAL      (0x00000000u)

/* CHIPREVIDR */


#define CSL_SYSCFG_CHIPREVIDR_CHIPREVID_MASK (0x0000003Fu)
#define CSL_SYSCFG_CHIPREVIDR_CHIPREVID_SHIFT (0x00000000u)
#define CSL_SYSCFG_CHIPREVIDR_CHIPREVID_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CHIPREVIDR_RESETVAL   (0x00000000u)

/* KICK0R */

#define CSL_SYSCFG_KICK0R_KICK0_MASK     (0xFFFFFFFFu)
#define CSL_SYSCFG_KICK0R_KICK0_SHIFT    (0x00000000u)
#define CSL_SYSCFG_KICK0R_KICK0_RESETVAL (0x00000000u)

#define CSL_SYSCFG_KICK0R_RESETVAL       (0x00000000u)

/* KICK1R */

#define CSL_SYSCFG_KICK1R_KICK1_MASK     (0xFFFFFFFFu)
#define CSL_SYSCFG_KICK1R_KICK1_SHIFT    (0x00000000u)
#define CSL_SYSCFG_KICK1R_KICK1_RESETVAL (0x00000000u)

#define CSL_SYSCFG_KICK1R_RESETVAL       (0x00000000u)

/* HOST0CFG */

#define CSL_SYSCFG_HOST0CFG_BOOTRDY_MASK (0x00000001u)
#define CSL_SYSCFG_HOST0CFG_BOOTRDY_SHIFT (0x00000000u)
#define CSL_SYSCFG_HOST0CFG_BOOTRDY_RESETVAL (0x00000000u)


#define CSL_SYSCFG_HOST0CFG_RESETVAL     (0x00000000u)

/* HOST1CFG */

#define CSL_SYSCFG_HOST1CFG_BOOTRDY_MASK (0x00000001u)
#define CSL_SYSCFG_HOST1CFG_BOOTRDY_SHIFT (0x00000000u)
#define CSL_SYSCFG_HOST1CFG_BOOTRDY_RESETVAL (0x00000001u)


#define CSL_SYSCFG_HOST1CFG_DSP_ISTP_RST_VAL_MASK (0xFFFFFC00u)
#define CSL_SYSCFG_HOST1CFG_DSP_ISTP_RST_VAL_SHIFT (0x0000000Au)
#define CSL_SYSCFG_HOST1CFG_DSP_ISTP_RST_VAL_RESETVAL (0x00001C00u)

#define CSL_SYSCFG_HOST1CFG_RESETVAL     (0x00700001u)

/* IRAWSTAT */


#define CSL_SYSCFG_IRAWSTAT_ADDRERR_MASK (0x00000002u)
#define CSL_SYSCFG_IRAWSTAT_ADDRERR_SHIFT (0x00000001u)
#define CSL_SYSCFG_IRAWSTAT_ADDRERR_RESETVAL (0x00000000u)
/*----ADDRERR Tokens----*/
#define CSL_SYSCFG_IRAWSTAT_ADDRERR_NOTSET (0x00000000u)
#define CSL_SYSCFG_IRAWSTAT_ADDRERR_SET  (0x00000001u)

#define CSL_SYSCFG_IRAWSTAT_PROTERR_MASK (0x00000001u)
#define CSL_SYSCFG_IRAWSTAT_PROTERR_SHIFT (0x00000000u)
#define CSL_SYSCFG_IRAWSTAT_PROTERR_RESETVAL (0x00000000u)
/*----PROTERR Tokens----*/
#define CSL_SYSCFG_IRAWSTAT_PROTERR_NOTSET (0x00000000u)
#define CSL_SYSCFG_IRAWSTAT_PROTERR_SET  (0x00000001u)

#define CSL_SYSCFG_IRAWSTAT_RESETVAL     (0x00000000u)

/* IENSTAT */


#define CSL_SYSCFG_IENSTAT_ADDRERR_MASK  (0x00000002u)
#define CSL_SYSCFG_IENSTAT_ADDRERR_SHIFT (0x00000001u)
#define CSL_SYSCFG_IENSTAT_ADDRERR_RESETVAL (0x00000000u)
/*----ADDRERR Tokens----*/
#define CSL_SYSCFG_IENSTAT_ADDRERR_NOTSET (0x00000000u)
#define CSL_SYSCFG_IENSTAT_ADDRERR_SET_CLEAR (0x00000001u)

#define CSL_SYSCFG_IENSTAT_PROTERR_MASK  (0x00000001u)
#define CSL_SYSCFG_IENSTAT_PROTERR_SHIFT (0x00000000u)
#define CSL_SYSCFG_IENSTAT_PROTERR_RESETVAL (0x00000000u)
/*----PROTERR Tokens----*/
#define CSL_SYSCFG_IENSTAT_PROTERR_NOTSET (0x00000000u)
#define CSL_SYSCFG_IENSTAT_PROTERR_SET_CLEAR (0x00000001u)

#define CSL_SYSCFG_IENSTAT_RESETVAL      (0x00000000u)

/* IENSET */


#define CSL_SYSCFG_IENSET_ADDRERR_EN_MASK (0x00000002u)
#define CSL_SYSCFG_IENSET_ADDRERR_EN_SHIFT (0x00000001u)
#define CSL_SYSCFG_IENSET_ADDRERR_EN_RESETVAL (0x00000000u)
/*----ADDRERR_EN Tokens----*/
#define CSL_SYSCFG_IENSET_ADDRERR_EN_SET_EN (0x00000001u)

#define CSL_SYSCFG_IENSET_PROTERR_EN_MASK (0x00000001u)
#define CSL_SYSCFG_IENSET_PROTERR_EN_SHIFT (0x00000000u)
#define CSL_SYSCFG_IENSET_PROTERR_EN_RESETVAL (0x00000000u)
/*----PROTERR_EN Tokens----*/
#define CSL_SYSCFG_IENSET_PROTERR_EN_SET_EN (0x00000001u)

#define CSL_SYSCFG_IENSET_RESETVAL       (0x00000000u)

/* IENCLR */


#define CSL_SYSCFG_IENCLR_ADDRERR_CLR_MASK (0x00000002u)
#define CSL_SYSCFG_IENCLR_ADDRERR_CLR_SHIFT (0x00000001u)
#define CSL_SYSCFG_IENCLR_ADDRERR_CLR_RESETVAL (0x00000000u)
/*----ADDRERR_CLR Tokens----*/
#define CSL_SYSCFG_IENCLR_ADDRERR_CLR_CLEAR_DIS (0x00000001u)

#define CSL_SYSCFG_IENCLR_PROTERR_CLR_MASK (0x00000001u)
#define CSL_SYSCFG_IENCLR_PROTERR_CLR_SHIFT (0x00000000u)
#define CSL_SYSCFG_IENCLR_PROTERR_CLR_RESETVAL (0x00000000u)
/*----PROTERR_CLR Tokens----*/
#define CSL_SYSCFG_IENCLR_PROTERR_CLR_CLEAR_DIS (0x00000001u)

#define CSL_SYSCFG_IENCLR_RESETVAL       (0x00000000u)

/* EOI */


#define CSL_SYSCFG_EOI_EOIVECT_MASK      (0x000000FFu)
#define CSL_SYSCFG_EOI_EOIVECT_SHIFT     (0x00000000u)
#define CSL_SYSCFG_EOI_EOIVECT_RESETVAL  (0x00000000u)

#define CSL_SYSCFG_EOI_RESETVAL          (0x00000000u)

/* FLTADDRR */

#define CSL_SYSCFG_FLTADDRR_FLTADDR_MASK (0xFFFFFFFFu)
#define CSL_SYSCFG_FLTADDRR_FLTADDR_SHIFT (0x00000000u)
#define CSL_SYSCFG_FLTADDRR_FLTADDR_RESETVAL (0x00000000u)

#define CSL_SYSCFG_FLTADDRR_RESETVAL     (0x00000000u)

/* FLTSTAT */

#define CSL_SYSCFG_FLTSTAT_ID_MASK       (0xFF000000u)
#define CSL_SYSCFG_FLTSTAT_ID_SHIFT      (0x00000018u)
#define CSL_SYSCFG_FLTSTAT_ID_RESETVAL   (0x00000000u)

#define CSL_SYSCFG_FLTSTAT_MSTID_MASK    (0x00FF0000u)
#define CSL_SYSCFG_FLTSTAT_MSTID_SHIFT   (0x00000010u)
#define CSL_SYSCFG_FLTSTAT_MSTID_RESETVAL (0x00000000u)


#define CSL_SYSCFG_FLTSTAT_PRIVID_MASK   (0x00001E00u)
#define CSL_SYSCFG_FLTSTAT_PRIVID_SHIFT  (0x00000009u)
#define CSL_SYSCFG_FLTSTAT_PRIVID_RESETVAL (0x00000000u)


#define CSL_SYSCFG_FLTSTAT_NOSECACC_MASK (0x00000080u)
#define CSL_SYSCFG_FLTSTAT_NOSECACC_SHIFT (0x00000007u)
#define CSL_SYSCFG_FLTSTAT_NOSECACC_RESETVAL (0x00000000u)


#define CSL_SYSCFG_FLTSTAT_TYPE_MASK     (0x0000003Fu)
#define CSL_SYSCFG_FLTSTAT_TYPE_SHIFT    (0x00000000u)
#define CSL_SYSCFG_FLTSTAT_TYPE_RESETVAL (0x00000000u)
/*----TYPE Tokens----*/
#define CSL_SYSCFG_FLTSTAT_TYPE_NOFLT    (0x00000000u)
#define CSL_SYSCFG_FLTSTAT_TYPE_USREXE   (0x00000001u)
#define CSL_SYSCFG_FLTSTAT_TYPE_USRWR    (0x00000002u)
#define CSL_SYSCFG_FLTSTAT_TYPE_USRRD    (0x00000004u)
#define CSL_SYSCFG_FLTSTAT_TYPE_SPREXE   (0x00000008u)
#define CSL_SYSCFG_FLTSTAT_TYPE_SPRWR    (0x00000010u)
#define CSL_SYSCFG_FLTSTAT_TYPE_SPRRD    (0x00000020u)

#define CSL_SYSCFG_FLTSTAT_RESETVAL      (0x00000000u)

/* MSTPRI0 */


#define CSL_SYSCFG_MSTPRI0_DSP_CFG_MASK  (0x00007000u)
#define CSL_SYSCFG_MSTPRI0_DSP_CFG_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_MSTPRI0_DSP_CFG_RESETVAL (0x00000002u)


#define CSL_SYSCFG_MSTPRI0_DSP_MDMA_MASK (0x00000700u)
#define CSL_SYSCFG_MSTPRI0_DSP_MDMA_SHIFT (0x00000008u)
#define CSL_SYSCFG_MSTPRI0_DSP_MDMA_RESETVAL (0x00000002u)


#define CSL_SYSCFG_MSTPRI0_ARM_D_MASK    (0x00000070u)
#define CSL_SYSCFG_MSTPRI0_ARM_D_SHIFT   (0x00000004u)
#define CSL_SYSCFG_MSTPRI0_ARM_D_RESETVAL (0x00000002u)


#define CSL_SYSCFG_MSTPRI0_ARM_I_MASK    (0x00000007u)
#define CSL_SYSCFG_MSTPRI0_ARM_I_SHIFT   (0x00000000u)
#define CSL_SYSCFG_MSTPRI0_ARM_I_RESETVAL (0x00000002u)

#define CSL_SYSCFG_MSTPRI0_RESETVAL      (0x00002222u)

/* MSTPRI1 */


#define CSL_SYSCFG_MSTPRI1_EDMA3TC1_MASK (0x00007000u)
#define CSL_SYSCFG_MSTPRI1_EDMA3TC1_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_MSTPRI1_EDMA3TC1_RESETVAL (0x00000000u)


#define CSL_SYSCFG_MSTPRI1_EDMA3TC0_MASK (0x00000700u)
#define CSL_SYSCFG_MSTPRI1_EDMA3TC0_SHIFT (0x00000008u)
#define CSL_SYSCFG_MSTPRI1_EDMA3TC0_RESETVAL (0x00000000u)


#define CSL_SYSCFG_MSTPRI1_PRU1_MASK     (0x00000070u)
#define CSL_SYSCFG_MSTPRI1_PRU1_SHIFT    (0x00000004u)
#define CSL_SYSCFG_MSTPRI1_PRU1_RESETVAL (0x00000000u)


#define CSL_SYSCFG_MSTPRI1_PRU0_MASK     (0x00000007u)
#define CSL_SYSCFG_MSTPRI1_PRU0_SHIFT    (0x00000000u)
#define CSL_SYSCFG_MSTPRI1_PRU0_RESETVAL (0x00000000u)

#define CSL_SYSCFG_MSTPRI1_RESETVAL      (0x00000000u)

/* MSTPRI2 */


#define CSL_SYSCFG_MSTPRI2_LCDC_MASK     (0x70000000u)
#define CSL_SYSCFG_MSTPRI2_LCDC_SHIFT    (0x0000001Cu)
#define CSL_SYSCFG_MSTPRI2_LCDC_RESETVAL (0x00000005u)


#define CSL_SYSCFG_MSTPRI2_USB1_MASK     (0x07000000u)
#define CSL_SYSCFG_MSTPRI2_USB1_SHIFT    (0x00000018u)
#define CSL_SYSCFG_MSTPRI2_USB1_RESETVAL (0x00000004u)


#define CSL_SYSCFG_MSTPRI2_UHPI_MASK     (0x00700000u)
#define CSL_SYSCFG_MSTPRI2_UHPI_SHIFT    (0x00000014u)
#define CSL_SYSCFG_MSTPRI2_UHPI_RESETVAL (0x00000006u)


#define CSL_SYSCFG_MSTPRI2_USB0CDMA_MASK (0x00007000u)
#define CSL_SYSCFG_MSTPRI2_USB0CDMA_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_MSTPRI2_USB0CDMA_RESETVAL (0x00000004u)


#define CSL_SYSCFG_MSTPRI2_USB0VBUSP_MASK (0x00000700u)
#define CSL_SYSCFG_MSTPRI2_USB0VBUSP_SHIFT (0x00000008u)
#define CSL_SYSCFG_MSTPRI2_USB0VBUSP_RESETVAL (0x00000004u)


#define CSL_SYSCFG_MSTPRI2_EMAC_MASK     (0x00000007u)
#define CSL_SYSCFG_MSTPRI2_EMAC_SHIFT    (0x00000000u)
#define CSL_SYSCFG_MSTPRI2_EMAC_RESETVAL (0x00000004u)

#define CSL_SYSCFG_MSTPRI2_RESETVAL      (0x54604404u)

/* PINMUX0 */

#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_RESETVAL (0x00000000u)
/*----PINMUX0_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_EMB_WE (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_31_28_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_RESETVAL (0x00000000u)
/*----PINMUX0_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_EMB_RAS (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_27_24_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_RESETVAL (0x00000000u)
/*----PINMUX0_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_EMB_CAS (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_23_20_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_RESETVAL (0x00000000u)
/*----PINMUX0_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_EMB_CS0 (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_19_16_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_RESETVAL (0x00000000u)
/*----PINMUX0_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_EMB_CLK (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_15_12_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_RESETVAL (0x00000000u)
/*----PINMUX0_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_EMB_SDCKE (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_11_8_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_RESETVAL (0x00000000u)
/*----PINMUX0_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_GPIO7_15 (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_7_4_EMU0 (0x00000008u)

#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_RESETVAL (0x00000000u)
/*----PINMUX0_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_GPIO7_14 (0x00000001u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX0_PINMUX0_3_0_RTCK (0x00000008u)

#define CSL_SYSCFG_PINMUX0_RESETVAL      (0x00000000u)

/* PINMUX1 */

#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_RESETVAL (0x00000000u)
/*----PINMUX1_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_EMB_A5 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_31_28_GPIO7_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_RESETVAL (0x00000000u)
/*----PINMUX1_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_EMB_A4 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_27_24_GPIO7_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_RESETVAL (0x00000000u)
/*----PINMUX1_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_EMB_A3 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_23_20_GPIO7_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_RESETVAL (0x00000000u)
/*----PINMUX1_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_EMB_A2 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_19_16_GPIO7_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_RESETVAL (0x00000000u)
/*----PINMUX1_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_EMB_A1 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_15_12_GPIO7_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_RESETVAL (0x00000000u)
/*----PINMUX1_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_EMB_A0 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_11_8_GPIO7_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_RESETVAL (0x00000000u)
/*----PINMUX1_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_EMB_BA0 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_7_4_GPIO7_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_RESETVAL (0x00000000u)
/*----PINMUX1_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_EMB_BA1 (0x00000001u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX1_PINMUX1_3_0_GPIO7_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX1_RESETVAL      (0x00000000u)

/* PINMUX2 */

#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_RESETVAL (0x00000000u)
/*----PINMUX2_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_EMB_D31 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_31_28_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_RESETVAL (0x00000000u)
/*----PINMUX2_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_EMB_A12 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_27_24_GPIO3_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_RESETVAL (0x00000000u)
/*----PINMUX2_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_EMB_A11 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_23_20_GPIO7_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_RESETVAL (0x00000000u)
/*----PINMUX2_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_EMB_A10 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_19_16_GPIO7_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_RESETVAL (0x00000000u)
/*----PINMUX2_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_EMB_A9 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_15_12_GPIO7_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_RESETVAL (0x00000000u)
/*----PINMUX2_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_EMB_A8 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_11_8_GPIO7_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_RESETVAL (0x00000000u)
/*----PINMUX2_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_EMB_A7 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_7_4_GPIO7_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_RESETVAL (0x00000000u)
/*----PINMUX2_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_EMB_A6 (0x00000001u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX2_PINMUX2_3_0_GPIO7_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX2_RESETVAL      (0x00000000u)

/* PINMUX3 */

#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_RESETVAL (0x00000000u)
/*----PINMUX3_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_EMB_D23 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_31_28_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_RESETVAL (0x00000000u)
/*----PINMUX3_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_EMB_D24 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_27_24_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_RESETVAL (0x00000000u)
/*----PINMUX3_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_EMB_D25 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_23_20_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_RESETVAL (0x00000000u)
/*----PINMUX3_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_EMB_D26 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_19_16_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_RESETVAL (0x00000000u)
/*----PINMUX3_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_EMB_D27 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_15_12_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_RESETVAL (0x00000000u)
/*----PINMUX3_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_EMB_D28 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_11_8_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_RESETVAL (0x00000000u)
/*----PINMUX3_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_EMB_D29 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_7_4_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_RESETVAL (0x00000000u)
/*----PINMUX3_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_EMB_D30 (0x00000001u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX3_PINMUX3_3_0_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX3_RESETVAL      (0x00000000u)

/* PINMUX4 */

#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_RESETVAL (0x00000000u)
/*----PINMUX4_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_EMB_WE_DQM3 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_31_28_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_RESETVAL (0x00000000u)
/*----PINMUX4_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_EMB_D16 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_27_24_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_RESETVAL (0x00000000u)
/*----PINMUX4_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_EMB_D17 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_23_20_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_RESETVAL (0x00000000u)
/*----PINMUX4_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_EMB_D18 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_19_16_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_RESETVAL (0x00000000u)
/*----PINMUX4_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_EMB_D19 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_15_12_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_RESETVAL (0x00000000u)
/*----PINMUX4_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_EMB_D20 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_11_8_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_RESETVAL (0x00000000u)
/*----PINMUX4_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_EMB_D21 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_7_4_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_RESETVAL (0x00000000u)
/*----PINMUX4_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_EMB_D22 (0x00000001u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX4_PINMUX4_3_0_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX4_RESETVAL      (0x00000000u)

/* PINMUX5 */

#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_RESETVAL (0x00000000u)
/*----PINMUX5_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_EMB_D6 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_31_28_GPIO6_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_RESETVAL (0x00000000u)
/*----PINMUX5_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_EMB_D5 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_27_24_GPIO6_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_RESETVAL (0x00000000u)
/*----PINMUX5_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_EMB_D4 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_23_20_GPIO6_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_RESETVAL (0x00000000u)
/*----PINMUX5_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_EMB_D3 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_19_16_GPIO6_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_RESETVAL (0x00000000u)
/*----PINMUX5_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_EMB_D2 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_15_12_GPIO6_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_RESETVAL (0x00000000u)
/*----PINMUX5_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_EMB_D1 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_11_8_GPIO6_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_RESETVAL (0x00000000u)
/*----PINMUX5_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_EMB_D0 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_7_4_GPIO6_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_RESETVAL (0x00000000u)
/*----PINMUX5_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_EMB_WE_DQM2 (0x00000001u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX5_PINMUX5_3_0_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX5_RESETVAL      (0x00000000u)

/* PINMUX6 */

#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_RESETVAL (0x00000000u)
/*----PINMUX6_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_EMB_D14 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_31_28_GPIO6_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_RESETVAL (0x00000000u)
/*----PINMUX6_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_EMB_D13 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_27_24_GPIO6_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_RESETVAL (0x00000000u)
/*----PINMUX6_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_EMB_D12 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_23_20_GPIO6_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_RESETVAL (0x00000000u)
/*----PINMUX6_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_EMB_D11 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_19_16_GPIO6_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_RESETVAL (0x00000000u)
/*----PINMUX6_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_EMB_D10 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_15_12_GPIO6_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_RESETVAL (0x00000000u)
/*----PINMUX6_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_EMB_D9 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_11_8_GPIO6_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_RESETVAL (0x00000000u)
/*----PINMUX6_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_EMB_D8 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_7_4_GPIO6_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_RESETVAL (0x00000000u)
/*----PINMUX6_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_EMB_D7 (0x00000001u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX6_PINMUX6_3_0_GPIO6_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX6_RESETVAL      (0x00000000u)

/* PINMUX7 */

#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_RESETVAL (0x00000000u)
/*----PINMUX7_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_SPI0_SCS0 (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_UART0_RTS (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_EQEP0B (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_31_28_GPIO5_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_RESETVAL (0x00000000u)
/*----PINMUX7_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_SPI0_ENA (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_UART0_CTS (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_EQEP0A (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_27_24_GPIO5_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_RESETVAL (0x00000000u)
/*----PINMUX7_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_SPI0_CLK (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_EQEP1I (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_23_20_GPIO5_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_RESETVAL (0x00000000u)
/*----PINMUX7_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_SPI0_SIMO0 (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_EQEP0S (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_19_16_GPIO5_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_RESETVAL (0x00000000u)
/*----PINMUX7_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_SPI0_SOMI0 (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_EQEP0I (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_15_12_GPIO5_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_RESETVAL (0x00000000u)
/*----PINMUX7_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_EMB_WE_DQM0 (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_11_8_GPIO5_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_RESETVAL (0x00000000u)
/*----PINMUX7_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_EMB_WE_DQM1 (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_7_4_GPIO5_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_RESETVAL (0x00000000u)
/*----PINMUX7_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_EMB_D15 (0x00000001u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX7_PINMUX7_3_0_GPIO6_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX7_RESETVAL      (0x00000000u)

/* PINMUX8 */

#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_RESETVAL (0x00000000u)
/*----PINMUX8_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_SPI1_ENA (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_UART2_RXD (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_31_28_GPIO5_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_RESETVAL (0x00000000u)
/*----PINMUX8_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_AXR1_11 (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_27_24_GPIO5_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_RESETVAL (0x00000000u)
/*----PINMUX8_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_AXR1_10 (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_23_20_GPIO5_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_RESETVAL (0x00000000u)
/*----PINMUX8_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_UART0_TXD (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_I2C0_SCL (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_TM64P0_OUT12 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_19_16_GPIO5_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_RESETVAL (0x00000000u)
/*----PINMUX8_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_UART0_RXD (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_I2C0_SDA (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_TM64P0_IN12 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_15_12_GPIO5_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_RESETVAL (0x00000000u)
/*----PINMUX8_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_SPI1_CLK (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_EQEP1S (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_11_8_GPIO5_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_RESETVAL (0x00000000u)
/*----PINMUX8_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_SPI1_SIMO0 (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_I2C1_SDA (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_7_4_GPIO5_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_RESETVAL (0x00000000u)
/*----PINMUX8_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_SPI1_SOMI0 (0x00000001u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_I2C1_SCL (0x00000002u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX8_PINMUX8_3_0_GPIO5_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX8_RESETVAL      (0x00000000u)

/* PINMUX9 */

#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_RESETVAL (0x00000000u)
/*----PINMUX9_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_AFSR0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_31_28_GPIO3_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_RESETVAL (0x00000000u)
/*----PINMUX9_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_ACLKR0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_ECAP1 (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_27_24_GPIO2_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_RESETVAL (0x00000000u)
/*----PINMUX9_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_AHCLKR0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_RMII_MHZ_50_CLK (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_23_20_GPIO2_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_RESETVAL (0x00000000u)
/*----PINMUX9_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_AFSX0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_19_16_GPIO2_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_RESETVAL (0x00000000u)
/*----PINMUX9_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_ACLKX0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_ECAP0 (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_15_12_GPIO2_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_RESETVAL (0x00000000u)
/*----PINMUX9_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_AHCLKX0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_AHCLKX2 (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_USB_REFCLKIN (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_11_8_GPIO2_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_RESETVAL (0x00000000u)
/*----PINMUX9_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_USB0_DRVVBUS (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_7_4_GPIO4_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_RESETVAL (0x00000000u)
/*----PINMUX9_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_SPI1_SCS0 (0x00000001u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_UART2_TXD (0x00000002u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX9_PINMUX9_3_0_GPIO5_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX9_RESETVAL      (0x00000000u)

/* PINMUX10 */

#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_RESETVAL (0x00000000u)
/*----PINMUX10_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_AXR0_6 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_RMII_RXER (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_ACLKR2 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_31_28_GPIO3_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_RESETVAL (0x00000000u)
/*----PINMUX10_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_AXR0_5 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_RMII_RXD1 (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_AFSX2 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_27_24_GPIO3_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_RESETVAL (0x00000000u)
/*----PINMUX10_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_AXR0_4 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_RMII_RXD0 (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_AXR2_1 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_23_20_GPIO3_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_RESETVAL (0x00000000u)
/*----PINMUX10_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_AXR0_3 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_RMII_CRS_DV (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_AXR2_2 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_19_16_GPIO3_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_RESETVAL (0x00000000u)
/*----PINMUX10_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_AXR0_2 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_RMII_TXEN (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_AXR2_3 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_15_12_GPIO3_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_RESETVAL (0x00000000u)
/*----PINMUX10_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_AXR0_1 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_RMII_TXD1 (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_ACLKX2 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_11_8_GPIO3_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_RESETVAL (0x00000000u)
/*----PINMUX10_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_AXR0_0 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_RMII_TXD0 (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_AFSR2 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_7_4_GPIO3_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_RESETVAL (0x00000000u)
/*----PINMUX10_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_AMUTE0 (0x00000001u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX10_PINMUX10_3_0_RESETOUT (0x00000008u)

#define CSL_SYSCFG_PINMUX10_RESETVAL     (0x00000000u)

/* PINMUX11 */

#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_RESETVAL (0x00000000u)
/*----PINMUX11_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_AFSX1 (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_EPWMSYNCI (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_EPWMSYNC0 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_31_28_GPIO4_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_RESETVAL (0x00000000u)
/*----PINMUX11_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_ACLKX1 (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_EPWM0A (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_27_24_GPIO3_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_RESETVAL (0x00000000u)
/*----PINMUX11_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_AHCLKX1 (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_EPWM0B (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_23_20_GPIO3_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_RESETVAL (0x00000000u)
/*----PINMUX11_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_AXR0_11 (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_AXR2_0 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_19_16_GPIO3_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_RESETVAL (0x00000000u)
/*----PINMUX11_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_UART1_TXD (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_AXR0_10 (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_15_12_GPIO3_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_RESETVAL (0x00000000u)
/*----PINMUX11_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_UART1_RXD (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_AXR0_9 (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_11_8_GPIO3_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_RESETVAL (0x00000000u)
/*----PINMUX11_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_AXR0_8 (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_MDIO_D (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_7_4_GPIO3_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_RESETVAL (0x00000000u)
/*----PINMUX11_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_AXR0_7 (0x00000001u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_MDIO_CLK (0x00000002u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX11_PINMUX11_3_0_GPIO3_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX11_RESETVAL     (0x00000000u)

/* PINMUX12 */

#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_RESETVAL (0x00000000u)
/*----PINMUX12_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_AXR1_3 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_EQEP1A (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_31_28_GPIO4_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_RESETVAL (0x00000000u)
/*----PINMUX12_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_AXR1_2 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_27_24_GPIO4_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_RESETVAL (0x00000000u)
/*----PINMUX12_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_AXR1_1 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_23_20_GPIO4_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_RESETVAL (0x00000000u)
/*----PINMUX12_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_AXR1_0 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_19_16_GPIO4_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_RESETVAL (0x00000000u)
/*----PINMUX12_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_AMUTE1 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_EHRPWMTZ (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_15_12_GPIO4_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_RESETVAL (0x00000000u)
/*----PINMUX12_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_AFSR1 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_11_8_GPIO4_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_RESETVAL (0x00000000u)
/*----PINMUX12_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_ACLKR1 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_ECAP2 (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_7_4_GPIO4_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_RESETVAL (0x00000000u)
/*----PINMUX12_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_AHCLKR1 (0x00000001u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX12_PINMUX12_3_0_GPIO4_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX12_RESETVAL     (0x00000000u)

/* PINMUX13 */

#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_RESETVAL (0x00000000u)
/*----PINMUX13_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_EMA_D1 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_MMCSD_DAT1 (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_UHPI_HD1 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_31_28_GPIO0_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_RESETVAL (0x00000000u)
/*----PINMUX13_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_EMA_D0 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_MMCSD_DAT0 (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_UHPI_HD0 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_27_24_GPIO0_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_RESETVAL (0x00000000u)
/*----PINMUX13_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_AXR1_9 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_23_20_GPIO4_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_RESETVAL (0x00000000u)
/*----PINMUX13_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_AXR1_8 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_EPWM1A (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_19_16_GPIO4_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_RESETVAL (0x00000000u)
/*----PINMUX13_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_AXR1_7 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_EPWM1B (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_15_12_GPIO4_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_RESETVAL (0x00000000u)
/*----PINMUX13_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_AXR1_6 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_EPWM2A (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_11_8_GPIO4_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_RESETVAL (0x00000000u)
/*----PINMUX13_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_AXR1_5 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_EPWM2B (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_7_4_GPIO4_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_RESETVAL (0x00000000u)
/*----PINMUX13_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_AXR1_4 (0x00000001u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_EQEP1B (0x00000002u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX13_PINMUX13_3_0_GPIO4_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX13_RESETVAL     (0x00000000u)

/* PINMUX14 */

#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_RESETVAL (0x00000000u)
/*----PINMUX14_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_EMA_D9 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_UHPI_HD9 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_LCD_D9 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_31_28_GPIO0_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_RESETVAL (0x00000000u)
/*----PINMUX14_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_EMA_D8 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_UHPI_HD8 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_LCD_D8 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_27_24_GPIO0_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_RESETVAL (0x00000000u)
/*----PINMUX14_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_EMA_D7 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_MMCSD_DAT7 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_UHPI_HD7 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_23_20_GPIO0_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_RESETVAL (0x00000000u)
/*----PINMUX14_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_EMA_D6 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_MMCSD_DAT6 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_UHPI_HD6 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_19_16_GPIO0_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_RESETVAL (0x00000000u)
/*----PINMUX14_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_EMA_D5 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_MMCSD_DAT5 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_UHPI_HD5 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_15_12_GPIO0_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_RESETVAL (0x00000000u)
/*----PINMUX14_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_EMA_D4 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_MMCSD_DAT4 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_UHPI_HD4 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_11_8_GPIO0_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_RESETVAL (0x00000000u)
/*----PINMUX14_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_EMA_D3 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_MMCSD_DAT3 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_UHPI_HD3 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_7_4_GPIO0_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_RESETVAL (0x00000000u)
/*----PINMUX14_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_EMA_D2 (0x00000001u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_MMCSD_DAT2 (0x00000002u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_UHPI_HD2 (0x00000004u)
#define CSL_SYSCFG_PINMUX14_PINMUX14_3_0_GPIO0_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX14_RESETVAL     (0x00000000u)

/* PINMUX15 */

#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_RESETVAL (0x00000000u)
/*----PINMUX15_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_EMA_A1 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_MMCSD_CLK (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_UHPI_HCNTL0 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_31_28_GPIO1_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_RESETVAL (0x00000000u)
/*----PINMUX15_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_EMA_A0 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_LCD_D7 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_27_24_GPIO1_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_RESETVAL (0x00000000u)
/*----PINMUX15_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_EMA_D15 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_UHPI_HD15 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_LCD_D15 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_23_20_GPIO0_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_RESETVAL (0x00000000u)
/*----PINMUX15_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_EMA_D14 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_UHPI_HD14 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_LCD_D14 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_19_16_GPIO0_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_RESETVAL (0x00000000u)
/*----PINMUX15_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_EMA_D13 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_UHPI_HD13 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_LCD_D13 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_15_12_GPIO0_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_RESETVAL (0x00000000u)
/*----PINMUX15_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_EMA_D12 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_UHPI_HD12 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_LCD_D12 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_11_8_GPIO0_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_RESETVAL (0x00000000u)
/*----PINMUX15_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_EMA_D11 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_UHPI_HD11 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_LCD_D11 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_7_4_GPIO0_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_RESETVAL (0x00000000u)
/*----PINMUX15_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_EMA_D10 (0x00000001u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_UHPI_HD10 (0x00000002u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_LCD_D10 (0x00000004u)
#define CSL_SYSCFG_PINMUX15_PINMUX15_3_0_GPIO0_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX15_RESETVAL     (0x00000000u)

/* PINMUX16 */

#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_RESETVAL (0x00000000u)
/*----PINMUX16_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_EMA_A9 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_LCD_HSYNC (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_31_28_GPIO1_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_RESETVAL (0x00000000u)
/*----PINMUX16_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_EMA_A8 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_LCD_PCLK (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_27_24_GPIO1_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_RESETVAL (0x00000000u)
/*----PINMUX16_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_EMA_A7 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_LCD_D0 (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_23_20_GPIO1_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_RESETVAL (0x00000000u)
/*----PINMUX16_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_EMA_A6 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_LCD_D1 (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_19_16_GPIO1_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_RESETVAL (0x00000000u)
/*----PINMUX16_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_EMA_A5 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_LCD_D2 (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_15_12_GPIO1_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_RESETVAL (0x00000000u)
/*----PINMUX16_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_EMA_A4 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_LCD_D3 (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_11_8_GPIO1_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_RESETVAL (0x00000000u)
/*----PINMUX16_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_EMA_A3 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_LCD_D6 (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_7_4_GPIO1_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_RESETVAL (0x00000000u)
/*----PINMUX16_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_EMA_A2 (0x00000001u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_MMCSD_CMD (0x00000002u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_UHPI_HCNTL1 (0x00000004u)
#define CSL_SYSCFG_PINMUX16_PINMUX16_3_0_GPIO1_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX16_RESETVAL     (0x00000000u)

/* PINMUX17 */

#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_RESETVAL (0x00000000u)
/*----PINMUX17_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_EMA_CAS (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_EMA_CS4 (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_31_28_GPIO2_1 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_RESETVAL (0x00000000u)
/*----PINMUX17_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_EMA_SDCKE (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_27_24_GPIO2_0 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_RESETVAL (0x00000000u)
/*----PINMUX17_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_EMA_CLK (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_OBSCLK (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_AHCLKR2 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_23_20_GPIO1_15 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_RESETVAL (0x00000000u)
/*----PINMUX17_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_EMA_BA0 (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_LCD_D4 (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_19_16_GPIO1_14 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_RESETVAL (0x00000000u)
/*----PINMUX17_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_EMA_BA1 (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_LCD_D5 (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_UHPI_HHWEL (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_15_12_GPIO1_13 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_RESETVAL (0x00000000u)
/*----PINMUX17_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_EMA_A12 (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_LCD_MCLK (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_11_8_GPIO1_12 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_RESETVAL (0x00000000u)
/*----PINMUX17_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_EMA_A11 (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_LCD_AC_ENB_CS (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_7_4_GPIO1_11 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_RESETVAL (0x00000000u)
/*----PINMUX17_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_EMA_A10 (0x00000001u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_LCD_VSYNC (0x00000002u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX17_PINMUX17_3_0_GPIO1_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX17_RESETVAL     (0x00000000u)

/* PINMUX18 */

#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_RESETVAL (0x00000000u)
/*----PINMUX18_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_EMA_WE_DQM0 (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_UHPI_HINT (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_AXR0_15 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_31_28_GPIO2_9 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_RESETVAL (0x00000000u)
/*----PINMUX18_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_EMA_WE_DQM1 (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_UHPI_HDS2 (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_AXR0_14 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_27_24_GPIO2_8 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_RESETVAL (0x00000000u)
/*----PINMUX18_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_EMA_OE (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_UHPI_HDS1 (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_AXR0_13 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_23_20_GPIO2_7 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_RESETVAL (0x00000000u)
/*----PINMUX18_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_EMA_CS3 (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_AMUTE2 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_19_16_GPIO2_6 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_RESETVAL (0x00000000u)
/*----PINMUX18_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_EMA_CS2 (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_UHPI_HCS (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_15_12_GPIO2_5 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_RESETVAL (0x00000000u)
/*----PINMUX18_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_EMA_CS0 (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_UHPI_HAS (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_11_8_GPIO2_4 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_RESETVAL (0x00000000u)
/*----PINMUX18_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_EMA_WE (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_UHPI_HRW (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_AXR0_12 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_7_4_GPIO2_3 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_RESETVAL (0x00000000u)
/*----PINMUX18_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_EMA_RAS (0x00000001u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_EMA_CS5 (0x00000002u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX18_PINMUX18_3_0_GPIO2_2 (0x00000008u)

#define CSL_SYSCFG_PINMUX18_RESETVAL     (0x00000000u)

/* PINMUX19 */

#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_MASK (0xF0000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_RESETVAL (0x00000000u)
/*----PINMUX19_31_28 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_31_28_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_MASK (0x0F000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_SHIFT (0x00000018u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_RESETVAL (0x00000000u)
/*----PINMUX19_27_24 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_27_24_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_MASK (0x00F00000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_SHIFT (0x00000014u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_RESETVAL (0x00000000u)
/*----PINMUX19_23_20 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_23_20_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_MASK (0x000F0000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_SHIFT (0x00000010u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_RESETVAL (0x00000000u)
/*----PINMUX19_19_16 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_19_16_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_MASK (0x0000F000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_RESETVAL (0x00000000u)
/*----PINMUX19_15_12 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_15_12_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_MASK (0x00000F00u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_SHIFT (0x00000008u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_RESETVAL (0x00000000u)
/*----PINMUX19_11_8 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_11_8_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_MASK (0x000000F0u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_SHIFT (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_RESETVAL (0x00000000u)
/*----PINMUX19_7_4 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_RESERVED1 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_RESERVED2 (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_7_4_RESERVED8 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_MASK (0x0000000Fu)
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_SHIFT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_RESETVAL (0x00000000u)
/*----PINMUX19_3_0 Tokens----*/
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_DEFAULT (0x00000000u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_EMA_WAIT0 (0x00000001u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_UHPI_HRDY (0x00000002u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_RESERVED4 (0x00000004u)
#define CSL_SYSCFG_PINMUX19_PINMUX19_3_0_GPIO2_10 (0x00000008u)

#define CSL_SYSCFG_PINMUX19_RESETVAL     (0x00000000u)

/* SUSPSRC */


#define CSL_SYSCFG_SUSPSRC_TIMER64_1SRC_MASK (0x10000000u)
#define CSL_SYSCFG_SUSPSRC_TIMER64_1SRC_SHIFT (0x0000001Cu)
#define CSL_SYSCFG_SUSPSRC_TIMER64_1SRC_RESETVAL (0x00000001u)
/*----TIMER64_1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_TIMER64_1SRC_ARM (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_TIMER64_1SRC_DSP (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_TIMER64_0SRC_MASK (0x08000000u)
#define CSL_SYSCFG_SUSPSRC_TIMER64_0SRC_SHIFT (0x0000001Bu)
#define CSL_SYSCFG_SUSPSRC_TIMER64_0SRC_RESETVAL (0x00000001u)
/*----TIMER64_0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_TIMER64_0SRC_ARM (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_TIMER64_0SRC_DSP (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_GPIOSRC_MASK  (0x04000000u)
#define CSL_SYSCFG_SUSPSRC_GPIOSRC_SHIFT (0x0000001Au)
#define CSL_SYSCFG_SUSPSRC_GPIOSRC_RESETVAL (0x00000001u)
/*----GPIOSRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_GPIOSRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_GPIOSRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_EPWM2SRC_MASK (0x02000000u)
#define CSL_SYSCFG_SUSPSRC_EPWM2SRC_SHIFT (0x00000019u)
#define CSL_SYSCFG_SUSPSRC_EPWM2SRC_RESETVAL (0x00000001u)
/*----EPWM2SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_EPWM2SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_EPWM2SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_EPWM1SRC_MASK (0x01000000u)
#define CSL_SYSCFG_SUSPSRC_EPWM1SRC_SHIFT (0x00000018u)
#define CSL_SYSCFG_SUSPSRC_EPWM1SRC_RESETVAL (0x00000001u)
/*----EPWM1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_EPWM1SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_EPWM1SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_EPWM0SRC_MASK (0x00800000u)
#define CSL_SYSCFG_SUSPSRC_EPWM0SRC_SHIFT (0x00000017u)
#define CSL_SYSCFG_SUSPSRC_EPWM0SRC_RESETVAL (0x00000001u)
/*----EPWM0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_EPWM0SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_EPWM0SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_SPI1SRC_MASK  (0x00400000u)
#define CSL_SYSCFG_SUSPSRC_SPI1SRC_SHIFT (0x00000016u)
#define CSL_SYSCFG_SUSPSRC_SPI1SRC_RESETVAL (0x00000001u)
/*----SPI1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_SPI1SRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_SPI1SRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_SPI0SRC_MASK  (0x00200000u)
#define CSL_SYSCFG_SUSPSRC_SPI0SRC_SHIFT (0x00000015u)
#define CSL_SYSCFG_SUSPSRC_SPI0SRC_RESETVAL (0x00000001u)
/*----SPI0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_SPI0SRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_SPI0SRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_UART2SRC_MASK (0x00100000u)
#define CSL_SYSCFG_SUSPSRC_UART2SRC_SHIFT (0x00000014u)
#define CSL_SYSCFG_SUSPSRC_UART2SRC_RESETVAL (0x00000001u)
/*----UART2SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_UART2SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_UART2SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_UART1SRC_MASK (0x00080000u)
#define CSL_SYSCFG_SUSPSRC_UART1SRC_SHIFT (0x00000013u)
#define CSL_SYSCFG_SUSPSRC_UART1SRC_RESETVAL (0x00000001u)
/*----UART1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_UART1SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_UART1SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_UART0SRC_MASK (0x00040000u)
#define CSL_SYSCFG_SUSPSRC_UART0SRC_SHIFT (0x00000012u)
#define CSL_SYSCFG_SUSPSRC_UART0SRC_RESETVAL (0x00000001u)
/*----UART0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_UART0SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_UART0SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_I2C1SRC_MASK  (0x00020000u)
#define CSL_SYSCFG_SUSPSRC_I2C1SRC_SHIFT (0x00000011u)
#define CSL_SYSCFG_SUSPSRC_I2C1SRC_RESETVAL (0x00000001u)
/*----I2C1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_I2C1SRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_I2C1SRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_I2C0SRC_MASK  (0x00010000u)
#define CSL_SYSCFG_SUSPSRC_I2C0SRC_SHIFT (0x00000010u)
#define CSL_SYSCFG_SUSPSRC_I2C0SRC_RESETVAL (0x00000001u)
/*----I2C0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_I2C0SRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_I2C0SRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_MMCSDSRC_MASK (0x00008000u)
#define CSL_SYSCFG_SUSPSRC_MMCSDSRC_SHIFT (0x0000000Fu)
#define CSL_SYSCFG_SUSPSRC_MMCSDSRC_RESETVAL (0x00000001u)
/*----MMCSDSRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_MMCSDSRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_MMCSDSRC_DSP  (0x00000001u)


#define CSL_SYSCFG_SUSPSRC_HPISRC_MASK   (0x00001000u)
#define CSL_SYSCFG_SUSPSRC_HPISRC_SHIFT  (0x0000000Cu)
#define CSL_SYSCFG_SUSPSRC_HPISRC_RESETVAL (0x00000001u)
/*----HPISRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_HPISRC_ARM    (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_HPISRC_DSP    (0x00000001u)


#define CSL_SYSCFG_SUSPSRC_USB1SRC_MASK  (0x00000400u)
#define CSL_SYSCFG_SUSPSRC_USB1SRC_SHIFT (0x0000000Au)
#define CSL_SYSCFG_SUSPSRC_USB1SRC_RESETVAL (0x00000001u)
/*----USB1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_USB1SRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_USB1SRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_USB0SRC_MASK  (0x00000200u)
#define CSL_SYSCFG_SUSPSRC_USB0SRC_SHIFT (0x00000009u)
#define CSL_SYSCFG_SUSPSRC_USB0SRC_RESETVAL (0x00000001u)
/*----USB0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_USB0SRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_USB0SRC_DSP   (0x00000001u)



#define CSL_SYSCFG_SUSPSRC_EMACSRC_MASK  (0x00000020u)
#define CSL_SYSCFG_SUSPSRC_EMACSRC_SHIFT (0x00000005u)
#define CSL_SYSCFG_SUSPSRC_EMACSRC_RESETVAL (0x00000001u)
/*----EMACSRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_EMACSRC_ARM   (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_EMACSRC_DSP   (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_EQEP1SRC_MASK (0x00000010u)
#define CSL_SYSCFG_SUSPSRC_EQEP1SRC_SHIFT (0x00000004u)
#define CSL_SYSCFG_SUSPSRC_EQEP1SRC_RESETVAL (0x00000001u)
/*----EQEP1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_EQEP1SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_EQEP1SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_EQEP0SRC_MASK (0x00000008u)
#define CSL_SYSCFG_SUSPSRC_EQEP0SRC_SHIFT (0x00000003u)
#define CSL_SYSCFG_SUSPSRC_EQEP0SRC_RESETVAL (0x00000001u)
/*----EQEP0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_EQEP0SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_EQEP0SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_ECAP2SRC_MASK (0x00000004u)
#define CSL_SYSCFG_SUSPSRC_ECAP2SRC_SHIFT (0x00000002u)
#define CSL_SYSCFG_SUSPSRC_ECAP2SRC_RESETVAL (0x00000001u)
/*----ECAP2SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_ECAP2SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_ECAP2SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_ECAP1SRC_MASK (0x00000002u)
#define CSL_SYSCFG_SUSPSRC_ECAP1SRC_SHIFT (0x00000001u)
#define CSL_SYSCFG_SUSPSRC_ECAP1SRC_RESETVAL (0x00000001u)
/*----ECAP1SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_ECAP1SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_ECAP1SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_ECAP0SRC_MASK (0x00000001u)
#define CSL_SYSCFG_SUSPSRC_ECAP0SRC_SHIFT (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_ECAP0SRC_RESETVAL (0x00000001u)
/*----ECAP0SRC Tokens----*/
#define CSL_SYSCFG_SUSPSRC_ECAP0SRC_ARM  (0x00000000u)
#define CSL_SYSCFG_SUSPSRC_ECAP0SRC_DSP  (0x00000001u)

#define CSL_SYSCFG_SUSPSRC_RESETVAL      (0x3FFFBEFFu)

/* CHIPSIG */


#define CSL_SYSCFG_CHIPSIG_CHIPSIG4_MASK (0x00000010u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG4_SHIFT (0x00000004u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG4_RESETVAL (0x00000000u)
/*----CHIPSIG4 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CHIPSIG4_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG4_ASSERT (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CHIPSIG3_MASK (0x00000008u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG3_SHIFT (0x00000003u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG3_RESETVAL (0x00000000u)
/*----CHIPSIG3 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CHIPSIG3_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG3_ASSERT (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CHIPSIG2_MASK (0x00000004u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG2_SHIFT (0x00000002u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG2_RESETVAL (0x00000000u)
/*----CHIPSIG2 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CHIPSIG2_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG2_ASSERT (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CHIPSIG1_MASK (0x00000002u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG1_SHIFT (0x00000001u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG1_RESETVAL (0x00000000u)
/*----CHIPSIG1 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CHIPSIG1_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG1_ASSERT (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CHIPSIG0_MASK (0x00000001u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG0_SHIFT (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG0_RESETVAL (0x00000000u)
/*----CHIPSIG0 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CHIPSIG0_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CHIPSIG0_ASSERT (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_RESETVAL      (0x00000000u)

/* CHIPSIG_CLR */


#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG4_MASK (0x00000010u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG4_SHIFT (0x00000004u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG4_RESETVAL (0x00000000u)
/*----CHIPSIG4 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG4_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG4_CLEAR (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG3_MASK (0x00000008u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG3_SHIFT (0x00000003u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG3_RESETVAL (0x00000000u)
/*----CHIPSIG3 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG3_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG3_CLEAR (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG2_MASK (0x00000004u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG2_SHIFT (0x00000002u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG2_RESETVAL (0x00000000u)
/*----CHIPSIG2 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG2_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG2_CLEAR (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG1_MASK (0x00000002u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG1_SHIFT (0x00000001u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG1_RESETVAL (0x00000000u)
/*----CHIPSIG1 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG1_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG1_CLEAR (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG0_MASK (0x00000001u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG0_SHIFT (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG0_RESETVAL (0x00000000u)
/*----CHIPSIG0 Tokens----*/
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG0_NOTHING (0x00000000u)
#define CSL_SYSCFG_CHIPSIG_CLR_CHIPSIG0_CLEAR (0x00000001u)

#define CSL_SYSCFG_CHIPSIG_CLR_RESETVAL  (0x00000000u)

/* CFGCHIP0 */


#define CSL_SYSCFG_CFGCHIP0_PLL_MASTER_LOCK_MASK (0x00000010u)
#define CSL_SYSCFG_CFGCHIP0_PLL_MASTER_LOCK_SHIFT (0x00000004u)
#define CSL_SYSCFG_CFGCHIP0_PLL_MASTER_LOCK_RESETVAL (0x00000000u)
/*----PLL_MASTER_LOCK Tokens----*/
#define CSL_SYSCFG_CFGCHIP0_PLL_MASTER_LOCK_FREE (0x00000000u)
#define CSL_SYSCFG_CFGCHIP0_PLL_MASTER_LOCK_LOCK (0x00000001u)

#define CSL_SYSCFG_CFGCHIP0_TC1DBS_MASK  (0x0000000Cu)
#define CSL_SYSCFG_CFGCHIP0_TC1DBS_SHIFT (0x00000002u)
#define CSL_SYSCFG_CFGCHIP0_TC1DBS_RESETVAL (0x00000000u)
/*----TC1DBS Tokens----*/
#define CSL_SYSCFG_CFGCHIP0_TC1DBS_16BYTE (0x00000000u)
#define CSL_SYSCFG_CFGCHIP0_TC1DBS_32BYTE (0x00000001u)
#define CSL_SYSCFG_CFGCHIP0_TC1DBS_64BYTE (0x00000002u)
#define CSL_SYSCFG_CFGCHIP0_TC1DBS_RESERVED (0x00000003u)

#define CSL_SYSCFG_CFGCHIP0_TC0DBS_MASK  (0x00000003u)
#define CSL_SYSCFG_CFGCHIP0_TC0DBS_SHIFT (0x00000000u)
#define CSL_SYSCFG_CFGCHIP0_TC0DBS_RESETVAL (0x00000000u)
/*----TC0DBS Tokens----*/
#define CSL_SYSCFG_CFGCHIP0_TC0DBS_16BYTE (0x00000000u)
#define CSL_SYSCFG_CFGCHIP0_TC0DBS_32BYTE (0x00000001u)
#define CSL_SYSCFG_CFGCHIP0_TC0DBS_64BYTE (0x00000002u)
#define CSL_SYSCFG_CFGCHIP0_TC0DBS_RESERVED (0x00000003u)

#define CSL_SYSCFG_CFGCHIP0_RESETVAL     (0x00000000u)

/* CFGCHIP1 */

#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MASK (0xF8000000u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_SHIFT (0x0000001Bu)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_RESETVAL (0x00000000u)
/*----CAP2SRC Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_ECAP2 (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MCASP0_TXDMA (0x00000001u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MCASP0_RXDMA (0x00000002u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MCASP1_TXDMA (0x00000003u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MCASP1_RXDMA (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MCASP2_TXDMA (0x00000005u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_MCASP2_RXDMA (0x00000006u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C0_RXTHPLSEINT (0x00000007u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C0_RXPLSEINT (0x00000008u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C0_TXPLSEINT (0x00000009u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C0_MISCINT (0x0000000Au)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C1_RXTHPLSEINT (0x0000000Bu)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C1_RXPLSEINT (0x0000000Cu)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C1_TXPLSEINT (0x0000000Du)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C1_MISCINT (0x0000000Eu)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C2_RXTHPLSEINT (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C2_RXPLSEINT (0x00000010u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C2_TXPLSEINT (0x00000011u)
#define CSL_SYSCFG_CFGCHIP1_CAP2SRC_EMAC_C2_MISCINT (0x00000012u)

#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MASK (0x07C00000u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_SHIFT (0x00000016u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_RESETVAL (0x00000000u)
/*----CAP1SRC Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_ECAP1 (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MCASP0_TXDMA (0x00000001u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MCASP0_RXDMA (0x00000002u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MCASP1_TXDMA (0x00000003u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MCASP1_RXDMA (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MCASP2_TXDMA (0x00000005u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_MCASP2_RXDMA (0x00000006u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C0_RXTHPLSEINT (0x00000007u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C0_RXPLSEINT (0x00000008u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C0_TXPLSEINT (0x00000009u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C0_MISCINT (0x0000000Au)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C1_RXTHPLSEINT (0x0000000Bu)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C1_RXPLSEINT (0x0000000Cu)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C1_TXPLSEINT (0x0000000Du)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C1_MISCINT (0x0000000Eu)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C2_RXTHPLSEINT (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C2_RXPLSEINT (0x00000010u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C2_TXPLSEINT (0x00000011u)
#define CSL_SYSCFG_CFGCHIP1_CAP1SRC_EMAC_C2_MISCINT (0x00000012u)

#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MASK (0x003E0000u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_SHIFT (0x00000011u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_RESETVAL (0x00000000u)
/*----CAP0SRC Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_ECAP0 (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MCASP0_TXDMA (0x00000001u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MCASP0_RXDMA (0x00000002u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MCASP1_TXDMA (0x00000003u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MCASP1_RXDMA (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MCASP2_TXDMA (0x00000005u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_MCASP2_RXDMA (0x00000006u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C0_RXTHPLSEINT (0x00000007u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C0_RXPLSEINT (0x00000008u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C0_TXPLSEINT (0x00000009u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C0_MISCINT (0x0000000Au)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C1_RXTHPLSEINT (0x0000000Bu)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C1_RXPLSEINT (0x0000000Cu)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C1_TXPLSEINT (0x0000000Du)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C1_MISCINT (0x0000000Eu)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C2_RXTHPLSEINT (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C2_RXPLSEINT (0x00000010u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C2_TXPLSEINT (0x00000011u)
#define CSL_SYSCFG_CFGCHIP1_CAP0SRC_EMAC_C2_MISCINT (0x00000012u)

#define CSL_SYSCFG_CFGCHIP1_HPIBYTEAD_MASK (0x00010000u)
#define CSL_SYSCFG_CFGCHIP1_HPIBYTEAD_SHIFT (0x00000010u)
#define CSL_SYSCFG_CFGCHIP1_HPIBYTEAD_RESETVAL (0x00000000u)
/*----HPIBYTEAD Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_HPIBYTEAD_WORDADDR (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_HPIBYTEAD_BYTEADDR (0x00000001u)

#define CSL_SYSCFG_CFGCHIP1_HPIENA_MASK  (0x00008000u)
#define CSL_SYSCFG_CFGCHIP1_HPIENA_SHIFT (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP1_HPIENA_RESETVAL (0x00000000u)
/*----HPIENA Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_HPIENA_DISABLE (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_HPIENA_ENABLE (0x00000001u)


#define CSL_SYSCFG_CFGCHIP1_TBCLKSYNC_MASK (0x00001000u)
#define CSL_SYSCFG_CFGCHIP1_TBCLKSYNC_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_CFGCHIP1_TBCLKSYNC_RESETVAL (0x00000000u)
/*----TBCLKSYNC Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_TBCLKSYNC_STOP (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_TBCLKSYNC_ENABLE (0x00000001u)

#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_MASK (0x00000F00u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_SHIFT (0x00000008u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_RESETVAL (0x00000000u)
/*----AMUTESEL2 Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_LOW (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B0 (0x00000001u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B1 (0x00000002u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B2 (0x00000003u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B3 (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B4 (0x00000005u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B5 (0x00000006u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B6 (0x00000007u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL2_GPIO_B7 (0x00000008u)

#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_MASK (0x000000F0u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_SHIFT (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_RESETVAL (0x00000000u)
/*----AMUTESEL1 Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_LOW (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B0 (0x00000001u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B1 (0x00000002u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B2 (0x00000003u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B3 (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B4 (0x00000005u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B5 (0x00000006u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B6 (0x00000007u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL1_GPIO_B7 (0x00000008u)

#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_MASK (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_SHIFT (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_RESETVAL (0x00000000u)
/*----AMUTESEL0 Tokens----*/
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_LOW (0x00000000u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B0 (0x00000001u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B1 (0x00000002u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B2 (0x00000003u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B3 (0x00000004u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B4 (0x00000005u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B5 (0x00000006u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B6 (0x00000007u)
#define CSL_SYSCFG_CFGCHIP1_AMUTESEL0_GPIO_B7 (0x00000008u)

#define CSL_SYSCFG_CFGCHIP1_RESETVAL     (0x00000000u)

/* CFGCHIP2 */


#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKGD_MASK (0x00020000u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKGD_SHIFT (0x00000011u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKGD_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP2_USB0VBUSSENSE_MASK (0x00010000u)
#define CSL_SYSCFG_CFGCHIP2_USB0VBUSSENSE_SHIFT (0x00000010u)
#define CSL_SYSCFG_CFGCHIP2_USB0VBUSSENSE_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP2_RESET_MASK   (0x00008000u)
#define CSL_SYSCFG_CFGCHIP2_RESET_SHIFT  (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP2_RESET_RESETVAL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_MASK (0x00006000u)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_SHIFT (0x0000000Du)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_RESETVAL (0x00000003u)
/*----USB0OTGMODE Tokens----*/
#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_PHY (0x00000000u)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_USB_HOST (0x00000001u)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_USB_DEVICE (0x00000002u)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGMODE_USB_HOST_LOW (0x00000003u)

#define CSL_SYSCFG_CFGCHIP2_USB1PHYCLKMUX_MASK (0x00001000u)
#define CSL_SYSCFG_CFGCHIP2_USB1PHYCLKMUX_SHIFT (0x0000000Cu)
#define CSL_SYSCFG_CFGCHIP2_USB1PHYCLKMUX_RESETVAL (0x00000000u)
/*----USB1PHYCLKMUX Tokens----*/
#define CSL_SYSCFG_CFGCHIP2_USB1PHYCLKMUX_USBCLK (0x00000000u)
#define CSL_SYSCFG_CFGCHIP2_USB1PHYCLKMUX_EXTCLK (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKMUX_MASK (0x00000800u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKMUX_SHIFT (0x0000000Bu)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKMUX_RESETVAL (0x00000001u)
/*----USB0PHYCLKMUX Tokens----*/
#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKMUX_INTCLK (0x00000000u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYCLKMUX_EXTCLK (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB0PHYPWDN_MASK (0x00000400u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYPWDN_SHIFT (0x0000000Au)
#define CSL_SYSCFG_CFGCHIP2_USB0PHYPWDN_RESETVAL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB0OTGPWRDN_MASK (0x00000200u)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGPWRDN_SHIFT (0x00000009u)
#define CSL_SYSCFG_CFGCHIP2_USB0OTGPWRDN_RESETVAL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB0DATPOL_MASK (0x00000100u)
#define CSL_SYSCFG_CFGCHIP2_USB0DATPOL_SHIFT (0x00000008u)
#define CSL_SYSCFG_CFGCHIP2_USB0DATPOL_RESETVAL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB1SUSPENDM_MASK (0x00000080u)
#define CSL_SYSCFG_CFGCHIP2_USB1SUSPENDM_SHIFT (0x00000007u)
#define CSL_SYSCFG_CFGCHIP2_USB1SUSPENDM_RESETVAL (0x00000000u)
/*----USB1SUSPENDM Tokens----*/
#define CSL_SYSCFG_CFGCHIP2_USB1SUSPENDM_DISABLED (0x00000000u)
#define CSL_SYSCFG_CFGCHIP2_USB1SUSPENDM_ENABLED (0x00000001u)

#define CSL_SYSCFG_CFGCHIP2_USB0PHY_PLLON_MASK (0x00000040u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHY_PLLON_SHIFT (0x00000006u)
#define CSL_SYSCFG_CFGCHIP2_USB0PHY_PLLON_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP2_USB0SESNDEN_MASK (0x00000020u)
#define CSL_SYSCFG_CFGCHIP2_USB0SESNDEN_SHIFT (0x00000005u)
#define CSL_SYSCFG_CFGCHIP2_USB0SESNDEN_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP2_USB0VBDTCTEN_MASK (0x00000010u)
#define CSL_SYSCFG_CFGCHIP2_USB0VBDTCTEN_SHIFT (0x00000004u)
#define CSL_SYSCFG_CFGCHIP2_USB0VBDTCTEN_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP2_USB0REF_FREQ_MASK (0x0000000Fu)
#define CSL_SYSCFG_CFGCHIP2_USB0REF_FREQ_SHIFT (0x00000000u)
#define CSL_SYSCFG_CFGCHIP2_USB0REF_FREQ_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP2_RESETVAL     (0x0000EF00u)

/* CFGCHIP3 */




#define CSL_SYSCFG_CFGCHIP3_DIV4P5ENA_MASK (0x00000004u)
#define CSL_SYSCFG_CFGCHIP3_DIV4P5ENA_SHIFT (0x00000002u)
#define CSL_SYSCFG_CFGCHIP3_DIV4P5ENA_RESETVAL (0x00000000u)
/*----DIV4P5ENA Tokens----*/
#define CSL_SYSCFG_CFGCHIP3_DIV4P5ENA_DISABLE (0x00000000u)
#define CSL_SYSCFG_CFGCHIP3_DIV4P5ENA_ENABLE (0x00000001u)

#define CSL_SYSCFG_CFGCHIP3_EMA_CLKSRC_MASK (0x00000002u)
#define CSL_SYSCFG_CFGCHIP3_EMA_CLKSRC_SHIFT (0x00000001u)
#define CSL_SYSCFG_CFGCHIP3_EMA_CLKSRC_RESETVAL (0x00000000u)
/*----EMA_CLKSRC Tokens----*/
#define CSL_SYSCFG_CFGCHIP3_EMA_CLKSRC_PLLCTRL_SYSCLK3 (0x00000000u)
#define CSL_SYSCFG_CFGCHIP3_EMA_CLKSRC_4P5_PLL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP3_EMB_CLKSRC_MASK (0x00000001u)
#define CSL_SYSCFG_CFGCHIP3_EMB_CLKSRC_SHIFT (0x00000000u)
#define CSL_SYSCFG_CFGCHIP3_EMB_CLKSRC_RESETVAL (0x00000000u)
/*----EMB_CLKSRC Tokens----*/
#define CSL_SYSCFG_CFGCHIP3_EMB_CLKSRC_PLLCTRL_SYSCLK3 (0x00000000u)
#define CSL_SYSCFG_CFGCHIP3_EMB_CLKSRC_4P5_PLL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP3_RESETVAL     (0x00000100u)

/* CFGCHIP4 */

#define CSL_SYSCFG_CFGCHIP4_RESV_INPUTS_MASK (0xFFFF0000u)
#define CSL_SYSCFG_CFGCHIP4_RESV_INPUTS_SHIFT (0x00000010u)
#define CSL_SYSCFG_CFGCHIP4_RESV_INPUTS_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP4_RESV_OUT1_MASK (0x0000FF00u)
#define CSL_SYSCFG_CFGCHIP4_RESV_OUT1_SHIFT (0x00000008u)
#define CSL_SYSCFG_CFGCHIP4_RESV_OUT1_RESETVAL (0x00000001u)

#define CSL_SYSCFG_CFGCHIP4_RESV_OUT0_MASK (0x000000F8u)
#define CSL_SYSCFG_CFGCHIP4_RESV_OUT0_SHIFT (0x00000003u)
#define CSL_SYSCFG_CFGCHIP4_RESV_OUT0_RESETVAL (0x00000000u)

#define CSL_SYSCFG_CFGCHIP4_AMUTECLR2_MASK (0x00000004u)
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR2_SHIFT (0x00000002u)
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR2_RESETVAL (0x00000000u)
/*----AMUTECLR2 Tokens----*/
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR2_CLEAR (0x00000001u)

#define CSL_SYSCFG_CFGCHIP4_AMUTECLR1_MASK (0x00000002u)
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR1_SHIFT (0x00000001u)
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR1_RESETVAL (0x00000000u)
/*----AMUTECLR1 Tokens----*/
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR1_CLEAR (0x00000001u)

#define CSL_SYSCFG_CFGCHIP4_AMUTECLR0_MASK (0x00000001u)
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR0_SHIFT (0x00000000u)
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR0_RESETVAL (0x00000000u)
/*----AMUTECLR0 Tokens----*/
#define CSL_SYSCFG_CFGCHIP4_AMUTECLR0_CLEAR (0x00000001u)

#define CSL_SYSCFG_CFGCHIP4_RESETVAL     (0x00000100u)

#ifdef __cplusplus
}
#endif

#endif
