#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ti/csl/csl_edma3.h>
#include <ti/csl/csl_edma3Aux.h>

#pragma DATA_SECTION(srcbuf,".EXRAM")
#pragma DATA_SECTION(dstbuf,".MSRAM")

unsigned char srcbuf[512],dstbuf[512];

CSL_Edma3ParamHandle	hParamPing;
CSL_Edma3ParamSetup		myParamSetup;
CSL_Edma3ChannelHandle	hChannel;
CSL_Edma3Handle			hMoudle;

int Edma3Example()
{
	CSL_Edma3Obj	edmaObj;
	CSL_Edma3ChannelObj		chObj;
	CSL_Edma3CmdIntr	regionIntr;
	CSL_Edma3Context	context;
	CSL_Edma3ChannelAttr	chAttr;
	CSL_Status	status;

	unsigned char channelNum = 0;
	unsigned char instNum = 1;


	CSL_edma3Init(&context);

	hMoudle = CSL_edma3Open(&edmaObj,instNum,NULL,&status);

	chAttr.regionNum = CSL_EDMA3_REGION_GLOBAL;
	chAttr.chaNum = channelNum;
	hChannel = CSL_edma3ChannelOpen(&chObj,instNum,&chAttr,&status);

	CSL_edma3HwChannelSetupQue(hChannel,CSL_EDMA3_QUE_0);

	CSL_edma3MapDMAChannelToParamBlock(hMoudle,channelNum,0);

	hParamPing = CSL_edma3GetParamHandle(hChannel,0,&status);

	regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
	regionIntr.intr = 0x1;
	regionIntr.intrh = 0x0;
	CSL_edma3HwControl(hMoudle,CSL_EDMA3_CMD_INTR_ENABLE,&regionIntr);

	myParamSetup.option = 0x00100008;
	myParamSetup.srcAddr = (Uint32)srcbuf;
	myParamSetup.aCntbCnt = 0x00010040;
	myParamSetup.dstAddr = (Uint32)dstbuf;
	myParamSetup.srcDstBidx = 0x0;
	myParamSetup.linkBcntrld = 0x0000ffff;
	myParamSetup.srcDstCidx = 0x0;
	myParamSetup.cCnt = 0x00000001;
	CSL_edma3ParamSetup(hParamPing,&myParamSetup);

	CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);

	regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
	regionIntr.intr = 0x0;
	regionIntr.intrh = 0x0;
	do
	{
		CSL_edma3GetHwStatus(hMoudle,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
	}
	while (!(regionIntr.intr & 0x1));

	CSL_edma3HwControl(hMoudle,CSL_EDMA3_CMD_INTRPEND_CLEAR,&regionIntr);

	CSL_edma3ChannelClose(hChannel);

	CSL_edma3Close(hMoudle);

	return 0;
}

void main()
{
	int i;

	for(i=0;i<512;i++)
	{
		srcbuf[i] = 0xFF;
		dstbuf[i] = 0x00;
	}

	Edma3Example();

	printf("dstbuf[0] = %d\n",dstbuf[0]);
	printf("dstbuf[63] = %d\n",dstbuf[63]);
	printf("dstbuf[64] = %d\n",dstbuf[64]);
}
