#ifndef _PACKET_DESCRIPTOR_H_
#define _PACKET_DESCRIPTOR_H_

typedef enum
{
    /** Host descriptor */
    Cppi_DescType_HOST = 0,
    /** Monolithic descriptor */
    Cppi_DescType_MONOLITHIC = 2
}Cppi_DescType;

/*******************************************************************/
/* Define the bit and word layouts for the Host Packet Descriptor. */
/* For a Host Packet, this is used for the first descriptor only.  */
/*******************************************************************/
#ifdef _BIG_ENDIAN
typedef struct
{
  /* word 0 */
  Uint32 type_id         : 2;  //always 0x0 (Host Packet ID)
  Uint32 packet_type     : 5;
  Uint32 reserved_w0     : 2;
  Uint32 ps_reg_loc      : 1;  //0=PS words in desc, 1=PS words in SOP buff
  Uint32 packet_length   : 22; //in bytes (4M - 1 max)

  /* word 1 */
  Uint32 src_tag_hi      : 8;
  Uint32 src_tag_lo      : 8;
  Uint32 dest_tag_hi     : 8;
  Uint32 dest_tag_lo     : 8;

  /* word 2 */
  Uint32 epib            : 1;  //1=extended packet info block is present
  Uint32 reserved_w2     : 1;
  Uint32 psv_word_count  : 6;  //number of 32-bit PS data words
  Uint32 err_flags       : 4;
  Uint32 ps_flags        : 4;
  Uint32 return_policy   : 1;  //0=linked packet goes to pkt_return_qnum,
                                 //1=each descriptor goes to pkt_return_qnum
  Uint32 ret_push_policy : 1;  //0=return to queue tail, 1=queue head
  Uint32 pkt_return_qmgr : 2;
  Uint32 pkt_return_qnum : 12;

  /* word 3 */
  Uint32 reserved_w3     : 10;
  Uint32 buffer_len      : 22;

  /* word 4 */
  Uint32 buffer_ptr;

  /* word 5 */
  Uint32 next_desc_ptr;

  /* word 6 */
  Uint32 orig_buff0_pool : 4;
  Uint32 orig_buff0_refc : 6;
  Uint32 orig_buff0_len  : 22;

  /* word 7 */
  Uint32 orig_buff0_ptr;

} HostPacketDescriptor;

#endif


#endif 
