
#include <stdio.h>
#include <string.h>
#include <ti/csl/cslr_device.h>
#include <ti/csl/csl_qm_queue.h>
#include "init.h"
#include "drv.h"

#include <ti/drv/qmss/firmware/acc48_be_bin.h>

#pragma DATA_SECTION(hostDescriptor,".QMSS_Data")
#pragma DATA_ALIGN (hostDescriptor, 64)
Uint8 hostDescriptor[NUM_HOST_DESCRIPTOR][SIZE_HOST_DESCRIPTOR];

#pragma DATA_SECTION(packetBuffer,".QMSS_Data")
Uint8 packetBuffer[NUM_PKT_BUF][SIZE_PKT_BUF];

#pragma DATA_SECTION(rhostDescriptor,".QMSS_Data")
#pragma DATA_ALIGN (rhostDescriptor, 64)
Uint8 rhostDescriptor[NUM_HOST_DESCRIPTOR][SIZE_HOST_DESCRIPTOR];

#pragma DATA_SECTION(rpacketBuffer,".QMSS_Data")
Uint8 rpacketBuffer[NUM_PKT_BUF][SIZE_PKT_BUF];

void QMSS_init()
{
	QMSS_Linking_RAM_init();
	QMSS_Descriptor_Regions_init();
	Host_Descriptor_Queues_init();

	qmIntRegs->STATUS_CLR_REG0= 0xFFFFFFFF;
	qmIntRegs->STATUS_CLR_REG1= 0xFFFF;
}


void PktDMA_init()
{
	pktDma_Global_Control(qmDmaCfgRegs, 256, 0, 0);
	pktDma_RxCh_enable(qmDmaRxChCfgRegs, 0);
	pktDma_TxCh_enable(qmDmaTxChCfgRegs, 0);
	pktDma_configureRxFlow(qmDmaRxFlowCfgRegs->RX_FLOW_CONFIG);
}


