
#ifndef _MULTICORE_NAVIGATOR_INIT_H_
#define _MULTICORE_NAVIGATOR_INIT_H_

#include "drv.h"

#define SIZE_HOST_DESCRIPTOR      32
#define NUM_HOST_DESCRIPTOR       32
#define SIZE_PKT_BUF              16
#define NUM_PKT_BUF 						(NUM_HOST_DESCRIPTOR)

#define FDQ_USED_FOR_SEND 				(2013)
#define FDQ_USED_FOR_RECEIVE 			(2031)
#define PKTDMA_RX_Q 					(2036)
#define PKTDMA_TX_Q 					(800)

extern Uint8 packetBuffer[NUM_PKT_BUF][SIZE_PKT_BUF];
extern Uint8 hostDescriptor[NUM_HOST_DESCRIPTOR][SIZE_HOST_DESCRIPTOR];
extern Uint8 rpacketBuffer[NUM_PKT_BUF][SIZE_PKT_BUF];
extern Uint8 rhostDescriptor[NUM_HOST_DESCRIPTOR][SIZE_HOST_DESCRIPTOR];

extern void QMSS_init();
extern void PktDMA_init();
extern void 	QMSS_Descriptor_Regions_init();


/*
 * 100h			256
 * 400h			1k
 * 1000h			4k
 * 4000h			16k
 * 1 0000			64k
 * 4 0000			256k
 * 8 0000			512k
 * 10 0000			1m
 *
 *
 *
 */
#endif
