/* ========================================================================== */
/**
 *  @file   
 *
 *  path    /dsps_gtmas/ti/mas/fract/fract.h
 *
 *  @brief  Macros for manipulation of fractional types
 *
 * ============================================================================
 * Copyright (C) 2002-2007 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  ============================================================================
 */
#ifndef _FRACT_H
#define _FRACT_H

/** @defgroup  FRACT */

/** @ingroup FRACT */
/* @{ */



#ifdef ti_targets_C54
#define _FRACT_C54 1
#else
#define _FRACT_C54 0
#endif

#ifdef ti_targets_C54_far
#define _FRACT_C54_FAR 1
#else
#define _FRACT_C54_FAR 0
#endif

#ifdef ti_targets_C55
#define _FRACT_C55 1
#else
#define _FRACT_C55 0
#endif

#ifdef ti_targets_C55_large
#define _FRACT_C55_LARGE 1
#else
#define _FRACT_C55_LARGE 0
#endif


#ifdef ti_targets_C64
#define _FRACT_C64 1
#else
#define _FRACT_C64 0
#endif

#ifdef ti_targets_C64_big_endian
#define _FRACT_C64_BIG_ENDIAN 1
#else
#define _FRACT_C64_BIG_ENDIAN 0
#endif

#if defined(ti_targets_C674) || defined(ti_targets_elf_C674)
#define _FRACT_C674 1
#else
#define _FRACT_C674 0
#endif

#if defined(ti_targets_C674_big_endian) || defined(ti_targets_elf_C674_big_endian)
#define _FRACT_C674_BIG_ENDIAN 1
#else
#define _FRACT_C674_BIG_ENDIAN 0
#endif

#if defined(ti_targets_C64P) || defined(ti_targets_elf_C64P)
#define _FRACT_C64P 1
#else
#define _FRACT_C64P 0
#endif

#if defined(ti_targets_C64P_big_endian) || defined(ti_targets_elf_C64P_big_endian)
#define _FRACT_C64P_BIG_ENDIAN 1
#else
#define _FRACT_C64P_BIG_ENDIAN 0
#endif

#if defined(ti_targets_C66) || defined(ti_targets_elf_C66)
#define _FRACT_C66 1
#else
#define _FRACT_C66 0
#endif

#if defined(ti_targets_C66_big_endian) || defined(ti_targets_elf_C66_big_endian)
#define _FRACT_C66_BIG_ENDIAN 1
#else
#define _FRACT_C66_BIG_ENDIAN 0
#endif

#ifdef gnu_targets_MVArm9
#define _FRACT_MVARM9 1
#else
#define _FRACT_MVARM9 0
#endif

#ifdef gnu_targets_arm_GCArmv6
#define _FRACT_ARM_GCARMV6 1
#else
#define _FRACT_ARM_GCARMV6 0
#endif

#ifdef gnu_targets_arm_GCArmv7A
#define _FRACT_ARM_GCARMV7A 1
#else
#define _FRACT_ARM_GCARMV7A 0
#endif

#ifdef ti_targets_arm_Arm11
#define _FRACT_ARM_ARM11 1
#else
#define _FRACT_ARM_ARM11 0
#endif


#ifdef ti_targets_arm_Arm11_big_endian
#define _FRACT_ARM_ARM11_BIG_ENDIAN 1
#else
#define _FRACT_ARM_ARM11_BIG_ENDIAN 0
#endif

#ifdef microsoft_targets_arm_WinCE
#define _FRACT_WINCE 1
#else
#define _FRACT_WINCE 0
#endif

#ifdef microsoft_targets_VC98
#define _FRACT_VC98 1
#else
#define _FRACT_VC98 0
#endif

#if _FRACT_C54
#include <ti/mas/fract/c54/fract.h>
#elif _FRACT_C54_FAR
#include <ti/mas/fract/c54/fract.h>
#elif _FRACT_C55
#include <ti/mas/fract/c55/fract.h>
#elif _FRACT_C55_LARGE
#include <ti/mas/fract/c55/fract.h>
#elif _FRACT_C64
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C64_BIG_ENDIAN
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C674
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C674_BIG_ENDIAN
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C64P
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C64P_BIG_ENDIAN
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C66
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_C66_BIG_ENDIAN
#include <ti/mas/fract/c64/fract.h>
#elif _FRACT_MVARM9
#include <ti/mas/fract/arm/fract.h>
#elif _FRACT_WINCE
#include <ti/mas/fract/arm/fract.h>
#elif _FRACT_VC98
#include <ti/mas/fract/arm/fract.h>
#elif _FRACT_ARM_GCARMV6
#include <ti/mas/fract/arm/fract.h>
#elif _FRACT_ARM_ARM11
#include <ti/mas/fract/arm/fract.h>
#elif _FRACT_ARM_ARM11_BIG_ENDIAN
#include <ti/mas/fract/arm/fract.h>
#elif _FRACT_ARM_GCARMV7A
#include <ti/mas/fract/arm/fract.h>
#else
#error invalid target
#endif
/* @} */ /* ingroup */
#endif
/* nothing past this point */
