/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _AUDIOCFG_H
#define _AUDIOCFG_H
/******************************************************************************
 * FILE PURPOSE: Generic AUDIO configuration and message file.
 ******************************************************************************
 * FILE NAME:   aducfg.h
 *
 * DESCRIPTION: 1. Contains messages shared by AUDIO drivers and micro.
 *              2. Contains #defines related with AUDIO and Micro
 *
 *              NOTE: This file may be used by both Micro and DSP software.
 *
******************************************************************************/
#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/*****************************************************************************
 * Used for configuring AUDIO.
 *****************************************************************************/
struct MGB_MDS_AUDIO_CONFIG {
 
tuint valid_params;
#define MGB_AUDIO_VALID_TYPE              0x0001
#define MGB_AUDIO_VALID_PLAYOUT_SRATE     0x0002
#define MGB_AUDIO_VALID_INPUT_SRATE       0x0004
#define MGB_AUDIO_VALID_RESET             0x0008
#define MGB_AUDIO_VALID_INPUT_STREAM_TYPE 0x0010
 
tuint type;
#define MGB_AUDIO_TYPE_TRANSPARENT        0x0000
#define MGB_AUDIO_TYPE_MP3                0x0001
 
tuint playout_srate_index; /* Playout sampling rate index */
tuint input_srate_index;   /* Input sampling rate index */
#define MGB_AUDIO_PLAYOUT_SRATE_48 0x0000  /*48.0 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_44 0x0001  /*44.1 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_32 0x0002  /*32.0 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_24 0x0003  /*24.0 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_22 0x0004  /*22.05 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_16 0x0005  /*16.0 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_12 0x0006  /*12.0 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_11 0x0007  /*11.025 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_08 0x0008  /*8.0 KHz*/
#define MGB_AUDIO_PLAYOUT_SRATE_NONE 0x0009 /*None of the Above*/

tuint reset;                  /* Whether to reset the AUDIO or not */
#define MGB_AUDIO_PATH_RESET         0x0001

tuint input_stream_type;    /* Input sampling rate index */
#define MGB_AUDIO_INPUT_STREAM_TYPE_MONO   0x0000 
#define MGB_AUDIO_INPUT_STREAM_TYPE_STEREO 0x0001 
#define MGB_AUDIO_INPUT_STREAM_TYPE_NONE   0x0002 

}TNI_ATTR_PACK ;

#endif /* _AUDIOCFG_H */
/* nothing past this point */

