/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#ifndef _AICCFG_H
#define _AICCFG_H
/******************************************************************************
 * FILE PURPOSE: Generic AIC configuration and message file.
 ******************************************************************************
 * FILE NAME:   aiccfg.h
 *
 * DESCRIPTION: 1. Contains messages shared by AIC drivers and micro.
 *              2. Contains #defines related with AIC and Micro
 *
 *              NOTE: This file may be used by both Micro and DSP software.
 *
******************************************************************************/

#include <ti/mas/iface/ifeco/mgdefs.h>

/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK
#endif

/*****************************************************************************
 * Used to configure connectivity of ADC/DAC connection in AIC.
 *****************************************************************************/
struct MGB_MDS_ANALOG_CODEC_CONFIG{
  tuint valid_bitfield;
#define MGB_AIC_CONNECTIVITY  0x0001
#define MGB_AIC_GAIN_PATHS    0x0002
  tuint connectivity;
#define MGB_C1_IN_HANDSET     0x0001 
#define MGB_C1_IN_HEADSET     0x0002 
#define MGB_C1_IN_HANDSFREE   0x0004
#define MGB_C1_IN_LINE        0x0008 
#define MGB_C2_IN_HANDSET     0x0010 
#define MGB_C2_IN_HEADSET     0x0020 
#define MGB_C2_IN_HANDSFREE   0x0040
#define MGB_C2_IN_LINE        0x0080 
#define MGB_C1_OUT_HANDSET    0x0100 
#define MGB_C1_OUT_HEADSET    0x0200 
#define MGB_C1_OUT_HANDSFREE  0x0400
#define MGB_C1_OUT_LINE       0x0800 
#define MGB_C2_OUT_HANDSET    0x1000 
#define MGB_C2_OUT_HEADSET    0x2000 
#define MGB_C2_OUT_HANDSFREE  0x4000
#define MGB_C2_OUT_LINE       0x8000 
  tuint gain_paths;
#define MGB_CC_PRI_IN_MASK        0x0003
#define MGB_CC_PRI_IN_HAND_SET       0x0
#define MGB_CC_PRI_IN_HEAD_SET       0x1
#define MGB_CC_PRI_IN_HNDS_FREE      0x2
#define MGB_CC_PRI_IN_LINE           0x3
#define MGB_CC_PRI_IN_RESERVED    0x0004
#define MGB_CC_PRI_IN_CODEC       0x0008

#define MGB_CC_PRI_OUT_MASK       0x0030
#define MGB_CC_PRI_OUT_HAND_SET     0x00
#define MGB_CC_PRI_OUT_HEAD_SET     0x10
#define MGB_CC_PRI_OUT_HNDS_FREE    0x20
#define MGB_CC_PRI_OUT_LINE         0x30
#define MGB_CC_PRI_OUT_RESERVED   0x0040
#define MGB_CC_PRI_OUT_CODEC      0x0080

#define MGB_CC_SEC_OUT_MASK       0x0300
#define MGB_CC_SEC_OUT_HAND_SET    0x000
#define MGB_CC_SEC_OUT_HEAD_SET    0x100
#define MGB_CC_SEC_OUT_HNDS_FREE   0x200
#define MGB_CC_SEC_OUT_LINE        0x300
#define MGB_CC_SEC_OUT_RESERVED   0x0400
#define MGB_CC_SEC_OUT_CODEC      0x0800

#define MGB_CC_RESERVED           0xF000
} TNI_ATTR_PACK;

/*****************************************************************************
 * AIC type, sampling and crystal frequency defines
 *****************************************************************************/
#define  MGB_AIC_SAMP_FREQ_8KHZ     0
#define  MGB_AIC_SAMP_FREQ_16KHZ    1
#define  MGB_AIC_SAMP_FREQ_48KHZ    2

#define  MGB_CRSTL_32MHZ        32  /* 32.768 MHz clock */
#define  MGB_CRSTL_24MHZ        24  /* 24.576 MHz clock */
#define  MGB_CRSTL_6MHZ         6   /* 6.144  MHz clock - used for AIC23*/

#define MGB_AIC_10             0x0001  /* AIC10 */
#define MGB_AIC_22             0x0002  /* AIC22 */
#define MGB_AIC_20             0x0004  /* AIC20 */
#define MGB_AIC_23             0x0008  /* AIC23 */

/*****************************************************************************
 * Direct AIC Register read/write messages
 *****************************************************************************/

typedef struct MGB_ANALOG_CODEC_REGISTER{
  tuint address;            /* Register address */
  tuint value;              /* Register value */
  tuint mask;               /* Register mask */
} TNI_ATTR_PACK MGB_ANALOG_CODEC_REGISTER_t;

struct MGB_MDS_ANALOG_CODEC_REGISTER_CTRL{
  tuint                       reg_ctrl;
#define MGB_AIC_REG_WRITE      0x0001
#define MGB_AIC_REG_READ       0x0002
  MGB_ANALOG_CODEC_REGISTER_t  reg;
} TNI_ATTR_PACK;

struct MGB_DMS_ANALOG_CODEC_REGISTER_CTRL{
  tuint                        reg_ctrl;
  MGB_ANALOG_CODEC_REGISTER_t   reg;
}  TNI_ATTR_PACK;

#endif /* _AICCFG_H */
/* nothing past this point */
