#ifndef ANUSVR_API_H
#define ANUSVR_API_H
/*************************************************************************************
 * FILE PURPOSE: Structures shared between DSP and host for Announcement Server
 *************************************************************************************
 * FILE NAME: anusvrapi.h
 *
 * DESCRIPTION: Defines structures used by the host and DSP modules
 *
 * Copyright(C) 2007, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#include <ti/mas/iface/ifeco/mgdefs.h>

/*************************************************************************************
 * Name: MGB_MDS_ANUSVR_CONTROL
 * Description: Used to enable/disable and configure the announcement server.
 *              The DSP will respond with a general ack if the transaction ID
 *              of the request is non-zero.
 *************************************************************************************/
/* Dummy Define for a Micro Macro */
#ifndef TNI_ATTR_PACK
#define TNI_ATTR_PACK 
#endif

struct MGB_MDS_ANNOUNCE_SERVER_CONTROL {
#define MGB_ANUSVR_CONTROL_VALID_ENABLE          0x0001
#define MGB_ANUSVR_CONTROL_VALID_UDP             0x0002
#define MGB_ANUSVR_CONTROL_VALID_MIN_REQUEST     0x0004
#define MGB_ANUSVR_CONTROL_VALID_MAX_REQUEST     0x0008
#define MGB_ANUSVR_CONTROL_VALID_PERCENT         0x0010
#define MGB_ANUSVR_CONTROL_VALID_TASK_INTERVAL   0x0020
#define MGB_ANUSVR_CONTROL_VALID_WARN_THRESHOLD  0x0040
#define MGB_ANUSVR_CONTROL_VALID_BASE_ADDRESS    0x0080

  tuint valid_params;
  
#define MGB_ANUSVR_CONTROL_SERVER_DISABLE   0
#define MGB_ANUSVR_CONTROL_SERVER_ENABLE    1
  tuint control;
  
  tuint udpPort;
  
  tuint minRequests;
  tuint maxRequests;
  tuint percentRequests;   /* Fractional, Q.16 format */
  
  tuint taskProcessPeriod;
  
  tuint warnThreshold;     /* Fractional, Q.16 format */
  
  tuint baseAddressMSW;
  tuint baseAddressLSW;

} TNI_ATTR_PACK;

/*************************************************************************************
 * Name: MGB_MDS_REQ_ANNOUNCE_SERVER_STAT
 * Description: Requests the announcement server stats
 *************************************************************************************/
struct MGB_MDS_REQ_ANNOUNCE_SERVER_STAT  {
 
  tuint clear;   /* If set the stats are cleared after being returned */
 
} TNI_ATTR_PACK;


/*************************************************************************************
 * Name: MGB_MDS_GET_ANNOUNCE_SERVER_STAT
 * Description: The response generated when the stats request message was received 
 *              by the DSP.
 *************************************************************************************/
struct MGB_DMS_GET_ANNOUNCE_SERVER_STAT {

  tuint validRequestCount;     /* Number of announcement requests received                */
  tuint requestsScheduled;     /* Number of requests scheduled                            */
  tuint repliesGenerated;      /* Number of replies generated and sent from the module    */
  tuint invalidRequestCount;   /* Number of rejected announcement requests                */
  tuint fifoFullCount;         /* Number of requests dropped because the FIFO was full    */
  tuint gmcFailCount;          /* Number of requests dropped because of GMC failure       */
  tuint reqNoData;             /* Number of times a task was scheduled but no request
                                   was in the fifo                                         */
  tuint sysTransferFailCount;  /* Number of requests which failed due to system DMA
                                 * unavailable */
  tuint localRequestCount;     /* Count of requests from the local dsp                    */                                
  tuint invalidLocal;          /* Count of invalid local requests                         */
} TNI_ATTR_PACK;


/************************************************************************************
 * Name: MGB_MDS_ANUSVR_ALERT
 * Description: This message is generated when the number of announcement requests
 *              meets the threshold provided in the server control message
 ************************************************************************************/
struct MGB_DMS_ANNOUNCE_SERVER_ALERT
{
  tuint highWaterMark;        /* The current high water mark in the queue */
  
} TNI_ATTR_PACK;



#endif /* ANUSVR_API_H */

